/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This program takes a symbol file and compiles it to internal format. */

/* Includes. ================================================================*/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <setjmp.h>
#include <glib.h>
#include "basic.h"
#include "pools.h"
#include "values.h"
#include "scanner.h"
#include "files.h"
#include "sym_compiler.h"

/* Functions. ===============================================================*/

int 
main( int argc, char *argv[] )
/* The main function of "malsym". */
{
  string_t symbol_file, object_file, old_symbol_file;
  int_t i;

  init_basic( "malsym" );
  if (argc == 2) 
  { 
    if (strcmp_no_case( argv[1], "--version" ) == 0
	|| strcmp_no_case( argv[1], "-version" ) == 0
	|| strcmp_no_case( argv[1], "-v" ) == 0) 
    { 
      program_message();
      exit(0);
    } 
    else if (strcmp_no_case( argv[1], "--help" ) == 0
	     || strcmp_no_case( argv[1], "-help" ) == 0
	     || strcmp_no_case( argv[1], "-h" ) == 0) 
    { 
      printf( "Compile a symbol file of a Malaga grammar.\n\n"
              "Usage:\n"
	      "malsym SYM_FILE                  "
	      "-- Compile SYM_FILE.\n"
	      "malsym ESYM_FILE -u[se] SYM_FILE "
	      "-- Compile ESYM_FILE using SYM_FILE.\n"
	      "malsym -v[ersion]                "
	      "-- Print version information.\n"
	      "malsym -h[elp]                   "
	      "-- Print this help.\n\n"
	      "SYM_FILE must end on \".sym\".\n"
	      "ESYM_FILE must end on \".esym\".\n"
	      "Option \"-split-hangul-syllables\" makes Malaga split Hangul "
	      "syllables.\n" );
      exit(0);
    }
  }
  symbol_file = object_file = old_symbol_file = NULL;
  for (i = 1; i < argc; i++) 
  { 
    if (has_extension( argv[i], "sym" ) || has_extension( argv[i], "esym" )) 
    { 
      set_file_name( &symbol_file, argv[i] );
      set_binary_file_name( &object_file, argv[i] );
    }
    else if (strcmp_no_case( argv[i], "-use" ) == 0
	     || strcmp_no_case( argv[i], "-u" ) == 0)
    {
      if (argv[ ++i ] == NULL) 
	complain( "Missing file name after \"-use\"." );
      set_binary_file_name( &old_symbol_file, argv[i] );
    }
    else if (strcmp_no_case( argv[i], "-split-hangul-syllables" ) == 0) 
      split_hangul_syllables = TRUE;
    else 
      complain( "Illegal argument \"%s\".", argv[i] );
  }
  if (object_file == NULL) 
    complain( "Missing symbol file name." );
  init_values();
  init_scanner();

  compile_symbol_file( symbol_file, object_file, old_symbol_file );

  terminate_values();
  terminate_scanner();
  free_mem( &object_file );
  free_mem( &symbol_file );
  free_mem( &old_symbol_file );
  terminate_basic();

  return 0;
}

/* End of file. =============================================================*/
