; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-none-linux-gnu %s -o - | FileCheck --check-prefix=DAG %s
; RUN: llc -mtriple=aarch64-none-linux-gnu -global-isel %s -o - | FileCheck --check-prefix=GIS %s

declare i32 @llvm.get.fpmode.i32()
declare void @llvm.set.fpmode.i32(i32 %fpmode)
declare void @llvm.reset.fpmode()

define i32 @func_get_fpmode() #0 {
; DAG-LABEL: func_get_fpmode:
; DAG:       // %bb.0: // %entry
; DAG-NEXT:    mrs x0, FPCR
; DAG-NEXT:    // kill: def $w0 killed $w0 killed $x0
; DAG-NEXT:    ret
;
; GIS-LABEL: func_get_fpmode:
; GIS:       // %bb.0: // %entry
; GIS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; GIS-NEXT:    add x0, sp, #12
; GIS-NEXT:    bl fegetmode
; GIS-NEXT:    ldr w0, [sp, #12]
; GIS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; GIS-NEXT:    ret
entry:
  %fpmode = call i32 @llvm.get.fpmode.i32()
  ret i32 %fpmode
}

define void @func_set_fpmode(i32 %fpmode) #0 {
; DAG-LABEL: func_set_fpmode:
; DAG:       // %bb.0: // %entry
; DAG-NEXT:    mov w8, w0
; DAG-NEXT:    msr FPCR, x8
; DAG-NEXT:    ret
;
; GIS-LABEL: func_set_fpmode:
; GIS:       // %bb.0: // %entry
; GIS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; GIS-NEXT:    str w0, [sp, #12]
; GIS-NEXT:    add x0, sp, #12
; GIS-NEXT:    bl fesetmode
; GIS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; GIS-NEXT:    ret
entry:
  call void @llvm.set.fpmode.i32(i32 %fpmode)
  ret void
}

define void @func_reset_fpmode() #0 {
; DAG-LABEL: func_reset_fpmode:
; DAG:       // %bb.0: // %entry
; DAG-NEXT:    mov x9, #-48904 // =0xffffffffffff40f8
; DAG-NEXT:    mrs x8, FPCR
; DAG-NEXT:    movk x9, #63488, lsl #16
; DAG-NEXT:    and x8, x8, x9
; DAG-NEXT:    msr FPCR, x8
; DAG-NEXT:    ret
;
; GIS-LABEL: func_reset_fpmode:
; GIS:       // %bb.0: // %entry
; GIS-NEXT:    mov x0, #-1 // =0xffffffffffffffff
; GIS-NEXT:    b fesetmode
entry:
  call void @llvm.reset.fpmode()
  ret void
}

attributes #0 = { nounwind }
