// contact me at xeen.reversestudios.com if you need help understanding the functions
var autosizerProgressListener = {
	QueryInterface: function(aIID) {
		if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
		  aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
		  aIID.equals(Components.interfaces.nsISupports))
		  return this;
		throw Components.results.NS_NOINTERFACE;
	},
	onProgressChange: function (aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress) {},
	onStatusChange: function(aWebProgress, aRequest, aStatus, aMessage) {},
	onSecurityChange: function(aWebProgress, aRequest, aState) {},
	onLinkIconAvailable: function(a) {},
	onStateChange: function (aWebProgress, aRequest, aStateFlags, aStatus) {},
	onLocationChange: function(aProgress, aRequest, aLocation) { if (aLocation) autosizer.genWidthCheck(); }
}

var autosizer = {
	init: function() {
		window.removeEventListener("load",function() { autosizer.init(); }, false);

		this.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
		this.txt=document.getElementById("searchbar").mTextbox;
		this.label=document.getElementById('autosizer-label');
		this.sBox = document.getElementById("search-container");
		this.input=document.getAnonymousElementByAttribute(this.txt, "anonid", "input");
		if (this.prefs.getBoolPref('browser.search.searchbox.useMacFix') && (Components.classes['@mozilla.org/xre/app-info;1']) && (Components.interfaces.nsIXULAppInfo) && (Components.interfaces.nsIXULRuntime))
		  this.sBox.setAttribute('platform',Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).QueryInterface(Components.interfaces.nsIXULRuntime).OS.toLowerCase());
		this.sBox.flex=1;

		this.label.style.fontSize       = this.getStyle('font-size');
		this.label.style.fontSizeAdjust = this.getStyle('font-size-adjust');
		this.label.style.fontStretch    = this.getStyle('font-stretch');
		this.label.style.fontStyle      = this.getStyle('font-style');
		this.label.style.fontVariant    = this.getStyle('font-variant');
		this.label.style.fontWeight     = this.getStyle('font-weight');
		this.label.style.letterSpacing  = this.getStyle('letter-spacing');
		this.label.style.wordSpacing    = this.getStyle('word-spacing');

		window.setTimeout("autosizer.getAvailableWidth();autosizer.genWidth();",0);

		window.addEventListener("load",function() { autosizer.genWidthCheck(); }, false);
		window.getBrowser().addProgressListener(autosizerProgressListener, Components.interfaces.nsIWebProgress.STATE_STOP);
	},

	getStyle: function(aProperty) {
		return document.defaultView.getComputedStyle(this.input, '').getPropertyValue(aProperty);
	},

	getAvailableWidth: function() {
		var toolbaritems=this.sBox.parentNode.childNodes,flextemp,i,x;
		this.availableWidth=window.outerWidth;
		for(i=0;x=toolbaritems[i];i++) {
			if(x.id=='search-container') continue;
			flextemp=x.getAttribute('flex');
			x.setAttribute('flex',0);
			this.availableWidth-=toolbaritems[i].boxObject.width;
			x.setAttribute('flex',flextemp);
		}
	},

	genWidth: function() {
		if(!this.diffWidth) this.diffWidth=this.sBox.boxObject.width-this.input.offsetWidth;

		var offset=this.prefs.getIntPref('browser.search.searchbox.offset');
		if(this.prefs.getCharPref('general.skins.selectedSkin').substr(0,8)=='RedCats_') offset+=3; // workaround for these themes
		var minwidth=this.prefs.getIntPref('browser.search.searchbox.minwidth');
		var maxwidth=this.prefs.getIntPref('browser.search.searchbox.maxwidth');
		var prevLength=this.label.value.length;

		this.label.value=this.txt.value;
		var width=this.label.boxObject.width+this.diffWidth+(offset>0 ? offset : 0);

		var limited=false;

		if(width>maxwidth && maxwidth>0) { // set max width
		width=maxwidth;
		limited=true;
		}
		if(width<minwidth && minwidth>0) width=minwidth; // set min width
		if(width>this.availableWidth) { // available width
		width=this.availableWidth;
		limited=true;
		}
		if(width<this.diffWidth) width=this.diffWidth+1; // needed width

		this.sBox.width=width;

		var caret=this.txt.selectionEnd;
		if(caret==this.txt.textLength && (!limited || (limited  && prevLength>this.txt.textLength))) window.setTimeout("autosizer.focusEnd(true);",0);
	},

	genWidthCheck: function() {
		if(this.label.value!=this.txt.value) this.genWidth();
	},

	focusEnd: function(k) {
		var oEvent = document.createEvent('KeyEvents');
		oEvent.initKeyEvent("keypress",true,true,null,false,false,false,false,(k?oEvent.DOM_VK_HOME:oEvent.DOM_VK_END),0);
		this.input.dispatchEvent(oEvent);
		if(k) this.focusEnd(false);
		else this.txt.setSelectionRange(this.txt.textLength,this.txt.textLength);
	},

	d: function(t) {
		Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService).logStringMessage('autosizer: '+t);
	}
}