!define NAME "PortableSunbird"
!define VER "0.0.3"

!packhdr "C:\tmp.dat" "c:\Program Files\UPX\upx.exe --best --crp-ms=999999 C:\tmp.dat"

;=== Out program information
Name "${NAME}"
OutFile "${NAME}.exe"
Caption "${NAME} - Making Sunbird Portable"

CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True

;=== Set program icon
Icon "sunbird.ico"

;=== Path variables
Var SUNBIRDPATH
Var PROFILEDIRECTORY

Section "Main"
	
	;=== Get the path information from the INI file
	IfFileExists "$EXEDIR\${NAME}.ini" ReadINI NoINI
	ReadINI:
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "SUNBIRDPATH"
		StrCpy "$SUNBIRDPATH" $0
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "PROFILEDIRECTORY"
		StrCpy "$PROFILEDIRECTORY" $0
		IfErrors NoINI EndINI
	NoINI:
		MessageBox MB_OK "Unable to find configuration file $\"$EXEDIR\${NAME}.ini$\". Click OK to exit." IDOK
		Goto TheEnd
	EndINI:

	IfFileExists "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" ChromeFound RunSunbird
	ChromeFound:
	FileOpen $0 "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" r
	FileOpen $R0 "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf.new" w
	ClearErrors ; if there's an error, we're done with the file
	NextLine:
		FileWrite $R0 $4
		FileRead $0 $4
		IfErrors NoMoreLines
		StrCpy $5 $4 39
		;MessageBox MB_OK "$5"
		StrCmp $5 `                   c:baseURL="jar:file:` "" NextLine
		StrCpy $R4 40
	NotYet:
		IntOp $R4 $R4 + 1
		StrCpy $7 $4 10 $R4 ; looking for the point to strip the extension path
		;MessageBox MB_OK "$7"
		StrCmp $7 "extensions" PathFound NotYet
	PathFound:
		StrCpy $5 $4 "" $R4
		;MessageBox MB_OK "The following extension has an absolute path.$\n$\n$5$\n$\nWe'll make it relative, because that's our purpose :)"
		StrCpy $4 `                   c:baseURL="jar:resource:/$PROFILEDIRECTORY/$5` ; the path made relative
		GoTo NextLine
	NoMoreLines:
	FileClose $0
	FileClose $R0
	CopyFiles "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf.old" ; rename it just in case
	CopyFiles "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf.new" "$SUNBIRDPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" ; that was our purpose

	RunSunbird:
	Exec "$SUNBIRDPATH\sunbird.exe -profile $SUNBIRDPATH\$PROFILEDIRECTORY\"

	TheEnd:
SectionEnd