// cf. netwerk/bas/public/nsNetError.h
const ERROR_FTP_LOGIN  = 2152398869;
const ERROR_FTP_CWD    = 2152398870;
const ERROR_FTP_PASV   = 2152398871;
const ERROR_FTP_PWD    = 2152398872;
const ERROR_FTP_LIST   = 2152398873;

var gPublishSiteData;
var gItemsArray, gFilteredItemsArray;
var gTreeView;

var gLastDirOpenOrClose = -1;

const ATOM_CTRID = "@mozilla.org/atom-service;1";
const nsIAtomService = Components.interfaces.nsIAtomService;

function SetupTreeView()
{
  if (!window.top.gSiteManagerItemsArray)
  {
    window.top.gSiteManagerItemsArray = new Array();
  }
  gItemsArray = window.top.gSiteManagerItemsArray;

  if (gFilteredItemsArray)
    delete gFilteredItemsArray;
  gFilteredItemsArray = new Array();

  gTreeView = {
      rowCount : gFilteredItemsArray.length,

      getCellText : function(row,column)
      {
        if (column=="dirCol") return " "+gFilteredItemsArray[row].name;
        else if (column=="sizeCol") return gFilteredItemsArray[row].size;
        else if (column=="lastModifiedCol") return gFilteredItemsArray[row].lastModified;
      },

      setTree: function(treebox)                     { this.treebox=treebox; },
      isContainer: function(row)                     { return gFilteredItemsArray[row].isContainer; },
      isContainerOpen: function(row)                 { return gFilteredItemsArray[row].isContainerOpen; },
      isContainerEmpty: function(row)                { return gFilteredItemsArray[row].isContainerEmpty; },
      isSeparator: function(row)                     { return false; },
      isSorted: function(row)                        { return false; },
      getLevel: function(row)                        { return gFilteredItemsArray[row].level; },
      getRowProperties: function(row,props)          {},
      getCellProperties: function(row,col,props)     {},
      getColumnProperties: function(colid,col,props) {},

      getImageSrc: function(row,col)
      {
        if (col!="dirCol" || !this.getLevel(row))
          return null;

        if (gFilteredItemsArray[row].isSymLink)
          return "chrome://editor/skin/icons/link.gif";

        if (gFilteredItemsArray[row].isContainer)
          return "chrome://editor/skin/icons/directory.gif";

        var path = "/" + gFilteredItemsArray[row].name;
        return window.top.GetCurrentEditor().iconForURL(path);
      },

      getParentIndex: function( rowIndex )
      {
        var rowLevel = this.getLevel(rowIndex);
        if (!rowLevel) return -1;
        while (this.getLevel(rowIndex) != rowLevel - 1)
          rowIndex--;
        return rowIndex;
      },

      hasNextSibling: function(row,nextrow)
      {
        var i = row + 1, l = gFilteredItemsArray.length;
        while (i < l)
        {
          if (this.getLevel(i) < this.getLevel(row))
            return false;
          else if (this.getLevel(i) == this.getLevel(row))
            return true;
          i++;
        }
        return false;
      },

      toggleOpenState: function(row)
      {
        if (this.isContainerOpen(row))
        {
          var count = 1, level = this.getLevel(row);
          while (row+count < gFilteredItemsArray.length && this.getLevel(row+count) > level)
            count++;
          count--;
          gFilteredItemsArray.splice(row+1, count);

          var realRow = gFilteredItemsArray[row].realIndex;
          var realCount = 1;
          while (realRow+realCount < gItemsArray.length && gItemsArray[realRow+realCount].level > level)
            realCount++;
          realCount--;
          gItemsArray.splice(realRow+1, realCount);

          gFilteredItemsArray[row].isContainerOpen = false;
          gDialog.SiteTree.treeBoxObject.invalidateRow(row);
          gDialog.SiteTree.treeBoxObject.rowCountChanged(row+1, -count);
          var parentIndex = this.getParentIndex(row);
          if (parentIndex <= 0)
            parentIndex = 0;
          gLastDirOpenOrClose = parentIndex;            
        }
        else
        {
          EnableAllUI(false);
          gLastDirOpenOrClose = row;
          if (IsFileUrl(gFilteredItemsArray[row].url))
            OpenLocalDirectory(gFilteredItemsArray[row].url,
                               { total: gFilteredItemsArray.length,
                                 row: row+1,
                                 parentRow: row,
                                 realRow: gFilteredItemsArray[row].realIndex + 1,
                                 previousRefreshCount: 0,
                                 level: this.getLevel(row)+1
                               }
                              );
          else
            var foo = new FTPDirParser(gFilteredItemsArray[row].url,
                                       { total: gFilteredItemsArray.length,
                                         row: row+1,
                                         parentRow: row,
                                         realRow: gFilteredItemsArray[row].realIndex + 1,
                                         previousRefreshCount: 0,
                                         level: this.getLevel(row)+1
                                       },
                                       AddFTPDirSubdirs, EndFtpRequest, ErrorFtpRequest);
          gFilteredItemsArray[row].isContainerOpen = true;
        }
      },

      // PRIVATE

      atomSvc: null,
      atomFiltered: null,

      addRow: function(aRequestData,
                       name, url, size, lastModified,
                       isContainer, isContainerOpen, isContainerEmpty, isSymLink,
                       level, hidden)
      {
        // filteredRowIndex is the index of insertion in the filter data table
        // if we have to insert
        var filteredRowIndex = aRequestData ? aRequestData.row : -1;
        var realRowIndex = aRequestData ? aRequestData.realRow : gItemsArray.length;

        var newItem = {
                        name: name,
                        url: url,
                        size: size,
                        lastModified: lastModified,
                        isContainer: isContainer,
                        isContainerOpen: isContainerOpen,
                        isContainerEmpty: isContainerEmpty,
                        isSymLink: isSymLink,
                        level: level,
                        hidden: hidden,
                        realIndex: realRowIndex
                      };

        if (realRowIndex == -1)
          gItemsArray.push( newItem );
        else
        {
          gItemsArray.splice(realRowIndex, 0, newItem)

          var i, l = gItemsArray.length;
          for (i = realRowIndex + 1; i < l; i++)
            gItemsArray[i].realIndex = i;

          if (aRequestData)
            aRequestData.realRow++;
        }
          

        if (isContainer || !IsHiddenByFilter(window.top.gSiteManagerCurrentFilter, name))
        {
          if (filteredRowIndex == -1)
            gFilteredItemsArray.push( newItem );
          else
            gFilteredItemsArray.splice(filteredRowIndex, 0, newItem)

          if (aRequestData && aRequestData.row != -1)
            aRequestData.row++;
        }


      },

  };
}

// Dialog initialization code
function Startup()
{

  if (!GetCurrentEditorFromSidebar())
  {
    dump("Publish: No editor or return data object not supplied\n");
    window.close();
    return;
  }

  gDialog.SiteTree              = document.getElementById("SiteTree");
  gDialog.SiteDropDown          = document.getElementById("SiteDropDown");
  gDialog.SiteList              = document.getElementById("SiteList");
  gDialog.DirectoryList         = document.getElementById("DirectoryList");
  gDialog.FilterDropDown        = document.getElementById("FilterDropDown");
  gDialog.treeViewCheckbox      = document.getElementById("treeViewCheckbox");
  gDialog.dirHierarchy          = document.getElementById("dirHierarchy");
  gDialog.dirHierarchyPopup     = document.getElementById("dirHierarchyPopup");

  gDialog.reloadButton          = document.getElementById("reloadButton");
  gDialog.renameButton          = document.getElementById("renameButton");
  gDialog.createDirButton       = document.getElementById("createDirButton");
  gDialog.removeFileOrDirButton = document.getElementById("removeFileOrDirButton");
  gDialog.stopButton            = document.getElementById("stopButton");
  gDialog.mainBox               = document.getElementById("mainBox");

  gDialog.progressmeter         = document.getElementById("progressmeter");

  SetupTreeView();
  if (!window.top.gSiteManagerItemsArray.length)
    FillSiteList();
  else
    FilterAllItems();

  if (window.top.gSiteManagerCurrentFilter != "all")
    gDialog.FilterDropDown.value = window.top.gSiteManagerCurrentFilter;

  SetupTree();

  if (SiteManagerNotificationHandler)
    window.top.gSiteManagerNotificationHandler = SiteManagerNotificationHandler;

  SetWindowLocation();
}

function SetupTree()
{
  gTreeView.atomsvc = Components.classes[ATOM_CTRID].getService(nsIAtomService);
  gTreeView.atomFiltered = gTreeView.atomsvc.getAtom("filtered");

  gDialog.SiteTree.view = gTreeView ;
  gDialog.SiteTree.treeBoxObject.rowCountChanged(0, gFilteredItemsArray.length);
}

function FillSiteList()
{
  // Fill the site lists
  var count = 0;
  gPublishSiteData = window.top.GetPublishSiteData();

  if (gPublishSiteData)
    count = gPublishSiteData.length;
  var i;

  if (!count)
  {
    return;
  }

  if (window.top.gSiteManagerItemsArray)
    delete window.top.gSiteManagerItemsArray;
  if (gFilteredItemsArray)
    delete gFilteredItemsArray;
  window.top.gSiteManagerItemsArray = new Array();
  gItemsArray = window.top.gSiteManagerItemsArray;

  for (i = 0; i < count; i++)
  {
    var name = gPublishSiteData[i].siteName;
    var siteUrl = _GetUrlForPasswordManager(gPublishSiteData[i]);

    gTreeView.addRow(null,
                     name,
                     siteUrl,
                     "",
                     "",
                     true,
                     false,
                     false,
                     false,
                     0,
                     false);
  }
  FilterAllItems();
}

function TweakSiteSettings()
{
  var junk = { cancelled: false };
  window.top.openDialog("chrome://editor/content/EditorPublishSettings.xul","_blank", "chrome,close,titlebar,modal", junk);
  if (!junk.cancelled)
  {
    var n = gFilteredItemsArray.length;
    gFilteredItemsArray.splice(0, n);
    gItemsArray.splice(0, gItemsArray.length);
    gDialog.SiteTree.treeBoxObject.rowCountChanged(0, -n)
    
    FillSiteList();
    gDialog.SiteTree.treeBoxObject.rowCountChanged(0, gFilteredItemsArray.length)
  }
}

function EnableAllUI(enabled)
{
  if (enabled)
  {
    //AllowEvents(gDialog.SiteTree, false);
    gDialog.SiteDropDown.removeAttribute("disabled");
    gDialog.DirectoryList.removeAttribute("disabled");
    gDialog.FilterDropDown.removeAttribute("disabled");

    gDialog.reloadButton.removeAttribute("disabled");
    gDialog.renameButton.removeAttribute("disabled");
    gDialog.createDirButton.removeAttribute("disabled");
    gDialog.removeFileOrDirButton.removeAttribute("disabled");

    gDialog.stopButton.setAttribute("disabled", "true");

    window.setCursor("auto");
    //gDialog.mainBox.style.removeProperty("cursor");
    gDialog.progressmeter.className = "";
  }
  else
  {
    //AllowEvents(gDialog.SiteTree, true);
    gDialog.SiteDropDown.setAttribute("disabled", "true");
    gDialog.DirectoryList.setAttribute("disabled", "true");
    gDialog.FilterDropDown.setAttribute("disabled", "true");

    gDialog.reloadButton.setAttribute("disabled", "true");
    gDialog.renameButton.setAttribute("disabled", "true");
    gDialog.createDirButton.setAttribute("disabled", "true");
    gDialog.removeFileOrDirButton.setAttribute("disabled", "true");

    gDialog.stopButton.removeAttribute("disabled");

    window.setCursor("wait");
    //gDialog.mainBox.style.setProperty("cursor", "wait", "");
    gDialog.progressmeter.className = "progress";
  }
}

function RemoveSubdirs(ti)
{
  _removeAllChildren(ti.lastChild);
}

function ResetFirstFileEntry()
{
  gFirstFileEntry = null;
}

function AddFTPDirSubdirs(url, dirEntry, aRQdata)
{
  var location = dirEntry.location;
  var newlocation, size, description;
  if (dirEntry)
  {
    if (dirEntry.type == cnsIDirIndex.TYPE_DIRECTORY)
      size = "";
    else
      size = dirEntry.size;
    description = dirEntry.description;
    newlocation = url + ( (url[url.length - 1] == "/") ?
                          "" : "/" )
                          + location;
  }

  gTreeView.addRow(aRQdata,
                   location,
                   newlocation,
                   size,
                   description,
                   (dirEntry.type == cnsIDirIndex.TYPE_DIRECTORY),
                   false,
                   false,
                   (dirEntry.type == cnsIDirIndex.TYPE_SYMLINK),
                   aRQdata.level,
                   false);
}

function EndFtpRequest(aRQdata)
{
  ForgetAboutLastFtpRequest();
  EnableAllUI(true);

  if (aRQdata && aRQdata.row != -1)
  {
    //FilterAllItems();
    if (gFilteredItemsArray.length - aRQdata.total == 0)
    {
      gFilteredItemsArray[aRQdata.parentRow].isContainerEmpty = true;
      gDialog.SiteTree.treeBoxObject.invalidateRow(aRQdata.parentRow);
    }
    else
      gDialog.SiteTree.treeBoxObject.rowCountChanged(aRQdata.parentRow, gFilteredItemsArray.length - aRQdata.total);
  }
}

function ErrorFtpRequest(url, status)
{
  var message = "";
  if (status == ERROR_FTP_LOGIN)
    message = _GetString("FtpLoginError");
  else if (status == ERROR_FTP_CWD)
    message = _GetString("FtpCwdError");
  else
    message = _GetString("FtpUnknownError");

  AlertWithTitle("FTP", message, window.top);

  EndFtpRequest({total:0, row:0, parentRow:0, previousRefreshCount:0, level:0});
}

function stopCallback()
{
  DropFtpConnection();
  ForgetAboutLastFtpRequest();
  StopNavigation();
}

function StopNavigation()
{
  window.top.document.getElementById("tabeditor").stopWebNavigation(false);
  EndNavigation();
}
function EndNavigation()
{
  window.document.documentElement.removeAttribute("style");
  EnableAllUI(true);
}

function openFile(e)
{
  if (e.button != 0)
    return;

  var item = gFilteredItemsArray[GetSelectedItem(gDialog.SiteTree)];
  if (!item.isContainer)
  {
    var newTab = false; // default is false
    var prefs = window.top.GetPrefs()
    try {
      newTab = prefs.getBoolPref("editor.nvu.sitemanager.openInNewTab");
      DEBUG ( "prefs found" );
    }
    catch (e) {};
    EnableAllUI(false);
    window.top.document.getElementById("tabeditor").endNavigationCallback = EndNavigation;
    window.top.editPage(item.url, window.top, true, newTab);
  }
}

function IsHiddenByFilter(filter, fileName)
{
  if (filter == "all")
    return false;

  if (filter == "html")
    var re = /\.html?$|\.shtml?$/i ;
  else if (filter == "images")
    re = /\.gif$|\.png$|\.jpg$|\.jpeg$|\.ico$/i ;

  return !re.test(fileName);
}

function SelectsFilter(e)
{
  window.top.gSiteManagerCurrentFilter = e.value;
  gLastDirOpenOrClose = -1;
  var n = gFilteredItemsArray.length;
  FilterAllItems();
  gDialog.SiteTree.treeBoxObject.rowCountChanged(0, - n);
  gDialog.SiteTree.treeBoxObject.rowCountChanged(0, gFilteredItemsArray.length);
}

function FilterAllItems()
{
  delete gFilteredItemsArray;

  gFilteredItemsArray = new Array()
  var i, l = gItemsArray.length;
  for (i=0; i<l; i++)
    if (gItemsArray[i].isContainer || !IsHiddenByFilter(window.top.gSiteManagerCurrentFilter, gItemsArray[i].name))
      gFilteredItemsArray.push(gItemsArray[i]);
}

var siteManagerDndObserver = {

  onDragStart: function (evt , transferData, action){
    var selected = gFilteredItemsArray[GetSelectedItem(gDialog.SiteTree)];
    if (selected.isContainer)
      return false;

    var publishData = window.top.CreatePublishDataFromUrl(selected.url);
    var url  = selected.url;
    var URL  = GetURLFromUrl(url);
    var name = URL.fileName;

    if (publishData)
    {
      url = publishData.browseUrl + publishData.docDir + publishData.filename;
      name = publishData.filename;
    }
    if (!IsHiddenByFilter("images", name))
      var htmlText = '<img src="' +  url + '" alt="' + name + '">';
    else
      htmlText = '<a href="' +  url + '">' + url + "</a>";
    var plainText = url;

    transferData.data = new TransferData();
    transferData.data.addDataForFlavour("text/html", htmlText);
    transferData.data.addDataForFlavour("text/unicode", plainText);
  }
};

function NewSubDir()
{
  var index = GetSelectedItem(gDialog.SiteTree);
  if (index >= 0)
  {
    var item = gFilteredItemsArray[index];
    var url;
    if (item)
    {
      if (!item.isContainer)
      {
        index = gTreeView.getParentIndex(index);
        item = gFilteredItemsArray[index];
        url = item.url;
      }
    }
  }
  else if (gLastDirOpenOrClose >= 0)
  {
    index = gLastDirOpenOrClose;
    item = gFilteredItemsArray[index];
    url = item.url;
  }
  else
  {
    // nothing we can do, all sites are closed...
    return;
  }

  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  var result = {value:null};
  if (promptService.prompt(window,
                           "Create a new directory?",
                           "Please enter a directory name",
                           result,
                           null,
                           {value:0}))
  {
    if (IsFileUrl(url))
    {
      file = GetFileFromURLSpec(url);
      file.append(result.value);
      file.create(1, 755);
      url += "/" + result.value;
      AppendNewDir(url, file.leafName, index);
    }
    else
    {
      url += "/" + result.value;
      createDirURLAsync(url, result.value, index);
      EnableAllUI(false);
    }
  }
}

function SelectItem(e)
{
  if (gDialog.SiteTree.treeBoxObject.selection.count != 1)
    return;
  var index = gDialog.SiteTree.treeBoxObject.selection.currentIndex;

  var item = gFilteredItemsArray[index];
  if (item.isContainer)
    gLastDirOpenOrClose = index;
  else
    gLastDirOpenOrClose = gTreeView.getParentIndex(index);
}

function AppendNewDir(aUrl, aDirName, aParentIndex)
{
  var item = gFilteredItemsArray[aParentIndex];
  var level = item.level;
  var index = aParentIndex + 1;
  while ( gFilteredItemsArray[index].level > level &&
          gFilteredItemsArray[index].name < aDirName )
    index++;

  var realIndex = gFilteredItemsArray[index].realIndex;
  var rqData = { row: index,
                 realRow: realIndex,
               };

  gTreeView.addRow(rqData,
                   aDirName,
                   aUrl,
                   0,
                   "",
                   true,
                   false,
                   false,
                   false,
                   level+1,
                   false);
  for (var i = realIndex; i < gItemsArray.length; i++)
    gItemsArray[i].realIndex = i;

  gDialog.SiteTree.treeBoxObject.rowCountChanged(index, +1);
}

function RefreshDirView()
{
  if (gLastDirOpenOrClose == -1)
    return;

  if (!gTreeView.isContainerOpen(gLastDirOpenOrClose))
    return;

  var row = gLastDirOpenOrClose;
  var count = 1, level = gFilteredItemsArray[row].level;
  while (row+count < gFilteredItemsArray.length && gFilteredItemsArray[row+count].level > level)
    count++;
  count--;

  var realRow = gFilteredItemsArray[row].realIndex;
  var realCount = 1;
  while (realRow+realCount < gItemsArray.length && gItemsArray[realRow+realCount].level > level)
    realCount++;
  realCount--;

  EnableAllUI(false);
  var foo = new FTPDirParser(gFilteredItemsArray[row].url,
                             { total: gFilteredItemsArray.length,
                               row: row+1+count,
                               parentRow: row,
                               realRow: gFilteredItemsArray[row].realIndex + 1 + realCount,
                               refreshCount: count,
                               refreshRealCount: realCount,
                               level: gFilteredItemsArray[row].level+1
                             },
                             AddFTPDirSubdirs, EndRefreshDir, ErrorFtpRequest);
}

function EndRefreshDir(aRQdata)
{
  ForgetAboutLastFtpRequest();
  EnableAllUI(true);

  gDialog.SiteTree.treeBoxObject.rowCountChanged(aRQdata.parentRow + 1 + aRQdata.refreshCount,
                                                 aRQdata.row - aRQdata.parentRow - 1 - aRQdata.refreshCount);
  gFilteredItemsArray.splice(aRQdata.parentRow+1, aRQdata.refreshCount);
  gDialog.SiteTree.treeBoxObject.rowCountChanged(aRQdata.parentRow + 1, -aRQdata.refreshCount);

  var parentRealRow = gFilteredItemsArray[aRQdata.parentRow].realIndex;
  gItemsArray.splice(parentRealRow+1, aRQdata.refreshRealCount);
  var i, l = gItemsArray.length;
  var i, l = gItemsArray.length;
  for (i = parentRealRow + 1; i < l; i++)
    gItemsArray[i].realIndex = i;

  var diff = gFilteredItemsArray.length - aRQdata.refreshCount - aRQdata.total;
  if (!diff)
  {
    gFilteredItemsArray[aRQdata.parentRow].isContainerEmpty = true;
    gDialog.SiteTree.treeBoxObject.invalidateRow(aRQdata.parentRow);
  }
}

function Rename()
{
  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  var index = GetSelectedItem(gDialog.SiteTree);
  if (index == -1)
    return;
  var item = gFilteredItemsArray[index];
  if (item.level == 0)
    return;

  var result = {value: item.name};
  if (promptService.prompt(window,
                           "Rename a file or directory?",
                           "Please enter the new name",
                           result,
                           null,
                           {value: 0}))
  {
    var url = item.url;
    var URL = GetURLFromUrl(url);
    URL.fileName = result.value;

    if (URL.spec == item.url)
      return;
    if (IsFileUrl(url))
    {
      var localFile = GetLocalFileFromURLSpec(url);
      localFile.moveTo(null, result.value);

      item.url  = URL.spec;
      item.name = result.value;

      gItemsArray[item.realIndex].url  = item.url;
      gItemsArray[item.realIndex].name = item.name;
      gDialog.SiteTree.treeBoxObject.invalidateRow(index);
    }
    else
    {
      renameURLAsync(url, URL.path, index);
      //window.document.documentElement.setAttribute("style", "cursor: wait");
      EnableAllUI(false);
    }
  }
}

function RenameTo(aNewName, aIndex)
{
  var item = gFilteredItemsArray[aIndex];

  var url = item.url;
  var URL = GetURLFromUrl(url);
  URL.path = aNewName;

  item.name = URL.fileName;
  gItemsArray[item.realIndex].name = item.name;

  item.url = URL.spec;
  gItemsArray[item.realIndex].url = item.url;

  gDialog.SiteTree.treeBoxObject.invalidateRow(aIndex);
}

function RemoveFileOrDir()
{
  // can we do that?
  var index = GetSelectedItem(gDialog.SiteTree);
  if (index == -1 || !gFilteredItemsArray[index].level)
    return;

  var item = gFilteredItemsArray[index];
  if (item.isContainer)
    RemoveDir(item);
  else
    DeleteFile(item);
}

function DeleteFile(aItem)
{
  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  if (promptService.confirm(window, "Delete File : confirmation?",
                            "Are you sure you want to delete this file?"))
  {
    var url  = aItem.url;
    if (IsFileUrl(url))
    {
      var localFile = GetLocalFileFromURLSpec(url);
      localFile.remove(false);
      DeleteSelectedItem();
    }
    else
    {
      deleteURLAsync(url);
      EnableAllUI(false);
    }
  }
}

function RemoveDir(aItem)
{
  // get a reference to the prompt service component.
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                      .getService(Components.interfaces.nsIPromptService);

  if (promptService.confirm(window, "Remove directory : confirmation?",
                            "Are you sure you want to remove this directory?"))
  {
    var url  = aItem.url;
    if (IsFileUrl(url))
    {
      var localFile = GetLocalFileFromURLSpec(url);
      var dirEntries = localFile.directoryEntries;
      var removeAll = false;
      if (dirEntries.hasMoreElements())
      {
        while (dirEntries.hasMoreElements())
          var junk = dirEntries.getNext();

        if (promptService.confirm(window, "Remove directory : alert",
                                  "This directory is not empty. Do you want to delete its contents too?"))
          removeAll = true;

      }
      localFile.remove(removeAll);
      DeleteSelectedItem();
    }
    else
    {
      removeDirURLAsync(url);
      EnableAllUI(false);
    }
  }
}



function DeleteSelectedItem()
{
  var index = GetSelectedItem(gDialog.SiteTree);
  if (index == -1)
    return;
  var item = gFilteredItemsArray[index];
  gItemsArray.splice(item.realIndex, 1);
  gFilteredItemsArray.splice(index, 1);
  gDialog.SiteTree.treeBoxObject.rowCountChanged(index, -1);  
}

function SiteManagerNotificationHandler(aNotifData, aNotification)
{
  // alert(aNotifData + " " + aNotification);
}
