const classes             = Components.classes;
const interfaces          = Components.interfaces;
const nsILocalFile        = interfaces.nsILocalFile;

function GetLocalFileFromURLSpec(url)
{
  return GetFileFromURLSpec(url).QueryInterface(nsILocalFile);
}

function GetFileFromURLSpec(url)
{
  var fileHandler = GetFileProtocolHandler();
  return fileHandler.getFileFromURLSpec(url);
}

function SelectLocalHDSite(url, tree)
{
  var localFile = GetLocalFileFromURLSpec(url);

  var dirEntries = localFile.directoryEntries;
  while (dirEntries.hasMoreElements())
  {
    var fileEntry = dirEntries.getNext().QueryInterface(Components.interfaces.nsIFile);
    AddLocalDirSubdirs(url, fileEntry, tree);
  }

  EnableAllUI(true);
  window.document.documentElement.removeAttribute("style");

}


function AddLocalDirSubdirs(url, dirEntry, treeitem)
{
  var tch = treeitem.lastChild;

  var ti             = document.createElementNS(XUL_NS, "treeitem");
  var tr             = document.createElementNS(XUL_NS, "treerow");
  var tcLocation     = document.createElementNS(XUL_NS, "treecell");
  var tcSize         = document.createElementNS(XUL_NS, "treecell");
  var tcLastModified = document.createElementNS(XUL_NS, "treecell");

  var createdUpperDirEntry = false;

  var path, name, size, lastModifiedDate, isDir;
  if (dirEntry)
  {
    name = dirEntry.leafName;
    path = url + "/" + name;
    size = dirEntry.fileSize;
    lastModifiedDate = new Date(dirEntry.lastModifiedTime);
    isDir = dirEntry.isDirectory();
  }
  else
  {
    var URL = GetURLFromUrl(url);
    path = URL.filePath;
    if (path == "" || path == "/")
      return;

    // get rid of trailing slashes
    while (path.length && path[path.length - 1] == '/')
      path = path.substr(0, path.length - 1);

    // rely on nsIURL magic
    var dir = URL.directory;

    while (dir.length && dir[dir.length - 1] == '/')
      dir = dir.substr(0, dir.length - 1);

    URL.filePath = dir;

    size             = "";
    lastModifiedDate = "";
    path             = URL.spec;
    name             = "..";
    createdUpperDirEntry  = true;
    isDir = true;
  }

  ti.setAttribute("value", path);
  tcLocation.setAttribute("label", name);
  tcSize.setAttribute("label", size);
  tcLastModified.setAttribute("label", lastModifiedDate);

  tr.appendChild(tcLocation);
  tr.appendChild(tcSize);
  tr.appendChild(tcLastModified);
  ti.appendChild(tr);

  if (isDir)
  {
    ti.setAttribute("container", "true");
    var subtch = document.createElementNS(XUL_NS, "treechildren");
    ti.appendChild(subtch);
    tch.insertBefore(ti, gFirstFileEntry);
    gFirstFileEntry = ti.nextSibling;
    return ti;
  }

  tch.appendChild(ti);
  if (!gFirstFileEntry)
    gFirstFileEntry = ti;

  FilterEntry(gCurrentFilter, ti);
  return ti;
}
