/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/* Mozile Test Suite Script
 * This script takes the URI of the current document, looks at everything after the first "?", and breaks it up. The test target is extracted, as well as a lits of test descriptors. Then four functions are called, one for each of HTML, XHTML, XML, and XUL, which add a test page to the JSUnit suite for each test descriptor.
 * The result is a JSUnit text suite which calls the HTML, XHTML, XML, and XUL versions of each test page specified in the URI.
 */
 

// Detect old versions of Safari, which don't support XML fully.
var isSafari = false;
var oldSafari = false;
if(navigator.userAgent.match(/Safari/)) {
	isSafari = true;
	var match = navigator.userAgent.match(/AppleWebKit\/(\d+)/);
	if(match[1] && match[1] <= 418) oldSafari = true;
}

var root = location.toString();
root = root.slice(0,root.lastIndexOf('testsuite.html'));
if(isSafari) root = root.replace("file://", "file:///");

var args = location.toString();
args = args.slice(args.indexOf('?')+1, args.length);
args = unescape(args);
args = args.split("&");

var target, matchTarget, allTests, matchAllTests;
for(var a=0; a < args.length; a++) {
	matchTarget = args[a].match(/target=(\w+)/);
	if(matchTarget && matchTarget.length == 2) target = matchTarget[1].toLowerCase();
	matchAllTests = args[a].match(/tests=(\[.+\])/);
	if(matchAllTests && matchAllTests.length == 2) allTests = matchAllTests[1];
}

var matchTests = allTests.match(/(\[.+?\])/g);
var tests = matchTests;
//alert(matchTests.length +" Tests: " + tests.join("\n"));

function mozileCoreHTMLSuite() {
  var suite = new top.jsUnitTestSuite();
	for(var i=0; i<tests.length; i++) {
		suite.addTestPage(root +"testpage.htm?test="+ tests[i]);
	}
	return suite;
}
	
function mozileCoreXHTMLSuite() {
  var suite = new top.jsUnitTestSuite();
	for(var i=0; i<tests.length; i++) {
		suite.addTestPage(root +"testpage.html?test="+ tests[i]);
	}
	return suite;
}
	
function mozileCoreXMLSuite() {
  var suite = new top.jsUnitTestSuite();
	for(var i=0; i<tests.length; i++) {
		suite.addTestPage(root +"testpage.xml?test="+ tests[i]);
	}
	return suite;
}
	
function mozileCoreXULSuite() {
  var suite = new top.jsUnitTestSuite();
	for(var i=0; i<tests.length; i++) {
		suite.addTestPage(root +"testpage.xul?test="+ tests[i]);
	}
	return suite;
}

function suite() {
  var suite = new top.jsUnitTestSuite();
	if(target=="html" || target=="all") suite.addTestSuite(mozileCoreHTMLSuite());
	if(target=="xhtml" || target=="all") suite.addTestSuite(mozileCoreXHTMLSuite());
	if(!oldSafari) {
		if(target=="xml" || target=="all") suite.addTestSuite(mozileCoreXMLSuite());
	}
	//	if(target=="xul" || target=="all") suite.addTestSuite(mozileCoreXULSuite());
	return suite;
}
