/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Validation object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Validation.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");

var name = "mozile.rng.Validation";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testBasics", "testCurrentElement", "testCurrentParent",  "testAttributes", "testLogging", "testBranch", "testAppend", "testMerge", "testReport"];
}

/*
 *
 */
function testBasics() {
	var component = new mozile.rng.Validation();
	assertEquals("String is '[object mozile.rng.Validation]'", "[object mozile.rng.Validation]", component.toString());
	assertEquals("Type is 'validation'", "validation", component.getType());
	assertTrue("New validation is valid", component.isValid);
	assertFalse("New validation is not empty", component.isEmpty);
	assertFalse("New validation does not allow text", component.allowText);
	assertNull("New validation has no current element", component._currentElement);
	assertNull("New validation has no last valid element", component._lastValidElement);
	assertEquals("New validation has 0 valid attributes", 0, component._validAttributes.length);
	assertEquals("New validation has 0 messages", 0, component._messages.length);
}

/**
 * 
 */
function testCurrentElement() {
	var component = new mozile.rng.Validation();

	var element1 = document.createElement("element");	
	component.setCurrentElement(element1);
	assertEquals("The current element should be element1", element1, component.getCurrentElement());
	assertNull("There should be no last valid element", component._lastValidElement);

	var element2 = document.createElement("element");	
	component.setCurrentElement(element2);
	assertEquals("The current element should be element2", element2, component.getCurrentElement());
	assertEquals("The last valid element should be element1", element1, component._lastValidElement);
}

/**
 * 
 */
function testCurrentParent() {
	var component = new mozile.rng.Validation();
	var target = document.getElementById("target");

	assertNull("There should be no current parent", component.getCurrentParent());
	assertEquals("The current parent should be 'target'", target, component.setCurrentParent(target));
	assertEquals("The current parent should be 'target'", target, component.getCurrentParent());
}

/**
 * 
 */
function testAttributes() {
	var component = new mozile.rng.Validation();
	var target = document.getElementById("target");
	var id = target.getAttributeNode("id");
	
	assertFalse("The id attribute should not be valid", component.isAttributeValid(id));
	component.addAttribute(id);
	assertEquals("The validation shoudl have 1 valid attribute", 1, component._validAttributes.length);
	assertTrue("The id attribute should be valid", component.isAttributeValid(id));
	
}

/**
 * 
 */
function testLogging() {
	var component = new mozile.rng.Validation();

	component.logMessage(null, null, "Message");
	assertEquals("There should be 1 message", 1, component._messages.length);
	assertTrue("The validation is still valid", component.isValid);

	component.logError(null, null, "Message");
	assertEquals("There should be 2 messages", 2, component._messages.length);
	assertFalse("The validation is no longer valid", component.isValid);
	
	assertNotNull("There should be a first error", component.getFirstError());
}

/**
 * 
 */
function testBranch() {
	var component = new mozile.rng.Validation();
	var target = document.getElementById("target");
	component.setCurrentParent(target);
	
	var validation = component.branch();
	assertEquals("Current parent should be the same", component.getCurrentParent(), validation.getCurrentParent());

}

/**
 * 
 */
function testAppend() {
	var component = new mozile.rng.Validation();
	var target = document.getElementById("target");
	var id = target.getAttributeNode("id");
	
	var validation = new mozile.rng.Validation();
	validation.logError(null, null, "Message");
	validation.isEmpty = true;
	validation.allowText = true;
	validation.setCurrentElement(document.createElement("element1"));
	validation.setCurrentElement(document.createElement("element2"));
	validation.addAttribute(id);

	component.append(validation);
	
	assertEquals("There should be 1 message", 1, component._messages.length);
	assertFalse("No longer valid", component.isValid);
	assertFalse("Still not empty", component.isEmpty);
	assertFalse("Still does not allow text", component.allowText);
	assertNull("Still has no current element", component._currentElement);
	assertNull("Still has no last valid element", component._lastValidElement);
	assertEquals("Still has 0 valid attributes", 0, component._validAttributes.length);
}

/**
 * 
 */
function testMerge() {
	var component = new mozile.rng.Validation();
	var target = document.getElementById("target");
	var id = target.getAttributeNode("id");
	
	var validation = new mozile.rng.Validation();
	validation.logError(null, null, "Message");
	validation.isEmpty = true;
	validation.allowText = true;
	validation.setCurrentElement(document.createElement("element1"));
	validation.setCurrentElement(document.createElement("element2"));
	validation.addAttribute(id);

	component.merge(validation);
	
	assertEquals("There should be 1 message", 1, component._messages.length);
	assertFalse("No longer valid", component.isValid);
	assertTrue("Now empty", component.isEmpty);
	assertTrue("Now allows text", component.allowText);
	assertNotNull("Now has a current element", component._currentElement);
	assertNotNull("Now has a last valid element", component._lastValidElement);
	assertEquals("Now has 1 valid attribute", 1, component._validAttributes.length);
}

/**
 * 
 */
function testReport() {
	var component = new mozile.rng.Validation();
	component.logMessage(null, null, "Test Message");
	assertEquals("Check report", "1. Message  validation     Test Message", component.report());
}
