/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Start object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Start.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Start";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRNGNode", "testCombine", "testValidate"];
}


function getNode() {
	return new mozile.rng.Start(mozile.xml.parseElement('<start/>'), mozile.test.rng.schema);
}
	
/**
 * Test node, naming, and namespace.
 */
function testRNGNode() {
	var RNGNode = getNode();
	mozile.test.rng.checkRNGNode(RNGNode);
}
	
/**
 * 
 */
function testCombine() {
	// Older version of Safari crash during this test.
	if(mozile.browser.isSafari && mozile.browser.safariVersion <= 418) return;

	var schema1 = new mozile.rng.Schema('<grammar xmlns="http://relaxng.org/ns/structure/1.0"><start><element name="a"><empty/></element></start></grammar>');
	var node1 = schema1._root.getChildNode(0);
	var schema2 = new mozile.rng.Schema('<grammar xmlns="http://relaxng.org/ns/structure/1.0"><start combine="choice"><element name="b"><empty/></element></start></grammar>');
	var node2 = schema2._root.getChildNode(0);	
	
	node1.combine(node2);
	assertEquals("There should be only one child", 1, node1.getChildNodes().length);
	assertEquals("The first child's type should be 'choice'", "choice", node1.getChildNode(0).getType());
	assertEquals("There should be two grand children", 2, node1.getChildNode(0).getChildNodes().length);

	var schema1 = new mozile.rng.Schema('<grammar xmlns="http://relaxng.org/ns/structure/1.0"><start><element name="a"><empty/></element></start></grammar>');
	var node1 = schema1._root.getChildNode(0);
	var schema2 = new mozile.rng.Schema('<grammar xmlns="http://relaxng.org/ns/structure/1.0"><start combine="interleave"><element name="b"><empty/></element></start></grammar>');
	var node2 = schema2._root.getChildNode(0);	
	
	node1.combine(node2);
	assertEquals("There should be only one child", 1, node1.getChildNodes().length);
	assertEquals("The first child's type should be 'interleave'", "interleave", node1.getChildNode(0).getType());
	assertEquals("There should be two grand children", 2, node1.getChildNode(0).getChildNodes().length);
}

/**
 * Test validation.
 */
function testValidate() {
	mozile.test.rng.checkCases(name);
}

