/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Empty object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Empty.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Empty";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRNGNode", "testValidate"];
}

/**
 * Create a sample node.
 */
function getNode() {
	return new mozile.rng.Empty(mozile.xml.parseElement('<empty/>'), mozile.test.rng.schema);
}
	
/**
 * 
 */
function testRNGNode() {
	var RNGNode = getNode();
	mozile.test.rng.checkRNGNode(RNGNode);
	assertFalse("mustHave('element') is false", RNGNode.mustHave('element'));
	assertFalse("mustHave('attribute') is false", RNGNode.mustHave('attribute'));
}


/**
 * 
 */
function testValidate() {
	var xmlDoc = mozile.xml.parseElement('<a></a>');
	var RNGNode, validation;
	
	RNGNode = new mozile.rng.Empty(document.createElement("empty"));
	validation = new mozile.rng.Validation();
	validation = RNGNode.validate(xmlDoc, validation);
	assertTrue("isEmpty should be true", validation.isEmpty);
	
	RNGNode = new mozile.rng.Text(document.createElement("text"));
	validation = new mozile.rng.Validation();
	validation = RNGNode.validate(xmlDoc, validation);
	assertFalse("isEmpty should be false", validation.isEmpty);
}

