<?xml version="1.0" encoding="UTF-8"?>


<!--
/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */

/** 
 * @fileoverview Converts the index.xml file into XHTML.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: index.xsl,v 1.2 2006/08/23 16:55:26 jameso Exp $
 */
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes"/>
	
	<xsl:template match="/">
<html>
	<head>
		<title>Mozile Test Index</title>
		<!--<script type="application/x-javascript" src="index.js"/>-->
		<script type="text/javascript" src="index.js"></script>
		<style type="text/css">
		
body {
	font-family: Arial, Helvitica, sans-serif;	
}

table {
	width: 100%;
}

.tableHeader {
	font-size: larger;
	font-weight: bold;
	background-color: lightblue;
}

.group {
	font-size: larger;
	font-weight: bold;
	background-color: #EEEEEE;
}

.name {
	background-color: lightgray;
	padding: 5px;
	text-align: left;
}

.description {
	font-style: italic;
	padding: 10px 5px 10px 5px;
}

.unit1 {
}

.unit2 {
	font-size: small;
	color: #888888;
	background-color: #EFEFEF;
}

.depth0 .name { 
	border-right: solid white 20px;
}
.depth1 .name {
	border-left: solid white 10px;
	border-right: solid white 10px;
}
.depth2 .name {
	border-left: solid white 20px;
}

.button {
	text-align: center;
	background-color: #CCCCCC;
	color: white;
	-moz-border-radius: 4px;
	padding: 2px 5px 2px 5px;
}
.button:hover {
	background-color: gray;
	cursor: pointer;
}

.fullSuite {
	font-size: larger;
	font-weight: bold;
}

#fullSuite {
	font-size: 18pt;
	text-align: right;
	padding-right: 10px;
}

		</style>
	</head>

	<body>
		<h2>Mozile Test Suite</h2>
		<table>
			<tr class="fullSuite">
				<td id="fullSuite" colspan="2">Full Test Suite</td>
				<xsl:call-template name="testsuiteButtons"/>
			</tr>
			
			<xsl:apply-templates/>
		
		</table>
	</body>
</html>
	</xsl:template>
	
	<!-- Creates test group. -->
	<xsl:template match="group">
		<tr class="group">
			<td colspan="2">
				<xsl:call-template name="name"/>
			</td>
			<xsl:call-template name="testsuiteButtons"/>
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- Creates a unit test entry. -->
	<xsl:template match="unit">
		<tr>
			<xsl:attribute name="class">
				<xsl:text>depth</xsl:text>
				<xsl:value-of select="count(ancestor::unit)"/>
			</xsl:attribute>
			<th class="name" rowspan="2">
				<xsl:call-template name="name"/>
			</th>
			<td class="description" colspan="6">
				<xsl:value-of select="@description"/>
			</td>
		</tr>
		<tr>
			<xsl:attribute name="class">
				<xsl:text>unit2</xsl:text>
			</xsl:attribute>
			<td>
				<xsl:value-of select="@targets"/>
			</td>
			<xsl:call-template name="testpageButtons"/>
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- Creates a functional test entry. -->
	<xsl:template match="function">
		<tr>
			<xsl:attribute name="class">
				<xsl:text>depth</xsl:text>
				<xsl:value-of select="count(ancestor::function)"/>
			</xsl:attribute>
			<th class="name" rowspan="2">
				<xsl:value-of select="@name"/>
			</th>
			<td class="description" colspan="6">
				<xsl:value-of select="@description"/>
			</td>
		</tr>
		<tr>
			<xsl:attribute name="class">
				<xsl:text>unit2</xsl:text>
			</xsl:attribute>
			<td>
			</td>
			<xsl:call-template name="testpageButtons"/>
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- Creates an RNG test entry. -->
	<xsl:template match="rng">
		<tr>
			<xsl:attribute name="class">
				<xsl:text>depth</xsl:text>
				<xsl:value-of select="count(ancestor::rng)"/>
			</xsl:attribute>
			<th class="name" rowspan="2">
				<xsl:call-template name="name"/>
			</th>
			<td class="description" colspan="6">
				<xsl:value-of select="@description"/>
			</td>
		</tr>
		<tr>
			<xsl:attribute name="class">
				<xsl:text>unit2</xsl:text>
			</xsl:attribute>
			<td></td>
			<td class="button" colspan="4">
				<xsl:attribute name="onclick">
					<xsl:text>javascript:openJsUnitTestPage('shared/testpage.html&amp;test=</xsl:text>
					<xsl:call-template name="testDescriptor"/>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>TEST</xsl:text>
			</td>
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template name="name">
		<xsl:if test="@module and @file">
			<a>
				<xsl:attribute name="href">
					<xsl:call-template name="module"/>
				</xsl:attribute>
				<xsl:value-of select="@module"/>
			</a>
			<xsl:text> :: </xsl:text>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@file">
				<a>
					<xsl:attribute name="href">
						<xsl:text>../src/</xsl:text>
						<xsl:value-of select="@file"/>
					</xsl:attribute>
					<xsl:value-of select="@name"/>
				</a>
			</xsl:when>
			<xsl:when test="@module">
				<a>
					<xsl:attribute name="href">
						<xsl:call-template name="module"/>
					</xsl:attribute>
					<xsl:value-of select="@name"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="module">	
		<xsl:text>../doc/jsdoc/</xsl:text>
		<xsl:choose>
			<xsl:when test="contains(@module, '.*')">
				<xsl:value-of select="substring(@module, 0, string-length(@module) - 1)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@module"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>.html</xsl:text>
	</xsl:template>



	<!-- Creates a set of test suite buttons. -->
	<xsl:template name="testsuiteButtons">
		<xsl:call-template name="testsuiteButton">
			<xsl:with-param name="target">all</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="testsuiteButton">
			<xsl:with-param name="target">html</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="testsuiteButton">
			<xsl:with-param name="target">xhtml</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="testsuiteButton">
			<xsl:with-param name="target">xml</xsl:with-param>
		</xsl:call-template>
		<!--
		<xsl:call-template name="testsuiteButton">
			<xsl:with-param name="target">xul</xsl:with-param>
		</xsl:call-template>
		-->
	</xsl:template>

	<!-- Creates a set of test page buttons. -->
	<xsl:template name="testpageButtons">
			<xsl:call-template name="testallButton"/>
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="target">html</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="target">xhtml</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="target">xml</xsl:with-param>
			</xsl:call-template>
			<!--
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="target">xul</xsl:with-param>
			</xsl:call-template>
			-->
	</xsl:template>


	<!-- Creates a button pointing to a testsuite including all child tests and using the given file type. -->
	<xsl:template name="testsuiteButton">
		<xsl:param name="target"/>
		<td class="button">
			<xsl:attribute name="onclick">
				<xsl:text>javascript:openJsUnitTestPage('shared/testsuite.html</xsl:text>
				<xsl:text>&amp;target=</xsl:text>
				<xsl:value-of select="$target"/>
				<xsl:text>&amp;tests=</xsl:text>
				<xsl:for-each select="descendant::*[name()!='group']">
					<xsl:call-template name="testDescriptor"/>
				</xsl:for-each>
				<xsl:text>')</xsl:text>
			</xsl:attribute>
			<xsl:value-of select="translate($target, 'axuhtml', 'AXUHTML')"/>
		</td>
	</xsl:template>
	
	<!-- Creates a test suite button for this test, pointing to a testsuite which includes all file types. -->
	<xsl:template name="testallButton">
		<td class="button">
			<xsl:attribute name="onclick">
				<xsl:text>javascript:openJsUnitTestPage('shared/testsuite.html</xsl:text>
				<xsl:text>&amp;target=</xsl:text>
				<xsl:text>all</xsl:text>
				<xsl:text>&amp;tests=</xsl:text>
				<xsl:call-template name="testDescriptor"/>
				<xsl:text>')</xsl:text>
			</xsl:attribute>
			<xsl:text>ALL</xsl:text>
		</td>
	</xsl:template>
	
	<!-- Creates a button for the current test, pointing to a testpage with the given file type. -->
	<xsl:template name="testpageButton">
		<xsl:param name="target"/>
		<xsl:param name="filetype">
			<xsl:choose>
				<xsl:when test="$target='html'">htm</xsl:when>
				<xsl:when test="$target='xhtml'">html</xsl:when>
				<xsl:otherwise><xsl:value-of select="$target"/></xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<td class="button">
			<xsl:attribute name="onclick">
				<xsl:text>javascript:openJsUnitTestPage('shared/testpage.</xsl:text>
				<xsl:value-of select="$filetype"/>
				<xsl:text>&amp;test=</xsl:text>
				<xsl:call-template name="testDescriptor"/>
				<xsl:text>')</xsl:text>
			</xsl:attribute>
			<xsl:value-of select="translate($target, 'axuhtml', 'AXUHTML')"/>
		</td>
	</xsl:template>
	
	<!-- Creates an entry specifying the test type and included files. -->
	<xsl:template name="testDescriptor">
		<xsl:text>[</xsl:text>
		<xsl:value-of select="name()"/>
		<xsl:text>:</xsl:text>
		<xsl:for-each select="ancestor-or-self::*/@utilities">
			<xsl:value-of select="."/>
			<xsl:text>,</xsl:text>
		</xsl:for-each>
		<xsl:value-of select="@testpages"/>
		<xsl:text>]</xsl:text>
	</xsl:template>
	
	
</xsl:stylesheet>