/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's splitNodes command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: splitNodes.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
//mozile.require("mozile.test.edit.util");
var name = "mozile.edit.splitNodes";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testClimbAndSplit"];
	return ["testSplitText", "testSplitElements", "testClimbAndSplit", "testSplitFromStart", "testSplitFromEnd"];
}

/**
 * 
 */
function testSplitText() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNodes;
	assertEquals("Name should be 'SplitNodes'", "SplitNodes", command.name);

	var container = document.getElementById("container");
	var target = document.getElementById("target");
	var targetChildren = target.childNodes.length;
	var text = target.firstChild;
	var original = text.data;

	// Execute
	var i = 1;
	var state = command.request({}, false, text, 4, target);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Target should have one more child node", targetChildren + 1, target.childNodes.length);
	assertEquals("Check the first part of the split 'text' node.", original.substring(0, 4), target.firstChild.data);
	assertEquals("Check the second part of the split 'text' node.", original.substring(4), target.childNodes[1].data);
	
	assertEquals("The old container should be text", text, state.oldContainer);
	assertEquals("The new container should be text's next sibling", text.nextSibling, state.newContainer);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Target should the original number of child nodes", targetChildren, target.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
	
}

/**
 * 
 */
function testSplitElements() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNodes;
	assertEquals("Name should be 'SplitNodes'", "SplitNodes", command.name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var text = target2.firstChild;
	var original = text.data;

	// Execute
	var i = 1;
	var state = command.request({}, false, text, 4, container);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("Check the first part of the split 'text' node.", original.substring(0, 4), target2.lastChild.data);
	assertEquals("Check the second part of the split 'text' node.", original.substring(4), target.nextSibling.firstChild.firstChild.data);
	
	assertEquals("The old container should be target", target, state.oldContainer);
	assertEquals("The new container should be target's next sibling", target.nextSibling, state.newContainer);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
}

/**
 * Test splitNodes' ability to climb upward in the DOM tree.
 */
function testClimbAndSplit() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNodes;
	assertEquals("Name should be 'SplitNodes'", "SplitNodes", command.name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var text = target2.firstChild;
	var original = text.data;

	// Execute
	var i = 1;
	var state = command.request({}, false, text, 0, container);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("Target should have just one child", 1, target.childNodes.length);
	assertEquals("target2 should be the first child of the new container", target2, target.nextSibling.firstChild);
	assertEquals("target2's text should be the same", original, target.nextSibling.firstChild.firstChild.data);
	
	assertEquals("The old container should be target", target, state.oldContainer);
	assertEquals("The new container should be target's next sibling", target.nextSibling, state.newContainer);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
}

/**
 * That split node doesn't climb too far up the DOM tree.
 */
function testSplitFromStart() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNodes;
	assertEquals("Name should be 'SplitNodes'", "SplitNodes", command.name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var text = target.firstChild;
	var original = text.data;

	// Execute
	var i = 1;
	var state = command.request({}, false, text, 0, container, true);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("Target should have one child", 1, target.childNodes.length);
	assertTrue("Target should now contain only an empty token", mozile.edit.isEmptyToken(target.firstChild));
	assertEquals("Check the second part of the split 'text' node.", original, target.nextSibling.firstChild.data);
	
	assertEquals("The old container should be target", target, state.oldContainer);
	assertEquals("The new container should be target's next sibling", target.nextSibling, state.newContainer);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
}


/**
 * That split node doesn't climb too far up the DOM tree.
 */
function testSplitFromEnd() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNodes;
	assertEquals("Name should be 'SplitNodes'", "SplitNodes", command.name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var targetChildren = target.childNodes.length;
	var text = target.lastChild;
	var original = text.data;

	// Execute
	var i = 1;
	var state = command.request({}, false, text, text.data.length, container, true);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("Target should have the same number of children", targetChildren, target.childNodes.length);
	assertTrue("Target's next sibling should now contain only an empty token", mozile.edit.isEmptyToken(target.nextSibling.firstChild));
	assertEquals("Check the 'text' node.", original, text.data);
	
	assertEquals("The old container should be target", target, state.oldContainer);
	assertEquals("The new container should be target's next sibling", target.nextSibling, state.newContainer);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
}

