/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's rich editing functionality.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: rich.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */

mozile.require("mozile.edit");
mozile.require("mozile.edit.rich");
mozile.require("mozile.xml");
mozile.require("mozile.test.edit.util");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.rich";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testEnsureNonEmpty"];
	return ["testEnsureNonEmpty"];
}

/**
 * 
 */
function testEnsureNonEmpty() {
	mozile.test.shared.preselect();
	var container = document.getElementById("container");
	var target = document.getElementById("target");
	var p = target.cloneNode(false);
	container.appendChild(p);
	var text = document.createTextNode("");
	p.appendChild(text);

	// Text case
	assertFalse("Text is not an empty token", mozile.edit.isEmptyToken(text));
	mozile.edit._ensureNonEmpty({}, false, text);
	assertTrue("Text should now be an empty token", mozile.edit.isEmptyToken(text));
	text.data = "test";
	mozile.edit._ensureNonEmpty({}, false, text);
	assertEquals("Text should be unchanged", "test", text.data);
	
	// Element case
	text.data = "";
	mozile.edit._ensureNonEmpty({}, false, p);
	assertTrue("Text should again be an empty token", mozile.edit.isEmptyToken(text));
	p.removeChild(text);
	mozile.edit._ensureNonEmpty({}, false, p);
	assertEquals("p should have one child", 1, p.childNodes.length);
	assertTrue("p's first child should be an empty token", mozile.edit.isEmptyToken(p.firstChild));
	
	container.removeChild(p);
}


