/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Remove Text command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: removeText.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.removeText";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testBackspace", "testDelete", "testRange"];
}

/**
 * 
 */
function testBackspace() {
	var command = mozile.edit.removeText;
	assertEquals("Name should be 'RemoveText'", "RemoveText", command.name);

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var text = target.firstChild;
	var original = text.data;
	var range = new mozile.dom.Range();
	range.setStart(text, original.length);
	range.collapse(true);
	var selection = mozile.dom.selection.get();
	selection.removeAllRanges();
	selection.addRange(range);
	
	var event = {
		type: "keypress", 
		keyCode: 8, // backspace key
		node: text,
		content: " ",
		ctrlKey: false, 
		metaKey: false,
		selection: selection
	}
	if(mozile.browser.isIE) event.type = "keydown";
	var count = 50;
	var states = new Array();
	var state;
	
	// Execute
	for(var i=0; i < count; i++) {
		//var state = command.prepare(event);
		//state = command.execute(state);
		state = command.trigger(event);
		states.push(state);
		assertTrue("Command "+ i +" should have been executed.", state.executed);		
		assertEquals("Check the text node contents after execution "+ i, 
			original.substring(0, original.length - (i+1)), text.data);
	}
	
	//alert(states.length +" : "+ text.data);
	
	// Unexecute
	for(i = states.length - 1; i >= 0; i--) {
		state = states[i];
		state = command.unexecute(state, true); // Use the "fresh" mode.
		assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
		assertEquals("Check the text node contents after unexecution "+ i, 
			original.substring(0, original.length - i), text.data);
	}
}


/**
 * 
 */
function testDelete() {
	var command = mozile.edit.removeText;
	assertEquals("Name should be 'RemoveText'", "RemoveText", command.name);

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var text = target.firstChild;
	var original = text.data;
	var range = new mozile.dom.Range();
	range.setStart(text, 0);
	range.collapse(true);
	var selection = mozile.dom.selection.get();
	selection.removeAllRanges();
	selection.addRange(range);
	
	var event = {
		type: "keypress", 
		keyCode: 46,  // delete key
		node: text,
		content: " ",
		ctrlKey: false, 
		metaKey: false,
		selection: selection
	}
	if(mozile.browser.isIE) event.type = "keydown";
	var count = 50;
	var states = new Array();
	var state;
	
	// Execute
	for(var i=0; i < count; i++) {
		//var state = command.prepare(event);
		//state = command.execute(state);
		state = command.trigger(event);
		states.push(state);
		assertTrue("Command "+ i +" should have been executed.", state.executed);		
		assertEquals("Check the text node contents after execution "+ i, 
			original.substring(i+1), text.data);
	}
	
	//alert(states.length +" : "+ text.data);
	
	// Unexecute
	for(i = states.length - 1; i >= 0; i--) {
		state = states[i];
		state = command.unexecute(state, true); // Use the "fresh" mode.
		assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
		assertEquals("Check the text node contents after unexecution "+ i, 
			original.substring(i), text.data);
	}
}



/**
 * Non-collapsed case
 */
function testRange() {
	var command = mozile.edit.removeText;
	assertEquals("Name should be 'RemoveText'", "RemoveText", command.name);

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var text = target.firstChild;
	var original = text.data;
	var range = new mozile.dom.Range();
	range.setStart(text, 1);
	range.setEnd(text, original.length - 1);
	var selection = mozile.dom.selection.get();
	selection.removeAllRanges();
	selection.addRange(range);
	
	var event = {
		type: "keypress", 
		keyCode: 8,  // backspace key
		node: text,
		content: " ",
		ctrlKey: false, 
		metaKey: false,
		selection: selection
	}
	if(mozile.browser.isIE) event.type = "keydown";
	
	var state = command.trigger(event);
	assertTrue("The command should have been executed.", state.executed);		
	assertEquals("The text node should have 2 characters left", 
			original.charAt(0) + original.charAt(original.length - 1), text.data);
	state = command.unexecute(state, true);
	assertFalse("The command should have been unexecuted.", state.executed);		
	assertEquals("The text node should match the original", 
			original, text.data);
}
