/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's insertNode command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: insertNode.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.insertNode";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testCommand"];
}

/**
 * 
 */
function testCommand() {
	var command = mozile.edit.insertNode;
	assertEquals("Name should be 'InsertNode'", "InsertNode", command.name);
	
	var element = mozile.dom.createElement("element");
	var target = document.getElementById("target");
	
	// Execute
	var state = new command.prepare(null);
	state.content = element;
	state.location.parentNode = mozile.xpath.getXPath(target);
	state = command.execute(state, false);
	assertTrue("Command should have been executed.", state.executed);
	assertEquals("Check that the element has been inserted", state.content, target.firstChild);
	
	// Unexecute
	state = command.unexecute(state, true); // use "fresh" mode
	assertFalse("Command should have been unexecuted.", state.executed);
	if(state.content.parentNode) assertEquals("If target has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, state.content.parentNode.nodeType);
	else assertEquals("Check that the target has been removed", null, state.content.parentNode);
	
}
