/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Unwrap  command class.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Unwrap.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.Unwrap";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testGetTarget"];
	return ["testIsAvailable", "testElement"];
}

/**
 * 
 */
function testIsAvailable() {
	var name = "testCommand";
	var command = new mozile.edit.Unwrap(name);
	command.target = "localName p";
	
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var container = document.getElementById("container");
	var event = {};

	event.node = target2.firstChild;
	assertTrue("Check inside target2", command.isAvailable(event));
	event.node = target.firstChild;
	assertTrue("Check inside target", command.isAvailable(event));
	event.node = container;
	assertFalse("Check inside container", command.isAvailable(event));
}

/**
 * 
 */
function testElement() {
	var name = "testCommand";
	var command = new mozile.edit.Unwrap(name);
	command.prompt = function(event, state) { 
		state.test = true; 
		return true;
	}

	assertEquals("Name should be '"+ name +"'", name, command.name);
	assertEquals("Group should be false", false, command.group);

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var original1 = target.firstChild.data;
	var original2 = target2.firstChild.data;
	var original3 = target2.nextSibling.data;
	var after = original1 + original2 + original3;
	var length = target.childNodes.length;

	var selection = mozile.dom.selection.get();
	selection.collapse(target2.firstChild, 5);
	
	var event = { };
	
	// Execute
	var state = command.prepare(event);
	var targetNode = mozile.xpath.getNode(state.target);
	assertNotUndefined("There should be a state")
	assertEquals("test should be true", true, state.test);
	
	state = command.execute(state);
	assertTrue("The command should have been executed.", state.executed);
	assertEquals("Check the text node contents after execution", 
		after, target.firstChild.data);
	assertEquals("There should be fewer child nodes", length - 2, target.childNodes.length);

	assertEquals("The selection should be in the firstChild", target.firstChild, selection.focusNode);
	assertEquals("The selection offset should be ...", original1.length + 5, selection.focusOffset);
	assertEquals("The selection should be collapsed", true, selection.isCollapsed);

	if(targetNode.parentNode) assertEquals("If the target has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, targetNode.parentNode.nodeType);
	else assertEquals("Check that the state.wrapper has been removed", null, targetNode.parentNode);
	
	// Unexecute
	state = command.unexecute(state);
	assertFalse("The command should have been unexecuted.", state.executed);
	assertEquals("Check the text node contents after unexecution 1", 
		original1, target.firstChild.data);
	assertEquals("Check the text node contents after unexecution 2", 
		original2, target2.firstChild.data);
	assertEquals("Check the text node contents after unexecution 3", 
		original3, target.childNodes[2].data);
	assertEquals("Target 2 should be restored.", 
		target2, target.childNodes[1]);

	delete mozile.edit.allCommands[name];
}

