/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's editing State class.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: State.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */

mozile.require("mozile.edit");
var name = "mozile.edit.State";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testIsEmpty"];
	return ["testCreate", "testToString", "testStoreNode"];
}

/**
 *
 */
function testCreate() {
	var command = {name: "command"};
	var state = new mozile.edit.State(command);
	assertEquals("The state's command is the command object", command, state.command);
}

/**
 *
 */
function testToString() {
	var command = {name: "command"};
	var state = new mozile.edit.State(command);
	assertEquals("Check the state's string", "[object mozile.edit.State]", state.toString());
}

/**
 *
 */
function testStoreNode() {
	var command = {name: "command"};
	var state = new mozile.edit.State(command);
	
	var target = document.getElementById("target");
	
	assertNull("null should not be stored", state.storeNode(null));
	assertNull("'cats' should not be stored", state.storeNode("cats"));
	assertNull("15 should not be stored", state.storeNode(15));
	
	assertEquals("'/cats' should be stored", "/cats", state.storeNode("/cats"));
	assertEquals("target should be stored", "string", typeof state.storeNode(target));
}

