/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's cross-browser range functions.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: rangeProfile.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */


mozile.require("mozile.dom");
mozile.require("mozile.test.shared.util");
var name = "mozile.range.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testCreate"];
}


/**
 *
 */
function testCreate() {

	mozile.test.shared.preselect();
	for(var i=0; i < 100; i++) {
		var s = new mozile.dom.Selection();
	}
	return;

	var target = document.getElementById("target");
	var range = document.body.createTextRange();
	range.findText("JavaScript test files");
	for(var i=0; i < 100; i++) {
		var r = new mozile.dom.Range(range);
		r._init();
	}
	return;

	var target = document.getElementById("target");
	var range = document.body.createTextRange();
	range.findText("JavaScript test files");
	var r = new mozile.dom.Range(range);
	r._init();
	alert(mozile.util.dumpValues(r.store()));
	return;

	for(var i=0; i < 100; i++) {
		var r = new mozile.dom.Range();
		r._init();
	}

} 


/**
 *
 */
function testSetStart() {
	var target = document.getElementById('target');
	
	for(var i=0; i < 1000; i++) {
		var r = new mozile.dom.Range();
		r.setStart(target.lastChild, target.lastChild.data.length);
		r.setEnd(target.lastChild, target.lastChild.data.length);
	}

}    







