/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's cross-browser TreeWalker object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: TreeWalker.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */


mozile.require("mozile.dom");
var name = "mozile.dom.TreeWalker.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testWalkAll"];
	return ["testInit", "testNavigateAll", "testNavigateElements", "testNavigateText", "testWalkAll", "testWalkElements", "testWalkText"];
}


/**
 *
 */
function testInit() {
	var	treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_ALL, null, false);
	assertEquals("Range constructor should create a treeWalker object", "object", typeof(treeWalker));
}


/**
 *
 */
function testNavigateAll() {
	var target = document.getElementById("target");
	
	var treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_ALL, null, false);
	treeWalker.currentNode = target;

	treeWalker.firstChild();
	assertEquals("firstChild is text", target.firstChild, treeWalker.currentNode);
	treeWalker.nextSibling();
	assertEquals("nextSibling is span", target.childNodes[1], treeWalker.currentNode);
	treeWalker.lastChild();
	assertEquals("lastChild is span's text", target.childNodes[1].lastChild, treeWalker.currentNode);
	treeWalker.parentNode();
	assertEquals("parentNode is span", target.childNodes[1], treeWalker.currentNode);
	treeWalker.previousSibling();
	assertEquals("previousSibling is text", target.firstChild, treeWalker.currentNode);
}


/**
 *
 */
function testNavigateElements() {
	var target = document.getElementById("target");
	var target5 = document.getElementById("target5");
	var container = document.getElementById("container");
	
	var treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_ELEMENT, null, false);
	treeWalker.currentNode = container;

	treeWalker.firstChild();
	assertEquals("firstChild is p", mozile.dom.getFirstChildElement(container), treeWalker.currentNode);
	treeWalker.nextSibling();
	assertEquals("nextSibling is target", target, treeWalker.currentNode);
	treeWalker.lastChild();
	assertEquals("lastChild is target5", target5, treeWalker.currentNode);
	treeWalker.parentNode();
	assertEquals("parentNode is span", target, treeWalker.currentNode);
	treeWalker.previousSibling();
	assertEquals("previousSibling is text", mozile.dom.getFirstChildElement(container), treeWalker.currentNode);
}


/**
 *
 */
function testNavigateText() {
	var target = document.getElementById("target");
	
	var treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_TEXT, null, false);
	treeWalker.currentNode = target;

	treeWalker.firstChild();
	//debug(mozile.xpath.getXPath(treeWalker.currentNode));
	assertEquals("firstChild is text", target.firstChild, treeWalker.currentNode);
	treeWalker.nextSibling();
	//debug(mozile.xpath.getXPath(treeWalker.currentNode));
	// TODO: Mozilla says the nextSibling is the span's text. Is that really right?
	//assertEquals("nextSibling is span's text", target.childNodes[1].firstChild, treeWalker.currentNode);
	treeWalker.previousSibling();
	//debug(mozile.xpath.getXPath(treeWalker.currentNode));
	assertEquals("previousSibling is text", target.firstChild, treeWalker.currentNode);
}

/**
 *
 */
function testWalkAll() {
	var target = document.getElementById("target");
	
	var nodes = [
		target,
		target.childNodes[0],
		target.childNodes[1],
		target.childNodes[1].firstChild,
		target.childNodes[2],
		target.childNodes[3],
		target.childNodes[3].firstChild,
		target.childNodes[4],
		target.childNodes[5],
		target.childNodes[6],
		target.childNodes[7],
		target.childNodes[7].firstChild,
		target.childNodes[7].firstChild.firstChild,
		target.childNodes[8]
	];	
	
	var treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_ALL, null, false);
	treeWalker.currentNode = nodes[0];

	// Next
	for(var i=1; i < nodes.length; i++) {
		treeWalker.nextNode();
		//debug("Next: nodes["+ i +"] "+ mozile.xpath.getXPath(nodes[i]) +" -- currentNode "+ mozile.xpath.getXPath(treeWalker.currentNode));
		assertEquals("Next node "+ i +" should match the currentNode", nodes[i], treeWalker.currentNode);
	}

	// Previous
	for(i = nodes.length - 2; i >= 0; i--) {
		treeWalker.previousNode();
		//debug("Next: nodes["+ i +"] "+ mozile.xpath.getXPath(nodes[i]) +" -- currentNode "+ mozile.xpath.getXPath(treeWalker.currentNode));
		assertEquals("Previous node "+ i +" should match the currentNode", nodes[i], treeWalker.currentNode);
	}
	
}


/**
 *
 */
function testWalkElements() {
	var target = document.getElementById("target");
	
	var nodes = [
		target,
		target.childNodes[1],
		target.childNodes[3],
		target.childNodes[5],
		target.childNodes[7],
		target.childNodes[7].firstChild
	];	
	
	var treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_ELEMENT, null, false);
	treeWalker.currentNode = nodes[0];

	// Next
	for(var i=1; i < nodes.length; i++) {
		treeWalker.nextNode();
		//debug("Next: nodes["+ i +"] "+ mozile.xpath.getXPath(nodes[i]) +" -- currentNode "+ mozile.xpath.getXPath(treeWalker.currentNode));
		assertEquals("Next node "+ i +" should match the currentNode", nodes[i], treeWalker.currentNode);
	}

	// Previous
	for(i = nodes.length - 2; i >= 0; i--) {
		treeWalker.previousNode();
		//debug("Previous: nodes["+ i +"] "+ mozile.xpath.getXPath(nodes[i]) +" -- currentNode "+ mozile.xpath.getXPath(treeWalker.currentNode));
		assertEquals("Previous node "+ i +" should match the currentNode", nodes[i], treeWalker.currentNode);
	}
	
}


/**
 *
 */
function testWalkText() {
	var target = document.getElementById("target");
	
	var nodes = [
		target.childNodes[0],
		target.childNodes[1].firstChild,
		target.childNodes[2],
		target.childNodes[3].firstChild,
		target.childNodes[4],
		target.childNodes[6],
		target.childNodes[7].firstChild.firstChild,
		target.childNodes[8]
	];	
	
	var treeWalker = document.createTreeWalker(document.documentElement, mozile.dom.NodeFilter.SHOW_TEXT, null, false);
	treeWalker.currentNode = nodes[0];

	// Next
	for(var i=1; i < nodes.length; i++) {
		treeWalker.nextNode();
		//debug("Next: nodes["+ i +"] "+ mozile.xpath.getXPath(nodes[i]) +" -- currentNode "+ mozile.xpath.getXPath(treeWalker.currentNode));
		assertEquals("Next node "+ i +" should match the currentNode", nodes[i], treeWalker.currentNode);
	}

	// Previous
	for(i = nodes.length - 2; i >= 0; i--) {
		treeWalker.previousNode();
		//debug("Previous: nodes["+ i +"] "+ mozile.xpath.getXPath(nodes[i]) +" -- currentNode "+ mozile.xpath.getXPath(treeWalker.currentNode));
		assertEquals("Previous node "+ i +" should match the currentNode", nodes[i], treeWalker.currentNode);
	}
	
}




