/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's event tools.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: event.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

mozile.require("mozile.event");
mozile.require("mozile.test.shared.util");
var name = "mozile.event.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testAddListener", "testCancel", "testCancelHyperlink", "testCancelKeyEvent", "testFindTarget", "testFixFocus", "testHandle", "testHandled", "testHandleMouseMove", "testListen", "testNormalize", "testSelectWord", "testStoreSelection"];
}

/**
 * 
 */
function testAddListener() {
	// Currently trivial.
}

/**
 * 
 */
function testCancel() {
	var event = {};
	mozile.event.cancel(event);
	assertTrue("cancelBubble should be true", event.cancelBubble);
}

/**
 * 
 */
function testCancelHyperlink() {
	if(!mozile.browser.isMozilla) return;
	mozile.useDesignMode = false;
	var target = document.getElementById("target");
	var event = {type: "click"};
	
	event.explicitOriginalTarget = target.firstChild;
	assertTrue("The event should not be cancelled", mozile.event.cancelHyperlink(event));
	
	var a = document.createElement("a");
	mozile.editElement(a);
	a.appendChild(document.createTextNode("text"));
	event.explicitOriginalTarget = a.firstChild;
	assertFalse("The event should be cancelled", mozile.event.cancelHyperlink(event));
}

/**
 * 
 */
function testCancelKeyEvent() {
	var event = {};
	assertTrue("Should not be cancelled", mozile.event.cancelKeyEvent(event));
	
	event.keyCode = 8;
	assertFalse("Backspace should be cancelled", mozile.event.cancelKeyEvent(event));
	
	event.keyCode = 9;
	assertFalse("Tab should be cancelled", mozile.event.cancelKeyEvent(event));
	
	event.keyCode = 46;
	assertFalse("Delete should be cancelled", mozile.event.cancelKeyEvent(event));
}

/**
 * 
 */
function testFindTarget() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var target = document.getElementById("target");
	selection.collapse(target.firstChild, 5);
	
	var event;
	//var event = {type: "click", target: target};
	//mozile.event.findTarget(event);
	//assertEquals("The node should be 'target'", target, event.node);

	event = {type: "keypress"};
	mozile.event.findTarget(event);
	assertEquals("The node should be target's first child", target.firstChild, event.node);
}

/**
 * 
 */
function testFixFocus() {
	// Currently trivial.
}

/**
 * 
 */
function testHandle() {
	// Difficult to test. However, any bugs should be caught quickly, since nearly everything else relies on this method.
}

/**
 * 
 */
function testHandled() {
	// Currently trivial.
}

/**
 * 
 */
function testHandleMouseMove() {
	// Currently trivial.
}

/**
 * 
 */
function testListen() {
	// Currently trivial.
}

/**
 * 
 */
function testNormalize() {
	var target = document.getElementById("target");
	var event = {
		srcElement: target,
		keyCode: 1337
	}
	
	event = mozile.event.normalize(event);
	assertEquals("The target should be target", target, event.target);
	assertEquals("The charCode should match keyCode", event.keyCode, event.charCode);
}

/**
 * 
 */
function testSelectWord() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var target = document.getElementById("target");
	var text = target.firstChild;
	
	mozile.event.selectWord(text, 0);
	assertEquals("The selection should be 'This' (0)", "This", selection.toString());
	mozile.event.selectWord(text, 1);
	assertEquals("The selection should be 'This' (1)", "This", selection.toString());
	mozile.event.selectWord(text, 2);
	assertEquals("The selection should be 'This' (2)", "This", selection.toString());
	mozile.event.selectWord(text, 3);
	assertEquals("The selection should be 'This' (3)", "This", selection.toString());
	mozile.event.selectWord(text, 4);
	assertEquals("The selection should be 'This is' (4)", "This is", selection.toString());
	mozile.event.selectWord(text, 5);
	assertEquals("The selection should be 'This is' (5)", "This is", selection.toString());
	mozile.event.selectWord(text, 6);
	assertEquals("The selection should be 'is' (6)", "is", selection.toString());
	mozile.event.selectWord(text, 7);
	assertEquals("The selection should be 'is a' (7)", "is a", selection.toString());
	mozile.event.selectWord(text, 8);
	assertEquals("The selection should be 'is a' (8)", "is a", selection.toString());
	mozile.event.selectWord(text, 9);
	assertEquals("The selection should be 'a page' (9)", "a page", selection.toString());
	
}

/**
 * 
 */
function testStoreSelection() {
	// Currently trivial.
}
