/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * @fileoverview Shared utilities for manipulating XML.
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: xml.js,v 1.2 2006/08/23 16:47:53 jameso Exp $
 */


mozile.provide("mozile.xml.*");

/**
 * A collection of XML functions.
 * @type Object
 */
mozile.xml = new Object();
// JSDoc hack
mozile.xml.prototype = new mozile.Module;


/**
 * A comprehensive list of XML namespaces.
 * Copied from Dojo 2.2.
 */
mozile.xml.ns = {
	AdobeExtensions : "http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/",
	cml : "http://www.xml-cml.org",
	dc : "http://purl.org/dc/elements/1.1/",
	dcq : "http://purl.org/dc/qualifiers/1.0",
	dt : "http://www.w3.org/2001/XMLSchema-datatypes",
	fo : "http://www.w3.org/1999/XSL/Format",
	mes : "http://mozile.mozdev.org/ns/mes/1.0", // Mozile's editing scheme
	mml : "http://www.w3.org/1998/Math/MathML",
	rdf : "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
	rdfs : "http://www.w3.org/2000/01/rdf-schema#",
	rng : "http://relaxng.org/ns/structure/1.0",
	saxon : "http://icl.com/saxon",
	"soap-env" : "http://schemas.xmlsoap.org/soap/envelope/",
	smil : "http://www.w3.org/2001/SMIL20/",
	svg : "http://www.w3.org/2000/svg",
	wsdl : "http://schemas.xmlsoap.org/wsdl/",
	xalan : "http://xml.apache.org/xslt",
	xbl : "http://www.mozilla.org/xbl",
	xforms : "http://www.w3.org/2002/01/xforms",
	xhtml : "http://www.w3.org/1999/xhtml",
	xi : "http://www.w3.org/2001/XInclude",
	xlink : "http://www.w3.org/1999/xlink",
	xsd : "http://www.w3.org/2001/XMLSchema",
	xsi : "http://www.w3.org/2001/XMLSchema-instance",
	xsl : "http://www.w3.org/1999/XSL/Transform",
	xslt : "http://www.w3.org/1999/XSL/Transform",
	xul : "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"
};

/**
 * Looks up the prefix corresponding to a namespace in the mozile.xml.ns list.
 * @param {String} namespaceURI The URI of the namespace to find the prefix for.
 * @type String
 */
mozile.xml.lookupPrefix = function(namespaceURI) {
	for(var prefix in mozile.xml.ns) {
		if(mozile.xml.ns[prefix] == namespaceURI) return prefix;
	}
	return null;
}

/**
 * Loads and returns an XML document.
 * This method should work in most browsers.
 * The method checks for a ":" in the filepath. 
 *   If one is found the filepath is treated as an absolute path.
 *   If none is found it treats the filepath as a relative path.
 * <p>This method should work in most browsers.
 * @param {String} string
 * @type Document
 */
mozile.xml.load = function(filepath) {
	//alert("Loading");
	if(typeof(filepath) != "string") return null;


	// Make filepath absolute.
	var uri;
	if(filepath.indexOf(":") > 0) uri = filepath;
	else {
		var loc = location.toString();
		loc = loc.substring(0, loc.lastIndexOf("?"));
		loc = loc.substring(0, loc.lastIndexOf("/") + 1);
		uri = loc + filepath;
	}
	// Hack for accessing local files with Safari
	if(mozile.browser.isSafari) uri = uri.replace("file://", "file:///");

	try { 
		// Try to find an XMLHTTPRequest object
		var XHR = new XMLHttpRequest();
		XHR.overrideMimeType("text/xml");
		XHR.open("GET", uri, false);
		try {
			XHR.send(null);
			return XHR.responseXML;
		} catch(e) {
			mozile.debug.inform("mozile.xml.load", "Error loading document: "+ e);
			return null;
		}
	}
	catch(e) {
		try	{
			// An IE XML load method
			var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
			xmlDoc.async = false;
			try {
				var loaded = xmlDoc.load(uri);
				if(loaded) return xmlDoc;
				else {
					mozile.debug.inform("mozile.xml.load", "Failed to load document.");
				}
			} catch(e) {
				mozile.debug.inform("mozile.xml.load", "Error loading document: "+ mozile.dumpError(e));
			}
		}
		catch(e) {
			mozile.debug.inform("mozile.xml.load", "No XML loading technique avaliable in this browser.");
		}
	}

	return null;
}

/*
	var uri;
	if(filepath.indexOf(":") > 0) uri = filepath;
	else {
		var loc = location.toString();
		loc = loc.substring(0, loc.lastIndexOf("?"));
		loc = loc.substring(0, loc.lastIndexOf("/") + 1);
		uri = loc + filepath;
	}
	//alert("URI:"+uri);
	
	var xmlDoc = null;
	if(window.ActiveXObject) {
		xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
	}
	else if(document.implementation) {
		var xmlDoc = document.implementation.createDocument("", "", null);
		
		// Handle Safari, which has no XMLDocument object or load() method.
		if(!xmlDoc.load) {
			// Hack for accessing local files.
			uri = uri.replace("file://", "file:///");
			var XHR = new XMLHttpRequest;
			XHR.open("GET", uri, false);
			XHR.send(null);

			// An idea to prevent crashes (doesn't help me):
			// http://www.jtauber.com/blog/2006/03/09/crashing_safari
			//var container = document.createElement("div");
			//container.innerHTML = XHR.responseText;
			//return container.innerHTML;


			return XHR.responseXML;
		}

	}
	else {
		mozile.debug.inform("mozile.xml.load", "No XML loading technique avaliable in this browser.");
		return null;
	}
	
	if(xmlDoc) {
		xmlDoc.async = false;
		try {
			alert("About to load "+ uri.substring(20));
			var loaded = xmlDoc.load(uri);
			alert("Loaded "+ uri.substring(20));
			//if(!loaded) throw Error("Could not load file "+ uri);
		} catch(e) {
			mozile.debug.inform("mozile.xml.load", "Failed to load document '"+ filepath +"' using path '"+ uri +"' because of an error:\n"+ mozile.dumpError(e));
		}
	}
	else {
		mozile.debug.inform("mozile.xml.load", "Failed to load document '"+ filepath +"' using path '"+ uri +"'.");
	}

	return xmlDoc;
}
*/

/**
 * Parses a string into an XML document, and returns the document.
 * <p>This method should work in most browsers.
 * @param {String} string
 * @type Document
 */
mozile.xml.parse = function(string) {
	if(window.ActiveXObject) {
		var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
		xmlDoc.async = "false";
		xmlDoc.loadXML(string);
		return xmlDoc;
	}
	else if(window.DOMParser) {
		var parser = new DOMParser();
		return parser.parseFromString(string, "text/xml");
	}
	else {
		mozile.debug.inform("mozile.xml.serialize", "No XML parsing technique avaliable in this browser.");
		return null;
	}
}

/**
 * Parses a string into an XML document, and returns the documentElement.
 * <p>This method should work in most browsers.
 * @param {String} string
 * @type Element
 */
mozile.xml.parseElement = function(string) {
	var doc = mozile.xml.parse(string);
	if(doc && doc.documentElement) return doc.documentElement;
	else return null;
}

/**
 * Serializes an XML node (or document) into a string.
 * <p>This method should work in most browsers.
 * @param {Node} node An XML node or document.
 * @type String
 */
mozile.xml.serialize = function(node) {
	if(!node) return null;
	if(node.xml) return node.xml;
	else if(window.XMLSerializer) {
		var serializer = new XMLSerializer()
		return serializer.serializeToString(node);
	}
	else if(node.outerHTML) return node.outerHTML;
	else if(node.innerHTML) {
		var container = document.createElement("container");
		container.appendChild(node.cloneNode(true));
		return container.innerHTML;
	}
	else {
		mozile.debug.inform("mozile.xml.serialize", "No XML serialization technique avaliable in this browser.");
		return null;
	}
}
