/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * @fileoverview Tools for rendering and updating a graphical user interface for Mozile.
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: gui.js,v 1.2 2006/08/23 16:47:53 jameso Exp $
 */

mozile.provide("mozile.gui.*");

/**
 * Tools for displaying a graphical user interface.
 * @type Object
 */
mozile.gui = new Object();
// JSDoc hack
mozile.gui.prototype = new mozile.Module;

/**
 * Points to the current GUI factory instance.
 * @type mozile.gui.Factory
 */
mozile.gui.factory = null;

/**
 * Creates a GUI using the current factory.
 * @type Void
 */
mozile.gui.create = function() {
	if(!mozile.gui.factory) throw("Error [mozile.gui.create]: No GUI factory selected.");
	else return mozile.gui.factory.create();
}

/**
 * Updates the factory using the current event.
 * @param {Event} event The current event object.
 * @param {String} change Optional. The type of change made. See mozile.edit.Command.makeChange for possible values.
 * @type Boolean
 * @return True if the GUI has been updated, false otherwise.
 */
mozile.gui.update = function(event, change) {
	if(!mozile.gui.factory) throw("Error [mozile.gui.update]: No GUI factory selected.");
	else return mozile.gui.factory.update(event, change);
}

/**
 * Displays the given content.
 * @param {String} content
 * @type Void
 */
mozile.gui.display = function(content) {
	if(!mozile.gui.factory) throw("Error [mozile.gui.display]: No GUI factory selected.");
	else return mozile.gui.factory.display(content);
}

/**
 * An abstract GUI factory class.
 * @constructor
 * @param {String} name
 */
mozile.gui.Factory = function(name) {
	/**
	 * A name for this factory.
	 * @type String
	 */
	this.name = name;
}

/**
 * Creates the GUI.
 * @type Void
 */
mozile.gui.Factory.prototype.create = function() {
	alert("Creating GUI.");
}

/**
 * Updates the GUI using the current event.
 * @param {Event} event The current event.
 * @type Boolean
 * @return True if the GUI has been updated, false otherwise.
 */
mozile.gui.Factory.prototype.update = function(event) {
	alert("Updating GUI based on "+ event);
}

/**
 * Displays content
 * @param {String} content
 * @type Void
 */
mozile.gui.Factory.prototype.display = function(content) {
	alert("Displaying content:\n"+ content);
}



