/**
 * For details on configuration, see: 
 *   http://mozile.mozdev.org/0.8/docs/index.html
 */

// CORE CONFIG
// The path from the web page to the Mozile directory.
mozile.root = "..";

// LOAD MODULES
// Load desired modules. They'll take care of their own requirements.
mozile.require("mozile.dom");
mozile.require("mozile.xpath");
mozile.require("mozile.event");
mozile.require("mozile.edit");
mozile.require("mozile.edit.rich");
mozile.require("mozile.save");
mozile.require("mozile.gui");
mozile.require("mozile.gui.htmlToolbar");

// MODULE CONFIG
mozile.debug.alertLevel = "inform";
mozile.debug.logLevel = "debug";
mozile.useDesignMode = false;
mozile.defaultNS = "http://www.w3.org/1999/xhtml";
mozile.event.listen();

// Wait until the document is loaded before executing these functions.
window.onload = function() { 
	mozile.editElements("card", null);
	// When false only text can be edited. When true elements can be split and merged.
	//mozile.editAllText(true);
	//mozile.useSchema("address.rng");
}


/**** DEMO CODE ****/
// The following code adds functions for the demo page and is not part of Mozile's configuration.

/**
 * Turns editing on and off.
 * @param {Boolean} value Optional.
 * @type Void
 */
function edit(value) {
	mozile.edit._defaultCommands = null;
	if(value === null || value === undefined) return;
	mozile.editAllText(value);
}

/**
 * Adds or removes a schema.
 * @param {Boolean} value Optional.
 * @type Void
 */
function schema(value) {
	mozile.schema = null;
	if(!value) return;
	mozile.useSchema("address.rng");
}
