/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JRexGreInstaller {
    static /* synthetic */ Class class$org$mozilla$jrex$JRexGreInstaller;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean installGRE(String greArchive, String installPath) {
        JRexGreInstaller.log("installGRE() greArchive<" + greArchive + "> installPath<" + installPath + "> ");
        try {
            if (installPath == null) {
                installPath = System.getProperty("user.home");
            }
            if (!installPath.endsWith(File.separator)) {
                installPath = installPath + File.separator;
            }
            JRexGreInstaller.log("installGRE() installPath<" + installPath + ">");
            File installDir = new File(installPath);
            int dotIndex = greArchive.lastIndexOf(".");
            String dirName = greArchive;
            if (dotIndex != -1) {
                dirName = greArchive.substring(0, dotIndex);
            }
            JRexGreInstaller.log("installGRE() dirName<" + dirName + ">");
            File greDirPath = new File(installDir.getAbsolutePath(), dirName);
            JRexGreInstaller.log("installGRE() greDirPath<" + greDirPath + ">");
            if (greDirPath.exists()) {
                JRexGreInstaller.log("installGRE() GRE ALREADY INSTALLED !!!");
                System.setProperty("jrex.gre.path", greDirPath.getAbsolutePath());
                return true;
            }
            boolean madeDirs = installDir.exists();
            if (!madeDirs) {
                madeDirs = installDir.mkdirs();
            }
            JRexGreInstaller.log("installGRE() installDir<" + installDir + "> madeDirs <" + madeDirs + ">");
            if (madeDirs) {
                JRexGreInstaller.installToDir(installDir, greArchive);
                JRexGreInstaller.log("installGRE() GRE InsatlledPath<" + greDirPath.getAbsolutePath() + ">");
                System.setProperty("jrex.gre.path", greDirPath.getAbsolutePath());
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void installToDir(File dir, String greArchive) throws Exception {
        ZipEntry ze;
        JRexGreInstaller.log("installToDir() dir<" + dir + "> greArchive<" + greArchive + ">");
        URL resURL = (class$org$mozilla$jrex$JRexGreInstaller == null ? (class$org$mozilla$jrex$JRexGreInstaller = JRexGreInstaller.class$("org.mozilla.jrex.JRexGreInstaller")) : class$org$mozilla$jrex$JRexGreInstaller).getResource(greArchive);
        JRexGreInstaller.log("installToDir() resURL<" + resURL + ">");
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(resURL.openStream()));
        int len = 0;
        byte[] buff = new byte[2048];
        while ((ze = zin.getNextEntry()) != null) {
            void var4_6;
            JRexGreInstaller.log("installToDir() ZipEntry <" + var4_6 + ">");
            File destFile = new File(dir.getAbsolutePath() + File.separator + var4_6.getName().replace('/', File.separatorChar));
            JRexGreInstaller.log("installToDir() destFile <" + destFile + ">");
            if (var4_6.isDirectory()) {
                JRexGreInstaller.log("installToDir() ZipEntry <" + var4_6 + "> is Directory ");
                zin.closeEntry();
                continue;
            }
            JRexGreInstaller.log("installToDir() ZipEntry <" + var4_6 + "> Parent <" + destFile.getParent() + ">");
            if (destFile.getParent() != null) {
                File destParent = new File(destFile.getParent());
                boolean madeDirs = destParent.mkdirs();
                JRexGreInstaller.log("installToDir() destParent <" + destParent + "> madeDirs <" + madeDirs + ">");
            }
            FileOutputStream fout = new FileOutputStream(destFile);
            while ((len = zin.read(buff)) != -1) {
                fout.write(buff, 0, len);
            }
            fout.close();
            zin.closeEntry();
            JRexGreInstaller.log("installToDir() destFile<" + destFile + "> Unzipping done!!!!");
        }
        zin.close();
    }

    private static final void log(String str) {
        System.out.println(str);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("install")) {
            JRexGreInstaller.log("main() Installing JREX GRE...");
            boolean success = JRexGreInstaller.installGRE("jrex_gre.zip", null);
            JRexGreInstaller.log("main() Installing JREX GRE success<" + success + ">");
            Class<?> srvMgrClass = Class.forName("javax.jnlp.ServiceManager");
            JRexGreInstaller.log("main() srvMgrClass<" + srvMgrClass + ">");
            Method lookup = srvMgrClass.getMethod("lookup", class$java$lang$String == null ? (class$java$lang$String = JRexGreInstaller.class$("java.lang.String")) : class$java$lang$String);
            JRexGreInstaller.log("main() lookup method<" + lookup + ">");
            Object exService = lookup.invoke(null, "javax.jnlp.ExtensionInstallerService");
            JRexGreInstaller.log("main() exService<" + exService + ">");
            if (success) {
                Method installSucceeded = exService.getClass().getMethod("installSucceeded", Boolean.TYPE);
                JRexGreInstaller.log("main() installSucceeded<" + installSucceeded + ">");
                installSucceeded.invoke(exService, new Boolean(false));
                Method setNativeLibraryInfo = exService.getClass().getMethod("setNativeLibraryInfo", class$java$lang$String == null ? (class$java$lang$String = JRexGreInstaller.class$("java.lang.String")) : class$java$lang$String);
                JRexGreInstaller.log("main() setNativeLibraryInfo<" + setNativeLibraryInfo + ">");
                setNativeLibraryInfo.invoke(exService, System.getProperty("jrex.gre.path"));
            } else {
                Method installFailed = exService.getClass().getMethod("installFailed", null);
                JRexGreInstaller.log("main() installFailed<" + installFailed + ">");
                installFailed.invoke(exService, null);
            }
        } else {
            JRexGreInstaller.log("Invalid Install args passed...");
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

