/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.window;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import org.mozilla.jrex.event.window.CreateEventParam;
import org.mozilla.jrex.event.window.WindowEvent;
import org.mozilla.jrex.event.window.WindowListener;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.window.JRexBaseBrowser;
import org.mozilla.jrex.window.JRexBrowserData;
import org.mozilla.jrex.window.JRexForceTabbedBrowser;
import org.mozilla.jrex.window.JRexSingleWindowBrowser;
import org.mozilla.jrex.window.JRexTabbedBrowser;
import org.mozilla.jrex.window.JRexWindowBrowser;
import org.mozilla.jrex.window.JRexWindowManager;

public class JRexWindowManagerImpl
implements JRexWindowManager {
    private static final String className;
    private JRexBaseBrowser browser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void create(int mode) {
        if (JRexL.on) {
            JRexL.log(className, "**** create()--> mode<" + mode + ">");
        }
        if (mode < 0 || mode > 4) {
            throw new IllegalArgumentException("invalid window mode");
        }
        switch (mode) {
            case 1: {
                this.browser = new JRexSingleWindowBrowser();
                break;
            }
            case 2: {
                this.browser = new JRexTabbedBrowser();
                break;
            }
            case 3: {
                this.browser = new JRexForceTabbedBrowser();
                break;
            }
            default: {
                this.browser = new JRexWindowBrowser();
            }
        }
    }

    public void init(JComponent comp) {
        if (JRexL.on) {
            JRexL.log(className, "**** init()--> comp<" + comp + ">");
        }
        if (this.browser == null) {
            throw new NullPointerException("browser not created!!!");
        }
        this.browser.init(comp);
    }

    public void openNewWindow(int parentPeer, String uri, int loadFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** openNewWindow()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
        }
        this.browser.openNewWindow(parentPeer, uri, loadFlags);
    }

    public void openNewTab(int parentPeer, String uri, int loadFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** openNewTab()-->parentPeer<" + parentPeer + "> uri<" + uri + "> loadFlags<" + loadFlags + ">");
        }
        this.browser.openNewTab(parentPeer, uri, loadFlags);
    }

    public void createWindow(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->event <" + event + "> ****");
        }
        CreateEventParam wcparam = (CreateEventParam)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->wcparam <" + wcparam + "> ****");
        }
        if (!$assertionsDisabled && wcparam == null) {
            throw new AssertionError();
        }
        int parentPeer = wcparam.getParentWindow();
        if (JRexL.on) {
            JRexL.log(className, "**** createWindow()-->parentPeer <" + parentPeer + ">");
        }
        this.browser.createWindow(parentPeer, wcparam.getChromeFlags(), wcparam.getWaitKey());
    }

    public void addWindow(JRexCanvas browserComp, Container parent, Container rootParent, Window window, long chromeFlags) {
        if (JRexL.on) {
            JRexL.log(className, "**** addWindow()-->browserComp<" + browserComp + "> parent<" + parent + "> rootParent<" + rootParent + "> chromeFlags<" + chromeFlags + ">");
        }
        this.browser.addWindow(browserComp, parent, rootParent, window, chromeFlags);
    }

    public void removeWindow(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeWindow()-->peerWindow<" + peerWindow + ">");
        }
        this.browser.removeWindow(peerWindow);
    }

    public void setModal(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->peerWindow <" + peerWindow + ">");
        }
        Boolean modal = (Boolean)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setModal()-->modal <" + modal + ">");
        }
        this.browser.setModal(peerWindow, modal);
    }

    public void setSize(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->peerWindow <" + peerWindow + ">");
        }
        Dimension dim = (Dimension)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setSize()-->dim <" + dim + ">");
        }
        this.browser.setSize(peerWindow, dim);
    }

    public void setTitle(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->peerWindow <" + peerWindow + ">");
        }
        String title = (String)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setTitle()-->title <" + title + ">");
        }
        this.browser.setTitle(peerWindow, title);
    }

    public void setChromeFlags(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->peerWindow <" + peerWindow + ">");
        }
        Long chromeFlags = (Long)event.getEventParam();
        if (JRexL.on) {
            JRexL.log(className, "**** setChromeFlags()-->chromeFlags <" + chromeFlags + ">");
        }
        this.browser.setChromeFlags(peerWindow, chromeFlags);
    }

    public void setRealized(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** setRealized()-->peerWindow <" + peerWindow + ">");
        }
        this.browser.setRealized(peerWindow);
    }

    public void destroyWindow(WindowEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->event <" + event + ">");
        }
        int peerWindow = event.getJRexPeer();
        if (JRexL.on) {
            JRexL.log(className, "**** destroyWindow()-->peerWindow <" + peerWindow + ">");
        }
        this.browser.destroyWindow(peerWindow);
    }

    public void destroyTab(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** destroyTab()-->peerWindow <" + peerWindow + ">");
        }
        this.browser.destroyTab(peerWindow);
    }

    public JRexCanvas getBrowser(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowser()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser.getBrowser(peerWindow);
    }

    public Container getBrowserParent(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserParent()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser.getBrowserParent(peerWindow);
    }

    public Window getBrowserWindow(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserWindow()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser.getBrowserWindow(peerWindow);
    }

    public JRexBrowserData getBrowserData(int peerWindow) {
        if (JRexL.on) {
            JRexL.log(className, "**** getBrowserData()-->peerWindow <" + peerWindow + ">");
        }
        return this.browser.getBrowserData(peerWindow);
    }

    public void addJRexWindowListener(WindowListener wl) {
        if (JRexL.on) {
            JRexL.log(className, "**** addJRexWindowListener()-->wl <" + wl + ">");
        }
        this.browser.addJRexWindowListener(wl);
    }

    public void removeJRexWindowListener() {
        if (JRexL.on) {
            JRexL.log(className, "**** removeJRexWindowListener()");
        }
        this.browser.removeJRexWindowListener();
    }

    public void dispose() {
        if (JRexL.on) {
            JRexL.log(className, "**** dispose()-->");
        }
        this.browser.dispose();
    }

    static {
        $assertionsDisabled = !JRexWindowManagerImpl.class.desiredAssertionStatus();
        className = JRexWindowManagerImpl.class.getName();
    }
}

