/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.mozilla.jrex.event.context.ContextMenuEvent;
import org.mozilla.jrex.event.context.ContextMenuListener;
import org.mozilla.jrex.event.history.HistoryEvent;
import org.mozilla.jrex.event.history.HistoryListener;
import org.mozilla.jrex.event.progress.ProgressEvent;
import org.mozilla.jrex.event.progress.ProgressListener;
import org.mozilla.jrex.event.tooltip.TooltipEvent;
import org.mozilla.jrex.event.uricontent.URIContentEvent;
import org.mozilla.jrex.event.uricontent.URIContentEventRV;
import org.mozilla.jrex.event.uricontent.URIContentListener;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.navigation.WebNavigation;
import org.mozilla.jrex.navigation.WebNavigationImpl;

public class JRexCanvas
extends Canvas {
    private static final String className;
    private static final int PRINTPREVIEW_GOTO_PAGENUM = 0;
    private static final int PRINTPREVIEW_PREV_PAGE = 1;
    private static final int PRINTPREVIEW_NEXT_PAGE = 2;
    private static final int PRINTPREVIEW_HOME = 3;
    private static final int PRINTPREVIEW_END = 4;
    private static boolean inited;
    private int jrexPeer = 0;
    private boolean realized = false;
    private boolean notifyPeer = false;
    private boolean progLstnAdded = false;
    private boolean ctxMenuLstnAdded = false;
    private boolean hisLstnAdded = false;
    private boolean keyLstnAdded = false;
    private boolean mouseLstnAdded = false;
    private boolean mouseMotionLstnAdded = false;
    private boolean uriContentLstnAdded = false;
    private boolean doRrealize = false;
    private int waitKey = 0;
    private WebNavigation navigator = new WebNavigationImpl();
    private Vector progLsnList;
    private Vector ctxMenuLsnList;
    private Vector hisLsnList;
    private URIContentListener uriContentListener;
    private static JWindow toolTipWin;
    private static Point location;
    private static JToolTip toolTip;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected JRexCanvas(boolean doRrealize, int waitKey) {
        this.doRrealize = doRrealize;
        this.waitKey = waitKey;
        this.setFocusable(true);
        this.enableEvents(4L);
    }

    public static JRexCanvas createBrowserComponent(boolean doRrealize) {
        return JRexCanvas.createBrowserComponent(doRrealize, 0);
    }

    public static JRexCanvas createBrowserComponent(boolean doRrealize, int waitKey) {
        if (inited) {
            return new JRexCanvas(doRrealize, waitKey);
        }
        throw new IllegalComponentStateException("Invocation of initIDs Failed!!!");
    }

    public int getJRexPeer() {
        return this.jrexPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        if (JRexL.on) {
            JRexL.log(className, "**** addNotify() -->jrexPeer<" + this.jrexPeer + "> before CreatePeer ****");
        }
        if (this.jrexPeer > 0) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (JRexL.on) {
                    JRexL.log(className, "**** addNotify() -->addNotify currentThread <" + Thread.currentThread() + ">****");
                }
                this.CreatePeer(this.waitKey);
                if (JRexL.on) {
                    JRexL.log(className, "**** addNotify() -->jrexPeer<" + this.jrexPeer + "> doRrealize<" + this.doRrealize + "> after CreatePeer **** ");
                }
                if (this.doRrealize) {
                    this.RealizePeer();
                    this.browserRealized();
                    if (JRexL.on) {
                        JRexL.log(className, "**** addNotify() -->RealizePeer done **** ");
                    }
                    this.setVisible(super.isVisible());
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
                throw new RuntimeException("**** addNotify() --> createPeer FAILED <" + ex.getMessage() + ">****");
            }
        }
    }

    public static void abortBrowserCreation(int waitKey) {
        try {
            JRexCanvas.AbortPeerCreation(waitKey);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void browserRealized() {
        if (JRexL.on) {
            JRexL.log(className, "**** browserRealized() -->realized <" + this.realized + "> **** ");
        }
        if (this.realized) {
            return;
        }
        this.realized = true;
        if (this.progLsnList != null && this.progLsnList.size() > 0) {
            this.addProgressListenerInternal();
        }
        if (this.ctxMenuLsnList != null && this.ctxMenuLsnList.size() > 0) {
            this.addContextMenuListenerInternal();
        }
        if (this.hisLsnList != null && this.hisLsnList.size() > 0) {
            this.addHistoryListenerInternal();
        }
        if (this.uriContentListener != null) {
            this.addURIContentListenerInternal();
        }
        if (this.getKeyListeners().length > 0) {
            this.addKeyListenerInternal();
        }
        if (this.getMouseListeners().length > 0) {
            this.addMouseListenerInternal();
        }
        if (this.getMouseMotionListeners().length > 0) {
            this.addMouseMotionListenerInternal();
        }
    }

    protected void processFocusEvent(final FocusEvent fe) {
        if (JRexL.on) {
            JRexL.log(className, "processFocusEvent()-->***** I AM HERE fe<" + fe + ">***** ");
        }
        if (fe.isTemporary() || !this.realized || !this.isShowing()) {
            return;
        }
        if (JRexL.on) {
            JRexL.log(className, "processFocusEvent()-->***** FOCUS_GAINED<" + (fe.getID() == 1004) + "> ***** ");
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.SetFocusPeer(fe.getID() == 1004);
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    JRexCanvas.this.SetFocusPeer(fe.getID() == 1004);
                }
                catch (JRexException ex) {
                    JRexL.printStackTrace(ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (JRexL.on) {
            JRexL.log(className, "paint()-->***** I AM HERE ***** ");
        }
        if (this.jrexPeer > 0 && !this.notifyPeer) {
            this.notifyPeer = true;
            try {
                if (JRexL.on) {
                    JRexL.log(className, "paint()-->***** Calling GotVisual ***** ");
                }
                Object object = this.getTreeLock();
                synchronized (object) {
                    this.GotVisual();
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
        if (!this.realized || !this.isShowing()) {
            return;
        }
        try {
            if (JRexL.on) {
                JRexL.log(className, "paint()-->***** Calling RepaintPeer ***** ");
            }
            this.RepaintPeer(false);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        super.removeNotify();
        if (JRexL.on) {
            JRexL.log(className, "removeNotify()--> ***** jrexPeer<" + this.jrexPeer + "> before DestroyPeer ****");
        }
        try {
            this.DestroyPeer();
            if (JRexL.on) {
                JRexL.log(className, "removeNotify()-->***** jrexPeer <" + this.jrexPeer + "> after DestroyPeer ****");
            }
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        finally {
            this.jrexPeer = 0;
        }
    }

    public void setVisible(final boolean visible) {
        super.setVisible(visible);
        if (JRexL.on) {
            JRexL.log(className, "setVisible()-->***** visible <" + visible + "> ****");
        }
        if (!this.realized) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.SetVisiblePeer(visible);
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    JRexCanvas.this.SetVisiblePeer(visible);
                }
                catch (JRexException ex) {
                    JRexL.printStackTrace(ex);
                }
            }
        });
    }

    public boolean isVisible() {
        if (JRexL.on) {
            JRexL.log(className, "isVisible()-->**** I AM HERE ****");
        }
        if (this.realized) {
            try {
                boolean temp = this.IsVisiblePeer();
                if (JRexL.on) {
                    JRexL.log(className, "isPeerVisible()-->***** visible <" + temp + ">***** ");
                }
                return temp;
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
        return super.isVisible();
    }

    public void setEnabled(final boolean enable) {
        if (JRexL.on) {
            JRexL.log(className, "setEnabled()-->***** enable <" + enable + "> ***** ");
        }
        super.setEnabled(enable);
        if (!this.realized) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.SetEnabledPeer(enable);
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    JRexCanvas.this.SetEnabledPeer(enable);
                }
                catch (JRexException ex) {
                    JRexL.printStackTrace(ex);
                }
            }
        });
    }

    public boolean isEnabled() {
        if (JRexL.on) {
            JRexL.log(className, "isEnabled()-->**** I AM HERE ****");
        }
        if (this.realized) {
            try {
                boolean temp = this.IsEnabledPeer();
                if (JRexL.on) {
                    JRexL.log(className, "IsEnabledPeer()-->**** enable <" + temp + ">****");
                }
                return temp;
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
        return super.isEnabled();
    }

    public void setBounds(int x, int y, int width, int height) {
        if (JRexL.on) {
            JRexL.log(className, "setBounds()-->**** x<" + x + "> y<" + y + "> width<" + width + "> height<" + height + "> ***");
        }
        super.setBounds(x, y, width, height);
        if (!this.realized) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.SetBoundsPeer();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    JRexCanvas.this.SetBoundsPeer();
                }
                catch (JRexException ex) {
                    JRexL.printStackTrace(ex);
                }
            }
        });
    }

    public Rectangle getBounds() {
        if (JRexL.on) {
            JRexL.log(className, "getBounds()-->**** I AM HERE ***");
        }
        if (this.realized) {
            try {
                return this.GetBoundsPeer();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
        return super.getBounds();
    }

    public Dimension getMinimumSize() {
        if (JRexL.on) {
            JRexL.log(className, "getMinimumSize()-->**** I AM HERE ***");
        }
        return this.getSize();
    }

    public Dimension getSize() {
        if (JRexL.on) {
            JRexL.log(className, "getSize()-->**** I AM HERE ***");
        }
        return this.realized ? this.getBounds().getSize() : super.getSize();
    }

    public Dimension getPreferredSize() {
        if (JRexL.on) {
            JRexL.log(className, "getPreferredSize()-->**** I AM HERE ***");
        }
        return this.getSize();
    }

    public String getJRexWindowTitle() {
        if (this.realized) {
            try {
                return this.GetTitlePeer();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
        return "";
    }

    public void setJRexWindowTitle(String title) {
        if (this.realized) {
            try {
                this.SetTitlePeer(title);
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public WebNavigation getNavigator() {
        this.navigator.setJRexPeer(this.jrexPeer);
        return this.navigator;
    }

    public void addKeyListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addKeyListenerInternal() -->keyLstnAdded <" + this.keyLstnAdded + "> **** ");
        }
        if (this.keyLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddKeyListener();
                this.keyLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addKeyListenerInternal() -->keyLstnAdded <" + this.keyLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addKeyListener(KeyListener l) {
        if (JRexL.on) {
            JRexL.log(className, "**** addKeyListener() -->l <" + l + "> **** ");
        }
        if (l == null) {
            return;
        }
        super.addKeyListener(l);
        this.addKeyListenerInternal();
    }

    public void addMouseListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addMouseListenerInternal() -->mouseLstnAdded <" + this.mouseLstnAdded + "> **** ");
        }
        if (this.mouseLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddMouseListener();
                this.mouseLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addMouseListenerInternal() -->mouseLstnAdded <" + this.mouseLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addMouseListener(MouseListener l) {
        if (JRexL.on) {
            JRexL.log(className, "**** addMouseListener() -->l <" + l + "> **** ");
        }
        if (l == null) {
            return;
        }
        super.addMouseListener(l);
        this.addMouseListenerInternal();
    }

    public void addMouseMotionListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addMouseMotionListenerInternal() -->mouseMotionLstnAdded <" + this.mouseMotionLstnAdded + "> **** ");
        }
        if (this.mouseMotionLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddMouseMotionListener();
                this.mouseMotionLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addMouseMotionListenerInternal() -->mouseMotionLstnAdded <" + this.mouseMotionLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        if (JRexL.on) {
            JRexL.log(className, "**** addMouseMotionListener() -->l <" + l + "> **** ");
        }
        if (l == null) {
            return;
        }
        super.addMouseMotionListener(l);
        this.addMouseMotionListenerInternal();
    }

    private void addProgressListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addProgressListenerInternal() -->progLstnAdded <" + this.progLstnAdded + "> **** ");
        }
        if (this.progLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddProgressListener();
                this.progLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addProgressListenerInternal() -->progLstnAdded <" + this.progLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** addProgressListener() -->progressListener <" + progressListener + "> **** ");
        }
        if (progressListener == null) {
            return;
        }
        if (this.progLsnList == null) {
            this.progLsnList = new Vector();
        }
        if (!this.progLsnList.contains(progressListener)) {
            this.progLsnList.add(progressListener);
        }
        this.addProgressListenerInternal();
    }

    public synchronized ProgressListener[] getProgressListeners() {
        if (this.progLsnList == null) {
            return new ProgressListener[0];
        }
        ProgressListener[] list = new ProgressListener[this.progLsnList.size()];
        return this.progLsnList.toArray(list);
    }

    private void addContextMenuListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addContextMenuListenerInternal() -->ctxMenuLstnAdded <" + this.ctxMenuLstnAdded + "> **** ");
        }
        if (this.ctxMenuLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddContextMenuListener();
                this.ctxMenuLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addContextMenuListenerInternal() -->ctxMenuLstnAdded <" + this.ctxMenuLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** addContextMenuListener() -->contextMenuListener <" + contextMenuListener + "> **** ");
        }
        if (contextMenuListener == null) {
            return;
        }
        if (this.ctxMenuLsnList == null) {
            this.ctxMenuLsnList = new Vector();
        }
        if (!this.ctxMenuLsnList.contains(contextMenuListener)) {
            this.ctxMenuLsnList.add(contextMenuListener);
        }
        this.addContextMenuListenerInternal();
    }

    public synchronized ContextMenuListener[] getContextMenuListeners() {
        if (this.ctxMenuLsnList == null) {
            return new ContextMenuListener[0];
        }
        ContextMenuListener[] list = new ContextMenuListener[this.ctxMenuLsnList.size()];
        return this.ctxMenuLsnList.toArray(list);
    }

    private void addHistoryListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addHistoryListenerInternal() -->hisLstnAdded <" + this.hisLstnAdded + "> **** ");
        }
        if (this.hisLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddHistoryListener();
                this.hisLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addHistoryListenerInternal() -->hisLstnAdded <" + this.hisLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addHistoryListener(HistoryListener historyListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** addHistoryListener() -->historyListener <" + historyListener + "> **** ");
        }
        if (historyListener == null) {
            return;
        }
        if (this.hisLsnList == null) {
            this.hisLsnList = new Vector();
        }
        if (!this.hisLsnList.contains(historyListener)) {
            this.hisLsnList.add(historyListener);
        }
        this.addHistoryListenerInternal();
    }

    public synchronized HistoryListener[] getHistoryListeners() {
        if (this.hisLsnList == null) {
            return new HistoryListener[0];
        }
        HistoryListener[] list = new HistoryListener[this.hisLsnList.size()];
        return this.ctxMenuLsnList.toArray(list);
    }

    private void addURIContentListenerInternal() {
        if (JRexL.on) {
            JRexL.log(className, "**** addURIContentListener() -->uriContentLstnAdded <" + this.uriContentLstnAdded + "> **** ");
        }
        if (this.uriContentLstnAdded) {
            return;
        }
        if (this.realized) {
            try {
                this.AddURIContentListener();
                this.uriContentLstnAdded = true;
                if (JRexL.on) {
                    JRexL.log(className, "**** addURIContentListener() -->uriContentLstnAdded <" + this.uriContentLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void addURIContentListener(URIContentListener uriContentListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** addURIContentListener() -->uriContentListener <" + uriContentListener + "> **** ");
        }
        if (uriContentListener == null) {
            return;
        }
        this.uriContentListener = uriContentListener;
        this.addURIContentListenerInternal();
    }

    public void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        if (this.getKeyListeners().length == 0 && this.keyLstnAdded) {
            try {
                this.RemoveKeyListener();
                this.keyLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeKeyListener() -->mouseLstnAdded <" + this.mouseLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        if (this.getMouseListeners().length == 0 && this.realized) {
            try {
                this.RemoveMouseListener();
                this.mouseLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeMouseListener() -->mouseLstnAdded <" + this.mouseLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        if (this.getMouseMotionListeners().length == 0 && this.mouseMotionLstnAdded) {
            try {
                this.RemoveMouseMotionListener();
                this.mouseMotionLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeMouseMotionListener() -->mouseMotionLstnAdded <" + this.mouseMotionLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeProgressListener() -->progressListener <" + progressListener + "> **** ");
        }
        if (progressListener == null || this.progLsnList == null) {
            return;
        }
        this.progLsnList.remove(progressListener);
        if (this.progLsnList.size() < 1 && this.progLstnAdded) {
            try {
                this.RemoveProgressListener();
                this.progLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeProgressListener() -->progLstnAdded <" + this.progLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeContextMenuListener() -->contextMenuListener <" + contextMenuListener + "> **** ");
        }
        if (contextMenuListener == null || this.ctxMenuLsnList == null) {
            return;
        }
        this.ctxMenuLsnList.remove(contextMenuListener);
        if (this.ctxMenuLsnList.size() < 1 && this.ctxMenuLstnAdded) {
            try {
                this.RemoveContextMenuListener();
                this.ctxMenuLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeContextMenuListener() -->ctxMenuLstnAdded <" + this.ctxMenuLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void removeHistoryListener(HistoryListener historyListener) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeHistoryListener() -->historyListener <" + historyListener + "> **** ");
        }
        if (historyListener == null || this.hisLsnList == null) {
            return;
        }
        this.hisLsnList.remove(historyListener);
        if (this.hisLsnList.size() < 1 && this.hisLstnAdded) {
            try {
                this.RemoveHistoryListener();
                this.hisLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeHistoryListener() -->hisLstnAdded <" + this.hisLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void removeURIContentListener() {
        if (JRexL.on) {
            JRexL.log(className, "**** removeURIContentListener() -->uriContentListener <" + this.uriContentListener + "> **** ");
        }
        if (this.uriContentLstnAdded) {
            try {
                this.RemoveURIContentListener();
                this.uriContentLstnAdded = false;
                if (JRexL.on) {
                    JRexL.log(className, "**** removeURIContentListener() -->uriContentLstnAdded <" + this.uriContentLstnAdded + "> **** ");
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    public void processProgressEvent(ProgressEvent pe) {
        if (JRexL.on) {
            JRexL.log(className, "**** processProgressEvent()-->pe<" + pe + "> ****");
        }
        if (!($assertionsDisabled || this.progLsnList != null && this.progLsnList.size() > 0)) {
            throw new AssertionError();
        }
        Iterator progIterator = this.progLsnList.iterator();
        int progEventType = pe.getEventType();
        switch (progEventType) {
            case 0: {
                while (progIterator.hasNext()) {
                    ((ProgressListener)progIterator.next()).onStateChange(pe);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()-->onStateChange ****");
                break;
            }
            case 1: {
                while (progIterator.hasNext()) {
                    ((ProgressListener)progIterator.next()).onProgressChange(pe);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()-->onProgressChange ****");
                break;
            }
            case 2: {
                while (progIterator.hasNext()) {
                    ((ProgressListener)progIterator.next()).onLocationChange(pe);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()-->onLocationChange ****");
                break;
            }
            case 3: {
                while (progIterator.hasNext()) {
                    ((ProgressListener)progIterator.next()).onStatusChange(pe);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()-->onStatusChange ****");
                break;
            }
            case 5: {
                while (progIterator.hasNext()) {
                    ((ProgressListener)progIterator.next()).onLinkStatusChange(pe);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()-->onStatusChange ****");
                break;
            }
            case 4: {
                while (progIterator.hasNext()) {
                    ((ProgressListener)progIterator.next()).onSecurityChange(pe);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()-->onSecurityChange ****");
                break;
            }
            default: {
                if (!JRexL.on) break;
                JRexL.log(className, "**** processProgressEvent()--> UNKNOW TYPE ****");
            }
        }
    }

    public void processContextMenuEvent(ContextMenuEvent ce) {
        if (JRexL.on) {
            JRexL.log(className, "**** processContextMenuEvent()-->ce<" + ce + "> ****");
        }
        if (!($assertionsDisabled || this.ctxMenuLsnList != null && this.ctxMenuLsnList.size() > 0)) {
            throw new AssertionError();
        }
        Iterator ctxMenuIterator = this.ctxMenuLsnList.iterator();
        while (ctxMenuIterator.hasNext()) {
            ((ContextMenuListener)ctxMenuIterator.next()).showContextMenu(ce);
        }
    }

    public Boolean processHistoryEvent(HistoryEvent he) {
        if (JRexL.on) {
            JRexL.log(className, "**** processHistoryEvent()-->he<" + he + "> ****");
        }
        if (!($assertionsDisabled || this.hisLsnList != null && this.hisLsnList.size() > 0)) {
            throw new AssertionError();
        }
        Iterator hisIterator = this.hisLsnList.iterator();
        int hisEventType = he.getEventType();
        switch (hisEventType) {
            case 0: {
                while (hisIterator.hasNext()) {
                    ((HistoryListener)hisIterator.next()).addEntry(he);
                }
                if (!JRexL.on) break;
                JRexL.log(className, "**** processHistoryEvent()-->addEntry ****");
                break;
            }
            case 1: {
                boolean canGoBack = true;
                while (hisIterator.hasNext()) {
                    canGoBack &= ((HistoryListener)hisIterator.next()).goBack(he);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** processHistoryEvent()-->goBack canGoBack <" + canGoBack + "> ****");
                }
                return new Boolean(canGoBack);
            }
            case 2: {
                boolean canGoForward = true;
                while (hisIterator.hasNext()) {
                    canGoForward &= ((HistoryListener)hisIterator.next()).goForward(he);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** processHistoryEvent()--> goForward canGoForward <" + canGoForward + "> ****");
                }
                return new Boolean(canGoForward);
            }
            case 3: {
                boolean canReload = true;
                while (hisIterator.hasNext()) {
                    canReload &= ((HistoryListener)hisIterator.next()).reload(he);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** processHistoryEvent()-->reload canReload <" + canReload + "> ****");
                }
                return new Boolean(canReload);
            }
            case 4: {
                boolean canGoToIndex = true;
                while (hisIterator.hasNext()) {
                    canGoToIndex &= ((HistoryListener)hisIterator.next()).goToIndex(he);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** processHistoryEvent()-->goToIndex canGoToIndex <" + canGoToIndex + "> ****");
                }
                return new Boolean(canGoToIndex);
            }
            case 5: {
                boolean canPurge = true;
                while (hisIterator.hasNext()) {
                    canPurge &= ((HistoryListener)hisIterator.next()).purge(he);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** processHistoryEvent()-->purge canPurge <" + canPurge + "> ****");
                }
                return new Boolean(canPurge);
            }
            default: {
                if (!JRexL.on) break;
                JRexL.log(className, "**** processHistoryEvent()--> UNKNOW TYPE ****");
            }
        }
        return null;
    }

    public Object processURIContentEvent(URIContentEvent uce) {
        if (JRexL.on) {
            JRexL.log(className, "**** processURIContentEvent()-->uce<" + uce + "> ****");
        }
        if (!$assertionsDisabled && this.uriContentListener == null) {
            throw new AssertionError();
        }
        int uriCntEventType = uce.getEventType();
        switch (uriCntEventType) {
            case 0: {
                boolean abortLoad = this.uriContentListener.onStartContent(uce);
                if (JRexL.on) {
                    JRexL.log(className, "**** processURIContentEvent()-->onStartContent abortLoad <" + abortLoad + "> ****");
                }
                return new Boolean(abortLoad);
            }
            case 1: {
                URIContentEventRV rval = this.uriContentListener.doContent(uce);
                if (JRexL.on) {
                    JRexL.log(className, "**** processURIContentEvent()-->doContent rval <" + rval + "> ****");
                }
                return rval;
            }
            case 2: {
                URIContentEventRV rval = this.uriContentListener.isContentPreferred(uce);
                if (JRexL.on) {
                    JRexL.log(className, "**** processURIContentEvent()-->isContentPreferred rval <" + rval + "> ****");
                }
                return rval;
            }
            case 3: {
                URIContentEventRV rval = this.uriContentListener.canHandleContent(uce);
                if (JRexL.on) {
                    JRexL.log(className, "**** processURIContentEvent()-->canHandleContent rval <" + rval + "> ****");
                }
                return rval;
            }
        }
        if (JRexL.on) {
            JRexL.log(className, "**** processURIContentEvent()--> UNKNOW TYPE ****");
        }
        return null;
    }

    public void processTooltipEvent(TooltipEvent tte) {
        if (JRexL.on) {
            JRexL.log(className, "**** TooltipEvent()-->tte<" + tte + "> ****");
        }
        int toolTipEventType = tte.getEventType();
        switch (toolTipEventType) {
            case 0: {
                if (toolTipWin == null) {
                    toolTipWin = new JWindow(SwingUtilities.getWindowAncestor(this));
                    toolTip = new JToolTip();
                    toolTipWin.getContentPane().add(toolTip);
                    location = new Point();
                }
                Point screenLocation = this.getLocationOnScreen();
                location.setLocation(tte.getClientX() + screenLocation.x, tte.getClientY() + screenLocation.y + 20);
                toolTip.setTipText(tte.getToolTip());
                Dimension tipSize = toolTip.getPreferredSize();
                Rectangle bounds = this.getBounds();
                if (JRexCanvas.location.x < bounds.x) {
                    JRexCanvas.location.x = bounds.x;
                } else if (JRexCanvas.location.x - bounds.x + tipSize.width > bounds.width) {
                    JRexCanvas.location.x = bounds.x + Math.max(0, bounds.width - tipSize.width);
                }
                if (JRexCanvas.location.y < bounds.y) {
                    JRexCanvas.location.y = bounds.y;
                } else if (JRexCanvas.location.y - bounds.y + tipSize.height > bounds.height) {
                    JRexCanvas.location.y = bounds.y + Math.max(0, bounds.height - tipSize.height);
                }
                toolTipWin.setBounds(JRexCanvas.location.x, JRexCanvas.location.y, tipSize.width, tipSize.height);
                toolTipWin.setVisible(true);
                break;
            }
            case 1: {
                if (toolTipWin == null) break;
                toolTipWin.setVisible(false);
                break;
            }
            default: {
                if (!JRexL.on) break;
                JRexL.log(className, "**** processTooltipEvent()--> UNKNOW TYPE ****");
            }
        }
    }

    public void print(boolean prompt, boolean showProgress) throws JRexException {
        this.Print(prompt, showProgress);
    }

    public void cancelPrint() throws JRexException {
        this.CancelPrint();
    }

    public boolean isPrinting() throws JRexException {
        return this.IsPrinting();
    }

    public void printPreview(boolean shrinkToFit, boolean isLandScape) throws JRexException {
        this.PrintPreview(shrinkToFit, isLandScape);
    }

    public void cancelPrintPreview() throws JRexException {
        this.CancelPrintPreview();
    }

    public boolean isPrintPreviewing() throws JRexException {
        return this.IsPrintPreviewing();
    }

    public int getPrintPreviewNumPages() throws JRexException {
        return this.GetPrintPreviewNumPages();
    }

    public void printPreviewNavigate(int navType, int pageNum) throws JRexException {
        this.PrintPreviewNavigate(navType, pageNum);
    }

    public void pageSetup() throws JRexException {
        this.PageSetup();
    }

    public boolean canUndo() throws JRexException {
        return this.CanUndo();
    }

    public boolean canRedo() throws JRexException {
        return this.CanRedo();
    }

    public boolean canCut() throws JRexException {
        return this.CanCut();
    }

    public boolean canCopy() throws JRexException {
        return this.CanCopy();
    }

    public boolean canCopyLinkLocation() throws JRexException {
        return this.CanCopyLinkLocation();
    }

    public boolean canCopyImageLocation() throws JRexException {
        return this.CanCopyImageLocation();
    }

    public boolean canCopyImageContents() throws JRexException {
        return this.CanCopyImageContents();
    }

    public boolean canPaste() throws JRexException {
        return this.CanPaste();
    }

    public boolean canDelete() throws JRexException {
        return this.CanDelete();
    }

    public void undo() throws JRexException {
        this.Undo();
    }

    public void redo() throws JRexException {
        this.Redo();
    }

    public void cut() throws JRexException {
        this.Cut();
    }

    public void copy() throws JRexException {
        this.Copy();
    }

    public void copyLinkLocation() throws JRexException {
        this.CopyLinkLocation();
    }

    public void copyImageLocation() throws JRexException {
        this.CopyImageLocation();
    }

    public void copyImageContents() throws JRexException {
        this.CopyImageContents();
    }

    public void paste() throws JRexException {
        this.Paste();
    }

    public void selectAll() throws JRexException {
        this.SelectAll();
    }

    public void selectNone() throws JRexException {
        this.SelectNone();
    }

    public void delete() throws JRexException {
        this.Delete();
    }

    public void find() throws JRexException {
        this.Find();
    }

    public void findAgain() throws JRexException {
        this.FindAgain();
    }

    private static native void initIDs() throws JRexException;

    private native void CreatePeer(int var1) throws JRexException;

    private static native void AbortPeerCreation(int var0) throws JRexException;

    private native void GotVisual() throws JRexException;

    private native void RealizePeer() throws JRexException;

    private native void DestroyPeer() throws JRexException;

    private native void SetBoundsPeer() throws JRexException;

    private native Rectangle GetBoundsPeer() throws JRexException;

    private native void SetVisiblePeer(boolean var1) throws JRexException;

    private native void SetEnabledPeer(boolean var1) throws JRexException;

    private native boolean IsVisiblePeer() throws JRexException;

    private native boolean IsEnabledPeer() throws JRexException;

    private native String GetTitlePeer() throws JRexException;

    private native void SetTitlePeer(String var1) throws JRexException;

    private native void RepaintPeer(boolean var1) throws JRexException;

    private native void SetFocusPeer(boolean var1) throws JRexException;

    private native void Print(boolean var1, boolean var2) throws JRexException;

    private native void CancelPrint() throws JRexException;

    private native boolean IsPrinting() throws JRexException;

    private native void PrintPreview(boolean var1, boolean var2) throws JRexException;

    private native void CancelPrintPreview() throws JRexException;

    private native int GetPrintPreviewNumPages() throws JRexException;

    private native boolean IsPrintPreviewing() throws JRexException;

    private native void PrintPreviewNavigate(int var1, int var2) throws JRexException;

    private native void PageSetup() throws JRexException;

    private native boolean CanUndo();

    private native boolean CanRedo();

    private native boolean CanCut();

    private native boolean CanCopy();

    private native boolean CanCopyLinkLocation();

    private native boolean CanCopyImageLocation();

    private native boolean CanCopyImageContents();

    private native boolean CanPaste();

    private native boolean CanDelete();

    private native void Undo();

    private native void Redo();

    private native void Cut();

    private native void Copy();

    private native void CopyLinkLocation();

    private native void CopyImageLocation();

    private native void CopyImageContents();

    private native void Paste();

    private native void SelectAll();

    private native void SelectNone();

    private native void Delete();

    private native void Find() throws JRexException;

    private native void FindAgain() throws JRexException;

    private native void AddProgressListener() throws JRexException;

    private native void AddContextMenuListener() throws JRexException;

    private native void AddHistoryListener() throws JRexException;

    private native void AddKeyListener() throws JRexException;

    private native void AddMouseListener() throws JRexException;

    private native void AddMouseMotionListener() throws JRexException;

    private native void AddURIContentListener() throws JRexException;

    private native void RemoveProgressListener() throws JRexException;

    private native void RemoveContextMenuListener() throws JRexException;

    private native void RemoveHistoryListener() throws JRexException;

    private native void RemoveKeyListener() throws JRexException;

    private native void RemoveMouseListener() throws JRexException;

    private native void RemoveMouseMotionListener() throws JRexException;

    private native void RemoveURIContentListener() throws JRexException;

    static {
        $assertionsDisabled = !JRexCanvas.class.desiredAssertionStatus();
        className = JRexCanvas.class.getName();
        inited = false;
        try {
            JRexCanvas.initIDs();
            inited = true;
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
    }
}

