/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.navigation;

import java.io.InputStream;
import java.net.URI;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.navigation.History;
import org.mozilla.jrex.navigation.WebNavigation;

public class WebNavigationImpl
implements WebNavigation {
    private static final String className = WebNavigationImpl.class.getName();
    private int jrexPeer = 0;

    public void setJRexPeer(int jrexPeer) {
        this.jrexPeer = jrexPeer;
    }

    public boolean canGoBack() throws JRexException {
        return this.CanGoBack(this.jrexPeer);
    }

    public boolean canGoForward() throws JRexException {
        return this.CanGoForward(this.jrexPeer);
    }

    public boolean goBack() throws JRexException {
        return this.GoBack(this.jrexPeer);
    }

    public boolean goForward() throws JRexException {
        return this.GoForward(this.jrexPeer);
    }

    public boolean goToIndex(int index) throws JRexException {
        return this.GoToIndex(this.jrexPeer, index);
    }

    public void loadURI(URI uri, int loadFlags, URI referrer, InputStream postData, InputStream headers) throws JRexException {
        this.loadURI(uri.normalize().toString(), loadFlags, referrer == null ? null : referrer.normalize().toString(), postData, headers);
    }

    public void loadURI(String uri, int loadFlags, String referrer, InputStream postData, InputStream headers) throws JRexException {
        this.LoadURI(this.jrexPeer, uri, loadFlags, referrer, postData, headers);
    }

    public void openWindow(short type, String uri, String referrer, String windowName, String features) throws JRexException {
        this.OpenWindow(this.jrexPeer, type, uri, referrer, windowName, features);
    }

    public void reload(int reloadFlags) throws JRexException {
        this.Reload(this.jrexPeer, reloadFlags);
    }

    public void stop(int stopFlags) throws JRexException {
        this.Stop(this.jrexPeer, stopFlags);
    }

    public Object getDocument() throws JRexException {
        return this.GetDocument(this.jrexPeer);
    }

    public URI getCurrentURI() throws JRexException {
        String sURI = this.GetCurrentURI(this.jrexPeer);
        if (JRexL.on) {
            JRexL.log(className, "getCurrentURI sURI<" + sURI + ">");
        }
        try {
            return sURI == null ? null : new URI(sURI);
        }
        catch (Exception ex) {
            JRexL.printStackTrace(ex);
            throw new JRexException("creating uri failed <" + ex.getMessage() + ">");
        }
    }

    public URI getReferringURI() throws JRexException {
        String rURI = this.GetReferringURI(this.jrexPeer);
        if (JRexL.on) {
            JRexL.log(className, "getReferringURI rURI<" + rURI + ">");
        }
        try {
            return rURI == null ? null : new URI(rURI);
        }
        catch (Exception ex) {
            JRexL.printStackTrace(ex);
            throw new JRexException("creating ref uri failed <" + ex.getMessage() + ">");
        }
    }

    public History getSessionHistory() throws JRexException {
        return this.GetSessionHistory(this.jrexPeer);
    }

    public void setSessionHistory(History his) throws JRexException {
        this.SetSessionHistory(this.jrexPeer, his);
    }

    private static native void initIDs() throws JRexException;

    private native boolean CanGoBack(int var1) throws JRexException;

    private native boolean CanGoForward(int var1) throws JRexException;

    private native boolean GoBack(int var1) throws JRexException;

    private native boolean GoForward(int var1) throws JRexException;

    private native boolean GoToIndex(int var1, int var2) throws JRexException;

    private native void LoadURI(int var1, String var2, int var3, String var4, InputStream var5, InputStream var6) throws JRexException;

    private native void OpenWindow(int var1, short var2, String var3, String var4, String var5, String var6) throws JRexException;

    private native void Reload(int var1, int var2) throws JRexException;

    private native void Stop(int var1, int var2) throws JRexException;

    private native Object GetDocument(int var1) throws JRexException;

    private native String GetCurrentURI(int var1) throws JRexException;

    private native String GetReferringURI(int var1) throws JRexException;

    private native History GetSessionHistory(int var1) throws JRexException;

    private native void SetSessionHistory(int var1, History var2) throws JRexException;

    static {
        try {
            WebNavigationImpl.initIDs();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
    }
}

