/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPopupMenu;
import org.mozilla.jrex.event.JRexEventManager;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.window.JRexWindowManager;
import org.mozilla.jrex.xpcom.JRexXPCOMImpl;

public final class JRexFactory {
    private static final String className = JRexFactory.class.getName();
    public static final String WINDOW_MANAGER = "WindowManager";
    public static final String WINDOW_EVENT_HANDLER = "WindowEventHandler";
    public static final String HISTORY_EVENT_HANDLER = "HistoryEventHandler";
    public static final String PROGRESS_EVENT_HANDLER = "ProgressEventHandler";
    public static final String CONTEXTMENU_EVENT_HANDLER = "ContextMenuEventHandler";
    public static final String TOOLTIP_EVENT_HANDLER = "TooltipEventHandler";
    public static final String OBSERVER_EVENT_HANDLER = "ObserverEventHandler";
    public static final String URICONTENT_EVENT_HANDLER = "URIContentEventHandler";
    public static final String JREX_MENUBAR = "JRexMenuBar";
    public static final String JREX_STATUSBAR = "JRexStatusBar";
    public static final String JREX_TOOLBAR = "JRexToolBar";
    public static final String JREX_POPUPMENU = "JRexPopupMenu";
    public static final String JREX_PRINTPREVIEWTOOLBAR = "JRexPrintPreviewToolBar";
    private static final JRexFactory instance = new JRexFactory();
    private Map implInstTable = Collections.synchronizedMap(new HashMap(10));
    private Properties implTable = new Properties();
    private boolean engineStarted = false;
    private Thread hookThread = null;

    private JRexFactory() {
    }

    public static JRexFactory getInstance() {
        return instance;
    }

    public Object getImplNewInstance(String key) {
        if (JRexL.on) {
            JRexL.log(className, "**** getImplNewInstance()-->key <" + key + ">");
        }
        String value = (String)this.implTable.get(key);
        if (JRexL.on) {
            JRexL.log(className, "getImplNewInstance()--> Class value<" + value + "> ");
        }
        Object rValue = null;
        try {
            Class<?> myClass = Class.forName(value);
            if (JRexL.on) {
                JRexL.log(className, "getImplNewInstance()--> **** myClass <" + myClass + ">***");
            }
            rValue = myClass.newInstance();
            if (JRexL.on) {
                JRexL.log(className, "getImplNewInstance()--> **** created instance <" + rValue + "> of <" + value + ">***");
            }
        }
        catch (Exception ex) {
            JRexL.printStackTrace(ex);
        }
        return rValue;
    }

    public Object getImplInstance(String key) {
        if (JRexL.on) {
            JRexL.log(className, "**** getImplInstance()-->key <" + key + ">");
        }
        if (this.implInstTable.containsKey(key)) {
            return this.implInstTable.get(key);
        }
        Object inst = this.getImplNewInstance(key);
        this.implInstTable.put(key, inst);
        return inst;
    }

    public synchronized void startEngine() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** startEngine()-->engineStarted <" + this.engineStarted + ">");
        }
        if (this.engineStarted) {
            return;
        }
        JRexXPCOMImpl.getInstance().startXPCOM();
        if (JRexL.on) {
            JRexL.log(className, "**** startEngine()-->startXPCOM done");
        }
        JRexEventManager.getInstance().startEventManager();
        if (JRexL.on) {
            JRexL.log(className, "**** startEngine()-->startEventManager done");
        }
        this.hookThread = new Thread(){

            public void run() {
                if (JRexL.on) {
                    JRexL.log(className, "**** run()-->Shutdown hook called engineStarted <" + JRexFactory.this.engineStarted + ">");
                }
                try {
                    JRexFactory.this.shutdownEngine();
                }
                catch (Exception ex) {
                    JRexL.printStackTrace(ex);
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** run()-->Shutdown hook done");
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.hookThread);
        if (JRexL.on) {
            JRexL.log(className, "**** startEngine()-->addShutdownHook done");
        }
        this.engineStarted = true;
    }

    public boolean isShutdownHook() {
        return Thread.currentThread() == this.hookThread;
    }

    public synchronized void shutdownEngine() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** shutdownEngine()-->engineStarted <" + this.engineStarted + ">");
        }
        if (this.engineStarted) {
            ((JRexWindowManager)this.implInstTable.get(WINDOW_MANAGER)).dispose();
            if (JRexL.on) {
                JRexL.log(className, "**** shutdownEngine()-->WINDOW_MANAGER dispose done!!!");
            }
            JRexEventManager.getInstance().stopEventManager();
            if (JRexL.on) {
                JRexL.log(className, "**** shutdownEngine()-->stopEventManager done");
            }
            JRexXPCOMImpl.getInstance().stopXPCOM();
            if (JRexL.on) {
                JRexL.log(className, "**** shutdownEngine()-->stopXPCOM done");
            }
            this.engineStarted = false;
        }
    }

    private void loadImplementers() {
        try {
            this.implTable.load(JRexFactory.class.getClassLoader().getResourceAsStream("jrex.impl"));
        }
        catch (Exception ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "loadImplementers()--> **** impl TABLE<" + this.implTable + ">***");
        }
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        if (JRexL.on) {
            JRexL.log(className, "static()--> **** loading implementers ****");
        }
        instance.loadImplementers();
    }
}

