/***************************************************************************
                          kaspawidget.h  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KASPAWIDGET_H
#define KASPAWIDGET_H
#include <resource.h>
#include <qlist.h>
#include <ktoolbar.h>
#include <kaspabase.h>
#include <kparts/part.h>

class QFrame;
class QWidget;
//class KToolBar;

//  enum GuiState {READWRITE,ERROR,WORKING,READONLY};
#define READWRITE 1
#define INVALID   2
#define WORKING   3
#define READONLY  4


bool kaspaidle();

class KaspaToolBar: public KToolBar {
Q_OBJECT

private:
	KaspaToolBar(const KaspaToolBar&);
	KaspaToolBar& operator=(const KaspaToolBar&);
	QList<QFrame> lines;
	BarPosition dir;
public:
	KaspaToolBar (QWidget *parent=0L, const char *name=0L, int _item_size = -1);
	~KaspaToolBar();
	void insertLineSeparator();

	virtual void paintEvent(QPaintEvent *e);
};


/** Abstract base class inherited by the GUI-classes. i.e. @ref Author.
 */

class KaspaWidget: public QWidget {
  Q_OBJECT
private:
	KaspaWidget(const KaspaWidget&);
	KaspaWidget& operator=(const KaspaWidget&);
  int guistate;
	
protected:
	virtual void closeEvent(QCloseEvent *e);

public:
  KaspaWidget(QWidget * parent=0, const char * name=0, WFlags f=0 );
  virtual ~KaspaWidget();
  virtual bool isValid()=0;
  virtual bool isReadOnly()=0;
  virtual bool isWorking()=0;
  virtual bool closeRequest()=0;
 	virtual const char *url()=0;
 	virtual void lockGUI();
 	virtual void setReadOnlyGUI(){ guistate=READONLY; emit readOnlyGUI(); }
 	virtual void setWorkingGUI(){ guistate=WORKING; emit workingGUI(); }
 	virtual void setInvalidGUI() { guistate=INVALID; emit invalidGUI(); }
 	virtual void setReadWriteGUI() { guistate=READWRITE; emit readWriteGUI(); }
	virtual void setupGUI();
 	virtual int getState() { return guistate; }
 	virtual void unlockGUI();
  virtual KToolBar *getToolBar() { return 0; }
    /** Resets the GUI.*/
  virtual void setFields(){};
	bool deleteDlg();
	void handleWarning(KaspaErr& err);

public slots:
  void requestAuthor(Oid o, bool w=false);
	void requestPublication(Oid o, bool w=false);
	void requestBibliography(Oid o, bool w=false);	
  void requestNote(Oid o, bool w=false);
  void requestPart(Oid o, bool w=false);
  void requestPartMemo(Oid o, bool w=false);
	void requestPublisher(Oid o, bool w=false);
	void requestJournal(Oid o, bool w=false);
	void requestHTMLData(Oid o, bool w=false);

  virtual void flush();

	virtual void copy();
	virtual void cut();
	virtual void paste();

	
signals:
	void modifyGUI(KParts::Part *);

	void statusMessage(const char *);
	void setCaption(const char *);
	void enableCommand(int id, bool state);
	void enableCommand(int id);
	void disableCommand(int id);
	

	void requestURL(const char*, bool, const char*);
	void requestURL(const char*, bool);
	
	void workingGUI();
	void invalidGUI();
	void readOnlyGUI();
	void readWriteGUI();
 	
};
#endif
