/***************************************************************************
                          publisherbase.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Oct 4 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "publisherbase.h"
#include <assert.h>
#include <stdlib.h>

#define Inherited Table

// Creates new Publisher
PublisherBase::PublisherBase(Sql *conn):Inherited("publisher", conn) {
	initNew();
}

PublisherBase::PublisherBase(const char *dbname):Inherited("publisher", dbname) {
	initNew();
}

void PublisherBase::initNew() {
  PublisherRec *publisher=new PublisherRec;
  assert(publisher);
  publisher->empty();
  publisher->id.set(newPublisher());
  init(publisher);
  _where="where publisher.no=";
  _where+=publisher->id.get();
}

PublisherBase::PublisherBase(const char *where, const char *dbname):Inherited("publisher", dbname) {
	initWhere(where);
}

PublisherBase::PublisherBase(const char *where, Sql *conn):Inherited("publisher", conn) {
	initWhere(where);
}

void PublisherBase::initWhere(const char *where) {
  PublisherRec *publisher=Inherited::getPublisher(where);
  if(!publisher) {
    publisher=new PublisherRec;
    assert(publisher);
    publisher->empty();
    publisher->id.set((Oid)InvalidOid);
  }
  init(publisher);
	if(where)	_where=where;
	else _where="";
}

PublisherBase::~PublisherBase() throw() {
}

const char *PublisherBase::getName() {
    return publisher()->name.get();
}

const char *PublisherBase::getCity() {
    return publisher()->city.get();
}

const char *PublisherBase::getSerie() {
    return publisher()->serie.get();
}

const char *PublisherBase::getModified() {
  return publisher()->modified.get();
}

const char *PublisherBase::getCreated() {
  return publisher()->created.get();
}

void PublisherBase::setName(const char *s) {
  publisher()->name.set(s);
  publisher()->name.setChanged();
}

void PublisherBase::setCity(const char *t) {
  publisher()->city.set(t);
  publisher()->city.setChanged();
}

void PublisherBase::setSerie(const char *t) {
  publisher()->serie.set(t);
  publisher()->serie.setChanged();
}

KaspaRec *PublisherBase::read(const char *where) {
	return getPublisher(where);
}	

KaspaRec *PublisherBase::invalid() {
  KaspaRec *publisher=new PublisherRec();
  assert(publisher);
  publisher->id.set((Oid)InvalidOid);
	return publisher;
}


void PublisherBase::write(const char *where, bool block) {
    updatePublisher(publisher(), where, block);
}

void PublisherBase::del(const Oid o) {
		Str s=Str("where publisher.no=");
		oid2str(o, &s);
    deletePublisher(s);
    publisher()->empty();
    publisher()->id.set((Oid)InvalidOid);
}

PublisherRec *PublisherBase::publisher() {
	if(!dynamic_cast<PublisherRec*>(rec))
		abort();
	return dynamic_cast<PublisherRec*>(rec);
}

PublTitle *PublisherBase::getPubls() {
	Str s=Str("where orgpublisher_no=");
	oid2str(publisher()->id.get(), &s);
	s+=" or publisher_no=";
	oid2str(publisher()->id.get(), &s);
  s+=" order by title";
  return Inherited::getPublTitles(s);
}
