/***************************************************************************
                          loadoids.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmdcodec.h>
#include <iostream.h>
#include <stdlib.h>
#include "kaspasql.h"
#include <qlist.h>
#include <signal.h>
#include <unistd.h>
#include <qfile.h>
#include "resource.h"
#include <qstring.h>
#include <qcstring.h>
#include <qregexp.h>
#include <qstylesheet.h>

Sql svr1(DB_NAME);
Sql svr2(DB_NAME);
QString target;

void update(QString table, QString field, QString field_new, bool encode) {
//	svr1.exec("begin");
	QString t("select oid,"); t+=field+" from "+table;
	svr1.exec(t);
	for(int i=0; i<svr1.tuples(); i++) {

  cout<<table<<":"<<i<<"\n";

		if( strcmp(svr1.getValue(i, field), "0")!=0 ) {

      QString fname=target+"/"+QString(svr1.getValue(i, field));
      QFile f(fname);
      char *buf=0L;
      long len;
      if(!f.open(IO_ReadOnly)) {
        // throw KaspaErr("Can not open file: "+fname+"\n");
        cout<<"Cannot open file \""<<fname<<"\"!. Creating dummy entry!\n";
        buf=new char[100];
        strcpy(buf, "Conversion failed! Could not read large object!");
        len=strlen(buf);
      }
      else {
        buf=new char[f.size()];
        if(f.readBlock(buf, f.size())!=int(f.size()))
          throw KaspaErr("Can not read file: "+fname+"\n");
        len=f.size();
      }
      QByteArray buffer;
      buffer.duplicate(buf, len);

      QString s("update "); s+=table+" set "+field_new+"= '";
      if(encode)
        s+=KCodecs::base64Encode(buffer);
      else
        s+=esc4sql(buffer);
      s+="' where oid=";
		  s+=svr1.getValue(i, "oid");
			svr2.exec("begin");
      svr2.exec(s);
			svr2.exec("end");
      delete buf;
		}
	}
//	svr1.exec("end");
}

void create_keys(QString table) {
  svr1.exec("select oid from "+table);
	for(int i=0; i<svr1.tuples(); i++) {
    cout<<table<<":"<<i<<"\n";
    svr2.exec("update "+table+" set no = NEXTVAL('kaspa_seq') where oid="+QString(svr1.getValue(i, "oid")));
  }
}


void renumber_publauthors(Oid publ) {
  svr2.exec("begin");
  Str s=Str("select author_no from publication_author where publication_no=");
  oid2str(publ, &s);
  s+=" order by author_order";
  svr2.exec(s);
  Str t;
  for(int i=0; i<svr2.tuples(); i++) {
    if(strlen(svr2.getValue(i, "author_no"))==0) continue;
    t+="update publication_author set author_order=";
    t+=i;
    t+=" where author_no=";
    t+=svr2.getValue(i, "author_no");
    t+=";";
  }
  svr2.exec(t);
  svr2.exec("commit");
}


void renumber_partauthors(Oid publ) {
  svr2.exec("begin");
  Str s=Str("select author_no from part_author where part_no=");
  oid2str(publ, &s);
  s+=" order by author_order";
  svr2.exec(s);
  Str t;
  for(int i=0; i<svr2.tuples(); i++) {
    if(strlen(svr2.getValue(i, "author_no"))==0) continue;
    t+="update part_author set author_order=";
    t+=i;
    t+=" where author_no=";
    t+=svr2.getValue(i, "author_no");
    t+=";";
  }
  svr2.exec(t);
  svr2.exec("commit");
}

void convert2richtext(QString table, QString field) {
  QString s="select no, "+field+" from "+table;
  svr1.exec(s);
  for(int i=0; i<svr1.tuples(); i++) {
    QString b="<p>";
    b+=svr1.getValue(i, field);
//    b=QStyleSheet::convertFromPlainText(b, QStyleSheetItem::WhiteSpaceNormal);
    QString no=svr1.getValue(i, "no");
    b=b.replace(QRegExp("\n"), "</p><p>");
    b+="</p>";
    char *buf=esc4sql(b);
    QString q="update "+table+" set "+field+" = '"+buf+"' where no="+no;
//    cout<<q<<endl;
    svr2.exec(q);
    delete buf;
  }
}



int main(int argc, char** argv){

	for(int i=0; i<argc; i++) {
		if(!strcmp(argv[i], "-i")) {
			i++;
			target=argv[i];
		}
	}
	if(target.isEmpty()) {
		cout<<"\nTool to load large objects from a directory into the kaspaliste database.\n" \
					"This program is part of the kaspaliste distribution\n (C) 2000 Jan Mueller\n" \
					"See COPYING file for the licence.\n" \
					"Syntax: loadoids -i <directory>\n";
		exit(1);
	}


  try {

     cout<<"add new text fields\n";
     svr1.exec("ALTER TABLE author ADD COLUMN memo_new text");
     svr1.exec("ALTER TABLE part ADD COLUMN memo_new text");
     svr1.exec("ALTER TABLE note ADD COLUMN memo_new text");
     svr1.exec("ALTER TABLE publication ADD COLUMN memo_new text");
     svr1.exec("ALTER TABLE partdata ADD COLUMN file_new text");
     svr1.exec("ALTER TABLE author ALTER COLUMN memo_new SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN memo_new SET DEFAULT ''");
     svr1.exec("ALTER TABLE note ALTER COLUMN memo_new SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN memo_new SET DEFAULT ''");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN file_new SET DEFAULT ''");

     cout<<"import large objects\n";
	   update("author", "memo", "memo_new", false);
	   update("part", "memo", "memo_new", false);
  	 update("note", "memo", "memo_new", false);
	   update("publication", "memo", "memo_new", false);
     update("partdata", "file", "file_new", true);


     cout<<"drop old stuff\n";
     svr1.exec("DROP TABLE word");
     svr1.exec("DROP TABLE dictionary");
     svr1.exec("DROP TABLE analyzed");

     cout<<"move old large object keys\n";
     svr1.exec("ALTER TABLE partdata RENAME COLUMN file TO file_old");
     svr1.exec("ALTER TABLE author RENAME COLUMN memo TO memo_old");
     svr1.exec("ALTER TABLE part RENAME COLUMN memo TO memo_old");
     svr1.exec("ALTER TABLE note RENAME COLUMN memo TO memo_old");
     svr1.exec("ALTER TABLE publication RENAME COLUMN memo TO memo_old");

     cout<<"move new text fields\n";
     svr1.exec("ALTER TABLE partdata RENAME COLUMN file_new TO file");
     svr1.exec("ALTER TABLE author RENAME COLUMN memo_new TO memo");
     svr1.exec("ALTER TABLE part RENAME COLUMN memo_new TO memo");
     svr1.exec("ALTER TABLE note RENAME COLUMN memo_new TO memo");
     svr1.exec("ALTER TABLE publication RENAME COLUMN memo_new TO memo");

     cout<<"add new fields\n";
     svr1.exec("ALTER TABLE partdata ADD COLUMN astext text");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN astext SET DEFAULT ''");

     cout<<"add keys\n";
     svr1.exec("ALTER TABLE partdata ADD COLUMN no integer");
     svr1.exec("ALTER TABLE author ADD COLUMN no integer");
     svr1.exec("ALTER TABLE part ADD COLUMN no integer");
     svr1.exec("ALTER TABLE note ADD COLUMN no integer");
     svr1.exec("ALTER TABLE publication ADD no integer");
     svr1.exec("ALTER TABLE publisher ADD no integer");

     cout<<"create sequences\n";
     svr1.exec("CREATE SEQUENCE kaspa_seq");

     svr1.exec("ALTER TABLE partdata ALTER COLUMN no SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE author ALTER COLUMN no SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE part ALTER COLUMN no SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE note ALTER COLUMN no SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE publication ALTER COLUMN no SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE publisher ALTER COLUMN no SET DEFAULT nextval('kaspa_seq')");

     cout<<"create key indices\n";
     svr1.exec("CREATE UNIQUE INDEX partdata_no_i ON partdata(no)");
     svr1.exec("CREATE UNIQUE INDEX author_no_i ON author(no)");
     svr1.exec("CREATE UNIQUE INDEX part_no_i ON part(no)");
     svr1.exec("CREATE UNIQUE INDEX note_no_i ON note(no)");
     svr1.exec("CREATE UNIQUE INDEX publication_no_i ON publication(no)");
     svr1.exec("CREATE UNIQUE INDEX publisher_no_i ON publisher(no)");

     cout<<"initialize keys\n";
     create_keys("partdata");
     create_keys("author");
     create_keys("part");
     create_keys("note");
     create_keys("publication");
     create_keys("publisher");

     cout<<"add new foreign keys\n";
     svr1.exec("ALTER TABLE part ADD COLUMN publication_no int4");
     svr1.exec("ALTER TABLE part ALTER COLUMN publication_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE partdata ADD COLUMN part_no int4");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN part_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ADD COLUMN publisher_no int4");
     svr1.exec("ALTER TABLE publication ALTER COLUMN publisher_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ADD COLUMN orgpublisher_no int4");
     svr1.exec("ALTER TABLE publication ALTER COLUMN orgpublisher_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE part ADD COLUMN intro_no int4");
     svr1.exec("ALTER TABLE part ALTER COLUMN intro_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE note ADD COLUMN publication_no int4");
     svr1.exec("ALTER TABLE note ALTER COLUMN publication_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication_author ADD COLUMN publication_no int4");
     svr1.exec("ALTER TABLE publication_author ALTER COLUMN publication_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication_author ADD COLUMN author_no int4");
     svr1.exec("ALTER TABLE publication_author ALTER COLUMN author_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE part_author ADD COLUMN part_no int4");
     svr1.exec("ALTER TABLE part_author ALTER COLUMN part_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE part_author ADD COLUMN author_no int4");
     svr1.exec("ALTER TABLE part_author ALTER COLUMN author_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE link ADD COLUMN obj_1 int4");
     svr1.exec("ALTER TABLE link ALTER COLUMN obj_1 SET DEFAULT 0");
     svr1.exec("ALTER TABLE link ADD COLUMN obj_2 int4");
     svr1.exec("ALTER TABLE link ALTER COLUMN obj_2 SET DEFAULT 0");

     cout<<"initialize new foreign keys\n";
     svr1.exec("UPDATE part set publication_no=publication.no where part.publicationno=publication.oid");
     svr1.exec("UPDATE part set intro_no=partdata.no where part.intro=partdata.oid");
     svr1.exec("UPDATE partdata set part_no=part.no where partdata.partno=part.oid");
     svr1.exec("UPDATE publication set publisher_no=publisher.no where publication.publisher=publisher.oid");
     svr1.exec("UPDATE publication set orgpublisher_no=publisher.no where publication.orgpublisher=publisher.oid");
     svr1.exec("UPDATE note set publication_no=publication.no where note.publicationno=publication.oid");
     svr1.exec("UPDATE publication_author set publication_no=publication.no where publication_author.publicationno=publication.oid");
     svr1.exec("UPDATE publication_author set author_no=author.no where publication_author.authorno=author.oid");
     svr1.exec("UPDATE part_author set part_no=part.no where part_author.partno=part.oid");
     svr1.exec("UPDATE part_author set author_no=author.no where part_author.authorno=author.oid");
     svr1.exec("UPDATE note set publication_no=publication.no where note.publicationno=publication.oid");
     svr1.exec("UPDATE link set obj_1=author.no where link.obj1=author.oid");
     svr1.exec("UPDATE link set obj_2=author.no where link.obj2=author.oid");
     svr1.exec("UPDATE link set obj_1=part.no where link.obj1=part.oid");
     svr1.exec("UPDATE link set obj_2=part.no where link.obj2=part.oid");
     svr1.exec("UPDATE link set obj_1=publication.no where link.obj1=publication.oid");
     svr1.exec("UPDATE link set obj_2=publication.no where link.obj2=publication.oid");
     svr1.exec("UPDATE link set obj_1=partdata.no where link.obj1=partdata.oid");
     svr1.exec("UPDATE link set obj_2=partdata.no where link.obj2=partdata.oid");
     svr1.exec("UPDATE link set obj_1=note.no where link.obj1=note.oid");
     svr1.exec("UPDATE link set obj_2=note.no where link.obj2=note.oid");

     cout<<"move old tables\n";
     svr1.exec("ALTER TABLE partdata RENAME TO partdata_old");
     svr1.exec("ALTER TABLE author RENAME TO author_old");
     svr1.exec("ALTER TABLE part RENAME TO part_old");
     svr1.exec("ALTER TABLE note RENAME TO note_old");
     svr1.exec("ALTER TABLE publication RENAME TO publication_old");
     svr1.exec("ALTER TABLE publisher RENAME TO publisher_old");
     svr1.exec("ALTER TABLE link RENAME TO link_old");
     svr1.exec("ALTER TABLE part_author RENAME TO part_author_old");
     svr1.exec("ALTER TABLE publication_author RENAME TO publication_author_old");

     cout<<"drop old indices\n";
     try { svr1.exec("DROP INDEX author_oid_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX part_publicationno_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX part_oid_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX partdata_oid_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX partdata_partno_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX publication_oid_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX publication_author_authorno_ind"); } catch(...) {};
     try { svr1.exec("DROP INDEX publication_author_bookno_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX part_author_authorno_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX part_author_partno_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX note_oid_index"); } catch(...) {};
     try { svr1.exec("DROP INDEX note_publicationno_index"); } catch(...) {};

     cout<<"create new tables and indices\n";
     svr1.exec("CREATE TABLE author AS SELECT no, lastname, firstname, pseudonym, born, died, country, memo, created, modified FROM author_old");
     svr1.exec("DROP TABLE author_old");

     svr1.exec("CREATE TABLE part AS SELECT no, publication_no, partno, title, pages, memo, key, language, bibtex, intro_no, createbibtex, created, modified FROM part_old");
     svr1.exec("CREATE INDEX part_publication_no_i ON part (publication_no)");
     svr1.exec("DROP TABLE part_old");

     svr1.exec("CREATE TABLE partdata AS SELECT no, part_no, file, astext, 'kaspa://'||filename as filename, type, created, modified FROM partdata_old");
     svr1.exec("CREATE INDEX partdata_part_no_i ON partdata (part_no)");
//     svr1.exec("CREATE INDEX partdata_astext_i ON partdata (astext)");
     svr1.exec("DROP TABLE partdata_old");

     svr1.exec("CREATE TABLE publisher AS SELECT no, name, city, serie, created, modified FROM publisher_old");
     svr1.exec("DROP TABLE publisher_old");

     svr1.exec("CREATE TABLE publication AS SELECT no, title, subtitle, edition, editor, howpublished, organization, publisher_no, year, pages, translator, volume, number, month, series, type, key, orgtitle,orgpublisher_no, orgyear, isbn_issn, hidingplace, bibtex, entrytype, memo, createbibtex, created, modified FROM publication_old");
     svr1.exec("DROP TABLE publication_old");

     svr1.exec("CREATE TABLE publication_author AS SELECT publication_no, author_no, created, modified FROM publication_author_old");
     svr1.exec("CREATE INDEX publication_author_author_no_i ON publication_author (author_no)");
     svr1.exec("CREATE INDEX publication_author_book_no_i ON publication_author (publication_no)");
     svr1.exec("DROP TABLE publication_author_old");

     svr1.exec("CREATE TABLE part_author AS SELECT part_no, author_no, created, modified FROM part_author_old");
     svr1.exec("CREATE INDEX part_author_author_no_i ON part_author (author_no)");
     svr1.exec("CREATE INDEX part_author_part_no_i ON part_author (part_no)");
     svr1.exec("DROP TABLE part_author_old");

     svr1.exec("CREATE TABLE note AS SELECT no, title, memo, type, publication_no, created, modified FROM note_old");
     svr1.exec("CREATE INDEX note_publication_no_i ON note (publication_no)");
     svr1.exec("DROP TABLE note_old");

     svr1.exec("CREATE TABLE link AS SELECT obj_1, obj_2, tbl, created, modified FROM link_old");
     svr1.exec("DROP TABLE link_old");

     svr1.exec("ALTER TABLE author ALTER COLUMN no         SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE author ALTER COLUMN lastname   SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN firstname  SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN pseudonym  SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN born	   SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN died	   SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN country    SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN memo	   SET DEFAULT ''");
     svr1.exec("ALTER TABLE author ALTER COLUMN created    SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE author ALTER COLUMN modified   SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE part ALTER COLUMN no                 SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE part ALTER COLUMN publication_no     SET DEFAULT 0");
     svr1.exec("ALTER TABLE part ALTER COLUMN partno             SET DEFAULT 1");
     svr1.exec("ALTER TABLE part ALTER COLUMN title     	 SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN pages     	 SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN memo  	         SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN key       	 SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN language	         SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN bibtex	         SET DEFAULT ''");
     svr1.exec("ALTER TABLE part ALTER COLUMN intro_no   	 SET DEFAULT 0");
     svr1.exec("ALTER TABLE part ALTER COLUMN createbibtex	 SET DEFAULT false");
     svr1.exec("ALTER TABLE part ALTER COLUMN created            SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE part ALTER COLUMN modified	         SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE partdata ALTER COLUMN no             SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN part_no	 SET DEFAULT 0");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN file		 SET DEFAULT ''");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN astext         SET DEFAULT ''");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN filename	 SET DEFAULT ''");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN type     	 SET DEFAULT ''");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN created	 SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE partdata ALTER COLUMN modified	 SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE publisher ALTER COLUMN no           SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE publisher ALTER COLUMN name		SET DEFAULT ''");
     svr1.exec("ALTER TABLE publisher ALTER COLUMN city		SET DEFAULT ''");
     svr1.exec("ALTER TABLE publisher ALTER COLUMN serie	SET DEFAULT ''");
     svr1.exec("ALTER TABLE publisher ALTER COLUMN created	SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE publisher ALTER COLUMN modified	SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE publication ALTER COLUMN no                 SET DEFAULT  nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE publication ALTER COLUMN title	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN subtitle	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN edition	        SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ALTER COLUMN editor  	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN howpublished 	SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN organization 	SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN publisher_no 	SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ALTER COLUMN year   	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN pages  	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN translator	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN volume	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN number	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN month  	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN series  	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN type 		SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN key 	 	SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN orgtitle	        SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN orgpublisher_no  SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ALTER COLUMN orgyear	    SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN isbn_issn		SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN hidingplace 	SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN bibtex	 	SET DEFAULT ''");
     svr1.exec("ALTER TABLE publication ALTER COLUMN entrytype		SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ALTER COLUMN memo		SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication ALTER COLUMN createbibtex	SET DEFAULT false");
     svr1.exec("ALTER TABLE publication ALTER COLUMN created	 	SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE publication ALTER COLUMN modified	 	SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE publication_author ALTER COLUMN publication_no	SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication_author ALTER COLUMN author_no	SET DEFAULT 0");
     svr1.exec("ALTER TABLE publication_author ALTER COLUMN created		SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE publication_author ALTER COLUMN modified	SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE publication_author ADD COLUMN author_order int4");
     svr1.exec("ALTER TABLE publication_author ALTER COLUMN author_order SET DEFAULT 0");

     svr1.exec("ALTER TABLE part_author ALTER COLUMN part_no	SET DEFAULT 0");
     svr1.exec("ALTER TABLE part_author ALTER COLUMN author_no	SET DEFAULT 0");
     svr1.exec("ALTER TABLE part_author ALTER COLUMN created	SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE part_author ADD COLUMN author_order int4");
     svr1.exec("ALTER TABLE part_author ALTER COLUMN author_order	SET DEFAULT 0");

     svr1.exec("ALTER TABLE part_author ALTER COLUMN modified	SET DEFAULT CURRENT_TIMESTAMP");

     svr1.exec("ALTER TABLE note ALTER COLUMN no         SET DEFAULT nextval('kaspa_seq')");
     svr1.exec("ALTER TABLE note ALTER COLUMN title	     SET DEFAULT ''");
     svr1.exec("ALTER TABLE note ALTER COLUMN memo	     SET DEFAULT 0");
     svr1.exec("ALTER TABLE note ALTER COLUMN type	     SET DEFAULT 0");
     svr1.exec("ALTER TABLE note ALTER COLUMN publication_no SET DEFAULT 0");
     svr1.exec("ALTER TABLE note ALTER COLUMN created	   SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE note ALTER COLUMN modified	 SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("UPDATE note SET publication_no=0 WHERE type=0");

     svr1.exec("ALTER TABLE link ALTER COLUMN obj_1	SET DEFAULT 0");
     svr1.exec("ALTER TABLE link ALTER COLUMN obj_2	SET DEFAULT 0");
     svr1.exec("ALTER TABLE link ALTER COLUMN tbl	SET DEFAULT ''");
     svr1.exec("ALTER TABLE link ALTER COLUMN created	SET DEFAULT CURRENT_TIMESTAMP");
     svr1.exec("ALTER TABLE link ALTER COLUMN modified	SET DEFAULT CURRENT_TIMESTAMP");

     cout<<"renumber authors\n";
     svr1.exec("SELECT DISTINCT publication_no FROM publication_author");
     for(int i=0; i<svr1.tuples(); i++)
       renumber_publauthors(str2oid(svr1.getValue(i, "publication_no")));

     svr1.exec("SELECT DISTINCT part_no FROM part_author");
     for(int i=0; i<svr1.tuples(); i++)
       renumber_partauthors(str2oid(svr1.getValue(i, "part_no")));

     svr1.exec("ALTER TABLE note ADD COLUMN parent int4");
     svr1.exec("ALTER TABLE note ADD COLUMN sibling int4");
     svr1.exec("ALTER TABLE note ALTER COLUMN parent SET DEFAULT 0");
     svr1.exec("ALTER TABLE note ALTER COLUMN sibling SET DEFAULT 0");

     cout<<"convert text\n";
     convert2richtext("part", "memo");
     convert2richtext("note", "memo");
  } catch (KaspaErr& err) {
	  cout<<"Error: "<< err.error();
  }
  cout<<"finished\n";
  return EXIT_SUCCESS;
}

