/***************************************************************************
                          linklistbox.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          linklistbox.h  -  description                              
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LINKLISTBOX_H
#define LINKLISTBOX_H

#include "kaspalistbox.h"
#include <kpopupmenu.h>

/**
  *@author Jan Mueller
  */

class LinkListBox : public KaspaListBox  {
	Q_OBJECT

private:
	LinkListBox(const LinkListBox&);
	LinkListBox& operator=(const LinkListBox&);

protected:
	KPopupMenu pop;
	QPoint mousePos;
public:
	LinkListBox(QWidget *parent=0, const char *name=0);
	~LinkListBox();

protected slots:
	void slotSelected(int index);
	void slotOpen();
	void slotNewWindow();
	void slotPopupMenu(QListBoxItem *item, const QPoint& p);

signals:
	void open(Oid o, const char *data, bool);
	void open(Oid o, bool);

};


class MoveLinkListBox : public LinkListBox  {
	Q_OBJECT

private:
	MoveLinkListBox(const LinkListBox&);
	MoveLinkListBox& operator=(const LinkListBox&);

public:
	MoveLinkListBox(QWidget *parent=0, const char *name=0);
	~MoveLinkListBox();

public slots:
	void slotItemUp();
	void slotItemDown();

signals:
	void moveItemUp(Oid o);
	void moveItemDown(Oid o);

};

#endif