/*
    KWin - the KDE window manager
    This file is part of the KDE project.

    SPDX-FileCopyrightText: 2014 Martin Gräßlin <mgraesslin@kde.org>

    SPDX-License-Identifier: GPL-2.0-or-later
*/
#ifndef KWIN_MAIN_X11_H
#define KWIN_MAIN_X11_H
#include "main.h"

namespace KWin
{

class KWinSelectionOwner;

class ApplicationX11 : public Application
{
    Q_OBJECT
public:
    ApplicationX11(int &argc, char **argv);
    ~ApplicationX11() override;

    void setReplace(bool replace);

protected:
    void performStartup() override;
    bool notify(QObject *o, QEvent *e) override;

private Q_SLOTS:
    void lostSelection();
    void continueStartupWithScreens();

private:
    void crashChecking();
    void setupCrashHandler();
    void notifyKSplash();

    static void crashHandler(int signal);

    QScopedPointer<KWinSelectionOwner> owner;
    bool m_replace;
};

}

#endif
