/***************************************************************************
                          settingsdlg.h  -  description
                             -------------------
    begin                : Fr Jun 4 2004
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H

#include <kdialogbase.h>
#include "kplnamespace.h"

class QButtonGroup;
class QCheckBox;
class QComboBox;
class QLineEdit;
class KColorButton;
class Kpl;
class KplDoc;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Edit fit parameter dialog class. Provides a dialog for the editing
  * the parameters of a function.
  * @author Werner Stille
  */
class EditFitParameterDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param m pointer to KplDoc model object.
   * @param p parameter array.
   * @param bFit array indicating whether a parameter is to be fitted or fixed.
   * @param file absolute path of the function library.
   * @param func function name.
   */
  EditFitParameterDlg(QWidget* parent, KplDoc* m, double* p, bool* bFit,
                      const QString& file, const QString& func);
  /** Destructor. */
  ~EditFitParameterDlg();

protected:
  bool* bFit;
  double* p;
  KplDoubleEdit* par[KPL_NPMAX];
  QCheckBox* enFit[KPL_NPMAX];

protected slots:
  /** Accepts changes and leaves the dialog. */
  void slotOk();
};

/**
  * Kpl settings dialog class. Provides a dialog for basic, autoplot, and
  * autofit settings.
  * @author Werner Stille
  */
class SettingsDlg : public KDialogBase
{
  Q_OBJECT
public: 
  SettingsDlg(QWidget* parent, KplDoc* model);
  ~SettingsDlg();

protected:
  /**
   * Get settings.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  Kpl* app;
  KplDoc* m;
  KplNamespace::AutoStruct a;
  QComboBox *pres, *sep, *format, *deci;
  KplSpinBox *prec, *symb, *sItmax;
  KplDoubleEdit *formatx, *formaty, *autoX0, *autoY0, *autoXl, *autoYl, *eTol;
  QLineEdit *autoLetX, *autoLetY, *autoLetH, *fileName, *func;
  QCheckBox *showSource, *autoPlot, *autoFit, *addData, *boundingBox,
            *printPS, *saveAbsPath, *warning, *saveAtEnd, *autohPath, *err,
            *logX, *logY, *autoNorm, *errCol, *showDlg, *saveRes, *follow,
            *nonLin;
  QButtonGroup* bg;
  KplSpinBox *ix, *iy, *ie, *autoSymb, *eRelSize;
  QPushButton *editH, *errMod;
  KColorButton *colFrame, *colGrid, *colData, *colFit;
  int lFormat;
  static const double xSize[];
  static const double ySize[];

protected slots:
  /**
   * Sets page size.
   * @param i index of selected format box item.
   */
  void slotFormatChanged(int i);
  /** Displays dialog to edit the x axis label. */
  void slotEditLetX();
  /** Displays dialog to edit the y axis label. */
  void slotEditLetY();
  /** Displays dialog to edit the heading. */
  void slotEditLetH();
  /**
   * Disables/enables heading widgets.
   * @param off disables widgets when true.
   */
  void disableHeading(bool off);
  /** Updates dialog according to logarithmic axis option. */
  void slotLogToggled(bool state);
  /** Updates dialog according to autonormalization option. */
  void slotNormToggled(bool state);
  /** Displays the dialog for selection of a library file to load. */
  void slotFile();
  /** Displays the dialog for selection of a function. */
  void slotFunc();
  /** Displays the dialog for selection of a parameter file to read. */
  void slotGetParameter();
  /** Displays the dialog for parameter editing. */
  void slotEditParameter();
  /** Displays the dialog for selection of a parameter file to save. */
  void slotSaveParameter();
  /** Displays the dialog for setting the calculation of standard deviations. */
  void slotErrMod();
  /**
   * Disables/enables error model button.
   * @param off disables button when true.
   */
  void disableErrMod(bool off);
  /**
   * Disables/enables widgets for nonlinear fits.
   * @param on enables widgets when true.
   */
  void enableNonLin(bool on);
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
  /** Applies and saves settings without leaving the dialog. */
  void slotUser1();
};

#endif
