/***************************************************************************
                          kpldoublespinbox.h  -  description
                             -------------------
    begin                : Do Apr 14 2005
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLDOUBLESPINBOX_H
#define KPLDOUBLESPINBOX_H

#include <qspinbox.h>

/**
  * Double value spinbox class. Provides a double value mapped QSpinBox widget
  * with validator.
  * @author Werner Stille
  */

class KplDoubleSpinBox : public QSpinBox
{
  Q_OBJECT
public: 
  /**
   * Constructor.
   * @param val initial double value.
   * @param step step size.
   * @param parent pointer to parent widget.
   * @param format format character for value display.
   * @param prec precision (number of digits) for value display.
   */
  KplDoubleSpinBox(double val, double step, QWidget* parent, char format = 'g',
                   int prec = 6);
  /**
   * Constructor.
   * @param val initial double value.
   * @param step step size.
   * @param minVal minimum value.
   * @param maxVal maximum value.
   * @param parent pointer to parent widget.
   * @param format format character for value display.
   * @param prec precision (number of digits) for value display.
   */
  KplDoubleSpinBox(double val, double step, double minVal, double maxVal,
                   QWidget* parent, char format = 'f', int prec = 2);
  /** Destructor. */
  ~KplDoubleSpinBox();
  /**
   * Returns value.
   * @return value.
   */
  double value() const;

signals:
  /**
   * Emitted whenever QSpinBox::valueChanged(int) is emitted.
   * @param value new double value.
   */
  void valueChanged(double value);

protected slots:
  /**
   * Emits new double value when the QSpinBox value is changed.
   * @param value new QSpinbox int value.
   */
  void slotValueChanged(int value);
  virtual QString mapValueToText(int);
  virtual int mapTextToValue(bool*);

protected:
  /**
   * Initializes several elements.
   * @param val initial double value.
   * @param step step size.
   */
  void init(double val, double step);
  char frm;
  int prec;
  double step;
};

#endif
