/***************************************************************************
                          editparameterdlg.h  -  description
                             -------------------
    begin                : Mit Jul 23 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITPARAMETERDLG_H
#define EDITPARAMETERDLG_H

#include <kdialogbase.h>
#include "kplnamespace.h"

class KplDoc;
class KplDoubleEdit;

/**
  * Edit parameter dialog class. Provides a dialog for the editing
  * the parameters of a function.
  * @author Werner Stille
  */
class EditParameterDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param m pointer to KplDoc model object.
   * @param p parameter array.
   * @param file absolute path of the function library.
   * @param func function name.
   * @param applyButton true to show a button for applying.
   * @param d3 true in case of a 3D function.
   */
  EditParameterDlg(QWidget* parent, KplDoc* m, double* p, const QString& file,
                   const QString& func, bool applyButton = false,
                   bool d3 = false);
  /** Destructor. */
  ~EditParameterDlg();

protected:
  /**
   * Copies settings to parameter array.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  double* p;
  KplDoubleEdit* par[KPL_NPMAX];

protected slots:
  /** Accepts changes and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
