/***************************************************************************
                          dokvokdoc.h  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOKVOKDOC_H
#define DOKVOKDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qstring.h>
#include <qlist.h>

// include files for this project
#include "vvocabulary.h"
#include "File/vvokfile.h"
#include "Abfrage/vabfragedialog.h"

// forward declaration of the DokVok classes
class DokVokView;

/**	DokVokDoc provides a document object for a document-view model.
  *
  * The DokVokDoc class provides a document object that can be used in conjunction with the classes DokVokApp and DokVokView
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the DokVokApp instance and contains the document structure with the according methods for manipulation of the document
  * data by DokVokView objects. Also, DokVokDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class DokVokDoc : public VVocabulary
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    DokVokDoc( QWidget *parent, const char *name=0 );
    /** Destructor for the fileclass of the application */
    ~DokVokDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView( DokVokView *view );
    /** removes a view from the list of currently connected views */
    void removeView( DokVokView *view );
    
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified( bool IsModified = true );
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified() { return Modified; };
    /** returns if the document is new or not. Use this to determine if your document needs a filename */
    bool isNew() { return FileName.isEmpty(); };
        
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument( const QString &FilePath, const char *format=0 );
    /** saves the document under filename and format.*/	
    bool saveDocument( const QString &FilePath, const char *format=0);
    
    /** sets the name of the file connected with the document */
    void setFileName( const QString &NewFileName ) { FileName = NewFileName; }
    /** returns the filename of the current document file*/
    const QString &fileName() { return FileName; };
    /** sets the path to the file connected with the document */
    void setAbsoluteDirName( const QString &Name ) { AbsoluteDirName = Name; }
    /** returns the path to the file connected with the document */
    const QString &absoluteDirName() { return AbsoluteDirName; };
    /** returns the absolute filename of the current document file*/
    QString absoluteFileName() { return AbsoluteDirName + '/' + FileName; };
        
    /** reset the views i.e. clears all Voklists and refills them */
    void resetView( DokVokView* View );
    /** resets all views */
    void resetAllViews();
    
    /** opens a dialog for editing of the list properties */
    void editProperties();
    /** sets the filedata to neutral */
    void setDocumentNew();
    /** set Document to a copy */
    void setAsCopy();
    /** copies the selection depending on the EditMode to the clipboard */
    void copySelection();
    /** pastes the TODO:inhalt from the clipboard */
    void pasteFromClipboard();
    /** cuts the selection depending on the EditMode */
    void cutSelection();
    /** delets the selection depending on the EditMode */
    void deleteSelection();
    
    /** starts the learning*/
    void learning();
    /** reads all Settings from the config file */
    void readQuestionSettings( KConfig *Config );
    /** writes all Settings to the config file */
    void writeQuestionSettings( KConfig *Config );
    /** edits questioning settings */
    void editQuestionSettings();
    /** edits languages */
    void editLanguages();
    
    /** */
    void setTyp( int Index );
	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(DokVokView *Sender);
    /** adds Vokabel  and therefore VokItems in all views */
    void appendVokabel( VVokabel *Vokabel = 0 );
    /** sets the EditMode */
    void slotSetEditMode ( bool Editing = true );
    /** */
    void setTypInfoList ( VTypInfoList *TypInfoList );

  protected:
  
  protected slots: // Protected slots
    /** tests if clipboard has Data and emits the state */
    void clipboardChanged();
	  /**  */
	  void setPasteFromClipboard ( bool Switch ) { emit clipboardHasData( Switch ); }
    
  signals:
    /**  */
    void clipboardHasData( bool );
    /**  */
    void editModeHasChanged( bool );
    /**  */
    void newTypInfoList( VTypInfoList * );
       	
  public: // Public attributes
    /** the list of the views currently connected to the document */
    static QList<DokVokView> *allViewsList;
    
  protected: // Protected attributes
    /**  */
    DokVokView *View;
    /** */
    VVokFile VokFile;
  private:
    /** the modified flag of the current document */
    bool Modified;
    /** the absolute path to the location of the file, taken from last used file
        or in the beginning from standard */
    QString AbsoluteDirName;
    /** the name of the file; is empty if file is new */
    QString FileName;      
    QList<DokVokView> *sameViewsList;
    /** settings for questioning */
    VQuestionSettings *QuestionSettings;    	  
};
#endif // DOKVOKDOC_H
