/***************************************************************************
                          dokvok.h  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOKVOK_H
#define DOKVOK_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qclipboard.h> 
// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kurl.h>

// forward declaration of the DokVok classes
class DokVokDoc;
class DokVokView;
class VTypInfoList;

/**
  * The base class for DokVok application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of DokVokView creates your center view, which is connected
  * to the window's Doc object.
  * DokVokApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class DokVokApp : public KTMainWindow
{
  Q_OBJECT

  friend class DokVokView;

  public:
    /** constructor of DokVokApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    DokVokApp();
    ~DokVokApp();
    /** enables menuentries/toolbar items
     */
    void enableCommand( int id_ );
    /** disables menuentries/toolbar items
     */
    void disableCommand( int id_ );
    /** sets menuentries/toolbar items state
     */
    void setState( int id_ );
    /** unsets menuentries/toolbar items state
     */
    void unsetState( int id_ );
    /** add a opened file to the recent file list and update recent_file_menu
     */
    void addRecentFile( const QString &file );
    /** */
    void fillRecentFileMenu();
    /** opens a file specified by commandline option
     */
    void startWithFile( const char* Filename = 0 );
    /** opens the file with the name Filename or popups an errormessage
     */
    bool openDocument( QString Filename );
    /** saves the file under the name Filename or popups an errormessage
     */
    bool saveDocument( QString Filename );
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */	
    DokVokDoc *getDocument() const; 	
    /** "save modified" - asks the user for saving if the document is modified 
      */
    bool saveModified();
    /** "save as" - asks the user for saving with a new filename 
      */
    bool saveAs();
    /** */
    void setStandardDirectory(const QString &NewDirectory);
    /** */    
    const QString & getStandardDirectory() const;
    
  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
     * @see KAccel
     */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
     * @see KApplication#getHelpMenu
     */
    void initMenuBar();
    /** this creates the toolbars.
     */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);
    /** */
    void editGeneralSettings();

  public slots:
    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
    void statusCallback(int id_);
    /** open a new application window by creating a new instance of DokVokApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** opens a file, load it into the document and sets it new */
    void slotFileNewFrom();
    /** clears the file information of the actual document to reuse it as a new document */
    void slotFileNewFromThis();
    /** opens a file and load it into the document */
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(int id_);
    /** reloads the document, this way discarding changes */
    void slotFileRevert();
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** removes the marked text/object from the document
     */
    void slotEditDelete();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** appends a new vokabel
    */
    void slotEditTypSelected( int TypIndex );
    /** appends a new vokabel
    */
    void slotEditNewVokabel();
    /** toggles the EditMode
     */
    void slotEditEditMode();
    /** selects all
     */
    void slotEditSelectAll();
    /** deselects all
     */
    void slotEditDeselectAll();
    /** inverts the selection
     */
    void slotEditInvertSelection();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** popups a dialog
     */
    void slotListProperties();
    /** starts the learning dialog
     */
    void slotLearningStart();
    /** popups a dialog
     */
    void slotSettingsGeneral();
    /** popups a dialog
     */
    void slotSettingsQuestioning();
    /** popups a dialog
     */
    void slotSettingsLanguages();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    /** call of slotStatusMsg with text "Ready."
     */
    void slotStatusMsgReady();
    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);
    /** sets the caption of the window */
    void setWindowCaption();
    /** sets the insert from clipboard to Enabled/Disabled */
    void setClipboard( bool Enabled );
    /** sets the insert from editmode to Enabled/Disabled */
    void setEditMode( bool Enabled );
    /** */
    void fillTypMenu( VTypInfoList *List );
 	
 	private slots:
    /** */
    void slotDropEvent(KDNDDropZone *);
    

  private:
    /** contains the recently used filenames */
    QStrList recentFiles;
    /** the standard directory for DokVok files */
    QString StandardDirectory;
    /** the clipboard*/
    QClipboard *ClipBoard;
    /** should last file be loaded at start*/
    bool AutoLoadLastFile;
    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;
    /** fileMenu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** the recent file menu containing the last five opened files */
    QPopupMenu *recentFilesMenu;
    /** editMenu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** the typ menu containing the types */
    QPopupMenu *TypMenu;
    /** viewMenu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** listMenu contains all items of the menubar entry "List" */
    QPopupMenu *listMenu;
    /** learningMenu contains all items of the menubar entry "Learning" */
    QPopupMenu *learningMenu;
    /** settingsMenu contains all items of the menubar entry "Settings" */
    QPopupMenu *settingsMenu;
    /** helpMenu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    DokVokView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    DokVokDoc *doc;
};
 
#endif // DOKVOK_H
