/***************************************************************************
                          vlangbox.cpp  -  description
                             -------------------
    begin                : Mon Mar 20 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>
 
#include <qfile.h>
#include <qdir.h> 
 
#include <kapp.h>

#include "vlangbox.h"


VLanguageBox::VLanguageBox( VLanguageList *List, QWidget *parent, const char *name ) 
  : QComboBox(parent,name), LanguageList( 0 )
{
  fill( List ); 
}



VLanguageBox::~VLanguageBox()
{
}


void VLanguageBox::fill( VLanguageList *NewList = 0 )
{
  // if there is a new List take it
  if( NewList )
    LanguageList = NewList;
    
  // if there is no list still return
  if( !LanguageList ) 
    return;
    
  clear();
  
  VLanguage *Language;
  for( Language=LanguageList->first(); Language; Language=LanguageList->next() )
    insertItem ( Language->Name );
}



void VLanguageBox::appendNew( QString Short )
{
  if( !LanguageList )
    return;
    
  VLanguage *Language = LanguageList->appendNew( Short );
  
  if( Language )
  {
    insertItem( Language->Name );
    
    int Index = count()-1;
    setCurrentItem( Index );
    emit activated( Index );
  }
}


void VLanguageBox::deleteCurrent()
{
  if( !LanguageList )
    return;
  
  QString FileName = KApplication::localkdedir().copy();
  FileName += "/share/apps/dokvok/languages/";
  FileName += language();
  FileName += ".dvlc"; //DokVok Language Config
    
  QFile::remove( FileName );
  
  int Index = currentItem();
  LanguageList->remove( Index );
  removeItem( Index );
  if( Index >= count() )
    Index = count() - 1;
    
  setCurrentItem( Index );
  
  emit activated( Index );
}


const QString VLanguageBox::language()
{
  return LanguageList->at( currentItem() )->Short;
}


void VLanguageBox::setLanguage( const QString &Short )
{
  int Index = 0; 
  VLanguage *Language;
  for( Language=LanguageList->first(); Language; Language=LanguageList->next() )
  {
    if( Short == Language->Short )
    {
      setCurrentItem( Index );
      break;
    }
    Index++;
  }
}