/***************************************************************************
                          questsettingsedit.cpp  -  description
                             -------------------
    begin                : Wed Mar 08 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qfileinfo.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kpixmap.h>

#include "vquestdialog.h"
#include "../Abfrage/vabfragedialog.h"  // wegen VQuestionSettings

VQuestionDialog::VQuestionDialog(QWidget *parent, const char *name) 
  : QDialog( parent, name, true),
    Layout( this, 10 ),
    General( this ),
    GeneralLayout( &General, 10 ),
    PartialCheck( i18n("&Partial knowledge sufficient"), &General ),
    SecondChanceCheck( i18n( "&Second Chance" ), &General ),
    ShowCorrectedInputCheck( i18n( "Show &Corrected Input" ), &General ),
    CharacterLayout(),
    UnknownCharacterEdit( &General, "UnknownCharacterEdit" ),
    UnknownCharacterLabel( &UnknownCharacterEdit, i18n("&Unknown Character"), &General ),
    ButtonRow( this )
{
  setLayout();

  // power to the buttons  
  connect( Ok, SIGNAL(clicked()), SLOT(accept()) );
  connect( Cancel, SIGNAL(clicked()), SLOT(reject()) );
  
  // set Inputdefaults
  PartialCheck.setFocus();
  Ok->setDefault(true);
  
  // yes, all should be able to be default
  Ok->setAutoDefault(true);
}


VQuestionDialog::~VQuestionDialog()
{

}


/** sets the layout */
void VQuestionDialog::setLayout()
{
  setCaption( i18n("Settings for questioning") );
  
  // the general box
  General.setTitle( i18n( "General" ) );
        
  // layout for edit: right to the editline is a button for selecting
  GeneralLayout.addSpacing( fontMetrics().height() ); // to gain distance to box titel
  GeneralLayout.addWidget( &PartialCheck );
  GeneralLayout.addWidget( &SecondChanceCheck );
  GeneralLayout.addWidget( &ShowCorrectedInputCheck );
  GeneralLayout.addLayout( &CharacterLayout );

  // partial
  PartialCheck.setFixedHeight( PartialCheck.sizeHint().height() );
  // second chance
  SecondChanceCheck.setFixedHeight( SecondChanceCheck.sizeHint().height() );
  // show correct input
  ShowCorrectedInputCheck.setFixedHeight( ShowCorrectedInputCheck.sizeHint().height() );
  
  // unknown character
  UnknownCharacterLabel.setFixedSize( UnknownCharacterLabel.sizeHint() );
  QFontMetrics SDFontMetrics( UnknownCharacterEdit.fontMetrics());
  UnknownCharacterEdit.setMaxLength( 1 );
  UnknownCharacterEdit.setFixedHeight( UnknownCharacterEdit.sizeHint().height() );
  UnknownCharacterEdit.setFixedWidth( SDFontMetrics.width("0")*3 );
  
  CharacterLayout.addWidget( &UnknownCharacterLabel );
  CharacterLayout.addSpacing( 10 );
  CharacterLayout.addWidget( &UnknownCharacterEdit );
  CharacterLayout.addStretch( 1 );
  
  GeneralLayout.activate();
    
  Layout.addWidget( &General );
  
  // to separate the buttonrow
  Layout.addSpacing( 10 );   
  Layout.addStretch( 1 );
  
  // buttonrow at bottom of Window
	ButtonRow.addStretch(); // push buttons to the right side
	Ok = ButtonRow.addButton( i18n("&Ok") );
	Cancel = ButtonRow.addButton( i18n("&Cancel") );
	ButtonRow.layout();
	
	Layout.addWidget( &ButtonRow, 0, AlignBottom );
		  
  // finally set the arrangment
  Layout.activate();
}


/** opens the dialog and returns true if anything was modified 
  * TODO: if anything is default it will be selected to have quick deleting
  */
void VQuestionDialog::edit( VQuestionSettings *Settings )
{
  PartialCheck.setChecked( Settings->CheckerSettings.Partial );
  ShowCorrectedInputCheck.setChecked( Settings->ShowCorrectedInput );
  
  SecondChanceCheck.setChecked( Settings->SecondChance );
  UnknownCharacterEdit.setText( &Settings->CheckerSettings.UnknownCharacter );
  
  exec(); 
  
  Settings->CheckerSettings.Partial = PartialCheck.isChecked();
  Settings->ShowCorrectedInput = ShowCorrectedInputCheck.isChecked();
  
  Settings->SecondChance = SecondChanceCheck.isChecked();
//TODO: give feedback about empty input for character
  if( UnknownCharacterEdit.text() )
    Settings->CheckerSettings.UnknownCharacter = UnknownCharacterEdit.text()[0];
  else
    Settings->CheckerSettings.UnknownCharacter = '';
  
}
