/*
 * Copyright 2009 Mathias Kraus <k.hias@gmx.de>
 * Copyright 2007-2008 Thomas Gallinari <tg8187@yahoo.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GAMEVIEW_H
#define GAMEVIEW_H

#include <QGraphicsView>

class QKeyEvent;
class Game;
class GameScene;

/**
 * @brief This class manages the drawing of each element of the Game instance.
 * It creates a GameScene instance associated to the given Game instance in order to manage the elements to be drawn at each moment of the game.
 */
class GameView : public QGraphicsView {

Q_OBJECT

public:

    /**
      * Creates a new GameView instance.
      * @param p_game the Game instance whose elements have to be drawn
      */
    GameView(GameScene* p_scene, Game* p_game);

    /**
      * Deletes the GameView instance.
      */
    ~GameView();

    /**
      * Resizes the items when the view is resized.
      * @param p_event the resize event
      */
    void resizeEvent(QResizeEvent* p_event) Q_DECL_OVERRIDE;

protected:

    /**
      * Manages the player actions by hanlding the key press events.
      * @param p_event the key press event
      */
    void keyPressEvent(QKeyEvent* p_event) Q_DECL_OVERRIDE;

    /**
      * Manages the player actions by hanlding the key release events.
      * @param p_event the key release event
      */
    void keyReleaseEvent(QKeyEvent* p_event) Q_DECL_OVERRIDE;

    /**
      * Pauses the game on focus lost.
      * @param p_event the focus event
      */
    void focusOutEvent(QFocusEvent* p_event) Q_DECL_OVERRIDE;

signals:

    /**
      * Emitted on key press event for the Game instance
      * @param p_event the key press event
      */
    void keyPressed(QKeyEvent* p_event);

    /**
      * Emitted on key release event for the Game instance
      * @param p_event the key release event
      */
    void keyReleased(QKeyEvent* p_event);
};

#endif

