/*
    This file is part of the KContacts framework.
    Copyright (c) 2015-2016 Laurent Montel <montel@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef GENDER_H
#define GENDER_H
#include "kcontacts_export.h"
#include <QtCore/QSharedDataPointer>
#include <QtCore/QString>

/** @short Class that holds a Gender for a contact.
 *  @since 4.14.5
 */

namespace KContacts
{

class KCONTACTS_EXPORT Gender
{
    friend KCONTACTS_EXPORT QDataStream &operator<<(QDataStream &, const Gender &);
    friend KCONTACTS_EXPORT QDataStream &operator>>(QDataStream &, Gender &);
public:
    /**
     * Creates an empty Gender object.
     */
    Gender();
    Gender(const Gender &other);
    Gender(const QString &gender);

    ~Gender();

    void setGender(const QString &gender);
    QString gender() const;

    void setComment(const QString &comment);
    QString comment() const;

    bool isValid() const;

    bool operator==(const Gender &other) const;
    bool operator!=(const Gender &other) const;

    Gender &operator=(const Gender &other);

    QString toString() const;
private:
    class Private;
    QSharedDataPointer<Private> d;
};

KCONTACTS_EXPORT QDataStream &operator<<(QDataStream &stream, const Gender &object);

KCONTACTS_EXPORT QDataStream &operator>>(QDataStream &stream, Gender &object);
}
Q_DECLARE_TYPEINFO(KContacts::Gender, Q_MOVABLE_TYPE);
#endif // GENDER_H
