/*  This file is part of the KDE project
    Copyright (C) 2011 Kevin Krammer, kevin.krammer@gmx.at

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef IMAPCACHEADAPTER_H
#define IMAPCACHEADAPTER_H

#include <QObject>

class KJob;
class MixedMaildirStore;

class ImapCacheAdapter : public QObject
{
  Q_OBJECT

  public:
    explicit ImapCacheAdapter( MixedMaildirStore *store, QObject *parent = 0 );
    ~ImapCacheAdapter();

    void addAccount( const QString &topLevelFolder, const QString &accountName );

  Q_SIGNALS:
    void finished( int messageType, const QString &message );

  public Q_SLOTS:
    void start();

  private:
    class Private;
    Private *const d;

    Q_PRIVATE_SLOT( d, void createResourceResult( KJob* ) )
    Q_PRIVATE_SLOT( d, void collectionModifyResult( KJob* ) )
};

#endif

// kate: space-indent on; indent-width 2; replace-tabs on;
