//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano {
    using Soprano;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \class Statement statement.h Soprano/Statement
    ///  \brief A Statement instance represents one RDF quadruple.
    ///  In %Soprano statements are quadruples, i.e. in addition to the subject, predicate, and
    ///  object nodes, they have a fourth node, the context. The context represents the named graph
    ///  in which the statement is stored. If the context is an empty node the statement is stored in
    ///  the default graph.
    ///  A Statement is valid if subject, predicate, and object are valid. Invalid statements can, however,
    ///  be used in many methods such as Model.ListStatements as wildwards.
    ///  \sa Node
    ///  \author Daniele Galdi <daniele.galdi@gmail.com><br>Sebastian Trueg <trueg@kde.org>
    ///      </remarks>        <short>    \class Statement statement.</short>
    [SmokeClass("Soprano::Statement")]
    public class Statement : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected Statement(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Statement), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Statement() {
            staticInterceptor = new SmokeInvocation(typeof(Statement), null);
        }
        /// <remarks>
        ///  Default Constructor, build an empty (invalid) Statement.
        ///          </remarks>        <short>    Default Constructor, build an empty (invalid) Statement.</short>
        public Statement() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Statement", "Statement()", typeof(void));
        }
        /// <remarks>
        ///  Build a Statement with the given subject, predicate and object.
        ///  \param subject The subject (cannot be of type Node.LiteralNode)
        ///  \param predicate The predicate (has to be of type Node.ResourceNode or Node.EmptyNode)
        ///  \param object The object can be of either Node type.
        ///  \param context The context node (has to be of type Node.ResourceNode or Node.EmptyNode)
        ///          </remarks>        <short>    Build a Statement with the given subject, predicate and object.</short>
        public Statement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Statement####", "Statement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(void), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Statement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Statement###", "Statement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(void), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        public Statement(Soprano.Statement other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Statement#", "Statement(const Soprano::Statement&)", typeof(void), typeof(Soprano.Statement), other);
        }
        public override bool Equals(object o) {
            if (!(o is Statement)) { return false; }
            return this == (Statement) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Match this statement against other. The only difference
        ///  to operator== is that empty nodes are matched as wildcards,
        ///  i.e. they match any other node.
        ///  \sa Node.Matches()
        ///  \return <pre>true</pre> if this statement matches other, <pre>false</pre> if not.
        ///          </remarks>        <short>    Match this statement against other.</short>
        public bool Matches(Soprano.Statement other) {
            return (bool) interceptor.Invoke("matches#", "matches(const Soprano::Statement&) const", typeof(bool), typeof(Soprano.Statement), other);
        }
        /// <remarks>
        ///  A Statement is valid if the subject is a resource or blank 
        ///  node, the predicate is a resource node,
        ///  and the object is a valid node.
        ///  \return <code>true</code> if the Statement is valid, <code>false</code> otherwise
        ///          </remarks>        <short>    A Statement is valid if the subject is a resource or blank   node, the predicate is a resource node,  and the object is a valid node.</short>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  \return The subject.
        ///          </remarks>        <short>    \return The subject.</short>
        public Soprano.Node Subject() {
            return (Soprano.Node) interceptor.Invoke("subject", "subject() const", typeof(Soprano.Node));
        }
        /// <remarks>
        ///  \return The predicate.
        ///          </remarks>        <short>    \return The predicate.</short>
        public Soprano.Node Predicate() {
            return (Soprano.Node) interceptor.Invoke("predicate", "predicate() const", typeof(Soprano.Node));
        }
        /// <remarks>
        ///  \return The object.
        ///          </remarks>        <short>    \return The object.</short>
        public Soprano.Node Object() {
            return (Soprano.Node) interceptor.Invoke("object", "object() const", typeof(Soprano.Node));
        }
        /// <remarks>
        ///  \return The Context node.
        ///          </remarks>        <short>    \return The Context node.</short>
        public Soprano.Node Context() {
            return (Soprano.Node) interceptor.Invoke("context", "context() const", typeof(Soprano.Node));
        }
        /// <remarks>
        ///  Change the Statement subject.
        ///  \param subject The new subject.
        ///          </remarks>        <short>    Change the Statement subject.</short>
        public void SetSubject(Soprano.Node subject) {
            interceptor.Invoke("setSubject#", "setSubject(const Soprano::Node&)", typeof(void), typeof(Soprano.Node), subject);
        }
        /// <remarks>
        ///  Change the Statement predicate.
        ///  \param predicate The new predicate.
        ///          </remarks>        <short>    Change the Statement predicate.</short>
        public void SetPredicate(Soprano.Node predicate) {
            interceptor.Invoke("setPredicate#", "setPredicate(const Soprano::Node&)", typeof(void), typeof(Soprano.Node), predicate);
        }
        /// <remarks>
        ///  Change the Statement object.
        ///  \param object The new object.
        ///          </remarks>        <short>    Change the Statement object.</short>
        public void SetObject(Soprano.Node arg1) {
            interceptor.Invoke("setObject#", "setObject(const Soprano::Node&)", typeof(void), typeof(Soprano.Node), arg1);
        }
        /// <remarks>
        ///  Change the Statement context.
        ///  \param context The new Context.
        ///          </remarks>        <short>    Change the Statement context.</short>
        public void SetContext(Soprano.Node context) {
            interceptor.Invoke("setContext#", "setContext(const Soprano::Node&)", typeof(void), typeof(Soprano.Node), context);
        }
        ~Statement() {
            interceptor.Invoke("~Statement", "~Statement()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Statement", "~Statement()", typeof(void));
        }
        public static bool operator==(Statement lhs, Soprano.Statement other) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const Soprano::Statement&) const", typeof(bool), typeof(Statement), lhs, typeof(Soprano.Statement), other);
        }
        public static bool operator!=(Statement lhs, Soprano.Statement other) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const Soprano::Statement&) const", typeof(bool), typeof(Statement), lhs, typeof(Soprano.Statement), other);
        }
    }
}
