/* GNU moe - My Own Editor
   Copyright (C) 2005-2024 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

const char * const rdonly_msg = "Read only";

namespace Window_vector {

int init();
Window & curwin();
int windows();
int load( int new_size = 0 );

void bufhandle_menu( const int abort_key );
const char * change_buffer_name();
const char * load_file( const int abort_key );
void split_window();
const char * save_file( const int abort_key = 3 );
int close( bool abort, const bool quiet = false );
int close_and_exit( const bool abort );

Window & window( int i );
void last_visited();
void next();
void prev();

const char * add_char( const int key, const bool force = false );
void delete_char( const bool back = false );
void delete_line();
void copy_block();
void delete_block();
void move_block();
const char * read_block();
const char * write_block();
void indent_block();
const char * unindent_block();
const char * undo();
const char * redo();

void center_line();
const char * reformat_paragraph();
const char * reformat_block();
const char * change_case( const int caps_level );
void encode_base64();
const char * decode_base64();
bool encode_ascii_utf8( const char ** const msgp,
                        const bool mode_a, const bool force = false );
const char * decode_quoted_printable_utf8( const bool mode_q,
                                           const bool force = false );
const char * remove_utf8_out_of_range();
void encode_rot1347( const bool mode13 );
const char * remove_duplicate_lines( const bool back = false );

const char * copyright_update();
const char * search_word( const int abort_key );
const char * search( const int abort_key, const bool again = false,
                     const std::string & s_ini = "",
                     const int toggle = 0 );

} // end namespace Window_vector
