/* UserConfig.c generated by valac 0.56.17, the Vala compiler
 * generated from UserConfig.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2015-2016 Adam Bieńkowski
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <act/act.h>

#define PC_CONSTANTS_DAEMON_CONF_FILE "/etc/pantheon-parental-controls/daemon.conf"
#define PC_CONSTANTS_DAEMON_KEY_ACTIVE "Active"
#define PC_CONSTANTS_DAEMON_KEY_TARGETS "Targets"
#define PC_CONSTANTS_DAEMON_KEY_BLOCK_URLS "BlockUrls"
#define PC_CONSTANTS_DAEMON_KEY_ADMIN "Admin"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_DAEMON_TYPE_USER_CONFIG (pc_daemon_user_config_get_type ())
#define PC_DAEMON_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig))
#define PC_DAEMON_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))
#define PC_DAEMON_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))

typedef struct _PCDaemonUserConfig PCDaemonUserConfig;
typedef struct _PCDaemonUserConfigClass PCDaemonUserConfigClass;
typedef struct _PCDaemonUserConfigPrivate PCDaemonUserConfigPrivate;
enum  {
	PC_DAEMON_USER_CONFIG_0_PROPERTY,
	PC_DAEMON_USER_CONFIG_USERNAME_PROPERTY,
	PC_DAEMON_USER_CONFIG_ACTIVE_PROPERTY,
	PC_DAEMON_USER_CONFIG_TARGETS_PROPERTY,
	PC_DAEMON_USER_CONFIG_BLOCK_URLS_PROPERTY,
	PC_DAEMON_USER_CONFIG_ADMIN_PROPERTY,
	PC_DAEMON_USER_CONFIG_NUM_PROPERTIES
};
static GParamSpec* pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PC_DAEMON_TYPE_SERVER (pc_daemon_server_get_type ())
#define PC_DAEMON_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SERVER, PCDaemonServer))
#define PC_DAEMON_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SERVER, PCDaemonServerClass))
#define PC_DAEMON_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SERVER))
#define PC_DAEMON_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SERVER))
#define PC_DAEMON_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SERVER, PCDaemonServerClass))

typedef struct _PCDaemonServer PCDaemonServer;
typedef struct _PCDaemonServerClass PCDaemonServerClass;

struct _PCDaemonUserConfig {
	GObject parent_instance;
	PCDaemonUserConfigPrivate * priv;
};

struct _PCDaemonUserConfigClass {
	GObjectClass parent_class;
};

struct _PCDaemonUserConfigPrivate {
	gchar* _username;
};

static gint PCDaemonUserConfig_private_offset;
static gpointer pc_daemon_user_config_parent_class = NULL;
static GKeyFile* pc_daemon_user_config_key;
static GKeyFile* pc_daemon_user_config_key = NULL;
static GList* pc_daemon_user_config_config_list;
static GList* pc_daemon_user_config_config_list = NULL;

VALA_EXTERN GType pc_daemon_user_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonUserConfig, g_object_unref)
VALA_EXTERN PCDaemonUserConfig* pc_daemon_user_config_get_for_username (const gchar* username,
                                                            gboolean create);
VALA_EXTERN const gchar* pc_daemon_user_config_get_username (PCDaemonUserConfig* self);
static PCDaemonUserConfig* pc_daemon_user_config_create_for_username (const gchar* username);
VALA_EXTERN GList* pc_daemon_user_config_get_all (void);
VALA_EXTERN void pc_daemon_user_config_init (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean pc_daemon_user_config_init_config_file (void);
static PCDaemonUserConfig* pc_daemon_user_config_new (const gchar* username);
static PCDaemonUserConfig* pc_daemon_user_config_construct (GType object_type,
                                                     const gchar* username);
VALA_EXTERN ActUserManager* pc_utils_get_usermanager (void);
VALA_EXTERN void pc_daemon_user_config_set_active (PCDaemonUserConfig* self,
                                       gboolean value);
VALA_EXTERN void pc_daemon_user_config_set_username (PCDaemonUserConfig* self,
                                         const gchar* value);
static void pc_daemon_user_config_save (PCDaemonUserConfig* self);
VALA_EXTERN GType pc_daemon_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonServer, g_object_unref)
VALA_EXTERN guint pc_daemon_server_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN PCDaemonServer* pc_daemon_server_get_default (void);
VALA_EXTERN gboolean pc_daemon_user_config_get_active (PCDaemonUserConfig* self);
VALA_EXTERN gchar** pc_daemon_user_config_get_targets (PCDaemonUserConfig* self,
                                           gint* result_length1);
VALA_EXTERN void pc_daemon_user_config_set_targets (PCDaemonUserConfig* self,
                                        gchar** value,
                                        gint value_length1);
VALA_EXTERN gchar** pc_daemon_user_config_get_block_urls (PCDaemonUserConfig* self,
                                              gint* result_length1);
VALA_EXTERN void pc_daemon_user_config_set_block_urls (PCDaemonUserConfig* self,
                                           gchar** value,
                                           gint value_length1);
VALA_EXTERN gboolean pc_daemon_user_config_get_admin (PCDaemonUserConfig* self);
VALA_EXTERN void pc_daemon_user_config_set_admin (PCDaemonUserConfig* self,
                                      gboolean value);
static void pc_daemon_user_config_finalize (GObject * obj);
static GType pc_daemon_user_config_get_type_once (void);
static void _vala_pc_daemon_user_config_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_pc_daemon_user_config_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pc_daemon_user_config_get_instance_private (PCDaemonUserConfig* self)
{
	return G_STRUCT_MEMBER_P (self, PCDaemonUserConfig_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PCDaemonUserConfig*
pc_daemon_user_config_get_for_username (const gchar* username,
                                        gboolean create)
{
	GList* _tmp0_;
	PCDaemonUserConfig* result;
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = pc_daemon_user_config_config_list;
	{
		GList* config_collection = NULL;
		GList* config_it = NULL;
		config_collection = _tmp0_;
		for (config_it = config_collection; config_it != NULL; config_it = config_it->next) {
			PCDaemonUserConfig* _tmp1_;
			PCDaemonUserConfig* config = NULL;
			_tmp1_ = _g_object_ref0 ((PCDaemonUserConfig*) config_it->data);
			config = _tmp1_;
			{
				PCDaemonUserConfig* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = config;
				_tmp3_ = _tmp2_->priv->_username;
				if (g_strcmp0 (_tmp3_, username) == 0) {
					result = config;
					return result;
				}
				_g_object_unref0 (config);
			}
		}
	}
	if (create) {
		PCDaemonUserConfig* _tmp4_;
		_tmp4_ = pc_daemon_user_config_create_for_username (username);
		result = _tmp4_;
		return result;
	}
	result = NULL;
	return result;
}

GList*
pc_daemon_user_config_get_all (void)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* result;
	_tmp0_ = pc_daemon_user_config_config_list;
	_tmp1_ = g_list_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
pc_daemon_user_config_init (void)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp7_;
	gsize _tmp8_ = 0;
	gchar** _tmp9_;
	GError* _inner_error0_ = NULL;
	(pc_daemon_user_config_config_list == NULL) ? NULL : (pc_daemon_user_config_config_list = (_g_list_free__g_object_unref0_ (pc_daemon_user_config_config_list), NULL));
	pc_daemon_user_config_config_list = NULL;
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (pc_daemon_user_config_key);
	pc_daemon_user_config_key = _tmp0_;
	_tmp1_ = pc_daemon_user_config_key;
	g_key_file_set_list_separator (_tmp1_, ';');
	if (!pc_daemon_user_config_init_config_file ()) {
		return;
	}
	{
		GKeyFile* _tmp2_;
		_tmp2_ = pc_daemon_user_config_key;
		g_key_file_load_from_file (_tmp2_, PC_CONSTANTS_DAEMON_CONF_FILE, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("UserConfig.vala:62: %s", _tmp4_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("UserConfig.vala:64: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = pc_daemon_user_config_key;
	_tmp9_ = g_key_file_get_groups (_tmp7_, &_tmp8_);
	{
		gchar** username_collection = NULL;
		gint username_collection_length1 = 0;
		gint _username_collection_size_ = 0;
		gint username_it = 0;
		username_collection = _tmp9_;
		username_collection_length1 = _tmp8_;
		for (username_it = 0; username_it < username_collection_length1; username_it = username_it + 1) {
			gchar* _tmp10_;
			gchar* username = NULL;
			_tmp10_ = g_strdup (username_collection[username_it]);
			username = _tmp10_;
			{
				PCDaemonUserConfig* user_config = NULL;
				const gchar* _tmp11_;
				PCDaemonUserConfig* _tmp12_;
				PCDaemonUserConfig* _tmp13_;
				PCDaemonUserConfig* _tmp14_;
				_tmp11_ = username;
				_tmp12_ = pc_daemon_user_config_new (_tmp11_);
				user_config = _tmp12_;
				_tmp13_ = user_config;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				pc_daemon_user_config_config_list = g_list_append (pc_daemon_user_config_config_list, _tmp14_);
				_g_object_unref0 (user_config);
				_g_free0 (username);
			}
		}
		username_collection = (_vala_array_free (username_collection, username_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static gboolean
pc_daemon_user_config_init_config_file (void)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	_tmp0_ = g_file_new_for_path (PC_CONSTANTS_DAEMON_CONF_FILE);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("Could not find daemon config file: %s does not exist", _tmp4_);
		_tmp6_ = _tmp5_;
		g_critical ("UserConfig.vala:76: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_object_unref0 (file);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (file);
	return result;
}

static PCDaemonUserConfig*
pc_daemon_user_config_create_for_username (const gchar* username)
{
	ActUser* user = NULL;
	ActUserManager* _tmp0_;
	ActUser* _tmp1_;
	ActUser* _tmp2_;
	ActUser* _tmp3_;
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp4_;
	PCDaemonUserConfig* _tmp5_;
	PCDaemonUserConfig* _tmp6_;
	PCDaemonUserConfig* _tmp7_;
	PCDaemonUserConfig* result;
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = pc_utils_get_usermanager ();
	_tmp1_ = act_user_manager_get_user (_tmp0_, username);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	user = _tmp2_;
	_tmp3_ = user;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (user);
		return result;
	}
	_tmp4_ = pc_daemon_user_config_new (username);
	config = _tmp4_;
	_tmp5_ = config;
	pc_daemon_user_config_set_active (_tmp5_, FALSE);
	_tmp6_ = config;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	pc_daemon_user_config_config_list = g_list_append (pc_daemon_user_config_config_list, _tmp7_);
	result = config;
	_g_object_unref0 (user);
	return result;
}

static PCDaemonUserConfig*
pc_daemon_user_config_construct (GType object_type,
                                 const gchar* username)
{
	PCDaemonUserConfig * self = NULL;
	g_return_val_if_fail (username != NULL, NULL);
	self = (PCDaemonUserConfig*) g_object_new (object_type, NULL);
	pc_daemon_user_config_set_username (self, username);
	return self;
}

static PCDaemonUserConfig*
pc_daemon_user_config_new (const gchar* username)
{
	return pc_daemon_user_config_construct (PC_DAEMON_TYPE_USER_CONFIG, username);
}

static void
pc_daemon_user_config_save (PCDaemonUserConfig* self)
{
	PCDaemonServer* _tmp3_;
	PCDaemonServer* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GKeyFile* _tmp0_;
		_tmp0_ = pc_daemon_user_config_key;
		g_key_file_save_to_file (_tmp0_, PC_CONSTANTS_DAEMON_CONF_FILE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserConfig.vala:167: %s", _tmp2_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = pc_daemon_server_get_default ();
	_tmp4_ = _tmp3_;
	g_signal_emit_by_name (_tmp4_, "config-changed");
	_g_object_unref0 (_tmp4_);
}

const gchar*
pc_daemon_user_config_get_username (PCDaemonUserConfig* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_username;
	result = _tmp0_;
	return result;
}

void
pc_daemon_user_config_set_username (PCDaemonUserConfig* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_daemon_user_config_get_username (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_username);
		self->priv->_username = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_USERNAME_PROPERTY]);
	}
}

gboolean
pc_daemon_user_config_get_active (PCDaemonUserConfig* self)
{
	gboolean result;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = pc_daemon_user_config_key;
		_tmp2_ = self->priv->_username;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, _tmp2_, PC_CONSTANTS_DAEMON_KEY_ACTIVE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("UserConfig.vala:104: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = FALSE;
	return result;
}

void
pc_daemon_user_config_set_active (PCDaemonUserConfig* self,
                                  gboolean value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_daemon_user_config_key;
	_tmp1_ = self->priv->_username;
	g_key_file_set_boolean (_tmp0_, _tmp1_, PC_CONSTANTS_DAEMON_KEY_ACTIVE, value);
	pc_daemon_user_config_save (self);
	g_object_notify_by_pspec ((GObject *) self, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_ACTIVE_PROPERTY]);
}

gchar**
pc_daemon_user_config_get_targets (PCDaemonUserConfig* self,
                                   gint* result_length1)
{
	gchar** result;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar** _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		gsize _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = pc_daemon_user_config_key;
		_tmp2_ = self->priv->_username;
		_tmp4_ = g_key_file_get_string_list (_tmp1_, _tmp2_, PC_CONSTANTS_DAEMON_KEY_TARGETS, &_tmp3_, &_inner_error0_);
		_tmp0_ = _tmp4_;
		_tmp0__length1 = _tmp3_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp5__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("UserConfig.vala:120: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp9_ = g_new0 (gchar*, 0 + 1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

void
pc_daemon_user_config_set_targets (PCDaemonUserConfig* self,
                                   gchar** value,
                                   gint value_length1)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_daemon_user_config_key;
	_tmp1_ = self->priv->_username;
	g_key_file_set_string_list (_tmp0_, _tmp1_, PC_CONSTANTS_DAEMON_KEY_TARGETS, (const gchar* const*) value, (gint) value_length1);
	pc_daemon_user_config_save (self);
	g_object_notify_by_pspec ((GObject *) self, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_TARGETS_PROPERTY]);
}

gchar**
pc_daemon_user_config_get_block_urls (PCDaemonUserConfig* self,
                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar** _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		gsize _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = pc_daemon_user_config_key;
		_tmp2_ = self->priv->_username;
		_tmp4_ = g_key_file_get_string_list (_tmp1_, _tmp2_, PC_CONSTANTS_DAEMON_KEY_BLOCK_URLS, &_tmp3_, &_inner_error0_);
		_tmp0_ = _tmp4_;
		_tmp0__length1 = _tmp3_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp5__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("UserConfig.vala:136: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp9_ = g_new0 (gchar*, 0 + 1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

void
pc_daemon_user_config_set_block_urls (PCDaemonUserConfig* self,
                                      gchar** value,
                                      gint value_length1)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_daemon_user_config_key;
	_tmp1_ = self->priv->_username;
	g_key_file_set_string_list (_tmp0_, _tmp1_, PC_CONSTANTS_DAEMON_KEY_BLOCK_URLS, (const gchar* const*) value, (gint) value_length1);
	pc_daemon_user_config_save (self);
	g_object_notify_by_pspec ((GObject *) self, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_BLOCK_URLS_PROPERTY]);
}

gboolean
pc_daemon_user_config_get_admin (PCDaemonUserConfig* self)
{
	gboolean result;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = pc_daemon_user_config_key;
		_tmp2_ = self->priv->_username;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, _tmp2_, PC_CONSTANTS_DAEMON_KEY_ADMIN, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("UserConfig.vala:152: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = FALSE;
	return result;
}

void
pc_daemon_user_config_set_admin (PCDaemonUserConfig* self,
                                 gboolean value)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_daemon_user_config_key;
	_tmp1_ = self->priv->_username;
	g_key_file_set_boolean (_tmp0_, _tmp1_, PC_CONSTANTS_DAEMON_KEY_ADMIN, value);
	pc_daemon_user_config_save (self);
	g_object_notify_by_pspec ((GObject *) self, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_ADMIN_PROPERTY]);
}

static void
pc_daemon_user_config_class_init (PCDaemonUserConfigClass * klass,
                                  gpointer klass_data)
{
	pc_daemon_user_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCDaemonUserConfig_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_daemon_user_config_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_daemon_user_config_set_property;
	G_OBJECT_CLASS (klass)->finalize = pc_daemon_user_config_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_DAEMON_USER_CONFIG_USERNAME_PROPERTY, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_USERNAME_PROPERTY] = g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_DAEMON_USER_CONFIG_ACTIVE_PROPERTY, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_DAEMON_USER_CONFIG_TARGETS_PROPERTY, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_TARGETS_PROPERTY] = g_param_spec_boxed ("targets", "targets", "targets", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_DAEMON_USER_CONFIG_BLOCK_URLS_PROPERTY, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_BLOCK_URLS_PROPERTY] = g_param_spec_boxed ("block-urls", "block-urls", "block-urls", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_DAEMON_USER_CONFIG_ADMIN_PROPERTY, pc_daemon_user_config_properties[PC_DAEMON_USER_CONFIG_ADMIN_PROPERTY] = g_param_spec_boolean ("admin", "admin", "admin", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pc_daemon_user_config_instance_init (PCDaemonUserConfig * self,
                                     gpointer klass)
{
	self->priv = pc_daemon_user_config_get_instance_private (self);
}

static void
pc_daemon_user_config_finalize (GObject * obj)
{
	PCDaemonUserConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig);
	_g_free0 (self->priv->_username);
	G_OBJECT_CLASS (pc_daemon_user_config_parent_class)->finalize (obj);
}

static GType
pc_daemon_user_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCDaemonUserConfig), 0, (GInstanceInitFunc) pc_daemon_user_config_instance_init, NULL };
	GType pc_daemon_user_config_type_id;
	pc_daemon_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "PCDaemonUserConfig", &g_define_type_info, 0);
	PCDaemonUserConfig_private_offset = g_type_add_instance_private (pc_daemon_user_config_type_id, sizeof (PCDaemonUserConfigPrivate));
	return pc_daemon_user_config_type_id;
}

GType
pc_daemon_user_config_get_type (void)
{
	static volatile gsize pc_daemon_user_config_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_user_config_type_id__once)) {
		GType pc_daemon_user_config_type_id;
		pc_daemon_user_config_type_id = pc_daemon_user_config_get_type_once ();
		g_once_init_leave (&pc_daemon_user_config_type_id__once, pc_daemon_user_config_type_id);
	}
	return pc_daemon_user_config_type_id__once;
}

static void
_vala_pc_daemon_user_config_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PCDaemonUserConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig);
	switch (property_id) {
		case PC_DAEMON_USER_CONFIG_USERNAME_PROPERTY:
		g_value_set_string (value, pc_daemon_user_config_get_username (self));
		break;
		case PC_DAEMON_USER_CONFIG_ACTIVE_PROPERTY:
		g_value_set_boolean (value, pc_daemon_user_config_get_active (self));
		break;
		case PC_DAEMON_USER_CONFIG_TARGETS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, pc_daemon_user_config_get_targets (self, &length));
		}
		break;
		case PC_DAEMON_USER_CONFIG_BLOCK_URLS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, pc_daemon_user_config_get_block_urls (self, &length));
		}
		break;
		case PC_DAEMON_USER_CONFIG_ADMIN_PROPERTY:
		g_value_set_boolean (value, pc_daemon_user_config_get_admin (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_daemon_user_config_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PCDaemonUserConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig);
	switch (property_id) {
		case PC_DAEMON_USER_CONFIG_USERNAME_PROPERTY:
		pc_daemon_user_config_set_username (self, g_value_get_string (value));
		break;
		case PC_DAEMON_USER_CONFIG_ACTIVE_PROPERTY:
		pc_daemon_user_config_set_active (self, g_value_get_boolean (value));
		break;
		case PC_DAEMON_USER_CONFIG_TARGETS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			pc_daemon_user_config_set_targets (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PC_DAEMON_USER_CONFIG_BLOCK_URLS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			pc_daemon_user_config_set_block_urls (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PC_DAEMON_USER_CONFIG_ADMIN_PROPERTY:
		pc_daemon_user_config_set_admin (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

