/* InputMethod.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from InputMethod.vala, do not modify */

/*
* Copyright 2019-2024 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#include "keyboard.h"
#include <ibus.h>
#include <gio/gio.h>
#include <glib.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_TYPE_SOURCE_SETTINGS (keyboard_source_settings_get_type ())
#define KEYBOARD_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings))
#define KEYBOARD_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))
#define KEYBOARD_IS_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_IS_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_SOURCE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))

typedef struct _KeyboardSourceSettings KeyboardSourceSettings;
typedef struct _KeyboardSourceSettingsClass KeyboardSourceSettingsClass;
enum  {
	KEYBOARD_INPUT_METHOD_PAGE_PAGE_0_PROPERTY,
	KEYBOARD_INPUT_METHOD_PAGE_PAGE_NUM_PROPERTIES
};
static GParamSpec* keyboard_input_method_page_page_properties[KEYBOARD_INPUT_METHOD_PAGE_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KeyboardInputMethodPagePagePrivate {
	IBusBus* bus;
	GSettings* ibus_panel_settings;
	gboolean selection_changing;
	GList* engines;
	GranitePlaceholder* spawn_failed_alert;
	GtkListBox* listbox;
	KeyboardSourceSettings* settings;
	GtkButton* remove_button;
	GtkStack* stack;
	GtkEntry* entry_test;
	GtkComboBoxText* keyboard_shortcut_combobox;
};

static gint KeyboardInputMethodPagePage_private_offset;
static gpointer keyboard_input_method_page_page_parent_class = NULL;

VALA_EXTERN GType keyboard_source_settings_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gchar* keyboard_input_method_page_page_get_keyboard_shortcut_id (KeyboardInputMethodPagePage* self);
static void keyboard_input_method_page_page_set_keyboard_shortcut (KeyboardInputMethodPagePage* self,
                                                            const gchar* combobox_id);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void keyboard_input_method_page_page_update_engines_list (KeyboardInputMethodPagePage* self);
VALA_EXTERN void keyboard_source_settings_reset (KeyboardSourceSettings* self,
                                     KeyboardLayoutType* layout_type,
                                     gboolean signal_changed);
VALA_EXTERN gchar** keyboard_source_settings_get_active_engines (KeyboardSourceSettings* self,
                                                     gint* result_length1);
VALA_EXTERN gchar* keyboard_input_method_page_utils_gettext_engine_longname (IBusEngineDesc* engine);
VALA_EXTERN gboolean keyboard_source_settings_add_layout (KeyboardSourceSettings* self,
                                              KeyboardInputSource* new_layout);
static void keyboard_input_method_page_page_write_ibus_autostart_file (KeyboardInputMethodPagePage* self,
                                                                gboolean enable);
static void keyboard_input_method_page_page_update_keyboard_shortcut_combo (KeyboardInputMethodPagePage* self);
static void keyboard_input_method_page_page_spawn_ibus_daemon (KeyboardInputMethodPagePage* self);
static void keyboard_input_method_page_page_set_visible_view (KeyboardInputMethodPagePage* self,
                                                       const gchar* error_message);
static gboolean __lambda79_ (KeyboardInputMethodPagePage* self);
static gboolean ___lambda79__gsource_func (gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void keyboard_input_method_page_page_update_entry_test_usable (KeyboardInputMethodPagePage* self);
VALA_EXTERN KeyboardInputSource* keyboard_source_settings_get_active_input_source (KeyboardSourceSettings* self);
static void keyboard_input_method_page_page_update_list_box_selected_row (KeyboardInputMethodPagePage* self);
static GObject * keyboard_input_method_page_page_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
VALA_EXTERN KeyboardSourceSettings* keyboard_source_settings_get_instance (void);
static void _keyboard_input_method_page_page_spawn_ibus_daemon_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void _keyboard_input_method_page_page___lambda80_ (KeyboardInputMethodPagePage* self,
                                                   GtkListBoxRow* row);
VALA_EXTERN void keyboard_source_settings_set_active_engine_name (KeyboardSourceSettings* self,
                                                      const gchar* engine_name);
static void __keyboard_input_method_page_page___lambda80__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                              GtkListBoxRow* row,
                                                                              gpointer self);
static void _keyboard_input_method_page_page___lambda81_ (KeyboardInputMethodPagePage* self,
                                                   const gchar* name);
static void __keyboard_input_method_page_page___lambda81__ibus_bus_global_engine_changed (IBusBus* _sender,
                                                                                   const gchar* name,
                                                                                   gpointer self);
static void _keyboard_input_method_page_page___lambda82_ (KeyboardInputMethodPagePage* self);
static void __lambda83_ (KeyboardInputMethodPagePage* self,
                  const gchar* engine);
VALA_EXTERN gboolean keyboard_source_settings_add_active_engine (KeyboardSourceSettings* self,
                                                     const gchar* engine_name);
static void ___lambda83__keyboard_input_method_page_add_engine_dialog_add_engine (KeyboardInputMethodPageAddEngineDialog* _sender,
                                                                           const gchar* new_engine,
                                                                           gpointer self);
static void __keyboard_input_method_page_page___lambda82__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _keyboard_input_method_page_page___lambda84_ (KeyboardInputMethodPagePage* self);
static void __keyboard_input_method_page_page___lambda84__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _keyboard_input_method_page_page___lambda85_ (KeyboardInputMethodPagePage* self);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void keyboard_source_settings_set_active_engines (KeyboardSourceSettings* self,
                                                  gchar** value,
                                                  gint value_length1);
VALA_EXTERN void keyboard_source_settings_set_active_index (KeyboardSourceSettings* self,
                                                guint value);
static void __keyboard_input_method_page_page___lambda85__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _keyboard_input_method_page_page___lambda86_ (KeyboardInputMethodPagePage* self);
static void __keyboard_input_method_page_page___lambda86__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void keyboard_input_method_page_page_finalize (GObject * obj);
static GType keyboard_input_method_page_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
keyboard_input_method_page_page_get_instance_private (KeyboardInputMethodPagePage* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardInputMethodPagePage_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar*
keyboard_input_method_page_page_get_keyboard_shortcut_id (KeyboardInputMethodPagePage* self)
{
	gchar** keyboard_shortcuts = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint keyboard_shortcuts_length1;
	gint _keyboard_shortcuts_size_;
	gchar* keyboard_shortcut_id = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = keyboard_plug_ibus_general_settings;
	_tmp1_ = g_settings_get_child (_tmp0_, "hotkey");
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "triggers");
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_object_unref0 (_tmp2_);
	keyboard_shortcuts = _tmp5_;
	keyboard_shortcuts_length1 = _tmp5__length1;
	_keyboard_shortcuts_size_ = keyboard_shortcuts_length1;
	_tmp6_ = g_strdup ("");
	keyboard_shortcut_id = _tmp6_;
	_tmp7_ = keyboard_shortcuts;
	_tmp7__length1 = keyboard_shortcuts_length1;
	{
		gchar** ks_collection = NULL;
		gint ks_collection_length1 = 0;
		gint _ks_collection_size_ = 0;
		gint ks_it = 0;
		ks_collection = _tmp7_;
		ks_collection_length1 = _tmp7__length1;
		for (ks_it = 0; ks_it < ks_collection_length1; ks_it = ks_it + 1) {
			gchar* _tmp8_;
			gchar* ks = NULL;
			_tmp8_ = g_strdup (ks_collection[ks_it]);
			ks = _tmp8_;
			{
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				GQuark _tmp12_ = 0U;
				static GQuark _tmp11_label0 = 0;
				static GQuark _tmp11_label1 = 0;
				static GQuark _tmp11_label2 = 0;
				_tmp9_ = ks;
				_tmp10_ = _tmp9_;
				_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
				if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("<Alt>space")))) {
					switch (0) {
						default:
						{
							gchar* _tmp13_;
							_tmp13_ = g_strdup ("alt-space");
							_g_free0 (keyboard_shortcut_id);
							keyboard_shortcut_id = _tmp13_;
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("<Shift>space")))) {
					switch (0) {
						default:
						{
							gchar* _tmp14_;
							_tmp14_ = g_strdup ("shift-space");
							_g_free0 (keyboard_shortcut_id);
							keyboard_shortcut_id = _tmp14_;
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("<Control>space")))) {
					switch (0) {
						default:
						{
							gchar* _tmp15_;
							_tmp15_ = g_strdup ("ctl-space");
							_g_free0 (keyboard_shortcut_id);
							keyboard_shortcut_id = _tmp15_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
				_g_free0 (ks);
			}
		}
	}
	result = keyboard_shortcut_id;
	keyboard_shortcuts = (_vala_array_free (keyboard_shortcuts, keyboard_shortcuts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
keyboard_input_method_page_page_set_keyboard_shortcut (KeyboardInputMethodPagePage* self,
                                                       const gchar* combobox_id)
{
	gchar** keyboard_shortcuts = NULL;
	gchar** _tmp0_;
	gint keyboard_shortcuts_length1;
	gint _keyboard_shortcuts_size_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combobox_id != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	keyboard_shortcuts = _tmp0_;
	keyboard_shortcuts_length1 = 0;
	_keyboard_shortcuts_size_ = keyboard_shortcuts_length1;
	if (combobox_id != NULL) {
		const gchar* _tmp1_;
		GQuark _tmp3_ = 0U;
		static GQuark _tmp2_label0 = 0;
		static GQuark _tmp2_label1 = 0;
		static GQuark _tmp2_label2 = 0;
		static GQuark _tmp2_label3 = 0;
		_tmp1_ = combobox_id;
		_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
		if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("alt-space")))) {
			switch (0) {
				default:
				{
					gchar* _tmp4_;
					_tmp4_ = g_strdup ("<Alt>space");
					_vala_array_add2 (&keyboard_shortcuts, &keyboard_shortcuts_length1, &_keyboard_shortcuts_size_, _tmp4_);
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("shift-space")))) {
			switch (0) {
				default:
				{
					gchar* _tmp5_;
					_tmp5_ = g_strdup ("<Shift>space");
					_vala_array_add3 (&keyboard_shortcuts, &keyboard_shortcuts_length1, &_keyboard_shortcuts_size_, _tmp5_);
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("control-space")))) {
			switch (0) {
				default:
				{
					gchar* _tmp6_;
					_tmp6_ = g_strdup ("<Control>space");
					_vala_array_add4 (&keyboard_shortcuts, &keyboard_shortcuts_length1, &_keyboard_shortcuts_size_, _tmp6_);
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("disabled")))) {
			switch (0) {
				default:
				{
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp7_ = keyboard_plug_ibus_general_settings;
	_tmp8_ = g_settings_get_child (_tmp7_, "hotkey");
	_tmp9_ = _tmp8_;
	_tmp10_ = keyboard_shortcuts;
	_tmp10__length1 = keyboard_shortcuts_length1;
	g_settings_set_strv (_tmp9_, "triggers", _tmp10_);
	_g_object_unref0 (_tmp9_);
	keyboard_shortcuts = (_vala_array_free (keyboard_shortcuts, keyboard_shortcuts_length1, (GDestroyNotify) g_free), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
keyboard_input_method_page_page_update_engines_list (KeyboardInputMethodPagePage* self)
{
	IBusBus* _tmp0_;
	GList* _tmp1_;
	KeyboardSourceSettings* _tmp7_;
	KeyboardLayoutType _tmp8_;
	KeyboardSourceSettings* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GtkButton* _tmp48_;
	GtkListBox* _tmp49_;
	GtkListBoxRow* _tmp50_;
	GtkStack* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bus;
	_tmp1_ = ibus_bus_list_engines (_tmp0_);
	(self->priv->engines == NULL) ? NULL : (self->priv->engines = (_g_list_free__g_object_unref0_ (self->priv->engines), NULL));
	self->priv->engines = _tmp1_;
	while (TRUE) {
		GtkListBox* _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		_tmp2_ = self->priv->listbox;
		_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, 0);
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = self->priv->listbox;
		_tmp5_ = self->priv->listbox;
		_tmp6_ = gtk_list_box_get_row_at_index (_tmp5_, 0);
		gtk_list_box_remove (_tmp4_, (GtkWidget*) _tmp6_);
	}
	_tmp7_ = self->priv->settings;
	_tmp8_ = KEYBOARD_LAYOUT_TYPE_IBUS;
	keyboard_source_settings_reset (_tmp7_, &_tmp8_, TRUE);
	_tmp9_ = self->priv->settings;
	_tmp10_ = keyboard_source_settings_get_active_engines (_tmp9_, &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	{
		gchar** active_engine_collection = NULL;
		gint active_engine_collection_length1 = 0;
		gint _active_engine_collection_size_ = 0;
		gint active_engine_it = 0;
		active_engine_collection = _tmp12_;
		active_engine_collection_length1 = _tmp12__length1;
		for (active_engine_it = 0; active_engine_it < active_engine_collection_length1; active_engine_it = active_engine_it + 1) {
			gchar* _tmp13_;
			gchar* active_engine = NULL;
			_tmp13_ = g_strdup (active_engine_collection[active_engine_it]);
			active_engine = _tmp13_;
			{
				GList* _tmp14_;
				_tmp14_ = self->priv->engines;
				{
					GList* engine_collection = NULL;
					GList* engine_it = NULL;
					engine_collection = _tmp14_;
					for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
						IBusEngineDesc* _tmp15_;
						IBusEngineDesc* engine = NULL;
						_tmp15_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
						engine = _tmp15_;
						{
							IBusEngineDesc* _tmp16_;
							const gchar* _tmp17_;
							const gchar* _tmp18_;
							const gchar* _tmp19_;
							_tmp16_ = engine;
							_tmp17_ = ibus_engine_desc_get_name (_tmp16_);
							_tmp18_ = _tmp17_;
							_tmp19_ = active_engine;
							if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
								gchar* engine_full_name = NULL;
								IBusEngineDesc* _tmp20_;
								const gchar* _tmp21_;
								const gchar* _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								IBusEngineDesc* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								gchar* _tmp29_;
								GtkLabel* label = NULL;
								const gchar* _tmp30_;
								GtkLabel* _tmp31_ = NULL;
								GtkListBoxRow* listboxrow = NULL;
								GtkLabel* _tmp32_;
								GtkWidget* _tmp33_;
								GtkListBoxRow* _tmp34_ = NULL;
								GtkListBoxRow* _tmp35_;
								IBusEngineDesc* _tmp36_;
								const gchar* _tmp37_;
								const gchar* _tmp38_;
								gchar* _tmp39_;
								GtkListBox* _tmp40_;
								GtkListBoxRow* _tmp41_;
								KeyboardSourceSettings* _tmp42_;
								IBusEngineDesc* _tmp43_;
								const gchar* _tmp44_;
								const gchar* _tmp45_;
								KeyboardInputSource* _tmp46_;
								KeyboardInputSource* _tmp47_;
								_tmp20_ = engine;
								_tmp21_ = ibus_engine_desc_get_language (_tmp20_);
								_tmp22_ = _tmp21_;
								_tmp23_ = ibus_get_language_name (_tmp22_);
								_tmp24_ = _tmp23_;
								_tmp25_ = engine;
								_tmp26_ = keyboard_input_method_page_utils_gettext_engine_longname (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = g_strdup_printf ("%s - %s", _tmp24_, _tmp27_);
								_tmp29_ = _tmp28_;
								_g_free0 (_tmp27_);
								_g_free0 (_tmp24_);
								engine_full_name = _tmp29_;
								_tmp30_ = engine_full_name;
								_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
								gtk_widget_set_halign ((GtkWidget*) _tmp31_, GTK_ALIGN_START);
								gtk_widget_set_margin_top ((GtkWidget*) _tmp31_, 6);
								gtk_widget_set_margin_end ((GtkWidget*) _tmp31_, 6);
								gtk_widget_set_margin_bottom ((GtkWidget*) _tmp31_, 6);
								gtk_widget_set_margin_start ((GtkWidget*) _tmp31_, 6);
								g_object_ref_sink (_tmp31_);
								label = _tmp31_;
								_tmp32_ = label;
								_tmp33_ = _g_object_ref0 ((GtkWidget*) _tmp32_);
								_tmp34_ = (GtkListBoxRow*) gtk_list_box_row_new ();
								gtk_list_box_row_set_child (_tmp34_, _tmp33_);
								_g_object_unref0 (_tmp33_);
								g_object_ref_sink (_tmp34_);
								listboxrow = _tmp34_;
								_tmp35_ = listboxrow;
								_tmp36_ = engine;
								_tmp37_ = ibus_engine_desc_get_name (_tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = g_strdup (_tmp38_);
								g_object_set_data_full ((GObject*) _tmp35_, "engine-name", _tmp39_, g_free);
								_tmp40_ = self->priv->listbox;
								_tmp41_ = listboxrow;
								gtk_list_box_append (_tmp40_, (GtkWidget*) _tmp41_);
								_tmp42_ = self->priv->settings;
								_tmp43_ = engine;
								_tmp44_ = ibus_engine_desc_get_name (_tmp43_);
								_tmp45_ = _tmp44_;
								_tmp46_ = keyboard_input_source_new_ibus (_tmp45_);
								_tmp47_ = _tmp46_;
								keyboard_source_settings_add_layout (_tmp42_, _tmp47_);
								_g_object_unref0 (_tmp47_);
								_g_object_unref0 (listboxrow);
								_g_object_unref0 (label);
								_g_free0 (engine_full_name);
							}
							_g_object_unref0 (engine);
						}
					}
				}
				_g_free0 (active_engine);
			}
		}
	}
	_tmp48_ = self->priv->remove_button;
	_tmp49_ = self->priv->listbox;
	_tmp50_ = gtk_list_box_get_selected_row (_tmp49_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp48_, _tmp50_ != NULL);
	_tmp51_ = self->priv->stack;
	_tmp52_ = gtk_stack_get_visible_child_name (_tmp51_);
	_tmp53_ = _tmp52_;
	if (g_strcmp0 (_tmp53_, "main_view") == 0) {
		GtkListBox* _tmp54_;
		GtkListBoxRow* _tmp55_;
		_tmp54_ = self->priv->listbox;
		_tmp55_ = gtk_list_box_get_row_at_index (_tmp54_, 0);
		keyboard_input_method_page_page_write_ibus_autostart_file (self, _tmp55_ != NULL);
	}
	keyboard_input_method_page_page_update_keyboard_shortcut_combo (self);
}

static gboolean
__lambda79_ (KeyboardInputMethodPagePage* self)
{
	gboolean result;
	keyboard_input_method_page_page_set_visible_view (self, "");
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda79__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda79_ ((KeyboardInputMethodPagePage*) self);
	return result;
}

static void
keyboard_input_method_page_page_spawn_ibus_daemon (KeyboardInputMethodPagePage* self)
{
	gboolean is_spawn_succeeded = FALSE;
	guint timeout_start_daemon = 0U;
	GtkListBox* _tmp13_;
	GtkListBoxRow* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	is_spawn_succeeded = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gboolean _tmp8_;
		_tmp1_ = g_strdup ("ibus-daemon");
		_tmp2_ = g_strdup ("-drx");
		_tmp3_ = g_new0 (gchar*, 2 + 1);
		_tmp3_[0] = _tmp1_;
		_tmp3_[1] = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 2;
		_tmp6_ = _tmp5_ = g_get_environ ();
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _vala_array_length (_tmp5_);
		_tmp8_ = g_spawn_sync ("/", _tmp4_, _tmp7_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		_tmp0_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		is_spawn_succeeded = _tmp0_;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("InputMethod.vala:365: %s", _tmp10_);
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		keyboard_input_method_page_page_set_visible_view (self, _tmp12_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	timeout_start_daemon = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda79__gsource_func, g_object_ref (self), g_object_unref);
	timeout_start_daemon = (guint) 0;
	_tmp13_ = self->priv->listbox;
	_tmp14_ = gtk_list_box_get_row_at_index (_tmp13_, 0);
	if (is_spawn_succeeded & (_tmp14_ != NULL)) {
		keyboard_input_method_page_page_write_ibus_autostart_file (self, TRUE);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
keyboard_input_method_page_page_write_ibus_autostart_file (KeyboardInputMethodPagePage* self,
                                                           gboolean enable)
{
	gchar* config_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* startup_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** languages = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint languages_length1;
	gint _languages_size_;
	gchar* preferred_language = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp16_;
	GKeyFile* _tmp17_;
	const gchar* _tmp18_;
	GKeyFile* _tmp19_;
	const gchar* _tmp20_;
	GKeyFile* _tmp21_;
	GKeyFile* _tmp22_;
	GKeyFile* _tmp23_;
	GKeyFile* _tmp24_;
	gchar* path = NULL;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = config_dir;
	_tmp3_ = g_build_filename (_tmp2_, "autostart", NULL);
	startup_dir = _tmp3_;
	_tmp4_ = startup_dir;
	if (!g_file_test (_tmp4_, G_FILE_TEST_EXISTS)) {
		GFile* file = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		_tmp5_ = startup_dir;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		file = _tmp6_;
		{
			GFile* _tmp7_;
			_tmp7_ = file;
			g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("InputMethod.vala:393: %s", _tmp9_);
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_free0 (startup_dir);
			_g_free0 (config_dir);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (startup_dir);
			_g_free0 (config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (file);
	}
	_tmp11_ = _tmp10_ = g_get_language_names ();
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup1 (_tmp11_, _vala_array_length (_tmp10_)) : _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	languages = _tmp12_;
	languages_length1 = _tmp12__length1;
	_languages_size_ = languages_length1;
	_tmp13_ = languages;
	_tmp13__length1 = languages_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = g_strdup (_tmp14_);
	preferred_language = _tmp15_;
	_tmp16_ = g_key_file_new ();
	keyfile = _tmp16_;
	_tmp17_ = keyfile;
	_tmp18_ = preferred_language;
	g_key_file_set_locale_string (_tmp17_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NAME, _tmp18_, _ ("IBus Daemon"));
	_tmp19_ = keyfile;
	_tmp20_ = preferred_language;
	g_key_file_set_locale_string (_tmp19_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_COMMENT, _tmp20_, _ ("Use and manage input methods"));
	_tmp21_ = keyfile;
	g_key_file_set_string (_tmp21_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_EXEC, "ibus-daemon -drx");
	_tmp22_ = keyfile;
	g_key_file_set_string (_tmp22_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, "ibus-setup");
	_tmp23_ = keyfile;
	g_key_file_set_string (_tmp23_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, "Application");
	_tmp24_ = keyfile;
	g_key_file_set_boolean (_tmp24_, G_KEY_FILE_DESKTOP_GROUP, "X-GNOME-Autostart-enabled", enable);
	_tmp25_ = startup_dir;
	_tmp26_ = g_build_filename (_tmp25_, "ibus-daemon.desktop", NULL);
	path = _tmp26_;
	{
		const gchar* _tmp27_;
		GKeyFile* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp27_ = path;
		_tmp28_ = keyfile;
		_tmp29_ = g_key_file_to_data (_tmp28_, NULL, NULL);
		_tmp30_ = _tmp29_;
		g_file_set_contents (_tmp27_, _tmp30_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp30_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = path;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("InputMethod.vala:419: Could not write to file %s: %s", _tmp31_, _tmp33_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_key_file_unref0 (keyfile);
		_g_free0 (preferred_language);
		languages = (_vala_array_free (languages, languages_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (startup_dir);
		_g_free0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
	_g_key_file_unref0 (keyfile);
	_g_free0 (preferred_language);
	languages = (_vala_array_free (languages, languages_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (startup_dir);
	_g_free0 (config_dir);
}

static void
keyboard_input_method_page_page_set_visible_view (KeyboardInputMethodPagePage* self,
                                                  const gchar* error_message)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	if (g_strcmp0 (error_message, "") != 0) {
		GtkStack* _tmp0_;
		GranitePlaceholder* _tmp1_;
		_tmp0_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp0_, "spawn_failed_view");
		_tmp1_ = self->priv->spawn_failed_alert;
		granite_placeholder_set_description (_tmp1_, error_message);
	} else {
		IBusBus* _tmp2_;
		_tmp2_ = self->priv->bus;
		if (ibus_bus_is_connected (_tmp2_)) {
			GtkStack* _tmp3_;
			_tmp3_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp3_, "main_view");
			keyboard_input_method_page_page_update_engines_list (self);
		} else {
			GtkStack* _tmp4_;
			_tmp4_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp4_, "no_daemon_runnning_view");
		}
	}
}

static void
keyboard_input_method_page_page_update_entry_test_usable (KeyboardInputMethodPagePage* self)
{
	gboolean _tmp0_ = FALSE;
	KeyboardSourceSettings* _tmp1_;
	KeyboardInputSource* _tmp2_;
	KeyboardInputSource* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->settings;
	_tmp2_ = keyboard_source_settings_get_active_input_source (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		KeyboardSourceSettings* _tmp4_;
		KeyboardInputSource* _tmp5_;
		KeyboardInputSource* _tmp6_;
		KeyboardLayoutType _tmp7_;
		KeyboardLayoutType _tmp8_;
		_tmp4_ = self->priv->settings;
		_tmp5_ = keyboard_source_settings_get_active_input_source (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = keyboard_input_source_get_layout_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == KEYBOARD_LAYOUT_TYPE_IBUS;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkEntry* _tmp9_;
		GtkEntry* _tmp10_;
		_tmp9_ = self->priv->entry_test;
		gtk_entry_set_placeholder_text (_tmp9_, _ ("Type to test your input method"));
		_tmp10_ = self->priv->entry_test;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
	} else {
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		_tmp11_ = self->priv->entry_test;
		gtk_entry_set_placeholder_text (_tmp11_, _ ("A keyboard layout is active"));
		_tmp12_ = self->priv->entry_test;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
	}
}

static void
keyboard_input_method_page_page_update_list_box_selected_row (KeyboardInputMethodPagePage* self)
{
	gchar* engine_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	KeyboardSourceSettings* _tmp2_;
	KeyboardInputSource* _tmp3_;
	KeyboardInputSource* _tmp4_;
	GtkWidget* child = NULL;
	GtkListBox* _tmp18_;
	GtkWidget* _tmp19_;
	GtkButton* _tmp35_;
	GtkListBox* _tmp36_;
	GtkListBoxRow* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	engine_name = _tmp0_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = keyboard_source_settings_get_active_input_source (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		KeyboardSourceSettings* _tmp5_;
		KeyboardInputSource* _tmp6_;
		KeyboardInputSource* _tmp7_;
		KeyboardLayoutType _tmp8_;
		KeyboardLayoutType _tmp9_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = keyboard_source_settings_get_active_input_source (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = keyboard_input_source_get_layout_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp1_ = _tmp9_ == KEYBOARD_LAYOUT_TYPE_IBUS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		KeyboardSourceSettings* _tmp10_;
		KeyboardInputSource* _tmp11_;
		KeyboardInputSource* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		IBusBus* _tmp16_;
		const gchar* _tmp17_;
		_tmp10_ = self->priv->settings;
		_tmp11_ = keyboard_source_settings_get_active_input_source (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = keyboard_input_source_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (engine_name);
		engine_name = _tmp15_;
		_tmp16_ = self->priv->bus;
		_tmp17_ = engine_name;
		ibus_bus_set_global_engine (_tmp16_, _tmp17_);
	}
	_tmp18_ = self->priv->listbox;
	_tmp19_ = gtk_widget_get_first_child ((GtkWidget*) _tmp18_);
	child = _tmp19_;
	while (TRUE) {
		GtkWidget* _tmp20_;
		GtkWidget* _tmp21_;
		GtkWidget* _tmp33_;
		GtkWidget* _tmp34_;
		_tmp20_ = child;
		if (!(_tmp20_ != NULL)) {
			break;
		}
		_tmp21_ = child;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_list_box_row_get_type ())) {
			GtkListBoxRow* row = NULL;
			GtkWidget* _tmp22_;
			GtkListBoxRow* _tmp23_;
			gchar* row_name = NULL;
			GtkListBoxRow* _tmp24_;
			gconstpointer _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			_tmp22_ = child;
			_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_list_box_row_get_type (), GtkListBoxRow));
			row = _tmp23_;
			_tmp24_ = row;
			_tmp25_ = g_object_get_data ((GObject*) _tmp24_, "engine-name");
			_tmp26_ = g_strdup ((const gchar*) _tmp25_);
			row_name = _tmp26_;
			_tmp27_ = row_name;
			_tmp28_ = engine_name;
			if (g_strcmp0 (_tmp27_, _tmp28_) == 0) {
				GtkListBox* _tmp29_;
				GtkListBoxRow* _tmp30_;
				_tmp29_ = self->priv->listbox;
				_tmp30_ = row;
				gtk_list_box_select_row (_tmp29_, _tmp30_);
			} else {
				GtkListBox* _tmp31_;
				GtkListBoxRow* _tmp32_;
				_tmp31_ = self->priv->listbox;
				_tmp32_ = row;
				gtk_list_box_unselect_row (_tmp31_, _tmp32_);
			}
			_g_free0 (row_name);
			_g_object_unref0 (row);
		}
		_tmp33_ = child;
		_tmp34_ = gtk_widget_get_next_sibling (_tmp33_);
		child = _tmp34_;
	}
	_tmp35_ = self->priv->remove_button;
	_tmp36_ = self->priv->listbox;
	_tmp37_ = gtk_list_box_get_selected_row (_tmp36_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, _tmp37_ != NULL);
	_g_free0 (engine_name);
}

static void
keyboard_input_method_page_page_update_keyboard_shortcut_combo (KeyboardInputMethodPagePage* self)
{
	KeyboardSourceSettings* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_source_settings_get_active_engines (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	if (_tmp3__length1 < 2) {
		GtkComboBoxText* _tmp4_;
		GtkComboBoxText* _tmp5_;
		_tmp4_ = self->priv->keyboard_shortcut_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		_tmp5_ = self->priv->keyboard_shortcut_combobox;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp5_, "disabled");
	} else {
		GtkComboBoxText* _tmp6_;
		GtkComboBoxText* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->keyboard_shortcut_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, TRUE);
		_tmp7_ = self->priv->keyboard_shortcut_combobox;
		_tmp8_ = keyboard_input_method_page_page_get_keyboard_shortcut_id (self);
		_tmp9_ = _tmp8_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
	}
}

KeyboardInputMethodPagePage*
keyboard_input_method_page_page_construct (GType object_type)
{
	KeyboardInputMethodPagePage * self = NULL;
	self = (KeyboardInputMethodPagePage*) g_object_new (object_type, NULL);
	return self;
}

KeyboardInputMethodPagePage*
keyboard_input_method_page_page_new (void)
{
	return keyboard_input_method_page_page_construct (KEYBOARD_INPUT_METHOD_PAGE_TYPE_PAGE);
}

static void
_keyboard_input_method_page_page_spawn_ibus_daemon_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	keyboard_input_method_page_page_spawn_ibus_daemon ((KeyboardInputMethodPagePage*) self);
}

static void
_keyboard_input_method_page_page___lambda80_ (KeyboardInputMethodPagePage* self,
                                              GtkListBoxRow* row)
{
	gboolean _tmp0_ = FALSE;
	if (!self->priv->selection_changing) {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (row, gtk_list_box_row_get_type ());
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* engine_name = NULL;
		gconstpointer _tmp1_;
		gchar* _tmp2_;
		KeyboardSourceSettings* _tmp3_;
		const gchar* _tmp4_;
		IBusBus* _tmp5_;
		const gchar* _tmp6_;
		self->priv->selection_changing = TRUE;
		_tmp1_ = g_object_get_data ((GObject*) row, "engine-name");
		_tmp2_ = g_strdup ((const gchar*) _tmp1_);
		engine_name = _tmp2_;
		_tmp3_ = self->priv->settings;
		_tmp4_ = engine_name;
		keyboard_source_settings_set_active_engine_name (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->bus;
		_tmp6_ = engine_name;
		ibus_bus_set_global_engine (_tmp5_, _tmp6_);
		keyboard_input_method_page_page_update_entry_test_usable (self);
		self->priv->selection_changing = FALSE;
		_g_free0 (engine_name);
	}
}

static void
__keyboard_input_method_page_page___lambda80__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self)
{
	_keyboard_input_method_page_page___lambda80_ ((KeyboardInputMethodPagePage*) self, row);
}

static void
_keyboard_input_method_page_page___lambda81_ (KeyboardInputMethodPagePage* self,
                                              const gchar* name)
{
	g_return_if_fail (name != NULL);
	keyboard_input_method_page_page_update_list_box_selected_row (self);
	keyboard_input_method_page_page_update_entry_test_usable (self);
}

static void
__keyboard_input_method_page_page___lambda81__ibus_bus_global_engine_changed (IBusBus* _sender,
                                                                              const gchar* name,
                                                                              gpointer self)
{
	_keyboard_input_method_page_page___lambda81_ ((KeyboardInputMethodPagePage*) self, name);
}

static void
__lambda83_ (KeyboardInputMethodPagePage* self,
             const gchar* engine)
{
	KeyboardSourceSettings* _tmp0_;
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->settings;
	if (keyboard_source_settings_add_active_engine (_tmp0_, engine)) {
		keyboard_input_method_page_page_update_engines_list (self);
	}
}

static void
___lambda83__keyboard_input_method_page_add_engine_dialog_add_engine (KeyboardInputMethodPageAddEngineDialog* _sender,
                                                                      const gchar* new_engine,
                                                                      gpointer self)
{
	__lambda83_ ((KeyboardInputMethodPagePage*) self, new_engine);
}

static void
_keyboard_input_method_page_page___lambda82_ (KeyboardInputMethodPagePage* self)
{
	KeyboardInputMethodPageAddEngineDialog* dialog = NULL;
	GList* _tmp0_;
	GtkRoot* _tmp1_;
	GtkWindow* _tmp2_;
	KeyboardInputMethodPageAddEngineDialog* _tmp3_ = NULL;
	KeyboardInputMethodPageAddEngineDialog* _tmp4_;
	KeyboardInputMethodPageAddEngineDialog* _tmp5_;
	_tmp0_ = self->priv->engines;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = keyboard_input_method_page_add_engine_dialog_new (_tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_modal ((GtkWindow*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	gtk_window_present ((GtkWindow*) _tmp4_);
	_tmp5_ = dialog;
	g_signal_connect_object (_tmp5_, "add-engine", (GCallback) ___lambda83__keyboard_input_method_page_add_engine_dialog_add_engine, self, 0);
	_g_object_unref0 (dialog);
}

static void
__keyboard_input_method_page_page___lambda82__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_keyboard_input_method_page_page___lambda82_ ((KeyboardInputMethodPagePage*) self);
}

static void
_keyboard_input_method_page_page___lambda84_ (KeyboardInputMethodPagePage* self)
{
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->keyboard_shortcut_combobox;
	_tmp1_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	keyboard_input_method_page_page_set_keyboard_shortcut (self, _tmp2_);
}

static void
__keyboard_input_method_page_page___lambda84__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_keyboard_input_method_page_page___lambda84_ ((KeyboardInputMethodPagePage*) self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_keyboard_input_method_page_page___lambda85_ (KeyboardInputMethodPagePage* self)
{
	gint index = 0;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GArray* removed_lists = NULL;
	GArray* _tmp2_;
	KeyboardSourceSettings* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GArray* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** new_engines = NULL;
	gint new_engines_length1 = 0;
	gint _new_engines_size_ = 0;
	KeyboardSourceSettings* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	KeyboardSourceSettings* _tmp22_;
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	index = gtk_list_box_row_get_index (_tmp1_);
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	removed_lists = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = keyboard_source_settings_get_active_engines (_tmp3_, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	{
		gchar** active_engine_collection = NULL;
		gint active_engine_collection_length1 = 0;
		gint _active_engine_collection_size_ = 0;
		gint active_engine_it = 0;
		active_engine_collection = _tmp6_;
		active_engine_collection_length1 = _tmp6__length1;
		for (active_engine_it = 0; active_engine_it < active_engine_collection_length1; active_engine_it = active_engine_it + 1) {
			gchar* _tmp7_;
			gchar* active_engine = NULL;
			_tmp7_ = g_strdup (active_engine_collection[active_engine_it]);
			active_engine = _tmp7_;
			{
				GArray* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = removed_lists;
				_tmp9_ = active_engine;
				_tmp10_ = g_strdup (_tmp9_);
				g_array_append_val (_tmp8_, _tmp10_);
				_g_free0 (active_engine);
			}
		}
	}
	_tmp11_ = removed_lists;
	_tmp12_ = vala_g_array_remove_index (_tmp11_, (guint) index);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp13_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				GArray* _tmp16_;
				GArray* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = removed_lists;
				if (!(((guint) i) < _tmp16_->len)) {
					break;
				}
				_tmp17_ = removed_lists;
				_tmp18_ = g_array_index (_tmp17_, gchar*, (guint) i);
				_tmp19_ = g_strdup (_tmp18_);
				_vala_array_add5 (&new_engines, &new_engines_length1, &_new_engines_size_, _tmp19_);
			}
		}
	}
	_tmp20_ = self->priv->settings;
	_tmp21_ = new_engines;
	_tmp21__length1 = new_engines_length1;
	keyboard_source_settings_set_active_engines (_tmp20_, _tmp21_, _tmp21__length1);
	keyboard_input_method_page_page_update_engines_list (self);
	_tmp22_ = self->priv->settings;
	keyboard_source_settings_set_active_index (_tmp22_, (guint) 0);
	new_engines = (_vala_array_free (new_engines, new_engines_length1, (GDestroyNotify) g_free), NULL);
	_g_array_unref0 (removed_lists);
}

static void
__keyboard_input_method_page_page___lambda85__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_keyboard_input_method_page_page___lambda85_ ((KeyboardInputMethodPagePage*) self);
}

static void
_keyboard_input_method_page_page___lambda86_ (KeyboardInputMethodPagePage* self)
{
	keyboard_input_method_page_page_update_list_box_selected_row (self);
	keyboard_input_method_page_page_update_entry_test_usable (self);
}

static void
__keyboard_input_method_page_page___lambda86__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_keyboard_input_method_page_page___lambda86_ ((KeyboardInputMethodPagePage*) self);
}

static GObject *
keyboard_input_method_page_page_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardInputMethodPagePage * self;
	KeyboardSourceSettings* _tmp0_;
	IBusBus* _tmp1_;
	GSettings* _tmp2_;
	GSettings* keyboard_settings = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GranitePlaceholder* no_daemon_runnning_alert = NULL;
	gchar* _tmp9_;
	GThemedIcon* _tmp10_;
	GranitePlaceholder* _tmp11_ = NULL;
	GranitePlaceholder* _tmp12_;
	GtkButton* ibus_button = NULL;
	GranitePlaceholder* _tmp13_;
	GThemedIcon* _tmp14_;
	GThemedIcon* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GThemedIcon* _tmp19_;
	GranitePlaceholder* _tmp20_ = NULL;
	GtkListBox* _tmp21_ = NULL;
	GtkListBox* _tmp22_;
	IBusBus* _tmp23_;
	IBusBus* _tmp24_;
	GtkScrolledWindow* scroll = NULL;
	GtkListBox* _tmp25_;
	GtkWidget* _tmp26_;
	GtkScrolledWindow* _tmp27_ = NULL;
	GtkLabel* add_button_label = NULL;
	GtkLabel* _tmp28_;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkImage* _tmp31_;
	GtkImage* _tmp32_;
	GtkBox* _tmp33_;
	GtkLabel* _tmp34_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp35_;
	GtkWidget* _tmp36_;
	GtkButton* _tmp37_ = NULL;
	GtkButton* _tmp38_;
	GtkLabel* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	gchar* _tmp42_;
	GtkButton* _tmp43_ = NULL;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp44_;
	GtkActionBar* _tmp45_;
	GtkActionBar* _tmp46_;
	GtkButton* _tmp47_;
	GtkActionBar* _tmp48_;
	GtkButton* _tmp49_;
	GtkBox* left_box = NULL;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	GtkScrolledWindow* _tmp52_;
	GtkBox* _tmp53_;
	GtkActionBar* _tmp54_;
	GtkFrame* display = NULL;
	GtkBox* _tmp55_;
	GtkWidget* _tmp56_;
	GtkFrame* _tmp57_ = NULL;
	GtkLabel* keyboard_shortcut_label = NULL;
	GtkLabel* _tmp58_ = NULL;
	GtkComboBoxText* _tmp59_ = NULL;
	GtkComboBoxText* _tmp60_;
	GtkComboBoxText* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GtkComboBoxText* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	GtkComboBoxText* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	GtkComboBoxText* _tmp70_;
	GtkLabel* show_ibus_panel_label = NULL;
	GtkLabel* _tmp71_ = NULL;
	GtkComboBoxText* show_ibus_panel_combobox = NULL;
	GtkComboBoxText* _tmp72_ = NULL;
	GtkComboBoxText* _tmp73_;
	GtkComboBoxText* _tmp74_;
	GtkComboBoxText* _tmp75_;
	GtkLabel* embed_preedit_text_label = NULL;
	GtkLabel* _tmp76_ = NULL;
	GtkSwitch* embed_preedit_text_switch = NULL;
	GtkSwitch* _tmp77_ = NULL;
	GtkEntry* _tmp78_ = NULL;
	GtkGrid* right_grid = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkGrid* _tmp80_;
	GtkLabel* _tmp81_;
	GtkGrid* _tmp82_;
	GtkComboBoxText* _tmp83_;
	GtkGrid* _tmp84_;
	GtkLabel* _tmp85_;
	GtkGrid* _tmp86_;
	GtkComboBoxText* _tmp87_;
	GtkGrid* _tmp88_;
	GtkLabel* _tmp89_;
	GtkGrid* _tmp90_;
	GtkSwitch* _tmp91_;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp92_ = NULL;
	GtkGrid* _tmp93_;
	GtkFrame* _tmp94_;
	GtkGrid* _tmp95_;
	GtkGrid* _tmp96_;
	GtkGrid* _tmp97_;
	GtkEntry* _tmp98_;
	GtkStack* _tmp99_;
	GtkStack* _tmp100_;
	GranitePlaceholder* _tmp101_;
	GtkStack* _tmp102_;
	GranitePlaceholder* _tmp103_;
	GtkStack* _tmp104_;
	GtkGrid* _tmp105_;
	GtkStack* _tmp106_;
	GtkButton* _tmp107_;
	GSettings* _tmp108_;
	GtkComboBoxText* _tmp109_;
	GSettings* _tmp110_;
	GtkSwitch* _tmp111_;
	KeyboardSourceSettings* _tmp112_;
	parent_class = G_OBJECT_CLASS (keyboard_input_method_page_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_INPUT_METHOD_PAGE_TYPE_PAGE, KeyboardInputMethodPagePage);
	_tmp0_ = keyboard_source_settings_get_instance ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = ibus_bus_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp1_;
	_tmp2_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->ibus_panel_settings);
	self->priv->ibus_panel_settings = _tmp2_;
	_tmp3_ = g_settings_new ("io.elementary.settings.keyboard");
	keyboard_settings = _tmp3_;
	_tmp4_ = keyboard_settings;
	if (g_settings_get_boolean (_tmp4_, "first-launch")) {
		GSettings* _tmp5_;
		GSettings* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp5_ = keyboard_settings;
		g_settings_set_boolean (_tmp5_, "first-launch", FALSE);
		_tmp6_ = keyboard_plug_ibus_general_settings;
		_tmp7_ = g_new0 (gchar*, 0 + 1);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 0;
		g_settings_set_strv (_tmp6_, "preload-engines", _tmp8_);
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp9_ = g_strdup (_ ("IBus daemon must run in the background to enable or configure input me" \
"thod engines."));
	_tmp10_ = (GThemedIcon*) g_themed_icon_new ("dialog-information");
	_tmp11_ = granite_placeholder_new (_ ("IBus Daemon is not running"));
	granite_placeholder_set_description (_tmp11_, _tmp9_);
	_g_free0 (_tmp9_);
	granite_placeholder_set_icon (_tmp11_, (GIcon*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp11_);
	no_daemon_runnning_alert = _tmp11_;
	_tmp12_ = no_daemon_runnning_alert;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp12_, GRANITE_STYLE_CLASS_VIEW);
	_tmp13_ = no_daemon_runnning_alert;
	_tmp14_ = (GThemedIcon*) g_themed_icon_new ("ibus-setup");
	_tmp15_ = _tmp14_;
	_tmp16_ = granite_placeholder_append_button (_tmp13_, (GIcon*) _tmp15_, _ ("Start IBus Daemon"), _ ("Can be managed in System Settings → Applications → Startup"));
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp15_);
	ibus_button = _tmp17_;
	_tmp18_ = ibus_button;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) _keyboard_input_method_page_page_spawn_ibus_daemon_gtk_button_clicked, self, 0);
	_tmp19_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp20_ = granite_placeholder_new (_ ("Could not start the IBus daemon"));
	granite_placeholder_set_icon (_tmp20_, (GIcon*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->spawn_failed_alert);
	self->priv->spawn_failed_alert = _tmp20_;
	_tmp21_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp21_, TRUE);
	gtk_list_box_set_selection_mode (_tmp21_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp21_;
	_tmp22_ = self->priv->listbox;
	g_signal_connect_object (_tmp22_, "row-selected", (GCallback) __keyboard_input_method_page_page___lambda80__gtk_list_box_row_selected, self, 0);
	_tmp23_ = self->priv->bus;
	ibus_bus_set_watch_ibus_signal (_tmp23_, TRUE);
	_tmp24_ = self->priv->bus;
	g_signal_connect_object (_tmp24_, "global-engine-changed", (GCallback) __keyboard_input_method_page_page___lambda81__ibus_bus_global_engine_changed, self, 0);
	_tmp25_ = self->priv->listbox;
	_tmp26_ = _g_object_ref0 ((GtkWidget*) _tmp25_);
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp27_, _tmp26_);
	_g_object_unref0 (_tmp26_);
	g_object_set (_tmp27_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp27_);
	scroll = _tmp27_;
	_tmp28_ = (GtkLabel*) gtk_label_new (_ ("Add Engine…"));
	g_object_ref_sink (_tmp28_);
	add_button_label = _tmp28_;
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp29_);
	add_button_box = _tmp29_;
	_tmp30_ = add_button_box;
	_tmp31_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp31_);
	_tmp32_ = _tmp31_;
	gtk_box_append (_tmp30_, (GtkWidget*) _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = add_button_box;
	_tmp34_ = add_button_label;
	gtk_box_append (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = add_button_box;
	_tmp36_ = _g_object_ref0 ((GtkWidget*) _tmp35_);
	_tmp37_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp37_, _tmp36_);
	_g_object_unref0 (_tmp36_);
	g_object_ref_sink (_tmp37_);
	add_button = _tmp37_;
	_tmp38_ = add_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp38_, GRANITE_STYLE_CLASS_FLAT);
	_tmp39_ = add_button_label;
	_tmp40_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = add_button;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) __keyboard_input_method_page_page___lambda82__gtk_button_clicked, self, 0);
	_tmp42_ = g_strdup (_ ("Remove"));
	_tmp43_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp43_, _tmp42_);
	_g_free0 (_tmp42_);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->remove_button = _tmp43_;
	_tmp44_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp44_);
	actionbar = _tmp44_;
	_tmp45_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp45_, GRANITE_STYLE_CLASS_FLAT);
	_tmp46_ = actionbar;
	_tmp47_ = add_button;
	gtk_action_bar_pack_start (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = actionbar;
	_tmp49_ = self->priv->remove_button;
	gtk_action_bar_pack_start (_tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp50_);
	left_box = _tmp50_;
	_tmp51_ = left_box;
	_tmp52_ = scroll;
	gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = left_box;
	_tmp54_ = actionbar;
	gtk_box_append (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = left_box;
	_tmp56_ = _g_object_ref0 ((GtkWidget*) _tmp55_);
	_tmp57_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp57_, _tmp56_);
	_g_object_unref0 (_tmp56_);
	g_object_ref_sink (_tmp57_);
	display = _tmp57_;
	_tmp58_ = (GtkLabel*) gtk_label_new (_ ("Switch engines:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp58_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp58_);
	keyboard_shortcut_label = _tmp58_;
	_tmp59_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp59_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->keyboard_shortcut_combobox);
	self->priv->keyboard_shortcut_combobox = _tmp59_;
	_tmp60_ = self->priv->keyboard_shortcut_combobox;
	gtk_combo_box_text_append (_tmp60_, "disabled", _ ("Disabled"));
	_tmp61_ = self->priv->keyboard_shortcut_combobox;
	_tmp62_ = granite_accel_to_string ("<Alt>space");
	_tmp63_ = _tmp62_;
	gtk_combo_box_text_append (_tmp61_, "alt-space", _tmp63_);
	_g_free0 (_tmp63_);
	_tmp64_ = self->priv->keyboard_shortcut_combobox;
	_tmp65_ = granite_accel_to_string ("<Control>space");
	_tmp66_ = _tmp65_;
	gtk_combo_box_text_append (_tmp64_, "ctl-space", _tmp66_);
	_g_free0 (_tmp66_);
	_tmp67_ = self->priv->keyboard_shortcut_combobox;
	_tmp68_ = granite_accel_to_string ("<Shift>space");
	_tmp69_ = _tmp68_;
	gtk_combo_box_text_append (_tmp67_, "shift-space", _tmp69_);
	_g_free0 (_tmp69_);
	_tmp70_ = self->priv->keyboard_shortcut_combobox;
	g_signal_connect_object ((GObject*) _tmp70_, "notify::active-id", (GCallback) __keyboard_input_method_page_page___lambda84__g_object_notify, self, 0);
	_tmp71_ = (GtkLabel*) gtk_label_new (_ ("Show property panel:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp71_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp71_);
	show_ibus_panel_label = _tmp71_;
	_tmp72_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp72_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp72_);
	show_ibus_panel_combobox = _tmp72_;
	_tmp73_ = show_ibus_panel_combobox;
	gtk_combo_box_text_append (_tmp73_, "none", _ ("Do not show"));
	_tmp74_ = show_ibus_panel_combobox;
	gtk_combo_box_text_append (_tmp74_, "auto-hide", _ ("Auto hide"));
	_tmp75_ = show_ibus_panel_combobox;
	gtk_combo_box_text_append (_tmp75_, "always-show", _ ("Always show"));
	_tmp76_ = (GtkLabel*) gtk_label_new (_ ("Embed preedit text in application window:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp76_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp76_);
	embed_preedit_text_label = _tmp76_;
	_tmp77_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp77_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp77_);
	embed_preedit_text_switch = _tmp77_;
	_tmp78_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp78_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp78_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (self->priv->entry_test);
	self->priv->entry_test = _tmp78_;
	keyboard_input_method_page_page_update_entry_test_usable (self);
	_tmp79_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp79_, 12);
	gtk_widget_set_halign ((GtkWidget*) _tmp79_, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp79_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp79_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp79_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp79_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp79_, 12);
	gtk_grid_set_row_spacing (_tmp79_, 12);
	g_object_ref_sink (_tmp79_);
	right_grid = _tmp79_;
	_tmp80_ = right_grid;
	_tmp81_ = keyboard_shortcut_label;
	gtk_grid_attach (_tmp80_, (GtkWidget*) _tmp81_, 0, 0, 1, 1);
	_tmp82_ = right_grid;
	_tmp83_ = self->priv->keyboard_shortcut_combobox;
	gtk_grid_attach (_tmp82_, (GtkWidget*) _tmp83_, 1, 0, 1, 1);
	_tmp84_ = right_grid;
	_tmp85_ = show_ibus_panel_label;
	gtk_grid_attach (_tmp84_, (GtkWidget*) _tmp85_, 0, 1, 1, 1);
	_tmp86_ = right_grid;
	_tmp87_ = show_ibus_panel_combobox;
	gtk_grid_attach (_tmp86_, (GtkWidget*) _tmp87_, 1, 1, 1, 1);
	_tmp88_ = right_grid;
	_tmp89_ = embed_preedit_text_label;
	gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 2, 1, 1);
	_tmp90_ = right_grid;
	_tmp91_ = embed_preedit_text_switch;
	gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 1, 2, 1, 1);
	_tmp92_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp92_, 12);
	gtk_grid_set_row_spacing (_tmp92_, 12);
	g_object_ref_sink (_tmp92_);
	main_grid = _tmp92_;
	_tmp93_ = main_grid;
	_tmp94_ = display;
	gtk_grid_attach (_tmp93_, (GtkWidget*) _tmp94_, 0, 0, 1, 2);
	_tmp95_ = main_grid;
	_tmp96_ = right_grid;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 1, 0, 1, 1);
	_tmp97_ = main_grid;
	_tmp98_ = self->priv->entry_test;
	gtk_grid_attach (_tmp97_, (GtkWidget*) _tmp98_, 1, 1, 1, 1);
	_tmp99_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp99_;
	_tmp100_ = self->priv->stack;
	_tmp101_ = no_daemon_runnning_alert;
	gtk_stack_add_named (_tmp100_, (GtkWidget*) _tmp101_, "no_daemon_runnning_view");
	_tmp102_ = self->priv->stack;
	_tmp103_ = self->priv->spawn_failed_alert;
	gtk_stack_add_named (_tmp102_, (GtkWidget*) _tmp103_, "spawn_failed_view");
	_tmp104_ = self->priv->stack;
	_tmp105_ = main_grid;
	gtk_stack_add_named (_tmp104_, (GtkWidget*) _tmp105_, "main_view");
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	gtk_widget_set_margin_top ((GtkWidget*) self, 12);
	_tmp106_ = self->priv->stack;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp106_);
	keyboard_input_method_page_page_set_visible_view (self, "");
	_tmp107_ = self->priv->remove_button;
	g_signal_connect_object (_tmp107_, "clicked", (GCallback) __keyboard_input_method_page_page___lambda85__gtk_button_clicked, self, 0);
	_tmp108_ = self->priv->ibus_panel_settings;
	_tmp109_ = show_ibus_panel_combobox;
	g_settings_bind (_tmp108_, "show", (GObject*) _tmp109_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp110_ = keyboard_plug_ibus_general_settings;
	_tmp111_ = embed_preedit_text_switch;
	g_settings_bind (_tmp110_, "embed-preedit-text", (GObject*) _tmp111_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp112_ = self->priv->settings;
	g_signal_connect_object ((GObject*) _tmp112_, "notify::active-index", (GCallback) __keyboard_input_method_page_page___lambda86__g_object_notify, self, 0);
	keyboard_input_method_page_page_update_list_box_selected_row (self);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (right_grid);
	_g_object_unref0 (embed_preedit_text_switch);
	_g_object_unref0 (embed_preedit_text_label);
	_g_object_unref0 (show_ibus_panel_combobox);
	_g_object_unref0 (show_ibus_panel_label);
	_g_object_unref0 (keyboard_shortcut_label);
	_g_object_unref0 (display);
	_g_object_unref0 (left_box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (add_button_label);
	_g_object_unref0 (scroll);
	_g_object_unref0 (ibus_button);
	_g_object_unref0 (no_daemon_runnning_alert);
	_g_object_unref0 (keyboard_settings);
	return obj;
}

static void
keyboard_input_method_page_page_class_init (KeyboardInputMethodPagePageClass * klass,
                                            gpointer klass_data)
{
	keyboard_input_method_page_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardInputMethodPagePage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = keyboard_input_method_page_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_input_method_page_page_finalize;
}

static void
keyboard_input_method_page_page_instance_init (KeyboardInputMethodPagePage * self,
                                               gpointer klass)
{
	self->priv = keyboard_input_method_page_page_get_instance_private (self);
	self->priv->selection_changing = FALSE;
}

static void
keyboard_input_method_page_page_finalize (GObject * obj)
{
	KeyboardInputMethodPagePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_INPUT_METHOD_PAGE_TYPE_PAGE, KeyboardInputMethodPagePage);
	_g_object_unref0 (self->priv->bus);
	_g_object_unref0 (self->priv->ibus_panel_settings);
	(self->priv->engines == NULL) ? NULL : (self->priv->engines = (_g_list_free__g_object_unref0_ (self->priv->engines), NULL));
	_g_object_unref0 (self->priv->spawn_failed_alert);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->remove_button);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->entry_test);
	_g_object_unref0 (self->priv->keyboard_shortcut_combobox);
	G_OBJECT_CLASS (keyboard_input_method_page_page_parent_class)->finalize (obj);
}

static GType
keyboard_input_method_page_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardInputMethodPagePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_input_method_page_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardInputMethodPagePage), 0, (GInstanceInitFunc) keyboard_input_method_page_page_instance_init, NULL };
	GType keyboard_input_method_page_page_type_id;
	keyboard_input_method_page_page_type_id = g_type_register_static (gtk_box_get_type (), "KeyboardInputMethodPagePage", &g_define_type_info, 0);
	KeyboardInputMethodPagePage_private_offset = g_type_add_instance_private (keyboard_input_method_page_page_type_id, sizeof (KeyboardInputMethodPagePagePrivate));
	return keyboard_input_method_page_page_type_id;
}

GType
keyboard_input_method_page_page_get_type (void)
{
	static volatile gsize keyboard_input_method_page_page_type_id__once = 0;
	if (g_once_init_enter (&keyboard_input_method_page_page_type_id__once)) {
		GType keyboard_input_method_page_page_type_id;
		keyboard_input_method_page_page_type_id = keyboard_input_method_page_page_get_type_once ();
		g_once_init_leave (&keyboard_input_method_page_page_type_id__once, keyboard_input_method_page_page_type_id);
	}
	return keyboard_input_method_page_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

