/* DisplayPlug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DisplayPlug.vala, do not modify */

/*-
 * Copyright (c) 2014-2023 elementary, Inc.
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 *              Oleksandr Lynok <oleksandr.lynok@gmail.com>
 */

#include "display.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_PLUG_0_PROPERTY,
	DISPLAY_PLUG_NUM_PROPERTIES
};
static GParamSpec* display_plug_properties[DISPLAY_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DisplayPlugSearchData DisplayPlugSearchData;

struct _DisplayPlugPrivate {
	GtkBox* box;
	GtkStack* stack;
	DisplayDisplaysView* displays_view;
};

struct _DisplayPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DisplayPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	GeeTreeMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeTreeMap* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GeeTreeMap* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GeeTreeMap* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GeeTreeMap* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GeeTreeMap* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GeeTreeMap* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GeeTreeMap* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GeeTreeMap* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GeeTreeMap* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GeeTreeMap* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GeeTreeMap* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	DisplaySensorManager* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	GeeTreeMap* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
};

static gint DisplayPlug_private_offset;
static gpointer display_plug_parent_class = NULL;
DisplayPlug* display_plug_plug = NULL;

static GtkWidget* display_plug_real_get_widget (SwitchboardPlug* base);
static void ___lambda48_ (DisplayPlug* self);
static void ____lambda48__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void display_plug_real_shown (SwitchboardPlug* base);
static void display_plug_real_hidden (SwitchboardPlug* base);
static void display_plug_real_search_callback (SwitchboardPlug* base,
                                        const gchar* location);
static void display_plug_real_search_data_free (gpointer _data);
static void display_plug_real_search (SwitchboardPlug* base,
                               const gchar* search,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gboolean display_plug_real_search_co (DisplayPlugSearchData* _data_);
static void display_plug_finalize (GObject * obj);
static GType display_plug_get_type_once (void);

static inline gpointer
display_plug_get_instance_private (DisplayPlug* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayPlug_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DisplayPlug*
display_plug_construct (GType object_type)
{
	DisplayPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	DisplayPlug* _tmp1_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "display", "displays");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "display/night-light", "night-light");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "display/filters", "filters");
	self = (DisplayPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.display", "display-name", _ ("Displays"), "description", _ ("Configure resolution and position of monitors and projectors"), "icon", "preferences-desktop-display", "supported-settings", settings, NULL);
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (display_plug_plug);
	display_plug_plug = _tmp1_;
	_g_object_unref0 (settings);
	return self;
}

DisplayPlug*
display_plug_new (void)
{
	return display_plug_construct (DISPLAY_TYPE_PLUG);
}

static void
___lambda48_ (DisplayPlug* self)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	DisplayDisplaysView* _tmp3_;
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->displays_view;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		DisplayDisplaysView* _tmp4_;
		DisplayDisplaysOverlay* _tmp5_;
		_tmp4_ = self->priv->displays_view;
		_tmp5_ = _tmp4_->displays_overlay;
		display_displays_overlay_show_windows (_tmp5_);
	} else {
		DisplayDisplaysView* _tmp6_;
		DisplayDisplaysOverlay* _tmp7_;
		_tmp6_ = self->priv->displays_view;
		_tmp7_ = _tmp6_->displays_overlay;
		display_displays_overlay_hide_windows (_tmp7_);
	}
}

static void
____lambda48__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda48_ ((DisplayPlug*) self);
}

static GtkWidget*
display_plug_real_get_widget (SwitchboardPlug* base)
{
	DisplayPlug * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp42_;
	GtkWidget* _tmp43_;
	GtkWidget* result;
	self = (DisplayPlug*) base;
	_tmp0_ = self->priv->box;
	if (_tmp0_ == NULL) {
		DisplayDisplaysView* _tmp1_;
		GtkStack* _tmp2_;
		GtkStack* _tmp3_;
		DisplayDisplaysView* _tmp4_;
		GSettingsSchema* interface_settings_schema = NULL;
		GSettingsSchemaSource* _tmp5_;
		GSettingsSchema* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GSettingsSchema* _tmp8_;
		GSettingsSchema* filters_settings_schema = NULL;
		GSettingsSchemaSource* _tmp13_;
		GSettingsSchema* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GSettingsSchema* _tmp16_;
		GtkStackSwitcher* stack_switcher = NULL;
		GtkStack* _tmp21_;
		GtkStack* _tmp22_;
		GtkStackSwitcher* _tmp23_ = NULL;
		GtkSizeGroup* switcher_sizegroup = NULL;
		GtkSizeGroup* _tmp24_;
		GtkWidget* switcher_child = NULL;
		GtkStackSwitcher* _tmp25_;
		GtkWidget* _tmp26_;
		AdwHeaderBar* headerbar = NULL;
		GtkStackSwitcher* _tmp32_;
		GtkWidget* _tmp33_;
		AdwHeaderBar* _tmp34_ = NULL;
		AdwHeaderBar* _tmp35_;
		GtkBox* _tmp36_;
		GtkBox* _tmp37_;
		AdwHeaderBar* _tmp38_;
		GtkBox* _tmp39_;
		GtkStack* _tmp40_;
		GtkStack* _tmp41_;
		_tmp1_ = display_displays_view_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->displays_view);
		self->priv->displays_view = _tmp1_;
		_tmp2_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp2_;
		_tmp3_ = self->priv->stack;
		_tmp4_ = self->priv->displays_view;
		gtk_stack_add_titled (_tmp3_, (GtkWidget*) _tmp4_, "displays", _ ("Displays"));
		_tmp5_ = g_settings_schema_source_get_default ();
		_tmp6_ = g_settings_schema_source_lookup (_tmp5_, "org.gnome.settings-daemon.plugins.color", TRUE);
		interface_settings_schema = _tmp6_;
		_tmp8_ = interface_settings_schema;
		if (_tmp8_ != NULL) {
			GSettingsSchema* _tmp9_;
			_tmp9_ = interface_settings_schema;
			_tmp7_ = g_settings_schema_has_key (_tmp9_, "night-light-enabled");
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			DisplayNightLightView* nightlight_view = NULL;
			DisplayNightLightView* _tmp10_;
			GtkStack* _tmp11_;
			DisplayNightLightView* _tmp12_;
			_tmp10_ = display_night_light_view_new ();
			g_object_ref_sink (_tmp10_);
			nightlight_view = _tmp10_;
			_tmp11_ = self->priv->stack;
			_tmp12_ = nightlight_view;
			gtk_stack_add_titled (_tmp11_, (GtkWidget*) _tmp12_, "night-light", _ ("Night Light"));
			_g_object_unref0 (nightlight_view);
		}
		_tmp13_ = g_settings_schema_source_get_default ();
		_tmp14_ = g_settings_schema_source_lookup (_tmp13_, "io.elementary.desktop.wm.accessibility", TRUE);
		filters_settings_schema = _tmp14_;
		_tmp16_ = filters_settings_schema;
		if (_tmp16_ != NULL) {
			GSettingsSchema* _tmp17_;
			_tmp17_ = filters_settings_schema;
			_tmp15_ = g_settings_schema_has_key (_tmp17_, "colorblindness-correction-filter");
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			DisplayFiltersView* filters_view = NULL;
			DisplayFiltersView* _tmp18_;
			GtkStack* _tmp19_;
			DisplayFiltersView* _tmp20_;
			_tmp18_ = display_filters_view_new ();
			g_object_ref_sink (_tmp18_);
			filters_view = _tmp18_;
			_tmp19_ = self->priv->stack;
			_tmp20_ = filters_view;
			gtk_stack_add_titled (_tmp19_, (GtkWidget*) _tmp20_, "filters", _ ("Filters"));
			_g_object_unref0 (filters_view);
		}
		_tmp21_ = self->priv->stack;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_tmp23_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
		gtk_stack_switcher_set_stack (_tmp23_, _tmp22_);
		_g_object_unref0 (_tmp22_);
		g_object_ref_sink (_tmp23_);
		stack_switcher = _tmp23_;
		_tmp24_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		switcher_sizegroup = _tmp24_;
		_tmp25_ = stack_switcher;
		_tmp26_ = gtk_widget_get_first_child ((GtkWidget*) _tmp25_);
		switcher_child = _tmp26_;
		while (TRUE) {
			GtkWidget* _tmp27_;
			GtkSizeGroup* _tmp28_;
			GtkWidget* _tmp29_;
			GtkWidget* _tmp30_;
			GtkWidget* _tmp31_;
			_tmp27_ = switcher_child;
			if (!(_tmp27_ != NULL)) {
				break;
			}
			_tmp28_ = switcher_sizegroup;
			_tmp29_ = switcher_child;
			gtk_size_group_add_widget (_tmp28_, _tmp29_);
			_tmp30_ = switcher_child;
			_tmp31_ = gtk_widget_get_next_sibling (_tmp30_);
			switcher_child = _tmp31_;
		}
		_tmp32_ = stack_switcher;
		_tmp33_ = _g_object_ref0 ((GtkWidget*) _tmp32_);
		_tmp34_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_title_widget (_tmp34_, _tmp33_);
		_g_object_unref0 (_tmp33_);
		g_object_ref_sink (_tmp34_);
		headerbar = _tmp34_;
		_tmp35_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp35_, GRANITE_STYLE_CLASS_FLAT);
		_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp36_);
		_g_object_unref0 (self->priv->box);
		self->priv->box = _tmp36_;
		_tmp37_ = self->priv->box;
		_tmp38_ = headerbar;
		gtk_box_append (_tmp37_, (GtkWidget*) _tmp38_);
		_tmp39_ = self->priv->box;
		_tmp40_ = self->priv->stack;
		gtk_box_append (_tmp39_, (GtkWidget*) _tmp40_);
		_tmp41_ = self->priv->stack;
		g_signal_connect_object ((GObject*) _tmp41_, "notify::visible-child", (GCallback) ____lambda48__g_object_notify, self, 0);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (switcher_sizegroup);
		_g_object_unref0 (stack_switcher);
		_g_settings_schema_unref0 (filters_settings_schema);
		_g_settings_schema_unref0 (interface_settings_schema);
	}
	_tmp42_ = self->priv->box;
	_tmp43_ = _g_object_ref0 ((GtkWidget*) _tmp42_);
	result = _tmp43_;
	return result;
}

static void
display_plug_real_shown (SwitchboardPlug* base)
{
	DisplayPlug * self;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	DisplayDisplaysView* _tmp3_;
	self = (DisplayPlug*) base;
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->displays_view;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		DisplayDisplaysView* _tmp4_;
		DisplayDisplaysOverlay* _tmp5_;
		_tmp4_ = self->priv->displays_view;
		_tmp5_ = _tmp4_->displays_overlay;
		display_displays_overlay_show_windows (_tmp5_);
	} else {
		DisplayDisplaysView* _tmp6_;
		DisplayDisplaysOverlay* _tmp7_;
		_tmp6_ = self->priv->displays_view;
		_tmp7_ = _tmp6_->displays_overlay;
		display_displays_overlay_hide_windows (_tmp7_);
	}
}

static void
display_plug_real_hidden (SwitchboardPlug* base)
{
	DisplayPlug * self;
	DisplayDisplaysView* _tmp0_;
	DisplayDisplaysOverlay* _tmp1_;
	self = (DisplayPlug*) base;
	_tmp0_ = self->priv->displays_view;
	_tmp1_ = _tmp0_->displays_overlay;
	display_displays_overlay_hide_windows (_tmp1_);
}

static void
display_plug_real_search_callback (SwitchboardPlug* base,
                                   const gchar* location)
{
	DisplayPlug * self;
	GtkStack* _tmp0_;
	self = (DisplayPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, location);
}

static void
display_plug_real_search_data_free (gpointer _data)
{
	DisplayPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DisplayPlugSearchData, _data_);
}

static void
display_plug_real_search (SwitchboardPlug* base,
                          const gchar* search,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	DisplayPlug * self;
	DisplayPlugSearchData* _data_;
	DisplayPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (DisplayPlug*) base;
	_data_ = g_slice_new0 (DisplayPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, display_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	display_plug_real_search_co (_data_);
}

static GeeTreeMap*
display_plug_search_finish (SwitchboardPlug* base,
                            GAsyncResult* _res_)
{
	GeeTreeMap* result;
	DisplayPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
display_plug_real_search_co (DisplayPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->search_results;
	_data_->_tmp4_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_strdup_printf ("%s → %s", _data_->_tmp5_, _ ("Screen Resolution"));
	_data_->_tmp7_ = _data_->_tmp6_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp3_, _data_->_tmp7_, "displays");
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->search_results;
	_data_->_tmp9_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strdup_printf ("%s → %s", _data_->_tmp10_, _ ("Primary display"));
	_data_->_tmp12_ = _data_->_tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp8_, _data_->_tmp12_, "displays");
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = _data_->search_results;
	_data_->_tmp14_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = g_strdup_printf ("%s → %s", _data_->_tmp15_, _ ("Screen mirroring"));
	_data_->_tmp17_ = _data_->_tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp13_, _data_->_tmp17_, "displays");
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = _data_->search_results;
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s", _data_->_tmp20_, _ ("Screen Rotation"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp18_, _data_->_tmp22_, "displays");
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = _data_->search_results;
	_data_->_tmp24_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = g_strdup_printf ("%s → %s", _data_->_tmp25_, _ ("Scaling factor"));
	_data_->_tmp27_ = _data_->_tmp26_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp23_, _data_->_tmp27_, "displays");
	_g_free0 (_data_->_tmp27_);
	_data_->_tmp28_ = _data_->search_results;
	_data_->_tmp29_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = g_strdup_printf ("%s → %s", _data_->_tmp30_, _ ("Night Light"));
	_data_->_tmp32_ = _data_->_tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp28_, _data_->_tmp32_, "night-light");
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp33_ = _data_->search_results;
	_data_->_tmp34_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp35_ = _data_->_tmp34_;
	_data_->_tmp36_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp35_, _ ("Night Light"), _ ("Schedule"));
	_data_->_tmp37_ = _data_->_tmp36_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp33_, _data_->_tmp37_, "night-light");
	_g_free0 (_data_->_tmp37_);
	_data_->_tmp38_ = _data_->search_results;
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp40_, _ ("Night Light"), _ ("Color temperature"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp38_, _data_->_tmp42_, "night-light");
	_g_free0 (_data_->_tmp42_);
	_data_->_tmp43_ = _data_->search_results;
	_data_->_tmp44_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp45_, _ ("Filters"), _ ("Color Blindness"));
	_data_->_tmp47_ = _data_->_tmp46_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp43_, _data_->_tmp47_, "filters");
	_g_free0 (_data_->_tmp47_);
	_data_->_tmp48_ = _data_->search_results;
	_data_->_tmp49_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp50_ = _data_->_tmp49_;
	_data_->_tmp51_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp50_, _ ("Filters"), _ ("Color Vision Deficiency"));
	_data_->_tmp52_ = _data_->_tmp51_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp48_, _data_->_tmp52_, "filters");
	_g_free0 (_data_->_tmp52_);
	_data_->_tmp53_ = _data_->search_results;
	_data_->_tmp54_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp55_ = _data_->_tmp54_;
	_data_->_tmp56_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp55_, _ ("Filters"), _ ("Grayscale"));
	_data_->_tmp57_ = _data_->_tmp56_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp53_, _data_->_tmp57_, "filters");
	_g_free0 (_data_->_tmp57_);
	_data_->_tmp58_ = _data_->search_results;
	_data_->_tmp59_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp60_ = _data_->_tmp59_;
	_data_->_tmp61_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp60_, _ ("Filters"), _ ("Monochrome"));
	_data_->_tmp62_ = _data_->_tmp61_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp58_, _data_->_tmp62_, "filters");
	_g_free0 (_data_->_tmp62_);
	_data_->_tmp63_ = display_sensor_manager_get_default ();
	_data_->_tmp64_ = display_sensor_manager_get_has_accelerometer (_data_->_tmp63_);
	_data_->_tmp65_ = _data_->_tmp64_;
	if (_data_->_tmp65_) {
		_data_->_tmp66_ = _data_->search_results;
		_data_->_tmp67_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
		_data_->_tmp68_ = _data_->_tmp67_;
		_data_->_tmp69_ = g_strdup_printf ("%s → %s", _data_->_tmp68_, _ ("Rotation lock"));
		_data_->_tmp70_ = _data_->_tmp69_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp66_, _data_->_tmp70_, "displays");
		_g_free0 (_data_->_tmp70_);
	}
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
display_plug_class_init (DisplayPlugClass * klass,
                         gpointer klass_data)
{
	display_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) display_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) display_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) display_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) display_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) display_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) display_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = display_plug_finalize;
}

static void
display_plug_instance_init (DisplayPlug * self,
                            gpointer klass)
{
	self->priv = display_plug_get_instance_private (self);
}

static void
display_plug_finalize (GObject * obj)
{
	DisplayPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_PLUG, DisplayPlug);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->displays_view);
	G_OBJECT_CLASS (display_plug_parent_class)->finalize (obj);
}

static GType
display_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayPlug), 0, (GInstanceInitFunc) display_plug_instance_init, NULL };
	GType display_plug_type_id;
	display_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "DisplayPlug", &g_define_type_info, 0);
	DisplayPlug_private_offset = g_type_add_instance_private (display_plug_type_id, sizeof (DisplayPlugPrivate));
	return display_plug_type_id;
}

GType
display_plug_get_type (void)
{
	static volatile gsize display_plug_type_id__once = 0;
	if (g_once_init_enter (&display_plug_type_id__once)) {
		GType display_plug_type_id;
		display_plug_type_id = display_plug_get_type_once ();
		g_once_init_leave (&display_plug_type_id__once, display_plug_type_id);
	}
	return display_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	DisplayPlug* plug = NULL;
	DisplayPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("DisplayPlug.vala:138: Activating Display plug");
	_tmp0_ = display_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

