#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#ifdef __APPLE__
/* the following define is necessary for OS X 10.6+; without it, the
   Apple-supplied ncurses.h sets NCURSES_OPAQUE to 1, and then Python
   can't get at the WINDOW flags field. */
#define NCURSES_OPAQUE 0
#endif

/* explicitly opt into this, rather than relying on _XOPEN_SOURCE */
#define NCURSES_WIDECHAR 1

/* ncurses 6 change behaviour  and makes all pointers opaque, 
  lets define backward compatibility. It doesn't harm 
  previous versions */

#define NCURSES_INTERNALS 1
#define NCURSES_REENTRANT 0
#include <ncurses.h>
#include <panel.h>
#include <term.h>

#if defined STRICT_SYSV_CURSES
#define _m_STRICT_SYSV_CURSES TRUE
#else
#define _m_STRICT_SYSV_CURSES FALSE
#endif

#if defined NCURSES_MOUSE_VERSION
#define _m_NCURSES_MOUSE_VERSION TRUE
#else
#define _m_NCURSES_MOUSE_VERSION FALSE
#endif

#if defined __NetBSD__
#define _m_NetBSD TRUE
#else
#define _m_NetBSD FALSE
#endif

int _m_ispad(WINDOW *win) {
    // <curses.h> may not have _flags (and possibly _ISPAD),
    // but for now let's assume that <ncurses.h> always has it
    return (win->_flags & _ISPAD);
}

void _m_getsyx(int *yx) {
    getsyx(yx[0], yx[1]);
}


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 61), // PANEL *()(PANEL const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 322), // PANEL const *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 61), // PANEL *()(WINDOW *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 324), // WINDOW *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // WINDOW *()(FILE *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 320), // FILE *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // WINDOW *()(PANEL const *)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // WINDOW *()(WINDOW *, int, int, int, int)
/* 13 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // WINDOW *()(int, int)
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // WINDOW *()(int, int, int, int)
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 25 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 26 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 27 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // WINDOW *()(void)
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 32), // char *()(char *)
/* 32 */ _CFFI_OP(_CFFI_OP_POINTER, 326), // char *
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 32), // char *()(char const *, ...)
/* 35 */ _CFFI_OP(_CFFI_OP_POINTER, 326), // char const *
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 32), // char *()(void)
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // char const *()(chtype)
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(chtype), (
           ((chtype)-1) | 0 /* check that chtype is an integer type */
         ) <= 0)), // chtype
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // char const *()(int)
/* 43 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 326), // char()(void)
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // chtype()(WINDOW *)
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // chtype()(WINDOW *, int, int)
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 40), // chtype()(void)
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(MEVENT *)
/* 58 */ _CFFI_OP(_CFFI_OP_POINTER, 321), // MEVENT *
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(PANEL *)
/* 61 */ _CFFI_OP(_CFFI_OP_POINTER, 322), // PANEL *
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(PANEL *, WINDOW *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(PANEL *, int, int)
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(PANEL *, void *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 61),
/* 74 */ _CFFI_OP(_CFFI_OP_POINTER, 328), // void *
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(PANEL const *)
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *)
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, FILE *)
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, char *, int)
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 89 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, char const *)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, char const *, int)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 98 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, chtype)
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, chtype, chtype)
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, chtype, chtype, chtype, chtype, chtype, chtype, chtype, chtype)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 117 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, chtype, int)
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 123 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int)
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 127 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, chtype, short, void const *)
/* 130 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 133 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5), // short
/* 134 */ _CFFI_OP(_CFFI_OP_POINTER, 328), // void const *
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int)
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 138 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 139 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, char *, int)
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 143 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 144 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, char const *)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 150 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 151 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, char const *, int)
/* 155 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 156 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 157 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 159 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, chtype)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 163 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, int)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 169 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 170 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 171 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, int, chtype, short, void const *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 175 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 176 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, int, int, int, int)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 184 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 185 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 186 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 187 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 189 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, int, int, wint_t *)
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 193 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 194 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 195 */ _CFFI_OP(_CFFI_OP_POINTER, 329), // wint_t *
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, unsigned char)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 199 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW *, wint_t *)
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 195),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW const *)
/* 206 */ _CFFI_OP(_CFFI_OP_POINTER, 324), // WINDOW const *
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW const *, WINDOW *)
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 206),
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(WINDOW const *, WINDOW *, int, int, int, int, int, int, int)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 206),
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 215 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 216 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 217 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 219 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 220 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 221 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(char *)
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(char *, int, int *)
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 32),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 229 */ _CFFI_OP(_CFFI_OP_POINTER, 14), // int *
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(char const *)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(int)
/* 235 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(int, int)
/* 238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 239 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(short, short *, short *)
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 243 */ _CFFI_OP(_CFFI_OP_POINTER, 133), // short *
/* 244 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(short, short *, short *, short *)
/* 247 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 248 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 243),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(short, short, short)
/* 253 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 254 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(short, short, short, short)
/* 258 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 259 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 261 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 5),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(void)
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // int()(wchar_t)
/* 266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 16), // wchar_t
/* 267 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION, 269), // mmask_t()(mmask_t, mmask_t *)
/* 269 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(mmask_t), (
           ((mmask_t)-1) | 0 /* check that mmask_t is an integer type */
         ) <= 0)), // mmask_t
/* 270 */ _CFFI_OP(_CFFI_OP_POINTER, 269), // mmask_t *
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION, 199), // unsigned char()(WINDOW *)
/* 273 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 274 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 275 */ _CFFI_OP(_CFFI_OP_FUNCTION, 199), // unsigned char()(WINDOW *, int)
/* 276 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 277 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 279 */ _CFFI_OP(_CFFI_OP_FUNCTION, 199), // unsigned char()(WINDOW const *, int, int)
/* 280 */ _CFFI_OP(_CFFI_OP_NOOP, 206),
/* 281 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 282 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 283 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION, 199), // unsigned char()(int, int)
/* 285 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 286 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 199), // unsigned char()(void)
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 290 */ _CFFI_OP(_CFFI_OP_FUNCTION, 134), // void const *()(PANEL const *)
/* 291 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(WINDOW *)
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(WINDOW *, chtype)
/* 297 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 298 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(WINDOW *, int)
/* 301 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 303 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(WINDOW *, unsigned char)
/* 305 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 306 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(int *)
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 229),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(int, int)
/* 312 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 313 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(unsigned char)
/* 316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 318 */ _CFFI_OP(_CFFI_OP_FUNCTION, 328), // void()(void)
/* 319 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 320 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // FILE
/* 321 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // MEVENT
/* 322 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // PANEL
/* 323 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // SCREEN
/* 324 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // WINDOW
/* 325 */ _CFFI_OP(_CFFI_OP_POINTER, 34), // char *(*)(char const *, ...)
/* 326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 327 */ _CFFI_OP(_CFFI_OP_OPEN_ARRAY, 40), // chtype[]
/* 328 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
/* 329 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(wint_t), (
           ((wint_t)-1) | 0 /* check that wint_t is an integer type */
         ) <= 0)), // wint_t
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_MEVENT(MEVENT *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->id) | 0);  /* check that 'MEVENT.id' is an integer */
  (void)((p->x) | 0);  /* check that 'MEVENT.x' is an integer */
  (void)((p->y) | 0);  /* check that 'MEVENT.y' is an integer */
  (void)((p->z) | 0);  /* check that 'MEVENT.z' is an integer */
  (void)((p->bstate) | 0);  /* check that 'MEVENT.bstate' is an integer */
}
struct _cffi_align_typedef_MEVENT { char x; MEVENT y; };

static int _cffi_const_ALL_MOUSE_EVENTS(unsigned long long *o)
{
  int n = (ALL_MOUSE_EVENTS) <= 0;
  *o = (unsigned long long)((ALL_MOUSE_EVENTS) | 0);  /* check that ALL_MOUSE_EVENTS is an integer */
  return n;
}

static int _cffi_const_A_ALTCHARSET(unsigned long long *o)
{
  int n = (A_ALTCHARSET) <= 0;
  *o = (unsigned long long)((A_ALTCHARSET) | 0);  /* check that A_ALTCHARSET is an integer */
  return n;
}

static int _cffi_const_A_ATTRIBUTES(unsigned long long *o)
{
  int n = (A_ATTRIBUTES) <= 0;
  *o = (unsigned long long)((A_ATTRIBUTES) | 0);  /* check that A_ATTRIBUTES is an integer */
  return n;
}

static int _cffi_const_A_BLINK(unsigned long long *o)
{
  int n = (A_BLINK) <= 0;
  *o = (unsigned long long)((A_BLINK) | 0);  /* check that A_BLINK is an integer */
  return n;
}

static int _cffi_const_A_BOLD(unsigned long long *o)
{
  int n = (A_BOLD) <= 0;
  *o = (unsigned long long)((A_BOLD) | 0);  /* check that A_BOLD is an integer */
  return n;
}

static int _cffi_const_A_CHARTEXT(unsigned long long *o)
{
  int n = (A_CHARTEXT) <= 0;
  *o = (unsigned long long)((A_CHARTEXT) | 0);  /* check that A_CHARTEXT is an integer */
  return n;
}

static int _cffi_const_A_COLOR(unsigned long long *o)
{
  int n = (A_COLOR) <= 0;
  *o = (unsigned long long)((A_COLOR) | 0);  /* check that A_COLOR is an integer */
  return n;
}

static int _cffi_const_A_DIM(unsigned long long *o)
{
  int n = (A_DIM) <= 0;
  *o = (unsigned long long)((A_DIM) | 0);  /* check that A_DIM is an integer */
  return n;
}

static int _cffi_const_A_HORIZONTAL(unsigned long long *o)
{
  int n = (A_HORIZONTAL) <= 0;
  *o = (unsigned long long)((A_HORIZONTAL) | 0);  /* check that A_HORIZONTAL is an integer */
  return n;
}

static int _cffi_const_A_INVIS(unsigned long long *o)
{
  int n = (A_INVIS) <= 0;
  *o = (unsigned long long)((A_INVIS) | 0);  /* check that A_INVIS is an integer */
  return n;
}

static int _cffi_const_A_LEFT(unsigned long long *o)
{
  int n = (A_LEFT) <= 0;
  *o = (unsigned long long)((A_LEFT) | 0);  /* check that A_LEFT is an integer */
  return n;
}

static int _cffi_const_A_LOW(unsigned long long *o)
{
  int n = (A_LOW) <= 0;
  *o = (unsigned long long)((A_LOW) | 0);  /* check that A_LOW is an integer */
  return n;
}

static int _cffi_const_A_NORMAL(unsigned long long *o)
{
  int n = (A_NORMAL) <= 0;
  *o = (unsigned long long)((A_NORMAL) | 0);  /* check that A_NORMAL is an integer */
  return n;
}

static int _cffi_const_A_PROTECT(unsigned long long *o)
{
  int n = (A_PROTECT) <= 0;
  *o = (unsigned long long)((A_PROTECT) | 0);  /* check that A_PROTECT is an integer */
  return n;
}

static int _cffi_const_A_REVERSE(unsigned long long *o)
{
  int n = (A_REVERSE) <= 0;
  *o = (unsigned long long)((A_REVERSE) | 0);  /* check that A_REVERSE is an integer */
  return n;
}

static int _cffi_const_A_RIGHT(unsigned long long *o)
{
  int n = (A_RIGHT) <= 0;
  *o = (unsigned long long)((A_RIGHT) | 0);  /* check that A_RIGHT is an integer */
  return n;
}

static int _cffi_const_A_STANDOUT(unsigned long long *o)
{
  int n = (A_STANDOUT) <= 0;
  *o = (unsigned long long)((A_STANDOUT) | 0);  /* check that A_STANDOUT is an integer */
  return n;
}

static int _cffi_const_A_TOP(unsigned long long *o)
{
  int n = (A_TOP) <= 0;
  *o = (unsigned long long)((A_TOP) | 0);  /* check that A_TOP is an integer */
  return n;
}

static int _cffi_const_A_UNDERLINE(unsigned long long *o)
{
  int n = (A_UNDERLINE) <= 0;
  *o = (unsigned long long)((A_UNDERLINE) | 0);  /* check that A_UNDERLINE is an integer */
  return n;
}

static int _cffi_const_A_VERTICAL(unsigned long long *o)
{
  int n = (A_VERTICAL) <= 0;
  *o = (unsigned long long)((A_VERTICAL) | 0);  /* check that A_VERTICAL is an integer */
  return n;
}

static int _cffi_const_BUTTON1_CLICKED(unsigned long long *o)
{
  int n = (BUTTON1_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON1_CLICKED) | 0);  /* check that BUTTON1_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON1_DOUBLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON1_DOUBLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON1_DOUBLE_CLICKED) | 0);  /* check that BUTTON1_DOUBLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON1_PRESSED(unsigned long long *o)
{
  int n = (BUTTON1_PRESSED) <= 0;
  *o = (unsigned long long)((BUTTON1_PRESSED) | 0);  /* check that BUTTON1_PRESSED is an integer */
  return n;
}

static int _cffi_const_BUTTON1_RELEASED(unsigned long long *o)
{
  int n = (BUTTON1_RELEASED) <= 0;
  *o = (unsigned long long)((BUTTON1_RELEASED) | 0);  /* check that BUTTON1_RELEASED is an integer */
  return n;
}

static int _cffi_const_BUTTON1_TRIPLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON1_TRIPLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON1_TRIPLE_CLICKED) | 0);  /* check that BUTTON1_TRIPLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON2_CLICKED(unsigned long long *o)
{
  int n = (BUTTON2_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON2_CLICKED) | 0);  /* check that BUTTON2_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON2_DOUBLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON2_DOUBLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON2_DOUBLE_CLICKED) | 0);  /* check that BUTTON2_DOUBLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON2_PRESSED(unsigned long long *o)
{
  int n = (BUTTON2_PRESSED) <= 0;
  *o = (unsigned long long)((BUTTON2_PRESSED) | 0);  /* check that BUTTON2_PRESSED is an integer */
  return n;
}

static int _cffi_const_BUTTON2_RELEASED(unsigned long long *o)
{
  int n = (BUTTON2_RELEASED) <= 0;
  *o = (unsigned long long)((BUTTON2_RELEASED) | 0);  /* check that BUTTON2_RELEASED is an integer */
  return n;
}

static int _cffi_const_BUTTON2_TRIPLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON2_TRIPLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON2_TRIPLE_CLICKED) | 0);  /* check that BUTTON2_TRIPLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON3_CLICKED(unsigned long long *o)
{
  int n = (BUTTON3_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON3_CLICKED) | 0);  /* check that BUTTON3_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON3_DOUBLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON3_DOUBLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON3_DOUBLE_CLICKED) | 0);  /* check that BUTTON3_DOUBLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON3_PRESSED(unsigned long long *o)
{
  int n = (BUTTON3_PRESSED) <= 0;
  *o = (unsigned long long)((BUTTON3_PRESSED) | 0);  /* check that BUTTON3_PRESSED is an integer */
  return n;
}

static int _cffi_const_BUTTON3_RELEASED(unsigned long long *o)
{
  int n = (BUTTON3_RELEASED) <= 0;
  *o = (unsigned long long)((BUTTON3_RELEASED) | 0);  /* check that BUTTON3_RELEASED is an integer */
  return n;
}

static int _cffi_const_BUTTON3_TRIPLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON3_TRIPLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON3_TRIPLE_CLICKED) | 0);  /* check that BUTTON3_TRIPLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON4_CLICKED(unsigned long long *o)
{
  int n = (BUTTON4_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON4_CLICKED) | 0);  /* check that BUTTON4_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON4_DOUBLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON4_DOUBLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON4_DOUBLE_CLICKED) | 0);  /* check that BUTTON4_DOUBLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON4_PRESSED(unsigned long long *o)
{
  int n = (BUTTON4_PRESSED) <= 0;
  *o = (unsigned long long)((BUTTON4_PRESSED) | 0);  /* check that BUTTON4_PRESSED is an integer */
  return n;
}

static int _cffi_const_BUTTON4_RELEASED(unsigned long long *o)
{
  int n = (BUTTON4_RELEASED) <= 0;
  *o = (unsigned long long)((BUTTON4_RELEASED) | 0);  /* check that BUTTON4_RELEASED is an integer */
  return n;
}

static int _cffi_const_BUTTON4_TRIPLE_CLICKED(unsigned long long *o)
{
  int n = (BUTTON4_TRIPLE_CLICKED) <= 0;
  *o = (unsigned long long)((BUTTON4_TRIPLE_CLICKED) | 0);  /* check that BUTTON4_TRIPLE_CLICKED is an integer */
  return n;
}

static int _cffi_const_BUTTON_ALT(unsigned long long *o)
{
  int n = (BUTTON_ALT) <= 0;
  *o = (unsigned long long)((BUTTON_ALT) | 0);  /* check that BUTTON_ALT is an integer */
  return n;
}

static int _cffi_const_BUTTON_CTRL(unsigned long long *o)
{
  int n = (BUTTON_CTRL) <= 0;
  *o = (unsigned long long)((BUTTON_CTRL) | 0);  /* check that BUTTON_CTRL is an integer */
  return n;
}

static int _cffi_const_BUTTON_SHIFT(unsigned long long *o)
{
  int n = (BUTTON_SHIFT) <= 0;
  *o = (unsigned long long)((BUTTON_SHIFT) | 0);  /* check that BUTTON_SHIFT is an integer */
  return n;
}

static int _cffi_const_COLOR_BLACK(unsigned long long *o)
{
  int n = (COLOR_BLACK) <= 0;
  *o = (unsigned long long)((COLOR_BLACK) | 0);  /* check that COLOR_BLACK is an integer */
  return n;
}

static int _cffi_const_COLOR_BLUE(unsigned long long *o)
{
  int n = (COLOR_BLUE) <= 0;
  *o = (unsigned long long)((COLOR_BLUE) | 0);  /* check that COLOR_BLUE is an integer */
  return n;
}

static int _cffi_const_COLOR_CYAN(unsigned long long *o)
{
  int n = (COLOR_CYAN) <= 0;
  *o = (unsigned long long)((COLOR_CYAN) | 0);  /* check that COLOR_CYAN is an integer */
  return n;
}

static int _cffi_const_COLOR_GREEN(unsigned long long *o)
{
  int n = (COLOR_GREEN) <= 0;
  *o = (unsigned long long)((COLOR_GREEN) | 0);  /* check that COLOR_GREEN is an integer */
  return n;
}

static int _cffi_const_COLOR_MAGENTA(unsigned long long *o)
{
  int n = (COLOR_MAGENTA) <= 0;
  *o = (unsigned long long)((COLOR_MAGENTA) | 0);  /* check that COLOR_MAGENTA is an integer */
  return n;
}

static int _cffi_const_COLOR_RED(unsigned long long *o)
{
  int n = (COLOR_RED) <= 0;
  *o = (unsigned long long)((COLOR_RED) | 0);  /* check that COLOR_RED is an integer */
  return n;
}

static int _cffi_const_COLOR_WHITE(unsigned long long *o)
{
  int n = (COLOR_WHITE) <= 0;
  *o = (unsigned long long)((COLOR_WHITE) | 0);  /* check that COLOR_WHITE is an integer */
  return n;
}

static int _cffi_const_COLOR_YELLOW(unsigned long long *o)
{
  int n = (COLOR_YELLOW) <= 0;
  *o = (unsigned long long)((COLOR_YELLOW) | 0);  /* check that COLOR_YELLOW is an integer */
  return n;
}

static int _cffi_const_ERR(unsigned long long *o)
{
  int n = (ERR) <= 0;
  *o = (unsigned long long)((ERR) | 0);  /* check that ERR is an integer */
  return n;
}

static int _cffi_const_FALSE(unsigned long long *o)
{
  int n = (FALSE) <= 0;
  *o = (unsigned long long)((FALSE) | 0);  /* check that FALSE is an integer */
  return n;
}

static int _cffi_const_KEY_CODE_YES(unsigned long long *o)
{
  int n = (KEY_CODE_YES) <= 0;
  *o = (unsigned long long)((KEY_CODE_YES) | 0);  /* check that KEY_CODE_YES is an integer */
  return n;
}

static int _cffi_const_KEY_MAX(unsigned long long *o)
{
  int n = (KEY_MAX) <= 0;
  *o = (unsigned long long)((KEY_MAX) | 0);  /* check that KEY_MAX is an integer */
  return n;
}

static int _cffi_const_KEY_MIN(unsigned long long *o)
{
  int n = (KEY_MIN) <= 0;
  *o = (unsigned long long)((KEY_MIN) | 0);  /* check that KEY_MIN is an integer */
  return n;
}

static int _cffi_const_OK(unsigned long long *o)
{
  int n = (OK) <= 0;
  *o = (unsigned long long)((OK) | 0);  /* check that OK is an integer */
  return n;
}

static int _cffi_const_REPORT_MOUSE_POSITION(unsigned long long *o)
{
  int n = (REPORT_MOUSE_POSITION) <= 0;
  *o = (unsigned long long)((REPORT_MOUSE_POSITION) | 0);  /* check that REPORT_MOUSE_POSITION is an integer */
  return n;
}

static int _cffi_const_TRUE(unsigned long long *o)
{
  int n = (TRUE) <= 0;
  *o = (unsigned long long)((TRUE) | 0);  /* check that TRUE is an integer */
  return n;
}

static void _cffi_d__m_getsyx(int * x0)
{
  _m_getsyx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__m_getsyx(PyObject *self, PyObject *arg0)
{
  int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(229), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(229), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _m_getsyx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__m_getsyx _cffi_d__m_getsyx
#endif

static int _cffi_d__m_ispad(WINDOW * x0)
{
  return _m_ispad(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__m_ispad(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _m_ispad(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__m_ispad _cffi_d__m_ispad
#endif

static int _cffi_d_baudrate(void)
{
  return baudrate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_baudrate(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = baudrate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_baudrate _cffi_d_baudrate
#endif

static int _cffi_d_beep(void)
{
  return beep();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_beep(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = beep(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_beep _cffi_d_beep
#endif

static int _cffi_d_bottom_panel(PANEL * x0)
{
  return bottom_panel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_bottom_panel(PyObject *self, PyObject *arg0)
{
  PANEL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = bottom_panel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_bottom_panel _cffi_d_bottom_panel
#endif

static int _cffi_d_box(WINDOW * x0, chtype x1, chtype x2)
{
  return box(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_box(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  chtype x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "box", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, chtype);
  if (x2 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = box(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_box _cffi_d_box
#endif

static unsigned char _cffi_d_can_change_color(void)
{
  return can_change_color();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_can_change_color(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = can_change_color(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_can_change_color _cffi_d_can_change_color
#endif

static int _cffi_d_cbreak(void)
{
  return cbreak();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cbreak(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cbreak(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_cbreak _cffi_d_cbreak
#endif

static int _cffi_d_clearok(WINDOW * x0, unsigned char x1)
{
  return clearok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clearok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clearok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clearok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clearok _cffi_d_clearok
#endif

static int _cffi_d_color_content(short x0, short * x1, short * x2, short * x3)
{
  return color_content(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_color_content(PyObject *self, PyObject *args)
{
  short x0;
  short * x1;
  short * x2;
  short * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "color_content", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, short);
  if (x0 == (short)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (short *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (short *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (short *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = color_content(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_color_content _cffi_d_color_content
#endif

static int _cffi_d_copywin(WINDOW const * x0, WINDOW * x1, int x2, int x3, int x4, int x5, int x6, int x7, int x8)
{
  return copywin(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_copywin(PyObject *self, PyObject *args)
{
  WINDOW const * x0;
  WINDOW * x1;
  int x2;
  int x3;
  int x4;
  int x5;
  int x6;
  int x7;
  int x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "copywin", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, int);
  if (x8 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = copywin(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_copywin _cffi_d_copywin
#endif

static int _cffi_d_curs_set(int x0)
{
  return curs_set(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_curs_set(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = curs_set(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_curs_set _cffi_d_curs_set
#endif

static int _cffi_d_def_prog_mode(void)
{
  return def_prog_mode();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_def_prog_mode(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = def_prog_mode(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_def_prog_mode _cffi_d_def_prog_mode
#endif

static int _cffi_d_def_shell_mode(void)
{
  return def_shell_mode();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_def_shell_mode(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = def_shell_mode(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_def_shell_mode _cffi_d_def_shell_mode
#endif

static int _cffi_d_del_panel(PANEL * x0)
{
  return del_panel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_del_panel(PyObject *self, PyObject *arg0)
{
  PANEL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = del_panel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_del_panel _cffi_d_del_panel
#endif

static int _cffi_d_delay_output(int x0)
{
  return delay_output(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_delay_output(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = delay_output(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_delay_output _cffi_d_delay_output
#endif

static int _cffi_d_delwin(WINDOW * x0)
{
  return delwin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_delwin(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = delwin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_delwin _cffi_d_delwin
#endif

static WINDOW * _cffi_d_derwin(WINDOW * x0, int x1, int x2, int x3, int x4)
{
  return derwin(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_derwin(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  WINDOW * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "derwin", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = derwin(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_derwin _cffi_d_derwin
#endif

static int _cffi_d_doupdate(void)
{
  return doupdate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_doupdate(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = doupdate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_doupdate _cffi_d_doupdate
#endif

static int _cffi_d_echo(void)
{
  return echo();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_echo(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = echo(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_echo _cffi_d_echo
#endif

static int _cffi_d_endwin(void)
{
  return endwin();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_endwin(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = endwin(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_endwin _cffi_d_endwin
#endif

static char _cffi_d_erasechar(void)
{
  return erasechar();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_erasechar(PyObject *self, PyObject *noarg)
{
  char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = erasechar(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_char(result);
  return pyresult;
}
#else
#  define _cffi_f_erasechar _cffi_d_erasechar
#endif

static void _cffi_d_filter(void)
{
  filter();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_filter(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { filter(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_filter _cffi_d_filter
#endif

static int _cffi_d_flash(void)
{
  return flash();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_flash(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = flash(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_flash _cffi_d_flash
#endif

static int _cffi_d_flushinp(void)
{
  return flushinp();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_flushinp(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = flushinp(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_flushinp _cffi_d_flushinp
#endif

static int _cffi_d_getattrs(WINDOW const * x0)
{
  return getattrs(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getattrs(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getattrs(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getattrs _cffi_d_getattrs
#endif

static int _cffi_d_getbegx(WINDOW const * x0)
{
  return getbegx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getbegx(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getbegx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getbegx _cffi_d_getbegx
#endif

static int _cffi_d_getbegy(WINDOW const * x0)
{
  return getbegy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getbegy(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getbegy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getbegy _cffi_d_getbegy
#endif

static chtype _cffi_d_getbkgd(WINDOW * x0)
{
  return getbkgd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getbkgd(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  chtype result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getbkgd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, chtype);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getbkgd _cffi_d_getbkgd
#endif

static int _cffi_d_getcurx(WINDOW const * x0)
{
  return getcurx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getcurx(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getcurx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getcurx _cffi_d_getcurx
#endif

static int _cffi_d_getcury(WINDOW const * x0)
{
  return getcury(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getcury(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getcury(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getcury _cffi_d_getcury
#endif

static int _cffi_d_getmaxx(WINDOW const * x0)
{
  return getmaxx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getmaxx(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getmaxx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getmaxx _cffi_d_getmaxx
#endif

static int _cffi_d_getmaxy(WINDOW const * x0)
{
  return getmaxy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getmaxy(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getmaxy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getmaxy _cffi_d_getmaxy
#endif

static int _cffi_d_getmouse(MEVENT * x0)
{
  return getmouse(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getmouse(PyObject *self, PyObject *arg0)
{
  MEVENT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (MEVENT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getmouse(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getmouse _cffi_d_getmouse
#endif

static int _cffi_d_getparx(WINDOW const * x0)
{
  return getparx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getparx(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getparx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getparx _cffi_d_getparx
#endif

static int _cffi_d_getpary(WINDOW const * x0)
{
  return getpary(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getpary(PyObject *self, PyObject *arg0)
{
  WINDOW const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getpary(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getpary _cffi_d_getpary
#endif

static WINDOW * _cffi_d_getwin(FILE * x0)
{
  return getwin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getwin(PyObject *self, PyObject *arg0)
{
  FILE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  WINDOW * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getwin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getwin _cffi_d_getwin
#endif

static int _cffi_d_halfdelay(int x0)
{
  return halfdelay(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_halfdelay(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = halfdelay(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_halfdelay _cffi_d_halfdelay
#endif

static unsigned char _cffi_d_has_colors(void)
{
  return has_colors();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_has_colors(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = has_colors(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_has_colors _cffi_d_has_colors
#endif

static unsigned char _cffi_d_has_ic(void)
{
  return has_ic();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_has_ic(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = has_ic(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_has_ic _cffi_d_has_ic
#endif

static unsigned char _cffi_d_has_il(void)
{
  return has_il();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_has_il(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = has_il(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_has_il _cffi_d_has_il
#endif

static int _cffi_d_has_key(int x0)
{
  return has_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_has_key(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = has_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_has_key _cffi_d_has_key
#endif

static int _cffi_d_hide_panel(PANEL * x0)
{
  return hide_panel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hide_panel(PyObject *self, PyObject *arg0)
{
  PANEL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = hide_panel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_hide_panel _cffi_d_hide_panel
#endif

static void _cffi_d_idcok(WINDOW * x0, unsigned char x1)
{
  idcok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_idcok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "idcok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { idcok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_idcok _cffi_d_idcok
#endif

static int _cffi_d_idlok(WINDOW * x0, unsigned char x1)
{
  return idlok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_idlok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "idlok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = idlok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_idlok _cffi_d_idlok
#endif

static void _cffi_d_immedok(WINDOW * x0, unsigned char x1)
{
  immedok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_immedok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "immedok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { immedok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_immedok _cffi_d_immedok
#endif

static int _cffi_d_init_color(short x0, short x1, short x2, short x3)
{
  return init_color(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_init_color(PyObject *self, PyObject *args)
{
  short x0;
  short x1;
  short x2;
  short x3;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "init_color", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, short);
  if (x0 == (short)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, short);
  if (x1 == (short)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, short);
  if (x2 == (short)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, short);
  if (x3 == (short)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = init_color(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_init_color _cffi_d_init_color
#endif

static int _cffi_d_init_pair(short x0, short x1, short x2)
{
  return init_pair(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_init_pair(PyObject *self, PyObject *args)
{
  short x0;
  short x1;
  short x2;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "init_pair", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, short);
  if (x0 == (short)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, short);
  if (x1 == (short)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, short);
  if (x2 == (short)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = init_pair(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_init_pair _cffi_d_init_pair
#endif

static WINDOW * _cffi_d_initscr(void)
{
  return initscr();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initscr(PyObject *self, PyObject *noarg)
{
  WINDOW * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = initscr(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  return pyresult;
}
#else
#  define _cffi_f_initscr _cffi_d_initscr
#endif

static int _cffi_d_intrflush(WINDOW * x0, unsigned char x1)
{
  return intrflush(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_intrflush(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "intrflush", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = intrflush(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_intrflush _cffi_d_intrflush
#endif

static unsigned char _cffi_d_is_linetouched(WINDOW * x0, int x1)
{
  return is_linetouched(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_is_linetouched(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "is_linetouched", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = is_linetouched(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_is_linetouched _cffi_d_is_linetouched
#endif

static unsigned char _cffi_d_is_term_resized(int x0, int x1)
{
  return is_term_resized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_is_term_resized(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  unsigned char result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "is_term_resized", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = is_term_resized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_is_term_resized _cffi_d_is_term_resized
#endif

static unsigned char _cffi_d_is_wintouched(WINDOW * x0)
{
  return is_wintouched(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_is_wintouched(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = is_wintouched(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_is_wintouched _cffi_d_is_wintouched
#endif

static unsigned char _cffi_d_isendwin(void)
{
  return isendwin();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_isendwin(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = isendwin(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_isendwin _cffi_d_isendwin
#endif

static char const * _cffi_d_keyname(int x0)
{
  return keyname(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_keyname(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = keyname(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(35));
  return pyresult;
}
#else
#  define _cffi_f_keyname _cffi_d_keyname
#endif

static int _cffi_d_keypad(WINDOW * x0, unsigned char x1)
{
  return keypad(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_keypad(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "keypad", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = keypad(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_keypad _cffi_d_keypad
#endif

static char _cffi_d_killchar(void)
{
  return killchar();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_killchar(PyObject *self, PyObject *noarg)
{
  char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = killchar(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_char(result);
  return pyresult;
}
#else
#  define _cffi_f_killchar _cffi_d_killchar
#endif

static int _cffi_d_leaveok(WINDOW * x0, unsigned char x1)
{
  return leaveok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_leaveok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "leaveok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = leaveok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_leaveok _cffi_d_leaveok
#endif

static char * _cffi_d_longname(void)
{
  return longname();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_longname(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = longname(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(32));
  return pyresult;
}
#else
#  define _cffi_f_longname _cffi_d_longname
#endif

static int _cffi_d_meta(WINDOW * x0, unsigned char x1)
{
  return meta(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_meta(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "meta", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = meta(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_meta _cffi_d_meta
#endif

static int _cffi_d_mouseinterval(int x0)
{
  return mouseinterval(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mouseinterval(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mouseinterval(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_mouseinterval _cffi_d_mouseinterval
#endif

static mmask_t _cffi_d_mousemask(mmask_t x0, mmask_t * x1)
{
  return mousemask(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mousemask(PyObject *self, PyObject *args)
{
  mmask_t x0;
  mmask_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  mmask_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "mousemask", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, mmask_t);
  if (x0 == (mmask_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (mmask_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mousemask(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, mmask_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mousemask _cffi_d_mousemask
#endif

static int _cffi_d_move_panel(PANEL * x0, int x1, int x2)
{
  return move_panel(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_move_panel(PyObject *self, PyObject *args)
{
  PANEL * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "move_panel", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = move_panel(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_move_panel _cffi_d_move_panel
#endif

static int _cffi_d_mvderwin(WINDOW * x0, int x1, int x2)
{
  return mvderwin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvderwin(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mvderwin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvderwin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvderwin _cffi_d_mvderwin
#endif

static int _cffi_d_mvwaddch(WINDOW * x0, int x1, int x2, chtype x3)
{
  return mvwaddch(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwaddch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  chtype x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mvwaddch", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, chtype);
  if (x3 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwaddch(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwaddch _cffi_d_mvwaddch
#endif

static int _cffi_d_mvwaddnstr(WINDOW * x0, int x1, int x2, char const * x3, int x4)
{
  return mvwaddnstr(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwaddnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  char const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mvwaddnstr", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwaddnstr(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwaddnstr _cffi_d_mvwaddnstr
#endif

static int _cffi_d_mvwaddstr(WINDOW * x0, int x1, int x2, char const * x3)
{
  return mvwaddstr(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwaddstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mvwaddstr", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwaddstr(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwaddstr _cffi_d_mvwaddstr
#endif

static int _cffi_d_mvwchgat(WINDOW * x0, int x1, int x2, int x3, chtype x4, short x5, void const * x6)
{
  return mvwchgat(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwchgat(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  chtype x4;
  short x5;
  void const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "mvwchgat", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, chtype);
  if (x4 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, short);
  if (x5 == (short)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwchgat(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwchgat _cffi_d_mvwchgat
#endif

static int _cffi_d_mvwdelch(WINDOW * x0, int x1, int x2)
{
  return mvwdelch(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwdelch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mvwdelch", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwdelch(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwdelch _cffi_d_mvwdelch
#endif

static int _cffi_d_mvwget_wch(WINDOW * x0, int x1, int x2, wint_t * x3)
{
  return mvwget_wch(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwget_wch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  wint_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mvwget_wch", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(195), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (wint_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(195), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwget_wch(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwget_wch _cffi_d_mvwget_wch
#endif

static int _cffi_d_mvwgetch(WINDOW * x0, int x1, int x2)
{
  return mvwgetch(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwgetch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mvwgetch", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwgetch(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwgetch _cffi_d_mvwgetch
#endif

static int _cffi_d_mvwgetnstr(WINDOW * x0, int x1, int x2, char * x3, int x4)
{
  return mvwgetnstr(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwgetnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  char * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mvwgetnstr", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwgetnstr(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwgetnstr _cffi_d_mvwgetnstr
#endif

static int _cffi_d_mvwin(WINDOW * x0, int x1, int x2)
{
  return mvwin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwin(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mvwin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwin _cffi_d_mvwin
#endif

static chtype _cffi_d_mvwinch(WINDOW * x0, int x1, int x2)
{
  return mvwinch(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwinch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  chtype result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mvwinch", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwinch(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, chtype);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwinch _cffi_d_mvwinch
#endif

static int _cffi_d_mvwinnstr(WINDOW * x0, int x1, int x2, char * x3, int x4)
{
  return mvwinnstr(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwinnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  char * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mvwinnstr", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwinnstr(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwinnstr _cffi_d_mvwinnstr
#endif

static int _cffi_d_mvwinsch(WINDOW * x0, int x1, int x2, chtype x3)
{
  return mvwinsch(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwinsch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  chtype x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mvwinsch", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, chtype);
  if (x3 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwinsch(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwinsch _cffi_d_mvwinsch
#endif

static int _cffi_d_mvwinsnstr(WINDOW * x0, int x1, int x2, char const * x3, int x4)
{
  return mvwinsnstr(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwinsnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  char const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mvwinsnstr", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwinsnstr(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwinsnstr _cffi_d_mvwinsnstr
#endif

static int _cffi_d_mvwinsstr(WINDOW * x0, int x1, int x2, char const * x3)
{
  return mvwinsstr(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mvwinsstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mvwinsstr", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mvwinsstr(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mvwinsstr _cffi_d_mvwinsstr
#endif

static int _cffi_d_napms(int x0)
{
  return napms(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_napms(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = napms(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_napms _cffi_d_napms
#endif

static PANEL * _cffi_d_new_panel(WINDOW * x0)
{
  return new_panel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_new_panel(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PANEL * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = new_panel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(61));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_new_panel _cffi_d_new_panel
#endif

static WINDOW * _cffi_d_newpad(int x0, int x1)
{
  return newpad(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_newpad(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  WINDOW * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "newpad", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = newpad(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  return pyresult;
}
#else
#  define _cffi_f_newpad _cffi_d_newpad
#endif

static WINDOW * _cffi_d_newwin(int x0, int x1, int x2, int x3)
{
  return newwin(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_newwin(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int x2;
  int x3;
  WINDOW * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "newwin", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = newwin(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  return pyresult;
}
#else
#  define _cffi_f_newwin _cffi_d_newwin
#endif

static int _cffi_d_nl(void)
{
  return nl();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nl(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nl(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_nl _cffi_d_nl
#endif

static int _cffi_d_nocbreak(void)
{
  return nocbreak();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nocbreak(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nocbreak(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_nocbreak _cffi_d_nocbreak
#endif

static int _cffi_d_nodelay(WINDOW * x0, unsigned char x1)
{
  return nodelay(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nodelay(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "nodelay", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nodelay(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_nodelay _cffi_d_nodelay
#endif

static int _cffi_d_noecho(void)
{
  return noecho();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_noecho(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = noecho(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_noecho _cffi_d_noecho
#endif

static int _cffi_d_nonl(void)
{
  return nonl();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_nonl(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = nonl(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_nonl _cffi_d_nonl
#endif

static void _cffi_d_noqiflush(void)
{
  noqiflush();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_noqiflush(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { noqiflush(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_noqiflush _cffi_d_noqiflush
#endif

static int _cffi_d_noraw(void)
{
  return noraw();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_noraw(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = noraw(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_noraw _cffi_d_noraw
#endif

static int _cffi_d_notimeout(WINDOW * x0, unsigned char x1)
{
  return notimeout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notimeout(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notimeout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notimeout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notimeout _cffi_d_notimeout
#endif

static int _cffi_d_overlay(WINDOW const * x0, WINDOW * x1)
{
  return overlay(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_overlay(PyObject *self, PyObject *args)
{
  WINDOW const * x0;
  WINDOW * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "overlay", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = overlay(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_overlay _cffi_d_overlay
#endif

static int _cffi_d_overwrite(WINDOW const * x0, WINDOW * x1)
{
  return overwrite(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_overwrite(PyObject *self, PyObject *args)
{
  WINDOW const * x0;
  WINDOW * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "overwrite", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = overwrite(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_overwrite _cffi_d_overwrite
#endif

static int _cffi_d_pair_content(short x0, short * x1, short * x2)
{
  return pair_content(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pair_content(PyObject *self, PyObject *args)
{
  short x0;
  short * x1;
  short * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "pair_content", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, short);
  if (x0 == (short)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (short *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(243), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (short *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(243), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pair_content(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pair_content _cffi_d_pair_content
#endif

static PANEL * _cffi_d_panel_above(PANEL const * x0)
{
  return panel_above(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_panel_above(PyObject *self, PyObject *arg0)
{
  PANEL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PANEL * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = panel_above(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(61));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_panel_above _cffi_d_panel_above
#endif

static PANEL * _cffi_d_panel_below(PANEL const * x0)
{
  return panel_below(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_panel_below(PyObject *self, PyObject *arg0)
{
  PANEL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PANEL * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = panel_below(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(61));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_panel_below _cffi_d_panel_below
#endif

static int _cffi_d_panel_hidden(PANEL const * x0)
{
  return panel_hidden(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_panel_hidden(PyObject *self, PyObject *arg0)
{
  PANEL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = panel_hidden(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_panel_hidden _cffi_d_panel_hidden
#endif

static void const * _cffi_d_panel_userptr(PANEL const * x0)
{
  return panel_userptr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_panel_userptr(PyObject *self, PyObject *arg0)
{
  PANEL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = panel_userptr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(134));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_panel_userptr _cffi_d_panel_userptr
#endif

static WINDOW * _cffi_d_panel_window(PANEL const * x0)
{
  return panel_window(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_panel_window(PyObject *self, PyObject *arg0)
{
  PANEL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  WINDOW * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = panel_window(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_panel_window _cffi_d_panel_window
#endif

static int _cffi_d_pechochar(WINDOW * x0, chtype x1)
{
  return pechochar(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pechochar(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pechochar", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pechochar(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pechochar _cffi_d_pechochar
#endif

static int _cffi_d_pnoutrefresh(WINDOW * x0, int x1, int x2, int x3, int x4, int x5, int x6)
{
  return pnoutrefresh(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pnoutrefresh(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  int x5;
  int x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "pnoutrefresh", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pnoutrefresh(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pnoutrefresh _cffi_d_pnoutrefresh
#endif

static int _cffi_d_prefresh(WINDOW * x0, int x1, int x2, int x3, int x4, int x5, int x6)
{
  return prefresh(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_prefresh(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  int x5;
  int x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "prefresh", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = prefresh(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_prefresh _cffi_d_prefresh
#endif

static int _cffi_d_putp(char const * x0)
{
  return putp(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_putp(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = putp(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_putp _cffi_d_putp
#endif

static int _cffi_d_putwin(WINDOW * x0, FILE * x1)
{
  return putwin(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_putwin(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  FILE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "putwin", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = putwin(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_putwin _cffi_d_putwin
#endif

static void _cffi_d_qiflush(void)
{
  qiflush();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qiflush(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qiflush(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qiflush _cffi_d_qiflush
#endif

static int _cffi_d_raw(void)
{
  return raw();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_raw(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = raw(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_raw _cffi_d_raw
#endif

static int _cffi_d_redrawwin(WINDOW * x0)
{
  return redrawwin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_redrawwin(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = redrawwin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_redrawwin _cffi_d_redrawwin
#endif

static int _cffi_d_replace_panel(PANEL * x0, WINDOW * x1)
{
  return replace_panel(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_replace_panel(PyObject *self, PyObject *args)
{
  PANEL * x0;
  WINDOW * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "replace_panel", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = replace_panel(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_replace_panel _cffi_d_replace_panel
#endif

static int _cffi_d_reset_prog_mode(void)
{
  return reset_prog_mode();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reset_prog_mode(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = reset_prog_mode(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_reset_prog_mode _cffi_d_reset_prog_mode
#endif

static int _cffi_d_reset_shell_mode(void)
{
  return reset_shell_mode();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reset_shell_mode(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = reset_shell_mode(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_reset_shell_mode _cffi_d_reset_shell_mode
#endif

static int _cffi_d_resetty(void)
{
  return resetty();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_resetty(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = resetty(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_resetty _cffi_d_resetty
#endif

static int _cffi_d_resize_term(int x0, int x1)
{
  return resize_term(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_resize_term(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "resize_term", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = resize_term(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_resize_term _cffi_d_resize_term
#endif

static int _cffi_d_resizeterm(int x0, int x1)
{
  return resizeterm(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_resizeterm(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "resizeterm", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = resizeterm(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_resizeterm _cffi_d_resizeterm
#endif

static int _cffi_d_savetty(void)
{
  return savetty();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_savetty(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = savetty(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_savetty _cffi_d_savetty
#endif

static int _cffi_d_scroll(WINDOW * x0)
{
  return scroll(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_scroll(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = scroll(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_scroll _cffi_d_scroll
#endif

static int _cffi_d_scrollok(WINDOW * x0, unsigned char x1)
{
  return scrollok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_scrollok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "scrollok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = scrollok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_scrollok _cffi_d_scrollok
#endif

static int _cffi_d_set_panel_userptr(PANEL * x0, void * x1)
{
  return set_panel_userptr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_set_panel_userptr(PyObject *self, PyObject *args)
{
  PANEL * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "set_panel_userptr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = set_panel_userptr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_set_panel_userptr _cffi_d_set_panel_userptr
#endif

static void _cffi_d_setsyx(int x0, int x1)
{
  setsyx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_setsyx(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "setsyx", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { setsyx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_setsyx _cffi_d_setsyx
#endif

static int _cffi_d_setupterm(char * x0, int x1, int * x2)
{
  return setupterm(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_setupterm(PyObject *self, PyObject *args)
{
  char * x0;
  int x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "setupterm", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(229), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(229), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = setupterm(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_setupterm _cffi_d_setupterm
#endif

static int _cffi_d_show_panel(PANEL * x0)
{
  return show_panel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_show_panel(PyObject *self, PyObject *arg0)
{
  PANEL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = show_panel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_show_panel _cffi_d_show_panel
#endif

static int _cffi_d_start_color(void)
{
  return start_color();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_start_color(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = start_color(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_start_color _cffi_d_start_color
#endif

static WINDOW * _cffi_d_subpad(WINDOW * x0, int x1, int x2, int x3, int x4)
{
  return subpad(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_subpad(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  WINDOW * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "subpad", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = subpad(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_subpad _cffi_d_subpad
#endif

static WINDOW * _cffi_d_subwin(WINDOW * x0, int x1, int x2, int x3, int x4)
{
  return subwin(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_subwin(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  WINDOW * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "subwin", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = subwin(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_subwin _cffi_d_subwin
#endif

static int _cffi_d_syncok(WINDOW * x0, unsigned char x1)
{
  return syncok(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_syncok(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  unsigned char x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "syncok", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned char);
  if (x1 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = syncok(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_syncok _cffi_d_syncok
#endif

static chtype _cffi_d_termattrs(void)
{
  return termattrs();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_termattrs(PyObject *self, PyObject *noarg)
{
  chtype result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = termattrs(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, chtype);
  return pyresult;
}
#else
#  define _cffi_f_termattrs _cffi_d_termattrs
#endif

static char * _cffi_d_termname(void)
{
  return termname();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_termname(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = termname(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(32));
  return pyresult;
}
#else
#  define _cffi_f_termname _cffi_d_termname
#endif

static int _cffi_d_tigetflag(char * x0)
{
  return tigetflag(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_tigetflag(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = tigetflag(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_tigetflag _cffi_d_tigetflag
#endif

static int _cffi_d_tigetnum(char * x0)
{
  return tigetnum(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_tigetnum(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = tigetnum(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_tigetnum _cffi_d_tigetnum
#endif

static char * _cffi_d_tigetstr(char * x0)
{
  return tigetstr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_tigetstr(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = tigetstr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(32));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_tigetstr _cffi_d_tigetstr
#endif

static int _cffi_d_top_panel(PANEL * x0)
{
  return top_panel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_top_panel(PyObject *self, PyObject *arg0)
{
  PANEL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(61), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PANEL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(61), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = top_panel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_top_panel _cffi_d_top_panel
#endif

static int _cffi_d_touchline(WINDOW * x0, int x1, int x2)
{
  return touchline(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_touchline(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "touchline", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = touchline(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_touchline _cffi_d_touchline
#endif

static int _cffi_d_touchwin(WINDOW * x0)
{
  return touchwin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_touchwin(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = touchwin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_touchwin _cffi_d_touchwin
#endif

static void _cffi_const_tparm(char *o)
{
  *(char *(* *)(char const *, ...))o = tparm;
}

static int _cffi_d_typeahead(int x0)
{
  return typeahead(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_typeahead(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = typeahead(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_typeahead _cffi_d_typeahead
#endif

static char const * _cffi_d_unctrl(chtype x0)
{
  return unctrl(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_unctrl(PyObject *self, PyObject *arg0)
{
  chtype x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, chtype);
  if (x0 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = unctrl(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(35));
  return pyresult;
}
#else
#  define _cffi_f_unctrl _cffi_d_unctrl
#endif

static int _cffi_d_unget_wch(wchar_t x0)
{
  return unget_wch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_unget_wch(PyObject *self, PyObject *arg0)
{
  wchar_t x0;
  int result;
  PyObject *pyresult;

  x0 = (wchar_t)_cffi_to_c_wchar_t(arg0);
  if (x0 == (wchar_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = unget_wch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_unget_wch _cffi_d_unget_wch
#endif

static int _cffi_d_ungetch(int x0)
{
  return ungetch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ungetch(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ungetch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ungetch _cffi_d_ungetch
#endif

static int _cffi_d_ungetmouse(MEVENT * x0)
{
  return ungetmouse(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ungetmouse(PyObject *self, PyObject *arg0)
{
  MEVENT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (MEVENT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ungetmouse(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ungetmouse _cffi_d_ungetmouse
#endif

static int _cffi_d_untouchwin(WINDOW * x0)
{
  return untouchwin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_untouchwin(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = untouchwin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_untouchwin _cffi_d_untouchwin
#endif

static void _cffi_d_update_panels(void)
{
  update_panels();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_update_panels(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { update_panels(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_update_panels _cffi_d_update_panels
#endif

static int _cffi_d_use_default_colors(void)
{
  return use_default_colors();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_use_default_colors(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = use_default_colors(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_use_default_colors _cffi_d_use_default_colors
#endif

static void _cffi_d_use_env(unsigned char x0)
{
  use_env(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_use_env(PyObject *self, PyObject *arg0)
{
  unsigned char x0;

  x0 = _cffi_to_c_int(arg0, unsigned char);
  if (x0 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { use_env(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_use_env _cffi_d_use_env
#endif

static int _cffi_d_waddch(WINDOW * x0, chtype x1)
{
  return waddch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_waddch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "waddch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = waddch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_waddch _cffi_d_waddch
#endif

static int _cffi_d_waddnstr(WINDOW * x0, char const * x1, int x2)
{
  return waddnstr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_waddnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "waddnstr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = waddnstr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_waddnstr _cffi_d_waddnstr
#endif

static int _cffi_d_waddstr(WINDOW * x0, char const * x1)
{
  return waddstr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_waddstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "waddstr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = waddstr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_waddstr _cffi_d_waddstr
#endif

static int _cffi_d_wattroff(WINDOW * x0, int x1)
{
  return wattroff(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wattroff(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wattroff", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wattroff(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wattroff _cffi_d_wattroff
#endif

static int _cffi_d_wattron(WINDOW * x0, int x1)
{
  return wattron(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wattron(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wattron", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wattron(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wattron _cffi_d_wattron
#endif

static int _cffi_d_wattrset(WINDOW * x0, int x1)
{
  return wattrset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wattrset(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wattrset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wattrset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wattrset _cffi_d_wattrset
#endif

static int _cffi_d_wbkgd(WINDOW * x0, chtype x1)
{
  return wbkgd(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wbkgd(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wbkgd", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wbkgd(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wbkgd _cffi_d_wbkgd
#endif

static void _cffi_d_wbkgdset(WINDOW * x0, chtype x1)
{
  wbkgdset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wbkgdset(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wbkgdset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wbkgdset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wbkgdset _cffi_d_wbkgdset
#endif

static int _cffi_d_wborder(WINDOW * x0, chtype x1, chtype x2, chtype x3, chtype x4, chtype x5, chtype x6, chtype x7, chtype x8)
{
  return wborder(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wborder(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  chtype x2;
  chtype x3;
  chtype x4;
  chtype x5;
  chtype x6;
  chtype x7;
  chtype x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "wborder", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, chtype);
  if (x2 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, chtype);
  if (x3 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, chtype);
  if (x4 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, chtype);
  if (x5 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, chtype);
  if (x6 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, chtype);
  if (x7 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, chtype);
  if (x8 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wborder(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wborder _cffi_d_wborder
#endif

static int _cffi_d_wchgat(WINDOW * x0, int x1, chtype x2, short x3, void const * x4)
{
  return wchgat(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wchgat(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  chtype x2;
  short x3;
  void const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wchgat", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, chtype);
  if (x2 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, short);
  if (x3 == (short)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wchgat(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wchgat _cffi_d_wchgat
#endif

static int _cffi_d_wclear(WINDOW * x0)
{
  return wclear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wclear(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wclear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wclear _cffi_d_wclear
#endif

static int _cffi_d_wclrtobot(WINDOW * x0)
{
  return wclrtobot(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wclrtobot(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wclrtobot(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wclrtobot _cffi_d_wclrtobot
#endif

static int _cffi_d_wclrtoeol(WINDOW * x0)
{
  return wclrtoeol(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wclrtoeol(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wclrtoeol(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wclrtoeol _cffi_d_wclrtoeol
#endif

static void _cffi_d_wcursyncup(WINDOW * x0)
{
  wcursyncup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wcursyncup(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wcursyncup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wcursyncup _cffi_d_wcursyncup
#endif

static int _cffi_d_wdelch(WINDOW * x0)
{
  return wdelch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wdelch(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wdelch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wdelch _cffi_d_wdelch
#endif

static int _cffi_d_wdeleteln(WINDOW * x0)
{
  return wdeleteln(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wdeleteln(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wdeleteln(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wdeleteln _cffi_d_wdeleteln
#endif

static int _cffi_d_wechochar(WINDOW * x0, chtype x1)
{
  return wechochar(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wechochar(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wechochar", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wechochar(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wechochar _cffi_d_wechochar
#endif

static unsigned char _cffi_d_wenclose(WINDOW const * x0, int x1, int x2)
{
  return wenclose(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wenclose(PyObject *self, PyObject *args)
{
  WINDOW const * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wenclose", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wenclose(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wenclose _cffi_d_wenclose
#endif

static int _cffi_d_werase(WINDOW * x0)
{
  return werase(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_werase(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = werase(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_werase _cffi_d_werase
#endif

static int _cffi_d_wget_wch(WINDOW * x0, wint_t * x1)
{
  return wget_wch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wget_wch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  wint_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wget_wch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(195), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (wint_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(195), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wget_wch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wget_wch _cffi_d_wget_wch
#endif

static int _cffi_d_wgetch(WINDOW * x0)
{
  return wgetch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wgetch(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wgetch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wgetch _cffi_d_wgetch
#endif

static int _cffi_d_wgetnstr(WINDOW * x0, char * x1, int x2)
{
  return wgetnstr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wgetnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  char * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wgetnstr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wgetnstr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wgetnstr _cffi_d_wgetnstr
#endif

static int _cffi_d_whline(WINDOW * x0, chtype x1, int x2)
{
  return whline(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_whline(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "whline", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = whline(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_whline _cffi_d_whline
#endif

static chtype _cffi_d_winch(WINDOW * x0)
{
  return winch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winch(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  chtype result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, chtype);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winch _cffi_d_winch
#endif

static int _cffi_d_winnstr(WINDOW * x0, char * x1, int x2)
{
  return winnstr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  char * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "winnstr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(32), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(32), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winnstr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winnstr _cffi_d_winnstr
#endif

static int _cffi_d_winsch(WINDOW * x0, chtype x1)
{
  return winsch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winsch(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "winsch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winsch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winsch _cffi_d_winsch
#endif

static int _cffi_d_winsdelln(WINDOW * x0, int x1)
{
  return winsdelln(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winsdelln(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "winsdelln", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winsdelln(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winsdelln _cffi_d_winsdelln
#endif

static int _cffi_d_winsertln(WINDOW * x0)
{
  return winsertln(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winsertln(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winsertln(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winsertln _cffi_d_winsertln
#endif

static int _cffi_d_winsnstr(WINDOW * x0, char const * x1, int x2)
{
  return winsnstr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winsnstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "winsnstr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winsnstr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winsnstr _cffi_d_winsnstr
#endif

static int _cffi_d_winsstr(WINDOW * x0, char const * x1)
{
  return winsstr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_winsstr(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "winsstr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = winsstr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_winsstr _cffi_d_winsstr
#endif

static int _cffi_d_wmove(WINDOW * x0, int x1, int x2)
{
  return wmove(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wmove(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wmove", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wmove(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wmove _cffi_d_wmove
#endif

static int _cffi_d_wnoutrefresh(WINDOW * x0)
{
  return wnoutrefresh(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wnoutrefresh(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wnoutrefresh(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wnoutrefresh _cffi_d_wnoutrefresh
#endif

static int _cffi_d_wredrawln(WINDOW * x0, int x1, int x2)
{
  return wredrawln(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wredrawln(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wredrawln", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wredrawln(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wredrawln _cffi_d_wredrawln
#endif

static int _cffi_d_wrefresh(WINDOW * x0)
{
  return wrefresh(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wrefresh(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wrefresh(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wrefresh _cffi_d_wrefresh
#endif

static int _cffi_d_wresize(WINDOW * x0, int x1, int x2)
{
  return wresize(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wresize(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wresize", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wresize(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wresize _cffi_d_wresize
#endif

static int _cffi_d_wscrl(WINDOW * x0, int x1)
{
  return wscrl(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wscrl(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wscrl", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wscrl(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wscrl _cffi_d_wscrl
#endif

static int _cffi_d_wsetscrreg(WINDOW * x0, int x1, int x2)
{
  return wsetscrreg(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wsetscrreg(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wsetscrreg", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wsetscrreg(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wsetscrreg _cffi_d_wsetscrreg
#endif

static int _cffi_d_wstandend(WINDOW * x0)
{
  return wstandend(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wstandend(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wstandend(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wstandend _cffi_d_wstandend
#endif

static int _cffi_d_wstandout(WINDOW * x0)
{
  return wstandout(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wstandout(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wstandout(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wstandout _cffi_d_wstandout
#endif

static void _cffi_d_wsyncdown(WINDOW * x0)
{
  wsyncdown(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wsyncdown(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wsyncdown(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wsyncdown _cffi_d_wsyncdown
#endif

static void _cffi_d_wsyncup(WINDOW * x0)
{
  wsyncup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wsyncup(PyObject *self, PyObject *arg0)
{
  WINDOW * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wsyncup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wsyncup _cffi_d_wsyncup
#endif

static void _cffi_d_wtimeout(WINDOW * x0, int x1)
{
  wtimeout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wtimeout(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wtimeout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wtimeout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wtimeout _cffi_d_wtimeout
#endif

static int _cffi_d_wtouchln(WINDOW * x0, int x1, int x2, int x3)
{
  return wtouchln(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wtouchln(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  int x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wtouchln", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wtouchln(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wtouchln _cffi_d_wtouchln
#endif

static int _cffi_d_wvline(WINDOW * x0, chtype x1, int x2)
{
  return wvline(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wvline(PyObject *self, PyObject *args)
{
  WINDOW * x0;
  chtype x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wvline", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (WINDOW *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, chtype);
  if (x1 == (chtype)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wvline(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wvline _cffi_d_wvline
#endif

static int _cffi_const__m_NCURSES_MOUSE_VERSION(unsigned long long *o)
{
  int n = (_m_NCURSES_MOUSE_VERSION) <= 0;
  *o = (unsigned long long)((_m_NCURSES_MOUSE_VERSION) | 0);  /* check that _m_NCURSES_MOUSE_VERSION is an integer */
  return n;
}

static int _cffi_const__m_NetBSD(unsigned long long *o)
{
  int n = (_m_NetBSD) <= 0;
  *o = (unsigned long long)((_m_NetBSD) | 0);  /* check that _m_NetBSD is an integer */
  return n;
}

static int _cffi_const__m_STRICT_SYSV_CURSES(unsigned long long *o)
{
  int n = (_m_STRICT_SYSV_CURSES) <= 0;
  *o = (unsigned long long)((_m_STRICT_SYSV_CURSES) | 0);  /* check that _m_STRICT_SYSV_CURSES is an integer */
  return n;
}

static int *_cffi_var_COLORS(void)
{
  return &(COLORS);
}

static int *_cffi_var_COLOR_PAIRS(void)
{
  return &(COLOR_PAIRS);
}

static int *_cffi_var_COLS(void)
{
  return &(COLS);
}

static int *_cffi_var_LINES(void)
{
  return &(LINES);
}

static chtype *_cffi_var_acs_map(void)
{
  return (acs_map);
}

static WINDOW * *_cffi_var_stdscr(void)
{
  return &(stdscr);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "ALL_MOUSE_EVENTS", (void *)_cffi_const_ALL_MOUSE_EVENTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_ALTCHARSET", (void *)_cffi_const_A_ALTCHARSET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_ATTRIBUTES", (void *)_cffi_const_A_ATTRIBUTES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_BLINK", (void *)_cffi_const_A_BLINK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_BOLD", (void *)_cffi_const_A_BOLD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_CHARTEXT", (void *)_cffi_const_A_CHARTEXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_COLOR", (void *)_cffi_const_A_COLOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_DIM", (void *)_cffi_const_A_DIM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_HORIZONTAL", (void *)_cffi_const_A_HORIZONTAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_INVIS", (void *)_cffi_const_A_INVIS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_LEFT", (void *)_cffi_const_A_LEFT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_LOW", (void *)_cffi_const_A_LOW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_NORMAL", (void *)_cffi_const_A_NORMAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_PROTECT", (void *)_cffi_const_A_PROTECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_REVERSE", (void *)_cffi_const_A_REVERSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_RIGHT", (void *)_cffi_const_A_RIGHT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_STANDOUT", (void *)_cffi_const_A_STANDOUT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_TOP", (void *)_cffi_const_A_TOP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_UNDERLINE", (void *)_cffi_const_A_UNDERLINE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "A_VERTICAL", (void *)_cffi_const_A_VERTICAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON1_CLICKED", (void *)_cffi_const_BUTTON1_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON1_DOUBLE_CLICKED", (void *)_cffi_const_BUTTON1_DOUBLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON1_PRESSED", (void *)_cffi_const_BUTTON1_PRESSED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON1_RELEASED", (void *)_cffi_const_BUTTON1_RELEASED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON1_TRIPLE_CLICKED", (void *)_cffi_const_BUTTON1_TRIPLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON2_CLICKED", (void *)_cffi_const_BUTTON2_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON2_DOUBLE_CLICKED", (void *)_cffi_const_BUTTON2_DOUBLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON2_PRESSED", (void *)_cffi_const_BUTTON2_PRESSED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON2_RELEASED", (void *)_cffi_const_BUTTON2_RELEASED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON2_TRIPLE_CLICKED", (void *)_cffi_const_BUTTON2_TRIPLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON3_CLICKED", (void *)_cffi_const_BUTTON3_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON3_DOUBLE_CLICKED", (void *)_cffi_const_BUTTON3_DOUBLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON3_PRESSED", (void *)_cffi_const_BUTTON3_PRESSED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON3_RELEASED", (void *)_cffi_const_BUTTON3_RELEASED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON3_TRIPLE_CLICKED", (void *)_cffi_const_BUTTON3_TRIPLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON4_CLICKED", (void *)_cffi_const_BUTTON4_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON4_DOUBLE_CLICKED", (void *)_cffi_const_BUTTON4_DOUBLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON4_PRESSED", (void *)_cffi_const_BUTTON4_PRESSED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON4_RELEASED", (void *)_cffi_const_BUTTON4_RELEASED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON4_TRIPLE_CLICKED", (void *)_cffi_const_BUTTON4_TRIPLE_CLICKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON_ALT", (void *)_cffi_const_BUTTON_ALT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON_CTRL", (void *)_cffi_const_BUTTON_CTRL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUTTON_SHIFT", (void *)_cffi_const_BUTTON_SHIFT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLORS", (void *)_cffi_var_COLORS, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 14), (void *)0 },
  { "COLOR_BLACK", (void *)_cffi_const_COLOR_BLACK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_BLUE", (void *)_cffi_const_COLOR_BLUE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_CYAN", (void *)_cffi_const_COLOR_CYAN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_GREEN", (void *)_cffi_const_COLOR_GREEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_MAGENTA", (void *)_cffi_const_COLOR_MAGENTA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_PAIRS", (void *)_cffi_var_COLOR_PAIRS, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 14), (void *)0 },
  { "COLOR_RED", (void *)_cffi_const_COLOR_RED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_WHITE", (void *)_cffi_const_COLOR_WHITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLOR_YELLOW", (void *)_cffi_const_COLOR_YELLOW, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COLS", (void *)_cffi_var_COLS, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 14), (void *)0 },
  { "ERR", (void *)_cffi_const_ERR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "FALSE", (void *)_cffi_const_FALSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "KEY_CODE_YES", (void *)_cffi_const_KEY_CODE_YES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "KEY_MAX", (void *)_cffi_const_KEY_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "KEY_MIN", (void *)_cffi_const_KEY_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LINES", (void *)_cffi_var_LINES, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 14), (void *)0 },
  { "OK", (void *)_cffi_const_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "REPORT_MOUSE_POSITION", (void *)_cffi_const_REPORT_MOUSE_POSITION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TRUE", (void *)_cffi_const_TRUE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_m_NCURSES_MOUSE_VERSION", (void *)_cffi_const__m_NCURSES_MOUSE_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_m_NetBSD", (void *)_cffi_const__m_NetBSD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_m_STRICT_SYSV_CURSES", (void *)_cffi_const__m_STRICT_SYSV_CURSES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_m_getsyx", (void *)_cffi_f__m_getsyx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 308), (void *)_cffi_d__m_getsyx },
  { "_m_ispad", (void *)_cffi_f__m_ispad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d__m_ispad },
  { "acs_map", (void *)_cffi_var_acs_map, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 327), (void *)0 },
  { "baudrate", (void *)_cffi_f_baudrate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_baudrate },
  { "beep", (void *)_cffi_f_beep, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_beep },
  { "bottom_panel", (void *)_cffi_f_bottom_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_bottom_panel },
  { "box", (void *)_cffi_f_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_box },
  { "can_change_color", (void *)_cffi_f_can_change_color, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 288), (void *)_cffi_d_can_change_color },
  { "cbreak", (void *)_cffi_f_cbreak, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_cbreak },
  { "clearok", (void *)_cffi_f_clearok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_clearok },
  { "color_content", (void *)_cffi_f_color_content, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 246), (void *)_cffi_d_color_content },
  { "copywin", (void *)_cffi_f_copywin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 212), (void *)_cffi_d_copywin },
  { "curs_set", (void *)_cffi_f_curs_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_curs_set },
  { "def_prog_mode", (void *)_cffi_f_def_prog_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_def_prog_mode },
  { "def_shell_mode", (void *)_cffi_f_def_shell_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_def_shell_mode },
  { "del_panel", (void *)_cffi_f_del_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_del_panel },
  { "delay_output", (void *)_cffi_f_delay_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_delay_output },
  { "delwin", (void *)_cffi_f_delwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_delwin },
  { "derwin", (void *)_cffi_f_derwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_derwin },
  { "doupdate", (void *)_cffi_f_doupdate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_doupdate },
  { "echo", (void *)_cffi_f_echo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_echo },
  { "endwin", (void *)_cffi_f_endwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_endwin },
  { "erasechar", (void *)_cffi_f_erasechar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 45), (void *)_cffi_d_erasechar },
  { "filter", (void *)_cffi_f_filter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 318), (void *)_cffi_d_filter },
  { "flash", (void *)_cffi_f_flash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_flash },
  { "flushinp", (void *)_cffi_f_flushinp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_flushinp },
  { "getattrs", (void *)_cffi_f_getattrs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getattrs },
  { "getbegx", (void *)_cffi_f_getbegx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getbegx },
  { "getbegy", (void *)_cffi_f_getbegy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getbegy },
  { "getbkgd", (void *)_cffi_f_getbkgd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 47), (void *)_cffi_d_getbkgd },
  { "getcurx", (void *)_cffi_f_getcurx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getcurx },
  { "getcury", (void *)_cffi_f_getcury, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getcury },
  { "getmaxx", (void *)_cffi_f_getmaxx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getmaxx },
  { "getmaxy", (void *)_cffi_f_getmaxy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getmaxy },
  { "getmouse", (void *)_cffi_f_getmouse, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_getmouse },
  { "getparx", (void *)_cffi_f_getparx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getparx },
  { "getpary", (void *)_cffi_f_getpary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 205), (void *)_cffi_d_getpary },
  { "getwin", (void *)_cffi_f_getwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_getwin },
  { "halfdelay", (void *)_cffi_f_halfdelay, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_halfdelay },
  { "has_colors", (void *)_cffi_f_has_colors, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 288), (void *)_cffi_d_has_colors },
  { "has_ic", (void *)_cffi_f_has_ic, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 288), (void *)_cffi_d_has_ic },
  { "has_il", (void *)_cffi_f_has_il, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 288), (void *)_cffi_d_has_il },
  { "has_key", (void *)_cffi_f_has_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_has_key },
  { "hide_panel", (void *)_cffi_f_hide_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_hide_panel },
  { "idcok", (void *)_cffi_f_idcok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 304), (void *)_cffi_d_idcok },
  { "idlok", (void *)_cffi_f_idlok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_idlok },
  { "immedok", (void *)_cffi_f_immedok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 304), (void *)_cffi_d_immedok },
  { "init_color", (void *)_cffi_f_init_color, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 257), (void *)_cffi_d_init_color },
  { "init_pair", (void *)_cffi_f_init_pair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 252), (void *)_cffi_d_init_pair },
  { "initscr", (void *)_cffi_f_initscr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 29), (void *)_cffi_d_initscr },
  { "intrflush", (void *)_cffi_f_intrflush, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_intrflush },
  { "is_linetouched", (void *)_cffi_f_is_linetouched, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 275), (void *)_cffi_d_is_linetouched },
  { "is_term_resized", (void *)_cffi_f_is_term_resized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 284), (void *)_cffi_d_is_term_resized },
  { "is_wintouched", (void *)_cffi_f_is_wintouched, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 272), (void *)_cffi_d_is_wintouched },
  { "isendwin", (void *)_cffi_f_isendwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 288), (void *)_cffi_d_isendwin },
  { "keyname", (void *)_cffi_f_keyname, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 42), (void *)_cffi_d_keyname },
  { "keypad", (void *)_cffi_f_keypad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_keypad },
  { "killchar", (void *)_cffi_f_killchar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 45), (void *)_cffi_d_killchar },
  { "leaveok", (void *)_cffi_f_leaveok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_leaveok },
  { "longname", (void *)_cffi_f_longname, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 37), (void *)_cffi_d_longname },
  { "meta", (void *)_cffi_f_meta, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_meta },
  { "mouseinterval", (void *)_cffi_f_mouseinterval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_mouseinterval },
  { "mousemask", (void *)_cffi_f_mousemask, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 268), (void *)_cffi_d_mousemask },
  { "move_panel", (void *)_cffi_f_move_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 67), (void *)_cffi_d_move_panel },
  { "mvderwin", (void *)_cffi_f_mvderwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_mvderwin },
  { "mvwaddch", (void *)_cffi_f_mvwaddch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 161), (void *)_cffi_d_mvwaddch },
  { "mvwaddnstr", (void *)_cffi_f_mvwaddnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 154), (void *)_cffi_d_mvwaddnstr },
  { "mvwaddstr", (void *)_cffi_f_mvwaddstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_mvwaddstr },
  { "mvwchgat", (void *)_cffi_f_mvwchgat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 173), (void *)_cffi_d_mvwchgat },
  { "mvwdelch", (void *)_cffi_f_mvwdelch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_mvwdelch },
  { "mvwget_wch", (void *)_cffi_f_mvwget_wch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 191), (void *)_cffi_d_mvwget_wch },
  { "mvwgetch", (void *)_cffi_f_mvwgetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_mvwgetch },
  { "mvwgetnstr", (void *)_cffi_f_mvwgetnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_mvwgetnstr },
  { "mvwin", (void *)_cffi_f_mvwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_mvwin },
  { "mvwinch", (void *)_cffi_f_mvwinch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_mvwinch },
  { "mvwinnstr", (void *)_cffi_f_mvwinnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_mvwinnstr },
  { "mvwinsch", (void *)_cffi_f_mvwinsch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 161), (void *)_cffi_d_mvwinsch },
  { "mvwinsnstr", (void *)_cffi_f_mvwinsnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 154), (void *)_cffi_d_mvwinsnstr },
  { "mvwinsstr", (void *)_cffi_f_mvwinsstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_mvwinsstr },
  { "napms", (void *)_cffi_f_napms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_napms },
  { "new_panel", (void *)_cffi_f_new_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_new_panel },
  { "newpad", (void *)_cffi_f_newpad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_newpad },
  { "newwin", (void *)_cffi_f_newwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 23), (void *)_cffi_d_newwin },
  { "nl", (void *)_cffi_f_nl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_nl },
  { "nocbreak", (void *)_cffi_f_nocbreak, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_nocbreak },
  { "nodelay", (void *)_cffi_f_nodelay, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_nodelay },
  { "noecho", (void *)_cffi_f_noecho, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_noecho },
  { "nonl", (void *)_cffi_f_nonl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_nonl },
  { "noqiflush", (void *)_cffi_f_noqiflush, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 318), (void *)_cffi_d_noqiflush },
  { "noraw", (void *)_cffi_f_noraw, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_noraw },
  { "notimeout", (void *)_cffi_f_notimeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_notimeout },
  { "overlay", (void *)_cffi_f_overlay, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 208), (void *)_cffi_d_overlay },
  { "overwrite", (void *)_cffi_f_overwrite, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 208), (void *)_cffi_d_overwrite },
  { "pair_content", (void *)_cffi_f_pair_content, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 241), (void *)_cffi_d_pair_content },
  { "panel_above", (void *)_cffi_f_panel_above, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_panel_above },
  { "panel_below", (void *)_cffi_f_panel_below, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_panel_below },
  { "panel_hidden", (void *)_cffi_f_panel_hidden, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 76), (void *)_cffi_d_panel_hidden },
  { "panel_userptr", (void *)_cffi_f_panel_userptr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_panel_userptr },
  { "panel_window", (void *)_cffi_f_panel_window, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_panel_window },
  { "pechochar", (void *)_cffi_f_pechochar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_pechochar },
  { "pnoutrefresh", (void *)_cffi_f_pnoutrefresh, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 182), (void *)_cffi_d_pnoutrefresh },
  { "prefresh", (void *)_cffi_f_prefresh, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 182), (void *)_cffi_d_prefresh },
  { "putp", (void *)_cffi_f_putp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 231), (void *)_cffi_d_putp },
  { "putwin", (void *)_cffi_f_putwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 82), (void *)_cffi_d_putwin },
  { "qiflush", (void *)_cffi_f_qiflush, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 318), (void *)_cffi_d_qiflush },
  { "raw", (void *)_cffi_f_raw, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_raw },
  { "redrawwin", (void *)_cffi_f_redrawwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_redrawwin },
  { "replace_panel", (void *)_cffi_f_replace_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_replace_panel },
  { "reset_prog_mode", (void *)_cffi_f_reset_prog_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_reset_prog_mode },
  { "reset_shell_mode", (void *)_cffi_f_reset_shell_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_reset_shell_mode },
  { "resetty", (void *)_cffi_f_resetty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_resetty },
  { "resize_term", (void *)_cffi_f_resize_term, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 237), (void *)_cffi_d_resize_term },
  { "resizeterm", (void *)_cffi_f_resizeterm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 237), (void *)_cffi_d_resizeterm },
  { "savetty", (void *)_cffi_f_savetty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_savetty },
  { "scroll", (void *)_cffi_f_scroll, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_scroll },
  { "scrollok", (void *)_cffi_f_scrollok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_scrollok },
  { "set_panel_userptr", (void *)_cffi_f_set_panel_userptr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_set_panel_userptr },
  { "setsyx", (void *)_cffi_f_setsyx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 311), (void *)_cffi_d_setsyx },
  { "setupterm", (void *)_cffi_f_setupterm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 226), (void *)_cffi_d_setupterm },
  { "show_panel", (void *)_cffi_f_show_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_show_panel },
  { "start_color", (void *)_cffi_f_start_color, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_start_color },
  { "stdscr", (void *)_cffi_var_stdscr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 4), (void *)0 },
  { "subpad", (void *)_cffi_f_subpad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_subpad },
  { "subwin", (void *)_cffi_f_subwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_subwin },
  { "syncok", (void *)_cffi_f_syncok, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_syncok },
  { "termattrs", (void *)_cffi_f_termattrs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 55), (void *)_cffi_d_termattrs },
  { "termname", (void *)_cffi_f_termname, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 37), (void *)_cffi_d_termname },
  { "tigetflag", (void *)_cffi_f_tigetflag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 223), (void *)_cffi_d_tigetflag },
  { "tigetnum", (void *)_cffi_f_tigetnum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 223), (void *)_cffi_d_tigetnum },
  { "tigetstr", (void *)_cffi_f_tigetstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 31), (void *)_cffi_d_tigetstr },
  { "top_panel", (void *)_cffi_f_top_panel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_top_panel },
  { "touchline", (void *)_cffi_f_touchline, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_touchline },
  { "touchwin", (void *)_cffi_f_touchwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_touchwin },
  { "tparm", (void *)_cffi_const_tparm, _CFFI_OP(_CFFI_OP_CONSTANT, 325), (void *)0 },
  { "typeahead", (void *)_cffi_f_typeahead, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_typeahead },
  { "unctrl", (void *)_cffi_f_unctrl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_unctrl },
  { "unget_wch", (void *)_cffi_f_unget_wch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 265), (void *)_cffi_d_unget_wch },
  { "ungetch", (void *)_cffi_f_ungetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_ungetch },
  { "ungetmouse", (void *)_cffi_f_ungetmouse, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_ungetmouse },
  { "untouchwin", (void *)_cffi_f_untouchwin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_untouchwin },
  { "update_panels", (void *)_cffi_f_update_panels, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 318), (void *)_cffi_d_update_panels },
  { "use_default_colors", (void *)_cffi_f_use_default_colors, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 263), (void *)_cffi_d_use_default_colors },
  { "use_env", (void *)_cffi_f_use_env, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 315), (void *)_cffi_d_use_env },
  { "waddch", (void *)_cffi_f_waddch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_waddch },
  { "waddnstr", (void *)_cffi_f_waddnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_waddnstr },
  { "waddstr", (void *)_cffi_f_waddstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_waddstr },
  { "wattroff", (void *)_cffi_f_wattroff, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_wattroff },
  { "wattron", (void *)_cffi_f_wattron, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_wattron },
  { "wattrset", (void *)_cffi_f_wattrset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_wattrset },
  { "wbkgd", (void *)_cffi_f_wbkgd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_wbkgd },
  { "wbkgdset", (void *)_cffi_f_wbkgdset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 296), (void *)_cffi_d_wbkgdset },
  { "wborder", (void *)_cffi_f_wborder, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_wborder },
  { "wchgat", (void *)_cffi_f_wchgat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 129), (void *)_cffi_d_wchgat },
  { "wclear", (void *)_cffi_f_wclear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wclear },
  { "wclrtobot", (void *)_cffi_f_wclrtobot, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wclrtobot },
  { "wclrtoeol", (void *)_cffi_f_wclrtoeol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wclrtoeol },
  { "wcursyncup", (void *)_cffi_f_wcursyncup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 293), (void *)_cffi_d_wcursyncup },
  { "wdelch", (void *)_cffi_f_wdelch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wdelch },
  { "wdeleteln", (void *)_cffi_f_wdeleteln, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wdeleteln },
  { "wechochar", (void *)_cffi_f_wechochar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_wechochar },
  { "wenclose", (void *)_cffi_f_wenclose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 279), (void *)_cffi_d_wenclose },
  { "werase", (void *)_cffi_f_werase, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_werase },
  { "wget_wch", (void *)_cffi_f_wget_wch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 201), (void *)_cffi_d_wget_wch },
  { "wgetch", (void *)_cffi_f_wgetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wgetch },
  { "wgetnstr", (void *)_cffi_f_wgetnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_wgetnstr },
  { "whline", (void *)_cffi_f_whline, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 120), (void *)_cffi_d_whline },
  { "winch", (void *)_cffi_f_winch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 47), (void *)_cffi_d_winch },
  { "winnstr", (void *)_cffi_f_winnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_winnstr },
  { "winsch", (void *)_cffi_f_winsch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_winsch },
  { "winsdelln", (void *)_cffi_f_winsdelln, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_winsdelln },
  { "winsertln", (void *)_cffi_f_winsertln, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_winsertln },
  { "winsnstr", (void *)_cffi_f_winsnstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_winsnstr },
  { "winsstr", (void *)_cffi_f_winsstr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_winsstr },
  { "wmove", (void *)_cffi_f_wmove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_wmove },
  { "wnoutrefresh", (void *)_cffi_f_wnoutrefresh, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wnoutrefresh },
  { "wredrawln", (void *)_cffi_f_wredrawln, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_wredrawln },
  { "wrefresh", (void *)_cffi_f_wrefresh, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wrefresh },
  { "wresize", (void *)_cffi_f_wresize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_wresize },
  { "wscrl", (void *)_cffi_f_wscrl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_wscrl },
  { "wsetscrreg", (void *)_cffi_f_wsetscrreg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_wsetscrreg },
  { "wstandend", (void *)_cffi_f_wstandend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wstandend },
  { "wstandout", (void *)_cffi_f_wstandout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wstandout },
  { "wsyncdown", (void *)_cffi_f_wsyncdown, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 293), (void *)_cffi_d_wsyncdown },
  { "wsyncup", (void *)_cffi_f_wsyncup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 293), (void *)_cffi_d_wsyncup },
  { "wtimeout", (void *)_cffi_f_wtimeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 300), (void *)_cffi_d_wtimeout },
  { "wtouchln", (void *)_cffi_f_wtouchln, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 167), (void *)_cffi_d_wtouchln },
  { "wvline", (void *)_cffi_f_wvline, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 120), (void *)_cffi_d_wvline },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "id", offsetof(MEVENT, id),
          sizeof(((MEVENT *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 133) },
  { "x", offsetof(MEVENT, x),
         sizeof(((MEVENT *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "y", offsetof(MEVENT, y),
         sizeof(((MEVENT *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "z", offsetof(MEVENT, z),
         sizeof(((MEVENT *)0)->z),
         _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "bstate", offsetof(MEVENT, bstate),
              sizeof(((MEVENT *)0)->bstate),
              _CFFI_OP(_CFFI_OP_NOOP, 269) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$MEVENT", 321, _CFFI_F_CHECK_FIELDS,
    sizeof(MEVENT), offsetof(struct _cffi_align_typedef_MEVENT, y), 0, 5 },
  { "$PANEL", 322, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$SCREEN", 323, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$WINDOW", 324, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_IO_FILE", 320, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "FILE", 320 },
  { "MEVENT", 321 },
  { "PANEL", 322 },
  { "SCREEN", 323 },
  { "WINDOW", 324 },
  { "attr_t", 40 },
  { "bool", 199 },
  { "chtype", 40 },
  { "mmask_t", 269 },
  { "wint_t", 329 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  253,  /* num_globals */
  5,  /* num_struct_unions */
  0,  /* num_enums */
  10,  /* num_typenames */
  NULL,  /* no includes */
  330,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__curses_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__curses_cffi(void) { return NULL; }
#  else
     init_curses_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__curses_cffi(void)
{
  return _cffi_init("_curses_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_curses_cffi(void)
{
  _cffi_init("_curses_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
