/* Branch.c generated by valac 0.56.18, the Vala compiler
 * generated from Branch.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	EVENTS_BRANCH_0_PROPERTY,
	EVENTS_BRANCH_NUM_PROPERTIES
};
static GParamSpec* events_branch_properties[EVENTS_BRANCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
enum  {
	EVENTS_DIRECTORY_ENTRY_0_PROPERTY,
	EVENTS_DIRECTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_directory_entry_properties[EVENTS_DIRECTORY_ENTRY_NUM_PROPERTIES];
enum  {
	EVENTS_MASTER_DIRECTORY_ENTRY_0_PROPERTY,
	EVENTS_MASTER_DIRECTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_master_directory_entry_properties[EVENTS_MASTER_DIRECTORY_ENTRY_NUM_PROPERTIES];
enum  {
	EVENTS_YEAR_DIRECTORY_ENTRY_0_PROPERTY,
	EVENTS_YEAR_DIRECTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_year_directory_entry_properties[EVENTS_YEAR_DIRECTORY_ENTRY_NUM_PROPERTIES];
enum  {
	EVENTS_MONTH_DIRECTORY_ENTRY_0_PROPERTY,
	EVENTS_MONTH_DIRECTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_month_directory_entry_properties[EVENTS_MONTH_DIRECTORY_ENTRY_NUM_PROPERTIES];
enum  {
	EVENTS_UNDATED_DIRECTORY_ENTRY_0_PROPERTY,
	EVENTS_UNDATED_DIRECTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_undated_directory_entry_properties[EVENTS_UNDATED_DIRECTORY_ENTRY_NUM_PROPERTIES];
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
enum  {
	EVENTS_EVENT_ENTRY_0_PROPERTY,
	EVENTS_EVENT_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_event_entry_properties[EVENTS_EVENT_ENTRY_NUM_PROPERTIES];
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
enum  {
	EVENTS_NO_EVENT_ENTRY_0_PROPERTY,
	EVENTS_NO_EVENT_ENTRY_NUM_PROPERTIES
};
static GParamSpec* events_no_event_entry_properties[EVENTS_NO_EVENT_ENTRY_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EventsBranchPrivate {
	GeeHashMap* entry_map;
	EventsUndatedDirectoryEntry* undated_entry;
	EventsNoEventEntry* no_event_entry;
	GSettings* ui_settings;
};

struct _Block1Data {
	int _ref_count_;
	EventsBranch* self;
	gint event_month;
};

struct _Block2Data {
	int _ref_count_;
	EventsBranch* self;
	gint event_year;
};

struct _EventsYearDirectoryEntryPrivate {
	gchar* name;
	GDateTime* tm;
};

struct _EventsMonthDirectoryEntryPrivate {
	gchar* name;
	GDateTime* tm;
};

struct _EventsEventEntryPrivate {
	Event* event;
};

static gint EventsBranch_private_offset;
static gpointer events_branch_parent_class = NULL;
VALA_EXTERN GIcon* events_branch_open_icon;
GIcon* events_branch_open_icon = NULL;
VALA_EXTERN GIcon* events_branch_closed_icon;
GIcon* events_branch_closed_icon = NULL;
VALA_EXTERN GIcon* events_branch_events_icon;
GIcon* events_branch_events_icon = NULL;
VALA_EXTERN GIcon* events_branch_single_event_icon;
GIcon* events_branch_single_event_icon = NULL;
VALA_EXTERN GIcon* events_branch_no_event_icon;
GIcon* events_branch_no_event_icon = NULL;
static gboolean events_branch__sort_ascending;
static gboolean events_branch__sort_ascending = FALSE;
static gpointer events_directory_entry_parent_class = NULL;
static SidebarExpandableEntryIface * events_directory_entry_sidebar_expandable_entry_parent_iface = NULL;
static gpointer events_master_directory_entry_parent_class = NULL;
static gint EventsYearDirectoryEntry_private_offset;
static gpointer events_year_directory_entry_parent_class = NULL;
static gint EventsMonthDirectoryEntry_private_offset;
static gpointer events_month_directory_entry_parent_class = NULL;
static gpointer events_undated_directory_entry_parent_class = NULL;
static gint EventsEventEntry_private_offset;
static gpointer events_event_entry_parent_class = NULL;
static SidebarRenameableEntryIface * events_event_entry_sidebar_renameable_entry_parent_iface = NULL;
static SidebarInternalDropTargetEntryIface * events_event_entry_sidebar_internal_drop_target_entry_parent_iface = NULL;
static gpointer events_no_event_entry_parent_class = NULL;

static void events_branch_on_events_added_removed (EventsBranch* self,
                                            GeeIterable* added,
                                            GeeIterable* removed);
static void _events_branch_on_events_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                              GeeIterable* added,
                                                                              GeeIterable* removed,
                                                                              gpointer self);
static void events_branch_on_events_altered (EventsBranch* self,
                                      GeeMap* altered);
static void _events_branch_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self);
static void events_branch_on_no_event_collection_altered (EventsBranch* self);
static void _events_branch_on_no_event_collection_altered_event_source_collection_no_event_collection_altered (EventSourceCollection* _sender,
                                                                                                        gpointer self);
static gint events_branch_event_year_comparator (SidebarEntry* a,
                                          SidebarEntry* b);
static gint _events_branch_event_year_comparator_gcompare_func (gconstpointer a,
                                                         gconstpointer b);
static void events_branch_add_event (EventsBranch* self,
                              Event* event);
static void events_branch_show_no_events (EventsBranch* self,
                                   gboolean show);
static void __lambda64_ (EventsBranch* self,
                  const gchar* key);
static void events_branch_set_sort_ascending (EventsBranch* self,
                                       gboolean value);
static void ___lambda64__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static gint events_branch_event_month_comparator (SidebarEntry* a,
                                           SidebarEntry* b);
static gint events_branch_event_comparator (SidebarEntry* a,
                                     SidebarEntry* b);
static gint events_branch_undated_event_comparator (SidebarEntry* a,
                                             SidebarEntry* b);
static void events_branch_remove_event (EventsBranch* self,
                                 Event* event);
static void events_branch_move_event (EventsBranch* self,
                               Event* event);
static void events_branch_add_undated_event (EventsBranch* self,
                                      Event* event);
static SidebarEntry* events_branch_find_event_month (EventsBranch* self,
                                              Event* event,
                                              GDateTime* event_tm,
                                              SidebarEntry** found_year);
static void events_branch_graft_event (EventsBranch* self,
                                SidebarEntry* parent,
                                Event* event,
                                GCompareFunc comparator);
static gint _events_branch_event_comparator_gcompare_func (gconstpointer a,
                                                    gconstpointer b);
static gint _events_branch_event_month_comparator_gcompare_func (gconstpointer a,
                                                          gconstpointer b);
static void events_branch_move_to_undated_event (EventsBranch* self,
                                          Event* event);
static void events_branch_reparent_event (EventsBranch* self,
                                   Event* event,
                                   SidebarEntry* new_parent);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static SidebarEntry* events_branch_find_event_year (EventsBranch* self,
                                             Event* event,
                                             GDateTime* event_tm);
static gboolean __lambda63_ (Block1Data* _data1_,
                      SidebarEntry* entry);
static gboolean ___lambda63__locator (gconstpointer item,
                               gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda62_ (Block2Data* _data2_,
                      SidebarEntry* entry);
static gboolean ___lambda62__locator (gconstpointer item,
                               gpointer self);
static gint _events_branch_undated_event_comparator_gcompare_func (gconstpointer a,
                                                            gconstpointer b);
static gboolean events_branch_get_sort_ascending (EventsBranch* self);
static GObject * events_branch_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void events_branch_finalize (GObject * obj);
static GType events_branch_get_type_once (void);
static void _vala_events_branch_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_events_branch_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static GIcon* events_directory_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static GIcon* events_directory_entry_real_get_sidebar_open_icon (EventsDirectoryEntry* self);
static GIcon* events_directory_entry_real_get_sidebar_closed_icon (EventsDirectoryEntry* self);
static gboolean events_directory_entry_real_expand_on_select (SidebarExpandableEntry* base);
static GType events_directory_entry_get_type_once (void);
static gchar* events_master_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static GIcon* events_master_directory_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static GIcon* events_master_directory_entry_real_get_sidebar_open_icon (EventsDirectoryEntry* base);
static GIcon* events_master_directory_entry_real_get_sidebar_closed_icon (EventsDirectoryEntry* base);
static Page* events_master_directory_entry_real_create_page (SidebarSimplePageEntry* base);
static GType events_master_directory_entry_get_type_once (void);
static gchar* events_year_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static Page* events_year_directory_entry_real_create_page (SidebarSimplePageEntry* base);
static void events_year_directory_entry_finalize (GObject * obj);
static GType events_year_directory_entry_get_type_once (void);
static gchar* events_month_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static Page* events_month_directory_entry_real_create_page (SidebarSimplePageEntry* base);
static void events_month_directory_entry_finalize (GObject * obj);
static GType events_month_directory_entry_get_type_once (void);
static gchar* events_undated_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static Page* events_undated_directory_entry_real_create_page (SidebarSimplePageEntry* base);
static GType events_undated_directory_entry_get_type_once (void);
static gchar* events_event_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static GIcon* events_event_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static Page* events_event_entry_real_create_page (SidebarSimplePageEntry* base);
static void events_event_entry_real_rename (SidebarRenameableEntry* base,
                                     const gchar* new_name);
static gboolean events_event_entry_real_internal_drop_received (SidebarInternalDropTargetEntry* base,
                                                         GeeList* media);
static gboolean events_event_entry_real_internal_drop_received_arbitrary (SidebarInternalDropTargetEntry* base,
                                                                   GtkSelectionData* data);
static void events_event_entry_finalize (GObject * obj);
static GType events_event_entry_get_type_once (void);
static gchar* events_no_event_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static GIcon* events_no_event_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static Page* events_no_event_entry_real_create_page (SidebarSimplePageEntry* base);
static GType events_no_event_entry_get_type_once (void);

static inline gpointer
events_branch_get_instance_private (EventsBranch* self)
{
	return G_STRUCT_MEMBER_P (self, EventsBranch_private_offset);
}

static void
_events_branch_on_events_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                         GeeIterable* added,
                                                                         GeeIterable* removed,
                                                                         gpointer self)
{
	events_branch_on_events_added_removed ((EventsBranch*) self, added, removed);
}

static void
_events_branch_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                GeeMap* items,
                                                                gpointer self)
{
	events_branch_on_events_altered ((EventsBranch*) self, items);
}

static void
_events_branch_on_no_event_collection_altered_event_source_collection_no_event_collection_altered (EventSourceCollection* _sender,
                                                                                                   gpointer self)
{
	events_branch_on_no_event_collection_altered ((EventsBranch*) self);
}

static gint
_events_branch_event_year_comparator_gcompare_func (gconstpointer a,
                                                    gconstpointer b)
{
	gint result;
	result = events_branch_event_year_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static void
__lambda64_ (EventsBranch* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "events-sort-ascending") == 0) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->ui_settings;
		events_branch_set_sort_ascending (self, g_settings_get_boolean (_tmp0_, "events-sort-ascending"));
	}
}

static void
___lambda64__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda64_ ((EventsBranch*) self, key);
}

EventsBranch*
events_branch_construct (GType object_type)
{
	EventsBranch * self = NULL;
	EventsMasterDirectoryEntry* _tmp0_;
	EventsMasterDirectoryEntry* _tmp1_;
	EventSourceCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	EventSourceCollection* _tmp16_;
	EventSourceCollection* _tmp17_;
	EventSourceCollection* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	_tmp0_ = events_master_directory_entry_new ();
	_tmp1_ = _tmp0_;
	self = (EventsBranch*) sidebar_branch_construct (object_type, (SidebarEntry*) _tmp1_, SIDEBAR_BRANCH_OPTIONS_STARTUP_EXPAND_TO_FIRST_CHILD, _events_branch_event_year_comparator_gcompare_func, NULL);
	_g_object_unref0 (_tmp1_);
	{
		GeeIterator* _object_it = NULL;
		EventSourceCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp2_ = event_global;
		_tmp3_ = data_collection_get_all ((DataCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_object_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			DataObject* object = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			DataObject* _tmp10_;
			_tmp7_ = _object_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _object_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			object = (DataObject*) _tmp9_;
			_tmp10_ = object;
			events_branch_add_event (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_EVENT, Event));
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp11_ = event_global;
	_tmp12_ = event_source_collection_get_no_event_objects (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_collection_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	events_branch_show_no_events (self, _tmp15_ > 0);
	_g_object_unref0 (_tmp13_);
	_tmp16_ = event_global;
	g_signal_connect_object ((DataCollection*) _tmp16_, "contents-altered", (GCallback) _events_branch_on_events_added_removed_data_collection_contents_altered, self, 0);
	_tmp17_ = event_global;
	g_signal_connect_object ((DataCollection*) _tmp17_, "items-altered", (GCallback) _events_branch_on_events_altered_data_collection_items_altered, self, 0);
	_tmp18_ = event_global;
	g_signal_connect_object (_tmp18_, "no-event-collection-altered", (GCallback) _events_branch_on_no_event_collection_altered_event_source_collection_no_event_collection_altered, self, 0);
	_tmp19_ = self->priv->ui_settings;
	g_signal_connect_object (_tmp19_, "changed", (GCallback) ___lambda64__g_settings_changed, self, 0);
	_tmp20_ = self->priv->ui_settings;
	events_branch_set_sort_ascending (self, g_settings_get_boolean (_tmp20_, "events-sort-ascending"));
	return self;
}

EventsBranch*
events_branch_new (void)
{
	return events_branch_construct (EVENTS_TYPE_BRANCH);
}

EventsMasterDirectoryEntry*
events_branch_get_master_entry (EventsBranch* self)
{
	SidebarEntry* _tmp0_;
	EventsMasterDirectoryEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sidebar_branch_get_root ((SidebarBranch*) self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, EVENTS_TYPE_MASTER_DIRECTORY_ENTRY, EventsMasterDirectoryEntry);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
events_branch_event_year_comparator (SidebarEntry* a,
                                     SidebarEntry* b)
{
	gint _result_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a == b) {
		result = 0;
		return result;
	}
	if (EVENTS_IS_UNDATED_DIRECTORY_ENTRY (a)) {
		if (EVENTS_IS_NO_EVENT_ENTRY (b)) {
			result = -1;
			return result;
		}
		result = 1;
		return result;
	} else {
		if (EVENTS_IS_UNDATED_DIRECTORY_ENTRY (b)) {
			if (EVENTS_IS_NO_EVENT_ENTRY (a)) {
				result = 1;
				return result;
			}
			result = -1;
			return result;
		}
	}
	if (EVENTS_IS_NO_EVENT_ENTRY (a)) {
		result = 1;
		return result;
	} else {
		if (EVENTS_IS_NO_EVENT_ENTRY (b)) {
			result = -1;
			return result;
		}
	}
	if (!events_branch__sort_ascending) {
		SidebarEntry* swap = NULL;
		SidebarEntry* _tmp0_;
		SidebarEntry* _tmp1_;
		_tmp0_ = _g_object_ref0 (a);
		swap = _tmp0_;
		a = b;
		_tmp1_ = swap;
		b = _tmp1_;
		_g_object_unref0 (swap);
	}
	_result_ = events_year_directory_entry_get_year (G_TYPE_CHECK_INSTANCE_CAST (a, EVENTS_TYPE_YEAR_DIRECTORY_ENTRY, EventsYearDirectoryEntry)) - events_year_directory_entry_get_year (G_TYPE_CHECK_INSTANCE_CAST (b, EVENTS_TYPE_YEAR_DIRECTORY_ENTRY, EventsYearDirectoryEntry));
	_vala_assert (_result_ != 0, "result != 0");
	result = _result_;
	return result;
}

static gint
events_branch_event_month_comparator (SidebarEntry* a,
                                      SidebarEntry* b)
{
	gint _result_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a == b) {
		result = 0;
		return result;
	}
	if (!events_branch__sort_ascending) {
		SidebarEntry* swap = NULL;
		SidebarEntry* _tmp0_;
		SidebarEntry* _tmp1_;
		_tmp0_ = _g_object_ref0 (a);
		swap = _tmp0_;
		a = b;
		_tmp1_ = swap;
		b = _tmp1_;
		_g_object_unref0 (swap);
	}
	_result_ = events_month_directory_entry_get_month (G_TYPE_CHECK_INSTANCE_CAST (a, EVENTS_TYPE_MONTH_DIRECTORY_ENTRY, EventsMonthDirectoryEntry)) - events_month_directory_entry_get_month (G_TYPE_CHECK_INSTANCE_CAST (b, EVENTS_TYPE_MONTH_DIRECTORY_ENTRY, EventsMonthDirectoryEntry));
	_vala_assert (_result_ != 0, "result != 0");
	result = _result_;
	return result;
}

static gint
events_branch_event_comparator (SidebarEntry* a,
                                SidebarEntry* b)
{
	gint64 _result_ = 0LL;
	Event* _tmp2_;
	Event* _tmp3_;
	Event* _tmp4_;
	Event* _tmp5_;
	gint64 _tmp6_;
	gint _tmp13_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a == b) {
		result = 0;
		return result;
	}
	if (!events_branch__sort_ascending) {
		SidebarEntry* swap = NULL;
		SidebarEntry* _tmp0_;
		SidebarEntry* _tmp1_;
		_tmp0_ = _g_object_ref0 (a);
		swap = _tmp0_;
		a = b;
		_tmp1_ = swap;
		b = _tmp1_;
		_g_object_unref0 (swap);
	}
	_tmp2_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (a, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (b, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
	_tmp5_ = _tmp4_;
	_tmp6_ = event_source_get_start_time ((EventSource*) _tmp3_) - event_source_get_start_time ((EventSource*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_result_ = _tmp6_;
	if (_result_ == ((gint64) 0)) {
		Event* _tmp7_;
		Event* _tmp8_;
		EventID _tmp9_ = {0};
		Event* _tmp10_;
		Event* _tmp11_;
		EventID _tmp12_ = {0};
		_tmp7_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (a, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
		_tmp8_ = _tmp7_;
		event_get_event_id (_tmp8_, &_tmp9_);
		_tmp10_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (b, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
		_tmp11_ = _tmp10_;
		event_get_event_id (_tmp11_, &_tmp12_);
		_result_ = _tmp9_.id - _tmp12_.id;
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp8_);
	}
	_vala_assert (_result_ != ((gint64) 0), "result != 0");
	if (_result_ < ((gint64) 0)) {
		_tmp13_ = -1;
	} else {
		_tmp13_ = 1;
	}
	result = _tmp13_;
	return result;
}

static gint
events_branch_undated_event_comparator (SidebarEntry* a,
                                        SidebarEntry* b)
{
	gint ret = 0;
	Event* _tmp2_;
	Event* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Event* _tmp6_;
	Event* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a == b) {
		result = 0;
		return result;
	}
	if (!events_branch__sort_ascending) {
		SidebarEntry* swap = NULL;
		SidebarEntry* _tmp0_;
		SidebarEntry* _tmp1_;
		_tmp0_ = _g_object_ref0 (a);
		swap = _tmp0_;
		a = b;
		_tmp1_ = swap;
		b = _tmp1_;
		_g_object_unref0 (swap);
	}
	_tmp2_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (a, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = data_object_get_name ((DataObject*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (b, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
	_tmp7_ = _tmp6_;
	_tmp8_ = data_object_get_name ((DataObject*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_collate (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	ret = _tmp10_;
	if (ret == 0) {
		Event* _tmp11_;
		Event* _tmp12_;
		Event* _tmp13_;
		Event* _tmp14_;
		_tmp11_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (b, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
		_tmp12_ = _tmp11_;
		_tmp13_ = events_event_entry_get_event (G_TYPE_CHECK_INSTANCE_CAST (a, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry));
		_tmp14_ = _tmp13_;
		ret = (gint) (data_source_get_instance_id ((DataSource*) _tmp12_) - data_source_get_instance_id ((DataSource*) _tmp14_));
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (_tmp12_);
	}
	result = ret;
	return result;
}

EventsEventEntry*
events_branch_get_entry_for_event (EventsBranch* self,
                                   Event* event)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	EventsEventEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = self->priv->entry_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, event);
	result = (EventsEventEntry*) _tmp1_;
	return result;
}

static void
events_branch_on_events_added_removed (EventsBranch* self,
                                       GeeIterable* added,
                                       GeeIterable* removed)
{
	g_return_if_fail (self != NULL);
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				DataObject* _tmp4_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				events_branch_add_event (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_EVENT, Event));
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp5_;
			_tmp5_ = gee_iterable_iterator (removed);
			_object_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				DataObject* object = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				DataObject* _tmp9_;
				_tmp6_ = _object_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _object_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				object = (DataObject*) _tmp8_;
				_tmp9_ = object;
				events_branch_remove_event (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_EVENT, Event));
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
}

static void
events_branch_on_events_altered (EventsBranch* self,
                                 GeeMap* altered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (altered != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (altered);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Event* event = NULL;
			DataObject* _tmp8_;
			Event* _tmp9_;
			Alteration* alteration = NULL;
			DataObject* _tmp10_;
			gpointer _tmp11_;
			Alteration* _tmp12_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_EVENT, Event));
			event = _tmp9_;
			_tmp10_ = object;
			_tmp11_ = gee_map_get (altered, _tmp10_);
			alteration = (Alteration*) _tmp11_;
			_tmp12_ = alteration;
			if (alteration_has_detail (_tmp12_, "metadata", "time")) {
				Event* _tmp13_;
				_tmp13_ = event;
				events_branch_move_event (self, _tmp13_);
			} else {
				Alteration* _tmp14_;
				_tmp14_ = alteration;
				if (alteration_has_detail (_tmp14_, "metadata", "name")) {
					EventsEventEntry* entry = NULL;
					GeeHashMap* _tmp15_;
					Event* _tmp16_;
					gpointer _tmp17_;
					EventsEventEntry* _tmp18_;
					EventsEventEntry* _tmp19_;
					Event* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					EventsEventEntry* _tmp23_;
					Event* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp15_ = self->priv->entry_map;
					_tmp16_ = event;
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
					entry = (EventsEventEntry*) _tmp17_;
					_tmp18_ = entry;
					_vala_assert (_tmp18_ != NULL, "entry != null");
					_tmp19_ = entry;
					_tmp20_ = event;
					_tmp21_ = data_object_get_name ((DataObject*) _tmp20_);
					_tmp22_ = _tmp21_;
					g_signal_emit_by_name ((SidebarRenameableEntry*) _tmp19_, "sidebar-name-changed", _tmp22_);
					_g_free0 (_tmp22_);
					_tmp23_ = entry;
					_tmp24_ = event;
					_tmp25_ = data_object_get_name ((DataObject*) _tmp24_);
					_tmp26_ = _tmp25_;
					g_signal_emit_by_name ((SidebarEntry*) _tmp23_, "sidebar-tooltip-changed", _tmp26_);
					_g_free0 (_tmp26_);
					_g_object_unref0 (entry);
				}
			}
			_alteration_unref0 (alteration);
			_g_object_unref0 (event);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
events_branch_on_no_event_collection_altered (EventsBranch* self)
{
	EventSourceCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = event_global;
	_tmp1_ = event_source_collection_get_no_event_objects (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	events_branch_show_no_events (self, _tmp4_ > 0);
	_g_object_unref0 (_tmp2_);
}

static gint
_events_branch_event_comparator_gcompare_func (gconstpointer a,
                                               gconstpointer b)
{
	gint result;
	result = events_branch_event_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static gint
_events_branch_event_month_comparator_gcompare_func (gconstpointer a,
                                                     gconstpointer b)
{
	gint result;
	result = events_branch_event_month_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static void
events_branch_add_event (EventsBranch* self,
                         Event* event)
{
	gint64 event_time = 0LL;
	GDateTime* event_tm = NULL;
	GDateTime* _tmp0_;
	SidebarEntry* year = NULL;
	SidebarEntry* month = NULL;
	GDateTime* _tmp1_;
	SidebarEntry* _tmp2_ = NULL;
	SidebarEntry* _tmp3_;
	SidebarEntry* _tmp4_;
	SidebarEntry* _tmp6_;
	GDateTime* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GDateTime* _tmp18_;
	EventsMonthDirectoryEntry* _tmp19_;
	SidebarEntry* _tmp20_;
	SidebarEntry* _tmp21_;
	SidebarEntry* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	event_time = event_source_get_start_time ((EventSource*) event);
	if (event_time == ((gint64) 0)) {
		events_branch_add_undated_event (self, event);
		return;
	}
	_tmp0_ = g_date_time_new_from_unix_local (event_time);
	event_tm = _tmp0_;
	_tmp1_ = event_tm;
	_tmp3_ = events_branch_find_event_month (self, event, _tmp1_, &_tmp2_);
	_g_object_unref0 (year);
	year = _tmp2_;
	month = _tmp3_;
	_tmp4_ = month;
	if (_tmp4_ != NULL) {
		SidebarEntry* _tmp5_;
		_tmp5_ = month;
		events_branch_graft_event (self, _tmp5_, event, _events_branch_event_comparator_gcompare_func);
		_g_object_unref0 (month);
		_g_object_unref0 (year);
		_g_date_time_unref0 (event_tm);
		return;
	}
	_tmp6_ = year;
	if (_tmp6_ == NULL) {
		GDateTime* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GDateTime* _tmp10_;
		EventsYearDirectoryEntry* _tmp11_;
		SidebarEntry* _tmp12_;
		SidebarEntry* _tmp13_;
		SidebarEntry* _tmp14_;
		_tmp7_ = event_tm;
		_tmp8_ = g_date_time_format (_tmp7_, SUB_EVENTS_DIRECTORY_PAGE_YEAR_FORMAT);
		_tmp9_ = _tmp8_;
		_tmp10_ = event_tm;
		_tmp11_ = events_year_directory_entry_new (_tmp9_, _tmp10_);
		_g_object_unref0 (year);
		year = (SidebarEntry*) _tmp11_;
		_g_free0 (_tmp9_);
		_tmp12_ = sidebar_branch_get_root ((SidebarBranch*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = year;
		sidebar_branch_graft ((SidebarBranch*) self, _tmp13_, _tmp14_, _events_branch_event_month_comparator_gcompare_func);
		_g_object_unref0 (_tmp13_);
	}
	_tmp15_ = event_tm;
	_tmp16_ = g_date_time_format (_tmp15_, SUB_EVENTS_DIRECTORY_PAGE_MONTH_FORMAT);
	_tmp17_ = _tmp16_;
	_tmp18_ = event_tm;
	_tmp19_ = events_month_directory_entry_new (_tmp17_, _tmp18_);
	_g_object_unref0 (month);
	month = (SidebarEntry*) _tmp19_;
	_g_free0 (_tmp17_);
	_tmp20_ = year;
	_tmp21_ = month;
	sidebar_branch_graft ((SidebarBranch*) self, _tmp20_, _tmp21_, _events_branch_event_comparator_gcompare_func);
	_tmp22_ = month;
	events_branch_graft_event (self, _tmp22_, event, _events_branch_event_comparator_gcompare_func);
	_g_object_unref0 (month);
	_g_object_unref0 (year);
	_g_date_time_unref0 (event_tm);
}

static void
events_branch_move_event (EventsBranch* self,
                          Event* event)
{
	gint64 event_time = 0LL;
	GDateTime* event_tm = NULL;
	GDateTime* _tmp0_;
	SidebarEntry* year = NULL;
	SidebarEntry* month = NULL;
	GDateTime* _tmp1_;
	SidebarEntry* _tmp2_ = NULL;
	SidebarEntry* _tmp3_;
	SidebarEntry* _tmp4_;
	SidebarEntry* _tmp13_;
	SidebarEntry* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	event_time = event_source_get_start_time ((EventSource*) event);
	if (event_time == ((gint64) 0)) {
		events_branch_move_to_undated_event (self, event);
		return;
	}
	_tmp0_ = g_date_time_new_from_unix_local (event_time);
	event_tm = _tmp0_;
	_tmp1_ = event_tm;
	_tmp3_ = events_branch_find_event_month (self, event, _tmp1_, &_tmp2_);
	_g_object_unref0 (year);
	year = _tmp2_;
	month = _tmp3_;
	_tmp4_ = year;
	if (_tmp4_ == NULL) {
		GDateTime* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GDateTime* _tmp8_;
		EventsYearDirectoryEntry* _tmp9_;
		SidebarEntry* _tmp10_;
		SidebarEntry* _tmp11_;
		SidebarEntry* _tmp12_;
		_tmp5_ = event_tm;
		_tmp6_ = g_date_time_format (_tmp5_, SUB_EVENTS_DIRECTORY_PAGE_YEAR_FORMAT);
		_tmp7_ = _tmp6_;
		_tmp8_ = event_tm;
		_tmp9_ = events_year_directory_entry_new (_tmp7_, _tmp8_);
		_g_object_unref0 (year);
		year = (SidebarEntry*) _tmp9_;
		_g_free0 (_tmp7_);
		_tmp10_ = sidebar_branch_get_root ((SidebarBranch*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = year;
		sidebar_branch_graft ((SidebarBranch*) self, _tmp11_, _tmp12_, _events_branch_event_month_comparator_gcompare_func);
		_g_object_unref0 (_tmp11_);
	}
	_tmp13_ = month;
	if (_tmp13_ == NULL) {
		GDateTime* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GDateTime* _tmp17_;
		EventsMonthDirectoryEntry* _tmp18_;
		SidebarEntry* _tmp19_;
		SidebarEntry* _tmp20_;
		_tmp14_ = event_tm;
		_tmp15_ = g_date_time_format (_tmp14_, SUB_EVENTS_DIRECTORY_PAGE_MONTH_FORMAT);
		_tmp16_ = _tmp15_;
		_tmp17_ = event_tm;
		_tmp18_ = events_month_directory_entry_new (_tmp16_, _tmp17_);
		_g_object_unref0 (month);
		month = (SidebarEntry*) _tmp18_;
		_g_free0 (_tmp16_);
		_tmp19_ = year;
		_tmp20_ = month;
		sidebar_branch_graft ((SidebarBranch*) self, _tmp19_, _tmp20_, _events_branch_event_comparator_gcompare_func);
	}
	_tmp21_ = month;
	events_branch_reparent_event (self, event, _tmp21_);
	_g_object_unref0 (month);
	_g_object_unref0 (year);
	_g_date_time_unref0 (event_tm);
}

static void
events_branch_remove_event (EventsBranch* self,
                            Event* event)
{
	SidebarEntry* entry = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	SidebarEntry* parent = NULL;
	SidebarEntry* _tmp3_;
	SidebarEntry* _tmp4_;
	SidebarEntry* _tmp5_;
	SidebarEntry* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->entry_map;
	_tmp2_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, event, &_tmp1_);
	_g_object_unref0 (entry);
	entry = (SidebarEntry*) ((EventsEventEntry*) _tmp1_);
	removed = _tmp2_;
	_vala_assert (removed, "removed");
	_tmp3_ = entry;
	_tmp4_ = sidebar_branch_get_parent ((SidebarBranch*) self, _tmp3_);
	parent = _tmp4_;
	_tmp5_ = parent;
	_vala_assert (_tmp5_ != NULL, "parent != null");
	_tmp6_ = entry;
	sidebar_branch_prune ((SidebarBranch*) self, _tmp6_);
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		SidebarEntry* _tmp8_;
		SidebarEntry* grandparent = NULL;
		SidebarEntry* _tmp12_;
		SidebarEntry* _tmp13_;
		SidebarEntry* _tmp14_;
		SidebarEntry* _tmp15_;
		SidebarEntry* _tmp16_;
		SidebarEntry* _tmp17_;
		_tmp8_ = parent;
		if (sidebar_branch_get_child_count ((SidebarBranch*) self, _tmp8_) == 0) {
			SidebarEntry* _tmp9_;
			SidebarEntry* _tmp10_;
			SidebarEntry* _tmp11_;
			_tmp9_ = parent;
			_tmp10_ = sidebar_branch_get_root ((SidebarBranch*) self);
			_tmp11_ = _tmp10_;
			_tmp7_ = _tmp9_ != _tmp11_;
			_g_object_unref0 (_tmp11_);
		} else {
			_tmp7_ = FALSE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp12_ = parent;
		_tmp13_ = sidebar_branch_get_parent ((SidebarBranch*) self, _tmp12_);
		grandparent = _tmp13_;
		_tmp14_ = grandparent;
		_vala_assert (_tmp14_ != NULL, "grandparent != null");
		_tmp15_ = parent;
		sidebar_branch_prune ((SidebarBranch*) self, _tmp15_);
		_tmp16_ = grandparent;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_g_object_unref0 (parent);
		parent = _tmp17_;
		_g_object_unref0 (grandparent);
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (entry);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		EventsBranch* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda63_ (Block1Data* _data1_,
             SidebarEntry* entry)
{
	EventsBranch* self;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	result = events_month_directory_entry_get_month (G_TYPE_CHECK_INSTANCE_CAST (entry, EVENTS_TYPE_MONTH_DIRECTORY_ENTRY, EventsMonthDirectoryEntry)) == _data1_->event_month;
	return result;
}

static gboolean
___lambda63__locator (gconstpointer item,
                      gpointer self)
{
	gboolean result;
	result = __lambda63_ (self, (SidebarEntry*) item);
	return result;
}

static SidebarEntry*
events_branch_find_event_month (EventsBranch* self,
                                Event* event,
                                GDateTime* event_tm,
                                SidebarEntry** found_year)
{
	SidebarEntry* _vala_found_year = NULL;
	Block1Data* _data1_;
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	SidebarEntry* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (event_tm != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = events_branch_find_event_year (self, event, event_tm);
	_g_object_unref0 (_vala_found_year);
	_vala_found_year = _tmp0_;
	_tmp1_ = _vala_found_year;
	if (_tmp1_ == NULL) {
		result = NULL;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		if (found_year) {
			*found_year = _vala_found_year;
		} else {
			_g_object_unref0 (_vala_found_year);
		}
		return result;
	}
	_data1_->event_month = g_date_time_get_month (event_tm) + 1;
	_tmp2_ = _vala_found_year;
	_tmp3_ = sidebar_branch_find_first_child ((SidebarBranch*) self, _tmp2_, ___lambda63__locator, _data1_);
	result = _tmp3_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	if (found_year) {
		*found_year = _vala_found_year;
	} else {
		_g_object_unref0 (_vala_found_year);
	}
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		EventsBranch* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda62_ (Block2Data* _data2_,
             SidebarEntry* entry)
{
	EventsBranch* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	if (EVENTS_IS_UNDATED_DIRECTORY_ENTRY (entry)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = EVENTS_IS_NO_EVENT_ENTRY (entry);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		result = events_year_directory_entry_get_year (G_TYPE_CHECK_INSTANCE_CAST (entry, EVENTS_TYPE_YEAR_DIRECTORY_ENTRY, EventsYearDirectoryEntry)) == _data2_->event_year;
		return result;
	}
}

static gboolean
___lambda62__locator (gconstpointer item,
                      gpointer self)
{
	gboolean result;
	result = __lambda62_ (self, (SidebarEntry*) item);
	return result;
}

static SidebarEntry*
events_branch_find_event_year (EventsBranch* self,
                               Event* event,
                               GDateTime* event_tm)
{
	Block2Data* _data2_;
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	SidebarEntry* _tmp2_;
	SidebarEntry* _tmp3_;
	SidebarEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (event_tm != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->event_year = g_date_time_get_year (event_tm);
	_tmp0_ = sidebar_branch_get_root ((SidebarBranch*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_branch_find_first_child ((SidebarBranch*) self, _tmp1_, ___lambda62__locator, _data2_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gint
_events_branch_undated_event_comparator_gcompare_func (gconstpointer a,
                                                       gconstpointer b)
{
	gint result;
	result = events_branch_undated_event_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static void
events_branch_add_undated_event (EventsBranch* self,
                                 Event* event)
{
	EventsUndatedDirectoryEntry* _tmp0_;
	EventsUndatedDirectoryEntry* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->undated_entry;
	if (!sidebar_branch_has_entry ((SidebarBranch*) self, (SidebarEntry*) _tmp0_)) {
		SidebarEntry* _tmp1_;
		SidebarEntry* _tmp2_;
		EventsUndatedDirectoryEntry* _tmp3_;
		_tmp1_ = sidebar_branch_get_root ((SidebarBranch*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->undated_entry;
		sidebar_branch_graft ((SidebarBranch*) self, _tmp2_, (SidebarEntry*) _tmp3_, _events_branch_undated_event_comparator_gcompare_func);
		_g_object_unref0 (_tmp2_);
	}
	_tmp4_ = self->priv->undated_entry;
	events_branch_graft_event (self, (SidebarEntry*) _tmp4_, event, NULL);
}

static void
events_branch_move_to_undated_event (EventsBranch* self,
                                     Event* event)
{
	EventsUndatedDirectoryEntry* _tmp0_;
	EventsUndatedDirectoryEntry* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->undated_entry;
	if (!sidebar_branch_has_entry ((SidebarBranch*) self, (SidebarEntry*) _tmp0_)) {
		SidebarEntry* _tmp1_;
		SidebarEntry* _tmp2_;
		EventsUndatedDirectoryEntry* _tmp3_;
		_tmp1_ = sidebar_branch_get_root ((SidebarBranch*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->undated_entry;
		sidebar_branch_graft ((SidebarBranch*) self, _tmp2_, (SidebarEntry*) _tmp3_, NULL);
		_g_object_unref0 (_tmp2_);
	}
	_tmp4_ = self->priv->undated_entry;
	events_branch_reparent_event (self, event, (SidebarEntry*) _tmp4_);
}

static void
events_branch_graft_event (EventsBranch* self,
                           SidebarEntry* parent,
                           Event* event,
                           GCompareFunc comparator)
{
	EventsEventEntry* entry = NULL;
	EventsEventEntry* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = events_event_entry_new (event);
	entry = _tmp0_;
	_tmp1_ = self->priv->entry_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, event, entry);
	sidebar_branch_graft ((SidebarBranch*) self, parent, (SidebarEntry*) entry, comparator);
	_g_object_unref0 (entry);
}

static void
events_branch_reparent_event (EventsBranch* self,
                              Event* event,
                              SidebarEntry* new_parent)
{
	EventsEventEntry* entry = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	EventsEventEntry* _tmp2_;
	SidebarEntry* old_parent = NULL;
	EventsEventEntry* _tmp3_;
	SidebarEntry* _tmp4_;
	SidebarEntry* _tmp5_;
	EventsEventEntry* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (new_parent != NULL);
	_tmp0_ = self->priv->entry_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, event);
	entry = (EventsEventEntry*) _tmp1_;
	_tmp2_ = entry;
	_vala_assert (_tmp2_ != NULL, "entry != null");
	_tmp3_ = entry;
	_tmp4_ = sidebar_branch_get_parent ((SidebarBranch*) self, (SidebarEntry*) _tmp3_);
	old_parent = _tmp4_;
	_tmp5_ = old_parent;
	_vala_assert (_tmp5_ != NULL, "old_parent != null");
	_tmp6_ = entry;
	sidebar_branch_reparent ((SidebarBranch*) self, new_parent, (SidebarEntry*) _tmp6_);
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		SidebarEntry* _tmp8_;
		SidebarEntry* grandparent = NULL;
		SidebarEntry* _tmp12_;
		SidebarEntry* _tmp13_;
		SidebarEntry* _tmp14_;
		SidebarEntry* _tmp15_;
		SidebarEntry* _tmp16_;
		SidebarEntry* _tmp17_;
		_tmp8_ = old_parent;
		if (sidebar_branch_get_child_count ((SidebarBranch*) self, _tmp8_) == 0) {
			SidebarEntry* _tmp9_;
			SidebarEntry* _tmp10_;
			SidebarEntry* _tmp11_;
			_tmp9_ = old_parent;
			_tmp10_ = sidebar_branch_get_root ((SidebarBranch*) self);
			_tmp11_ = _tmp10_;
			_tmp7_ = _tmp9_ != _tmp11_;
			_g_object_unref0 (_tmp11_);
		} else {
			_tmp7_ = FALSE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp12_ = old_parent;
		_tmp13_ = sidebar_branch_get_parent ((SidebarBranch*) self, _tmp12_);
		grandparent = _tmp13_;
		_tmp14_ = grandparent;
		_vala_assert (_tmp14_ != NULL, "grandparent != null");
		_tmp15_ = old_parent;
		sidebar_branch_prune ((SidebarBranch*) self, _tmp15_);
		_tmp16_ = grandparent;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_g_object_unref0 (old_parent);
		old_parent = _tmp17_;
		_g_object_unref0 (grandparent);
	}
	_g_object_unref0 (old_parent);
	_g_object_unref0 (entry);
}

static void
events_branch_show_no_events (EventsBranch* self,
                              gboolean show)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (show) {
		EventsNoEventEntry* _tmp1_;
		_tmp1_ = self->priv->no_event_entry;
		_tmp0_ = !sidebar_branch_has_entry ((SidebarBranch*) self, (SidebarEntry*) _tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SidebarEntry* _tmp2_;
		SidebarEntry* _tmp3_;
		EventsNoEventEntry* _tmp4_;
		_tmp2_ = sidebar_branch_get_root ((SidebarBranch*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->no_event_entry;
		sidebar_branch_graft ((SidebarBranch*) self, _tmp3_, (SidebarEntry*) _tmp4_, NULL);
		_g_object_unref0 (_tmp3_);
	} else {
		gboolean _tmp5_ = FALSE;
		if (!show) {
			EventsNoEventEntry* _tmp6_;
			_tmp6_ = self->priv->no_event_entry;
			_tmp5_ = sidebar_branch_has_entry ((SidebarBranch*) self, (SidebarEntry*) _tmp6_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			EventsNoEventEntry* _tmp7_;
			_tmp7_ = self->priv->no_event_entry;
			sidebar_branch_prune ((SidebarBranch*) self, (SidebarEntry*) _tmp7_);
		}
	}
}

static gboolean
events_branch_get_sort_ascending (EventsBranch* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = events_branch__sort_ascending;
	return result;
}

static void
events_branch_set_sort_ascending (EventsBranch* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	events_branch__sort_ascending = value;
	sidebar_branch_reorder_all ((SidebarBranch*) self);
}

static GObject *
events_branch_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	EventsBranch * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (events_branch_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EVENTS_TYPE_BRANCH, EventsBranch);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_UI_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp0_;
	return obj;
}

static void
events_branch_base_init (EventsBranchClass * klass)
{
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	GThemedIcon* _tmp4_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_FOLDER_OPEN);
	_g_object_unref0 (events_branch_open_icon);
	events_branch_open_icon = (GIcon*) _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_FOLDER_CLOSED);
	_g_object_unref0 (events_branch_closed_icon);
	events_branch_closed_icon = (GIcon*) _tmp1_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_EVENTS);
	_g_object_unref0 (events_branch_events_icon);
	events_branch_events_icon = (GIcon*) _tmp2_;
	_tmp3_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_ONE_EVENT);
	_g_object_unref0 (events_branch_single_event_icon);
	events_branch_single_event_icon = (GIcon*) _tmp3_;
	_tmp4_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_NO_EVENT);
	_g_object_unref0 (events_branch_no_event_icon);
	events_branch_no_event_icon = (GIcon*) _tmp4_;
}

static void
events_branch_class_init (EventsBranchClass * klass,
                          gpointer klass_data)
{
	events_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EventsBranch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_events_branch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_events_branch_set_property;
	G_OBJECT_CLASS (klass)->constructor = events_branch_constructor;
	G_OBJECT_CLASS (klass)->finalize = events_branch_finalize;
}

static void
events_branch_instance_init (EventsBranch * self,
                             gpointer klass)
{
	GeeHashMap* _tmp0_;
	EventsUndatedDirectoryEntry* _tmp1_;
	EventsNoEventEntry* _tmp2_;
	self->priv = events_branch_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_EVENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, EVENTS_TYPE_EVENT_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->entry_map = _tmp0_;
	_tmp1_ = events_undated_directory_entry_new ();
	self->priv->undated_entry = _tmp1_;
	_tmp2_ = events_no_event_entry_new ();
	self->priv->no_event_entry = _tmp2_;
}

static void
events_branch_finalize (GObject * obj)
{
	EventsBranch * self;
	EventSourceCollection* _tmp0_;
	guint _tmp1_;
	EventSourceCollection* _tmp2_;
	guint _tmp3_;
	EventSourceCollection* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EVENTS_TYPE_BRANCH, EventsBranch);
	_tmp0_ = event_global;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _events_branch_on_events_added_removed_data_collection_contents_altered, self);
	_tmp2_ = event_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _events_branch_on_events_altered_data_collection_items_altered, self);
	_tmp4_ = event_global;
	g_signal_parse_name ("no-event-collection-altered", TYPE_EVENT_SOURCE_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _events_branch_on_no_event_collection_altered_event_source_collection_no_event_collection_altered, self);
	_g_object_unref0 (self->priv->entry_map);
	_g_object_unref0 (self->priv->undated_entry);
	_g_object_unref0 (self->priv->no_event_entry);
	_g_object_unref0 (self->priv->ui_settings);
	G_OBJECT_CLASS (events_branch_parent_class)->finalize (obj);
}

static GType
events_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsBranchClass), (GBaseInitFunc) events_branch_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsBranch), 0, (GInstanceInitFunc) events_branch_instance_init, NULL };
	GType events_branch_type_id;
	events_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "EventsBranch", &g_define_type_info, 0);
	EventsBranch_private_offset = g_type_add_instance_private (events_branch_type_id, sizeof (EventsBranchPrivate));
	return events_branch_type_id;
}

GType
events_branch_get_type (void)
{
	static volatile gsize events_branch_type_id__once = 0;
	if (g_once_init_enter (&events_branch_type_id__once)) {
		GType events_branch_type_id;
		events_branch_type_id = events_branch_get_type_once ();
		g_once_init_leave (&events_branch_type_id__once, events_branch_type_id);
	}
	return events_branch_type_id__once;
}

static void
_vala_events_branch_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	EventsBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EVENTS_TYPE_BRANCH, EventsBranch);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_events_branch_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	EventsBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EVENTS_TYPE_BRANCH, EventsBranch);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

EventsDirectoryEntry*
events_directory_entry_construct (GType object_type)
{
	EventsDirectoryEntry * self = NULL;
	self = (EventsDirectoryEntry*) sidebar_simple_page_entry_construct (object_type);
	return self;
}

static GIcon*
events_directory_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	EventsDirectoryEntry * self;
	GIcon* result;
	self = (EventsDirectoryEntry*) base;
	result = NULL;
	return result;
}

static GIcon*
events_directory_entry_real_get_sidebar_open_icon (EventsDirectoryEntry* self)
{
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	_tmp0_ = events_branch_open_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GIcon*
events_directory_entry_get_sidebar_open_icon (EventsDirectoryEntry* self)
{
	EventsDirectoryEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = EVENTS_DIRECTORY_ENTRY_GET_CLASS (self);
	if (_klass_->get_sidebar_open_icon) {
		return _klass_->get_sidebar_open_icon (self);
	}
	return NULL;
}

static GIcon*
events_directory_entry_real_get_sidebar_closed_icon (EventsDirectoryEntry* self)
{
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	_tmp0_ = events_branch_closed_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GIcon*
events_directory_entry_get_sidebar_closed_icon (EventsDirectoryEntry* self)
{
	EventsDirectoryEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = EVENTS_DIRECTORY_ENTRY_GET_CLASS (self);
	if (_klass_->get_sidebar_closed_icon) {
		return _klass_->get_sidebar_closed_icon (self);
	}
	return NULL;
}

static gboolean
events_directory_entry_real_expand_on_select (SidebarExpandableEntry* base)
{
	EventsDirectoryEntry * self;
	gboolean result;
	self = (EventsDirectoryEntry*) base;
	result = TRUE;
	return result;
}

static void
events_directory_entry_class_init (EventsDirectoryEntryClass * klass,
                                   gpointer klass_data)
{
	events_directory_entry_parent_class = g_type_class_peek_parent (klass);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (GIcon* (*) (SidebarSimplePageEntry*)) events_directory_entry_real_get_sidebar_icon;
	((EventsDirectoryEntryClass *) klass)->get_sidebar_open_icon = (GIcon* (*) (EventsDirectoryEntry*)) events_directory_entry_real_get_sidebar_open_icon;
	((EventsDirectoryEntryClass *) klass)->get_sidebar_closed_icon = (GIcon* (*) (EventsDirectoryEntry*)) events_directory_entry_real_get_sidebar_closed_icon;
}

static void
events_directory_entry_sidebar_expandable_entry_interface_init (SidebarExpandableEntryIface * iface,
                                                                gpointer iface_data)
{
	events_directory_entry_sidebar_expandable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_sidebar_open_icon = (GIcon* (*) (SidebarExpandableEntry*)) events_directory_entry_get_sidebar_open_icon;
	iface->get_sidebar_closed_icon = (GIcon* (*) (SidebarExpandableEntry*)) events_directory_entry_get_sidebar_closed_icon;
	iface->expand_on_select = (gboolean (*) (SidebarExpandableEntry*)) events_directory_entry_real_expand_on_select;
}

static void
events_directory_entry_instance_init (EventsDirectoryEntry * self,
                                      gpointer klass)
{
}

static GType
events_directory_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsDirectoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_directory_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsDirectoryEntry), 0, (GInstanceInitFunc) events_directory_entry_instance_init, NULL };
	static const GInterfaceInfo sidebar_expandable_entry_info = { (GInterfaceInitFunc) events_directory_entry_sidebar_expandable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType events_directory_entry_type_id;
	events_directory_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "EventsDirectoryEntry", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (events_directory_entry_type_id, SIDEBAR_TYPE_EXPANDABLE_ENTRY, &sidebar_expandable_entry_info);
	return events_directory_entry_type_id;
}

GType
events_directory_entry_get_type (void)
{
	static volatile gsize events_directory_entry_type_id__once = 0;
	if (g_once_init_enter (&events_directory_entry_type_id__once)) {
		GType events_directory_entry_type_id;
		events_directory_entry_type_id = events_directory_entry_get_type_once ();
		g_once_init_leave (&events_directory_entry_type_id__once, events_directory_entry_type_id);
	}
	return events_directory_entry_type_id__once;
}

EventsMasterDirectoryEntry*
events_master_directory_entry_construct (GType object_type)
{
	EventsMasterDirectoryEntry * self = NULL;
	self = (EventsMasterDirectoryEntry*) events_directory_entry_construct (object_type);
	return self;
}

EventsMasterDirectoryEntry*
events_master_directory_entry_new (void)
{
	return events_master_directory_entry_construct (EVENTS_TYPE_MASTER_DIRECTORY_ENTRY);
}

static gchar*
events_master_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	EventsMasterDirectoryEntry * self;
	gchar* _tmp0_;
	gchar* result;
	self = (EventsMasterDirectoryEntry*) base;
	_tmp0_ = g_strdup (MASTER_EVENTS_DIRECTORY_PAGE_NAME);
	result = _tmp0_;
	return result;
}

static GIcon*
events_master_directory_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	EventsMasterDirectoryEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (EventsMasterDirectoryEntry*) base;
	_tmp0_ = events_branch_events_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
events_master_directory_entry_real_get_sidebar_open_icon (EventsDirectoryEntry* base)
{
	EventsMasterDirectoryEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (EventsMasterDirectoryEntry*) base;
	_tmp0_ = events_branch_events_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
events_master_directory_entry_real_get_sidebar_closed_icon (EventsDirectoryEntry* base)
{
	EventsMasterDirectoryEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (EventsMasterDirectoryEntry*) base;
	_tmp0_ = events_branch_events_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Page*
events_master_directory_entry_real_create_page (SidebarSimplePageEntry* base)
{
	EventsMasterDirectoryEntry * self;
	MasterEventsDirectoryPage* _tmp0_;
	Page* result;
	self = (EventsMasterDirectoryEntry*) base;
	_tmp0_ = master_events_directory_page_new ();
	g_object_ref_sink (_tmp0_);
	result = (Page*) _tmp0_;
	return result;
}

static void
events_master_directory_entry_class_init (EventsMasterDirectoryEntryClass * klass,
                                          gpointer klass_data)
{
	events_master_directory_entry_parent_class = g_type_class_peek_parent (klass);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) events_master_directory_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (GIcon* (*) (SidebarSimplePageEntry*)) events_master_directory_entry_real_get_sidebar_icon;
	((EventsDirectoryEntryClass *) klass)->get_sidebar_open_icon = (GIcon* (*) (EventsDirectoryEntry*)) events_master_directory_entry_real_get_sidebar_open_icon;
	((EventsDirectoryEntryClass *) klass)->get_sidebar_closed_icon = (GIcon* (*) (EventsDirectoryEntry*)) events_master_directory_entry_real_get_sidebar_closed_icon;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) events_master_directory_entry_real_create_page;
}

static void
events_master_directory_entry_instance_init (EventsMasterDirectoryEntry * self,
                                             gpointer klass)
{
}

static GType
events_master_directory_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsMasterDirectoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_master_directory_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsMasterDirectoryEntry), 0, (GInstanceInitFunc) events_master_directory_entry_instance_init, NULL };
	GType events_master_directory_entry_type_id;
	events_master_directory_entry_type_id = g_type_register_static (EVENTS_TYPE_DIRECTORY_ENTRY, "EventsMasterDirectoryEntry", &g_define_type_info, 0);
	return events_master_directory_entry_type_id;
}

GType
events_master_directory_entry_get_type (void)
{
	static volatile gsize events_master_directory_entry_type_id__once = 0;
	if (g_once_init_enter (&events_master_directory_entry_type_id__once)) {
		GType events_master_directory_entry_type_id;
		events_master_directory_entry_type_id = events_master_directory_entry_get_type_once ();
		g_once_init_leave (&events_master_directory_entry_type_id__once, events_master_directory_entry_type_id);
	}
	return events_master_directory_entry_type_id__once;
}

static inline gpointer
events_year_directory_entry_get_instance_private (EventsYearDirectoryEntry* self)
{
	return G_STRUCT_MEMBER_P (self, EventsYearDirectoryEntry_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

EventsYearDirectoryEntry*
events_year_directory_entry_construct (GType object_type,
                                       const gchar* name,
                                       GDateTime* tm)
{
	EventsYearDirectoryEntry * self = NULL;
	gchar* _tmp0_;
	GDateTime* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (tm != NULL, NULL);
	self = (EventsYearDirectoryEntry*) events_directory_entry_construct (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = _g_date_time_ref0 (tm);
	_g_date_time_unref0 (self->priv->tm);
	self->priv->tm = _tmp1_;
	return self;
}

EventsYearDirectoryEntry*
events_year_directory_entry_new (const gchar* name,
                                 GDateTime* tm)
{
	return events_year_directory_entry_construct (EVENTS_TYPE_YEAR_DIRECTORY_ENTRY, name, tm);
}

static gchar*
events_year_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	EventsYearDirectoryEntry * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (EventsYearDirectoryEntry*) base;
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gint
events_year_directory_entry_get_year (EventsYearDirectoryEntry* self)
{
	GDateTime* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tm;
	result = g_date_time_get_year (_tmp0_);
	return result;
}

static Page*
events_year_directory_entry_real_create_page (SidebarSimplePageEntry* base)
{
	EventsYearDirectoryEntry * self;
	GDateTime* _tmp0_;
	SubEventsDirectoryPage* _tmp1_;
	Page* result;
	self = (EventsYearDirectoryEntry*) base;
	_tmp0_ = self->priv->tm;
	_tmp1_ = sub_events_directory_page_new (SUB_EVENTS_DIRECTORY_PAGE_DIRECTORY_TYPE_YEAR, _tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (Page*) _tmp1_;
	return result;
}

static void
events_year_directory_entry_class_init (EventsYearDirectoryEntryClass * klass,
                                        gpointer klass_data)
{
	events_year_directory_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EventsYearDirectoryEntry_private_offset);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) events_year_directory_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) events_year_directory_entry_real_create_page;
	G_OBJECT_CLASS (klass)->finalize = events_year_directory_entry_finalize;
}

static void
events_year_directory_entry_instance_init (EventsYearDirectoryEntry * self,
                                           gpointer klass)
{
	self->priv = events_year_directory_entry_get_instance_private (self);
}

static void
events_year_directory_entry_finalize (GObject * obj)
{
	EventsYearDirectoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EVENTS_TYPE_YEAR_DIRECTORY_ENTRY, EventsYearDirectoryEntry);
	_g_free0 (self->priv->name);
	_g_date_time_unref0 (self->priv->tm);
	G_OBJECT_CLASS (events_year_directory_entry_parent_class)->finalize (obj);
}

static GType
events_year_directory_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsYearDirectoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_year_directory_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsYearDirectoryEntry), 0, (GInstanceInitFunc) events_year_directory_entry_instance_init, NULL };
	GType events_year_directory_entry_type_id;
	events_year_directory_entry_type_id = g_type_register_static (EVENTS_TYPE_DIRECTORY_ENTRY, "EventsYearDirectoryEntry", &g_define_type_info, 0);
	EventsYearDirectoryEntry_private_offset = g_type_add_instance_private (events_year_directory_entry_type_id, sizeof (EventsYearDirectoryEntryPrivate));
	return events_year_directory_entry_type_id;
}

GType
events_year_directory_entry_get_type (void)
{
	static volatile gsize events_year_directory_entry_type_id__once = 0;
	if (g_once_init_enter (&events_year_directory_entry_type_id__once)) {
		GType events_year_directory_entry_type_id;
		events_year_directory_entry_type_id = events_year_directory_entry_get_type_once ();
		g_once_init_leave (&events_year_directory_entry_type_id__once, events_year_directory_entry_type_id);
	}
	return events_year_directory_entry_type_id__once;
}

static inline gpointer
events_month_directory_entry_get_instance_private (EventsMonthDirectoryEntry* self)
{
	return G_STRUCT_MEMBER_P (self, EventsMonthDirectoryEntry_private_offset);
}

EventsMonthDirectoryEntry*
events_month_directory_entry_construct (GType object_type,
                                        const gchar* name,
                                        GDateTime* tm)
{
	EventsMonthDirectoryEntry * self = NULL;
	gchar* _tmp0_;
	GDateTime* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (tm != NULL, NULL);
	self = (EventsMonthDirectoryEntry*) events_directory_entry_construct (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = _g_date_time_ref0 (tm);
	_g_date_time_unref0 (self->priv->tm);
	self->priv->tm = _tmp1_;
	return self;
}

EventsMonthDirectoryEntry*
events_month_directory_entry_new (const gchar* name,
                                  GDateTime* tm)
{
	return events_month_directory_entry_construct (EVENTS_TYPE_MONTH_DIRECTORY_ENTRY, name, tm);
}

static gchar*
events_month_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	EventsMonthDirectoryEntry * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (EventsMonthDirectoryEntry*) base;
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gint
events_month_directory_entry_get_year (EventsMonthDirectoryEntry* self)
{
	GDateTime* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tm;
	result = g_date_time_get_year (_tmp0_);
	return result;
}

gint
events_month_directory_entry_get_month (EventsMonthDirectoryEntry* self)
{
	GDateTime* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tm;
	result = g_date_time_get_month (_tmp0_) + 1;
	return result;
}

static Page*
events_month_directory_entry_real_create_page (SidebarSimplePageEntry* base)
{
	EventsMonthDirectoryEntry * self;
	GDateTime* _tmp0_;
	SubEventsDirectoryPage* _tmp1_;
	Page* result;
	self = (EventsMonthDirectoryEntry*) base;
	_tmp0_ = self->priv->tm;
	_tmp1_ = sub_events_directory_page_new (SUB_EVENTS_DIRECTORY_PAGE_DIRECTORY_TYPE_MONTH, _tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (Page*) _tmp1_;
	return result;
}

static void
events_month_directory_entry_class_init (EventsMonthDirectoryEntryClass * klass,
                                         gpointer klass_data)
{
	events_month_directory_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EventsMonthDirectoryEntry_private_offset);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) events_month_directory_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) events_month_directory_entry_real_create_page;
	G_OBJECT_CLASS (klass)->finalize = events_month_directory_entry_finalize;
}

static void
events_month_directory_entry_instance_init (EventsMonthDirectoryEntry * self,
                                            gpointer klass)
{
	self->priv = events_month_directory_entry_get_instance_private (self);
}

static void
events_month_directory_entry_finalize (GObject * obj)
{
	EventsMonthDirectoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EVENTS_TYPE_MONTH_DIRECTORY_ENTRY, EventsMonthDirectoryEntry);
	_g_free0 (self->priv->name);
	_g_date_time_unref0 (self->priv->tm);
	G_OBJECT_CLASS (events_month_directory_entry_parent_class)->finalize (obj);
}

static GType
events_month_directory_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsMonthDirectoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_month_directory_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsMonthDirectoryEntry), 0, (GInstanceInitFunc) events_month_directory_entry_instance_init, NULL };
	GType events_month_directory_entry_type_id;
	events_month_directory_entry_type_id = g_type_register_static (EVENTS_TYPE_DIRECTORY_ENTRY, "EventsMonthDirectoryEntry", &g_define_type_info, 0);
	EventsMonthDirectoryEntry_private_offset = g_type_add_instance_private (events_month_directory_entry_type_id, sizeof (EventsMonthDirectoryEntryPrivate));
	return events_month_directory_entry_type_id;
}

GType
events_month_directory_entry_get_type (void)
{
	static volatile gsize events_month_directory_entry_type_id__once = 0;
	if (g_once_init_enter (&events_month_directory_entry_type_id__once)) {
		GType events_month_directory_entry_type_id;
		events_month_directory_entry_type_id = events_month_directory_entry_get_type_once ();
		g_once_init_leave (&events_month_directory_entry_type_id__once, events_month_directory_entry_type_id);
	}
	return events_month_directory_entry_type_id__once;
}

EventsUndatedDirectoryEntry*
events_undated_directory_entry_construct (GType object_type)
{
	EventsUndatedDirectoryEntry * self = NULL;
	self = (EventsUndatedDirectoryEntry*) events_directory_entry_construct (object_type);
	return self;
}

EventsUndatedDirectoryEntry*
events_undated_directory_entry_new (void)
{
	return events_undated_directory_entry_construct (EVENTS_TYPE_UNDATED_DIRECTORY_ENTRY);
}

static gchar*
events_undated_directory_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	EventsUndatedDirectoryEntry * self;
	gchar* _tmp0_;
	gchar* result;
	self = (EventsUndatedDirectoryEntry*) base;
	_tmp0_ = g_strdup (SUB_EVENTS_DIRECTORY_PAGE_UNDATED_PAGE_NAME);
	result = _tmp0_;
	return result;
}

static Page*
events_undated_directory_entry_real_create_page (SidebarSimplePageEntry* base)
{
	EventsUndatedDirectoryEntry * self;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	SubEventsDirectoryPage* _tmp4_;
	Page* _tmp5_;
	Page* result;
	self = (EventsUndatedDirectoryEntry*) base;
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sub_events_directory_page_new (SUB_EVENTS_DIRECTORY_PAGE_DIRECTORY_TYPE_UNDATED, _tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = (Page*) _tmp4_;
	_g_date_time_unref0 (_tmp3_);
	_g_time_zone_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static void
events_undated_directory_entry_class_init (EventsUndatedDirectoryEntryClass * klass,
                                           gpointer klass_data)
{
	events_undated_directory_entry_parent_class = g_type_class_peek_parent (klass);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) events_undated_directory_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) events_undated_directory_entry_real_create_page;
}

static void
events_undated_directory_entry_instance_init (EventsUndatedDirectoryEntry * self,
                                              gpointer klass)
{
}

static GType
events_undated_directory_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsUndatedDirectoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_undated_directory_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsUndatedDirectoryEntry), 0, (GInstanceInitFunc) events_undated_directory_entry_instance_init, NULL };
	GType events_undated_directory_entry_type_id;
	events_undated_directory_entry_type_id = g_type_register_static (EVENTS_TYPE_DIRECTORY_ENTRY, "EventsUndatedDirectoryEntry", &g_define_type_info, 0);
	return events_undated_directory_entry_type_id;
}

GType
events_undated_directory_entry_get_type (void)
{
	static volatile gsize events_undated_directory_entry_type_id__once = 0;
	if (g_once_init_enter (&events_undated_directory_entry_type_id__once)) {
		GType events_undated_directory_entry_type_id;
		events_undated_directory_entry_type_id = events_undated_directory_entry_get_type_once ();
		g_once_init_leave (&events_undated_directory_entry_type_id__once, events_undated_directory_entry_type_id);
	}
	return events_undated_directory_entry_type_id__once;
}

static inline gpointer
events_event_entry_get_instance_private (EventsEventEntry* self)
{
	return G_STRUCT_MEMBER_P (self, EventsEventEntry_private_offset);
}

EventsEventEntry*
events_event_entry_construct (GType object_type,
                              Event* event)
{
	EventsEventEntry * self = NULL;
	Event* _tmp0_;
	g_return_val_if_fail (event != NULL, NULL);
	self = (EventsEventEntry*) sidebar_simple_page_entry_construct (object_type);
	_tmp0_ = _g_object_ref0 (event);
	_g_object_unref0 (self->priv->event);
	self->priv->event = _tmp0_;
	return self;
}

EventsEventEntry*
events_event_entry_new (Event* event)
{
	return events_event_entry_construct (EVENTS_TYPE_EVENT_ENTRY, event);
}

Event*
events_event_entry_get_event (EventsEventEntry* self)
{
	Event* _tmp0_;
	Event* _tmp1_;
	Event* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->event;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
events_event_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	EventsEventEntry * self;
	Event* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (EventsEventEntry*) base;
	_tmp0_ = self->priv->event;
	_tmp1_ = data_object_get_name ((DataObject*) _tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
events_event_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	EventsEventEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (EventsEventEntry*) base;
	_tmp0_ = events_branch_single_event_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Page*
events_event_entry_real_create_page (SidebarSimplePageEntry* base)
{
	EventsEventEntry * self;
	Event* _tmp0_;
	EventPage* _tmp1_;
	Page* result;
	self = (EventsEventEntry*) base;
	_tmp0_ = self->priv->event;
	_tmp1_ = event_page_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (Page*) _tmp1_;
	return result;
}

static void
events_event_entry_real_rename (SidebarRenameableEntry* base,
                                const gchar* new_name)
{
	EventsEventEntry * self;
	gchar* prepped = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (EventsEventEntry*) base;
	g_return_if_fail (new_name != NULL);
	_tmp0_ = event_prep_event_name (new_name);
	prepped = _tmp0_;
	_tmp1_ = prepped;
	if (_tmp1_ != NULL) {
		CommandManager* _tmp2_;
		CommandManager* _tmp3_;
		Event* _tmp4_;
		const gchar* _tmp5_;
		RenameEventCommand* _tmp6_;
		RenameEventCommand* _tmp7_;
		_tmp2_ = app_window_get_command_manager ();
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->event;
		_tmp5_ = prepped;
		_tmp6_ = rename_event_command_new (_tmp4_, _tmp5_);
		_tmp7_ = _tmp6_;
		command_manager_execute (_tmp3_, (Command*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		_command_manager_unref0 (_tmp3_);
	}
	_g_free0 (prepped);
}

static gboolean
events_event_entry_real_internal_drop_received (SidebarInternalDropTargetEntry* base,
                                                GeeList* media)
{
	EventsEventEntry * self;
	GeeArrayList* views = NULL;
	GeeArrayList* _tmp0_;
	CommandManager* _tmp12_;
	CommandManager* _tmp13_;
	GeeArrayList* _tmp14_;
	Event* _tmp15_;
	SetEventCommand* _tmp16_;
	SetEventCommand* _tmp17_;
	gboolean result;
	self = (EventsEventEntry*) base;
	g_return_val_if_fail (media != NULL, FALSE);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	views = _tmp0_;
	{
		GeeList* _media_source_list = NULL;
		gint _media_source_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _media_source_index = 0;
		_media_source_list = media;
		_tmp1_ = _media_source_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_media_source_size = _tmp3_;
		_media_source_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MediaSource* media_source = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			GeeArrayList* _tmp8_;
			MediaSource* _tmp9_;
			DataView* _tmp10_;
			DataView* _tmp11_;
			_media_source_index = _media_source_index + 1;
			_tmp4_ = _media_source_index;
			_tmp5_ = _media_source_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _media_source_list;
			_tmp7_ = gee_list_get (_tmp6_, _media_source_index);
			media_source = (MediaSource*) _tmp7_;
			_tmp8_ = views;
			_tmp9_ = media_source;
			_tmp10_ = data_view_new ((DataSource*) _tmp9_);
			_tmp11_ = _tmp10_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp11_);
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (media_source);
		}
	}
	_tmp12_ = app_window_get_command_manager ();
	_tmp13_ = _tmp12_;
	_tmp14_ = views;
	_tmp15_ = self->priv->event;
	_tmp16_ = set_event_command_new ((GeeIterable*) _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	command_manager_execute (_tmp13_, (Command*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_command_manager_unref0 (_tmp13_);
	result = TRUE;
	_g_object_unref0 (views);
	return result;
}

static gboolean
events_event_entry_real_internal_drop_received_arbitrary (SidebarInternalDropTargetEntry* base,
                                                          GtkSelectionData* data)
{
	EventsEventEntry * self;
	gboolean result;
	self = (EventsEventEntry*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	result = FALSE;
	return result;
}

static void
events_event_entry_class_init (EventsEventEntryClass * klass,
                               gpointer klass_data)
{
	events_event_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EventsEventEntry_private_offset);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) events_event_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (GIcon* (*) (SidebarSimplePageEntry*)) events_event_entry_real_get_sidebar_icon;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) events_event_entry_real_create_page;
	G_OBJECT_CLASS (klass)->finalize = events_event_entry_finalize;
}

static void
events_event_entry_sidebar_renameable_entry_interface_init (SidebarRenameableEntryIface * iface,
                                                            gpointer iface_data)
{
	events_event_entry_sidebar_renameable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->rename = (void (*) (SidebarRenameableEntry*, const gchar*)) events_event_entry_real_rename;
}

static void
events_event_entry_sidebar_internal_drop_target_entry_interface_init (SidebarInternalDropTargetEntryIface * iface,
                                                                      gpointer iface_data)
{
	events_event_entry_sidebar_internal_drop_target_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->internal_drop_received = (gboolean (*) (SidebarInternalDropTargetEntry*, GeeList*)) events_event_entry_real_internal_drop_received;
	iface->internal_drop_received_arbitrary = (gboolean (*) (SidebarInternalDropTargetEntry*, GtkSelectionData*)) events_event_entry_real_internal_drop_received_arbitrary;
}

static void
events_event_entry_instance_init (EventsEventEntry * self,
                                  gpointer klass)
{
	self->priv = events_event_entry_get_instance_private (self);
}

static void
events_event_entry_finalize (GObject * obj)
{
	EventsEventEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EVENTS_TYPE_EVENT_ENTRY, EventsEventEntry);
	_g_object_unref0 (self->priv->event);
	G_OBJECT_CLASS (events_event_entry_parent_class)->finalize (obj);
}

static GType
events_event_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsEventEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_event_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsEventEntry), 0, (GInstanceInitFunc) events_event_entry_instance_init, NULL };
	static const GInterfaceInfo sidebar_renameable_entry_info = { (GInterfaceInitFunc) events_event_entry_sidebar_renameable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_internal_drop_target_entry_info = { (GInterfaceInitFunc) events_event_entry_sidebar_internal_drop_target_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType events_event_entry_type_id;
	events_event_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "EventsEventEntry", &g_define_type_info, 0);
	g_type_add_interface_static (events_event_entry_type_id, SIDEBAR_TYPE_RENAMEABLE_ENTRY, &sidebar_renameable_entry_info);
	g_type_add_interface_static (events_event_entry_type_id, SIDEBAR_TYPE_INTERNAL_DROP_TARGET_ENTRY, &sidebar_internal_drop_target_entry_info);
	EventsEventEntry_private_offset = g_type_add_instance_private (events_event_entry_type_id, sizeof (EventsEventEntryPrivate));
	return events_event_entry_type_id;
}

GType
events_event_entry_get_type (void)
{
	static volatile gsize events_event_entry_type_id__once = 0;
	if (g_once_init_enter (&events_event_entry_type_id__once)) {
		GType events_event_entry_type_id;
		events_event_entry_type_id = events_event_entry_get_type_once ();
		g_once_init_leave (&events_event_entry_type_id__once, events_event_entry_type_id);
	}
	return events_event_entry_type_id__once;
}

EventsNoEventEntry*
events_no_event_entry_construct (GType object_type)
{
	EventsNoEventEntry * self = NULL;
	self = (EventsNoEventEntry*) sidebar_simple_page_entry_construct (object_type);
	return self;
}

EventsNoEventEntry*
events_no_event_entry_new (void)
{
	return events_no_event_entry_construct (EVENTS_TYPE_NO_EVENT_ENTRY);
}

static gchar*
events_no_event_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	EventsNoEventEntry * self;
	gchar* _tmp0_;
	gchar* result;
	self = (EventsNoEventEntry*) base;
	_tmp0_ = g_strdup (NO_EVENT_PAGE_NAME);
	result = _tmp0_;
	return result;
}

static GIcon*
events_no_event_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	EventsNoEventEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (EventsNoEventEntry*) base;
	_tmp0_ = events_branch_no_event_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Page*
events_no_event_entry_real_create_page (SidebarSimplePageEntry* base)
{
	EventsNoEventEntry * self;
	NoEventPage* _tmp0_;
	Page* result;
	self = (EventsNoEventEntry*) base;
	_tmp0_ = no_event_page_new ();
	g_object_ref_sink (_tmp0_);
	result = (Page*) _tmp0_;
	return result;
}

static void
events_no_event_entry_class_init (EventsNoEventEntryClass * klass,
                                  gpointer klass_data)
{
	events_no_event_entry_parent_class = g_type_class_peek_parent (klass);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) events_no_event_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (GIcon* (*) (SidebarSimplePageEntry*)) events_no_event_entry_real_get_sidebar_icon;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) events_no_event_entry_real_create_page;
}

static void
events_no_event_entry_instance_init (EventsNoEventEntry * self,
                                     gpointer klass)
{
}

static GType
events_no_event_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventsNoEventEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) events_no_event_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventsNoEventEntry), 0, (GInstanceInitFunc) events_no_event_entry_instance_init, NULL };
	GType events_no_event_entry_type_id;
	events_no_event_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "EventsNoEventEntry", &g_define_type_info, 0);
	return events_no_event_entry_type_id;
}

GType
events_no_event_entry_get_type (void)
{
	static volatile gsize events_no_event_entry_type_id__once = 0;
	if (g_once_init_enter (&events_no_event_entry_type_id__once)) {
		GType events_no_event_entry_type_id;
		events_no_event_entry_type_id = events_no_event_entry_get_type_once ();
		g_once_init_leave (&events_no_event_entry_type_id__once, events_no_event_entry_type_id);
	}
	return events_no_event_entry_type_id__once;
}

